/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class HilfeDbAccess {
    private static Logger log = Logger.getLogger(HilfeDbAccess.class);

    public static ResultSet retrieveVersionInfo(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_VERSIONSINFO();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadAbkuerzungen(Connection con, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_ABKUERZUNGEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_ABKUERZUNGEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBedeutungen(Connection con, String sArt, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_BEDEUTUNGEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sArt);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_BEDEUTUNGEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSalapas(Connection con, String sProduktart, String sLang) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_SALAPAS();
            String sArten = sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? "'S', 'L', 'P'" : "'X', 'Y', 'Q'";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ARTEN", sArten);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Hilfe.instance.RETRIEVE_SALAPAS();
        String sArten = sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? "'S', 'L', 'P'" : "'X', 'Y', 'Q'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ARTEN", sArten);
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

