/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class InterpretationDbAccess {
    private static Logger log = Logger.getLogger(InterpretationDbAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getMarkenForSachnummer(Connection con, String sSachnummer, Collection<String> cMarkenBerechtigung) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Interpretation.instance.EXIST_SACHNUMMER_MARKE();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cMarkenBerechtigung.size()));
            for (String sMarkenBerechtigung : cMarkenBerechtigung) {
                StringUtils.setPreparedStatementParams(++index, sMarkenBerechtigung);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = null;
            ArrayList<String> cMarken = new ArrayList<String>();
            try {
                res = ps.executeQuery();
                while (res.next()) {
                    cMarken.add(res.getString("Marke"));
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
            return cMarken;
        }
        String sSQLStatement = SQLStatements.Interpretation.instance.EXIST_SACHNUMMER_MARKE();
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", cMarkenBerechtigung);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = null;
        ArrayList<String> cMarken = new ArrayList<String>();
        try {
            res = stmt.executeQuery(sSQLStatement);
            while (res.next()) {
                cMarken.add(res.getString("Marke"));
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return cMarken;
    }

    public static ResultSet loadInterpretationEinstieg(Connection con, String sSachnummer) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Interpretation.instance.LOAD_INTERPRETATION_EINSTIEG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummer);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Interpretation.instance.LOAD_INTERPRETATION_EINSTIEG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadInterpretation(Connection con, String sSprache, String sSachnummer) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = InterpretationDbAccess.loadInterpretationEinstieg(con, sSachnummer);
            if (!res.next()) {
                return res;
            }
            String sSachnummerE = res.getString("Sachnummer");
            WebetkUtils.closeQuery(res);
            String sSQLStatement = SQLStatements.Interpretation.instance.LOAD_INTERPRETATION();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummerE);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = InterpretationDbAccess.loadInterpretationEinstieg(con, sSachnummer);
        if (!res.next()) {
            return res;
        }
        String sSachnummerE = res.getString("Sachnummer");
        WebetkUtils.closeQuery(res);
        String sSQLStatement = SQLStatements.Interpretation.instance.LOAD_INTERPRETATION();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummerE);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

