/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.FGs;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.SQLStatements;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileSucheFzgDbAccess {
    private static Logger log = Logger.getLogger(TeileSucheFzgDbAccess.class);

    public static ResultSet selectHGs(Connection con, boolean bGrafischeSuche, long lModellspalte, String sMarke, String sSprache) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = bGrafischeSuche ? SQLStatements.TeilesucheFzg.instance.RETRIEVE_HGS_GRAF() : SQLStatements.TeilesucheFzg.instance.RETRIEVE_HGS();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(1, sModellspalte);
            ps.setString(5, sMarke);
            ps.setString(2, "00");
            ps.setString(6, "T");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = bGrafischeSuche ? SQLStatements.TeilesucheFzg.instance.RETRIEVE_HGS_GRAF() : SQLStatements.TeilesucheFzg.instance.RETRIEVE_HGS();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FGs getFGGrafMosp(String sHG, long lModellspalte, String sMarke, String sSprache, boolean bMitGrafiken) throws SQLException, DatabaseBusyException {
        FGs fGs;
        String sSQLStatement;
        ResultSet res;
        Statement stmt;
        Connection con;
        ServerGlobalObjects globs;
        block11: {
            Object sFg;
            block12: {
                Object sFg2;
                globs = ServerGlobalObjects.getInstance();
                con = null;
                stmt = null;
                res = null;
                con = globs.getDBConnection("db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
                sSQLStatement = null;
                if (!HtmlUtils.isConnectionSourceOracle(con)) break block11;
                if (!bMitGrafiken) break block12;
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MOSP_MIT_GRAFIKEN();
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps.setString(1, "00");
                ps.setString(5, "T");
                String sISO = LanguageUtils.toLanguage(sSprache);
                String sRegISO = LanguageUtils.toRegion(sSprache, true);
                ps.setString(2, sISO);
                ps.setString(3, sRegISO);
                String sModellspalte = Long.toString(lModellspalte);
                ps.setString(6, sModellspalte);
                ps.setString(4, sMarke);
                ps.setString(7, sHG);
                log.debug("Executing: " + sSQLStatement);
                res = ps.executeQuery();
                FGs fgs = new FGs(sHG);
                while (res != null && res.next()) {
                    sFg2 = res.getString("Funktionsgruppe");
                    String sBenennung = res.getString("Benennung");
                    String sGrafikId = res.getString("GrafikId");
                    if (sGrafikId == null) continue;
                    long lGrafikId = Long.parseLong(sGrafikId);
                    String sTimestamp = res.getString("ModStamp");
                    long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                    byte[] aGrafik = null;
                    aGrafik = WebetkUtils.ladeGrafik(sGrafikId, "T");
                    fgs.addDataSet((String)sFg2, sBenennung, lGrafikId, aGrafik, lTimestamp);
                }
                sFg2 = fgs;
                WebetkUtils.closeQuery(res);
                if (con != null) {
                    globs.freeDBConnection(con, "db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
                }
                return sFg2;
            }
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MOSP();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(4, "T");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(5, sModellspalte);
            ps.setString(3, sMarke);
            ps.setString(6, sHG);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            FGs fgs = new FGs(sHG);
            while (res != null && res.next()) {
                sFg = res.getString("Funktionsgruppe");
                String sBenennung = res.getString("Benennung");
                String sGrafikId = res.getString("GrafikId");
                if (sGrafikId == null) continue;
                long lGrafikId = Long.parseLong(sGrafikId);
                String sTimestamp = res.getString("ModStamp");
                long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                byte[] aGrafik = null;
                aGrafik = WebetkUtils.ladeGrafik(sGrafikId, "T");
                fgs.addDataSet((String)sFg, sBenennung, lGrafikId, aGrafik, lTimestamp);
            }
            sFg = fgs;
            WebetkUtils.closeQuery(res);
            if (con != null) {
                globs.freeDBConnection(con, "db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
            }
            return sFg;
        }
        try {
            sSQLStatement = bMitGrafiken ? SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MOSP_MIT_GRAFIKEN() : SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MOSP();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
            log.debug("Executing: " + sSQLStatement);
            stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            FGs fgs = new FGs(sHG);
            while (res != null && res.next()) {
                String sFg = res.getString("Funktionsgruppe");
                String sBenennung = res.getString("Benennung");
                String sGrafikId = res.getString("GrafikId");
                if (sGrafikId == null) continue;
                long lGrafikId = Long.parseLong(sGrafikId);
                String sTimestamp = res.getString("ModStamp");
                long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                byte[] aGrafik = null;
                aGrafik = WebetkUtils.ladeGrafik(sGrafikId, "T");
                fgs.addDataSet(sFg, sBenennung, lGrafikId, aGrafik, lTimestamp);
            }
            fGs = fgs;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            if (con != null) {
                globs.freeDBConnection(con, "db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        if (con != null) {
            globs.freeDBConnection(con, "db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
        }
        return fGs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FGs getFGGraf(String sHG, String sMarke, String sProduktart, String sSprache, boolean bMitGrafiken) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = globs.getDBConnection("db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                Object sFg;
                String sSQLStatement = null;
                sSQLStatement = bMitGrafiken ? SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MIT_GRAFIKEN() : SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF();
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                String sISO = LanguageUtils.toLanguage(sSprache);
                String sRegISO = LanguageUtils.toRegion(sSprache, true);
                ps.setString(1, sISO);
                ps.setString(2, sRegISO);
                ps.setString(3, sMarke);
                ps.setString(6, sProduktart);
                ps.setString(5, sHG);
                ps.setString(4, "T");
                log.debug("Executing: " + sSQLStatement);
                ResultSet res = ps.executeQuery();
                FGs fgs = new FGs(sHG);
                while (res != null && res.next()) {
                    sFg = res.getString("Funktionsgruppe");
                    String sBenennung = res.getString("Benennung");
                    String sGrafikId = res.getString("GrafikId");
                    long lGrafikId = sGrafikId == null ? 0L : Long.parseLong(sGrafikId);
                    String sTimestamp = res.getString("ModStamp");
                    long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                    byte[] aGrafik = null;
                    aGrafik = sGrafikId == null ? null : WebetkUtils.ladeGrafik(sGrafikId, "T");
                    if (lGrafikId <= 0L) continue;
                    fgs.addDataSet((String)sFg, sBenennung, lGrafikId, aGrafik, lTimestamp);
                }
                sFg = fgs;
                return sFg;
            }
            String sSQLStatement = null;
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF();
            sSQLStatement = bMitGrafiken ? SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF_MIT_GRAFIKEN() : SQLStatements.TeilesucheFzg.instance.RETRIEVE_FGS_GRAF();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = con.createStatement();
            ResultSet res = stmt.executeQuery(sSQLStatement);
            FGs fgs = new FGs(sHG);
            while (res != null && res.next()) {
                String sFg = res.getString("Funktionsgruppe");
                String sBenennung = res.getString("Benennung");
                String sGrafikId = res.getString("GrafikId");
                long lGrafikId = sGrafikId == null ? 0L : Long.parseLong(sGrafikId);
                String sTimestamp = res.getString("ModStamp");
                long lTimestamp = sTimestamp == null ? 0L : Long.parseLong(sTimestamp);
                byte[] aGrafik = null;
                aGrafik = sGrafikId == null ? null : WebetkUtils.ladeGrafik(sGrafikId, "T");
                if (lGrafikId <= 0L) continue;
                fgs.addDataSet(sFg, sBenennung, lGrafikId, aGrafik, lTimestamp);
            }
            FGs fGs = fgs;
            return fGs;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "db.teilesuchefzg.AdminToolDbAccess.getFGGraf");
            }
        }
    }

    public static ResultSet selectHGFGs(Connection con, long lModellspalte, String sMarke, String sSprache) throws SQLException, NoDataFoundException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.RETRIEVE_ALL_HGFGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1008);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(1, sModellspalte);
            ps.setString(5, sModellspalte);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            ps.setString(2, "00");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            if (res == null || !res.isBeforeFirst()) {
                throw new NoDataFoundException("No HgFs found");
            }
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.isBeforeFirst()) {
            throw new NoDataFoundException("No HgFs found");
        }
        return res;
    }

    public static ResultSet selectFGs(Connection con, long lModellspalte, String sHG, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.RETRIEVE_HGFGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(1, sModellspalte);
            ps.setString(2, sHG);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_Benennung(Connection con, String sSuchstring, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant, boolean bIncludeAccessoiresBildtafeln) throws SQLException {
        sSuchstring = StringUtils.substituteStringStraight(sSuchstring, "*", "%");
        sSuchstring = StringUtils.maskiereHochkommaFuerDb(sSuchstring);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        boolean bSonderlocke = false;
        boolean bSonderlocke_tr = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de")) {
            bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring);
            if (bSonderlocke) {
                sSuchstring1 = sSuchstring;
                sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            }
        } else if (sISO.equals("tr")) {
            boolean bl = bSonderlocke_tr = sSuchstring.indexOf("\u0131") > -1 || sSuchstring.indexOf("\u0130") > -1 || sSuchstring.indexOf("i") > -1 || sSuchstring.indexOf("I") > -1;
            if (bSonderlocke_tr) {
                sSuchstring = sSuchstring.toUpperCase(new Locale("tr", "TR"));
            }
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE();
                int index = 0;
                String sModellspalte = Long.toString(lModellspalte);
                StringUtils.setPreparedStatementParams(++index, sModellspalte);
                if (sLenkung.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                    StringUtils.setPreparedStatementParams(++index, sLenkung);
                }
                if (sGetriebe.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                    StringUtils.setPreparedStatementParams(++index, sGetriebe);
                }
                int nMonatAuslauf = 0;
                int nMonatEinsatz = 0;
                if (!bIdentifiedByFgstnr) {
                    nMonatEinsatz = 2;
                    nMonatAuslauf = -1;
                }
                if (sBaujahr.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
                } else {
                    String sAuslauf;
                    String sEinsatz;
                    if (sZulassungsmonat.equals("kA")) {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                    } else {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                    }
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                    StringUtils.setPreparedStatementParams(++index, sEinsatz);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                    StringUtils.setPreparedStatementParams(++index, sAuslauf);
                }
                if (!bSicherheitsrelevant) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                    StringUtils.setPreparedStatementParams(++index, "N");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
                }
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                if (bIncludeAccessoiresBildtafeln) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_SONDERLOCKE_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE());
                    StringUtils.setPreparedStatementParams(++index, sMarke);
                    StringUtils.setPreparedStatementParams(++index, sProduktart);
                    StringUtils.setPreparedStatementParams(++index, "BE");
                    StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_SONDERLOCKE_ASS", "");
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug("Executing: " + sSQLStatement);
                ResultSet res = ps.executeQuery();
                return res;
            }
            if (bSonderlocke_tr) {
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG_TR();
                int index = 0;
                String sModellspalte = Long.toString(lModellspalte);
                StringUtils.setPreparedStatementParams(++index, sModellspalte);
                if (sLenkung.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                    StringUtils.setPreparedStatementParams(++index, sLenkung);
                }
                if (sGetriebe.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                    StringUtils.setPreparedStatementParams(++index, sGetriebe);
                }
                int nMonatAuslauf = 0;
                int nMonatEinsatz = 0;
                if (!bIdentifiedByFgstnr) {
                    nMonatEinsatz = 2;
                    nMonatAuslauf = -1;
                }
                if (sBaujahr.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
                } else {
                    String sAuslauf;
                    String sEinsatz;
                    if (sZulassungsmonat.equals("kA")) {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                    } else {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                    }
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                    StringUtils.setPreparedStatementParams(++index, sEinsatz);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                    StringUtils.setPreparedStatementParams(++index, sAuslauf);
                }
                if (!bSicherheitsrelevant) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                    StringUtils.setPreparedStatementParams(++index, "N");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
                }
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                if (bIncludeAccessoiresBildtafeln) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_TR());
                    StringUtils.setPreparedStatementParams(++index, sMarke);
                    StringUtils.setPreparedStatementParams(++index, sProduktart);
                    StringUtils.setPreparedStatementParams(++index, "BE");
                    StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", "");
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug("Executing: " + sSQLStatement);
                ResultSet res = ps.executeQuery();
                return res;
            }
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG();
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            if (bIncludeAccessoiresBildtafeln) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG());
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE() : (bSonderlocke_tr ? SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG_TR() : SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BENENNUNG());
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = bSonderlocke ? StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_SONDERLOCKE_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE()) : (bSonderlocke_tr ? StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_TR()) : StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = bSonderlocke ? StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_SONDERLOCKE_ASS", "") : StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BENENNUNG_ASS", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_Begriff(Connection con, Collection<String> cBegriffePlus, Collection<String> cBegriffeMinus, Collection<String> cBegriffeOder, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant, boolean bIncludeAccessoiresBildtafeln) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_BEGRIFF_NEU();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffBen = AllgemeinDbAccess.erzeugeSuchbegriffBen(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", sSuchbegriffBen);
            if (bIncludeAccessoiresBildtafeln) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BEGRIFF_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BEGRIFF());
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", sSuchbegriffBen);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BEGRIFF_ASS", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffBenKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_KOMM_STMT", sSuchbegriffBenKomm);
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf1 = 0;
            int nMonatEinsatz1 = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz1 = 2;
                nMonatAuslauf1 = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz1);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf1);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz1);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf1);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BEGRIFF_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_BEGRIFF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_BEGRIFF_ASS", "");
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sSuchbegriffBen = AllgemeinDbAccess.erzeugeSuchbegriffBen(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", sSuchbegriffBen);
        String sSuchbegriffBenKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_KOMM_STMT", sSuchbegriffBenKomm);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getChangepointsKB(Connection con, FzgSucheInfo oFzgSucheInfo, SearchBTETeile.PartOrBTE obj) throws SQLException {
        block16: {
            block15: {
                typSchluessel = "";
                menge = oFzgSucheInfo.getTypmenge();
                for (String typSchluessel : menge) {
                }
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_KABELBAUM_CHANGEPOINTS();
                if (!HtmlUtils.isConnectionSourceOracle(con)) ** GOTO lbl27
                ps = con.prepareStatement(sSQLStatement);
                ps.setString(1, Long.toString(oFzgSucheInfo.getModellspalte()));
                ps.setString(2, typSchluessel);
                ps.setString(3, oFzgSucheInfo.getWerk());
                ps.setString(4, Long.toString(obj.getPos()));
                ps.setString(5, obj.getBTNummer());
                TeileSucheFzgDbAccess.log.debug("%%% Executing: " + sSQLStatement);
                res = null;
                res = ps.executeQuery(sSQLStatement);
                cphinterlegt = false;
                if (oFzgSucheInfo.getProduktionsdatum() != null) {
                    TeileSucheFzgDbAccess.log.debug("*** res= null? " + (res == null));
                    break block15;
                } else {
                    TeileSucheFzgDbAccess.log.debug("Auswertung der Changepoints nicht m\u00f6glich (kein Produktionsdatum vorhanden");
                    sTypDB = false;
                    return sTypDB;
                }
                finally {
                    WebetkUtils.closeQuery(res);
                }
lbl27:
                // 1 sources

                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPID", Long.toString(oFzgSucheInfo.getModellspalte()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPSCHLUESSEL", typSchluessel);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "WERK", oFzgSucheInfo.getWerk());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "POSITION", Long.toString(obj.getPos()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNUMMER", obj.getBTNummer());
                TeileSucheFzgDbAccess.log.debug("%%% Executing: " + sSQLStatement);
                stmt = null;
                res = null;
                try {
                    stmt = con.createStatement();
                    res = stmt.executeQuery(sSQLStatement);
                    cphinterlegt = false;
                    if (oFzgSucheInfo.getProduktionsdatum() != null) {
                        TeileSucheFzgDbAccess.log.debug("*** res= null? " + (res == null));
                        break block16;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var30_50) {
                    WebetkUtils.closeQuery(res);
                    throw var30_50;
                }
            }
            while (res != null && res.next()) {
                cphinterlegt = true;
                TeileSucheFzgDbAccess.log.debug("in der Schleife");
                sTypDB = res.getString("Typ");
                sWerkDB = res.getString("Werk");
                sArt = res.getString("Art");
                lDatumHelp = res.getLong("Datum");
                lDatum = res.wasNull() != false ? null : new Long(lDatumHelp);
                sVin = res.getString("Vin");
                lVinProddatumHelp = res.getLong("VinProddatum");
                lVinProddatum = res.wasNull() != false ? null : new Long(lVinProddatumHelp);
                sVinMin = res.getString("VinMin");
                sVinMax = res.getString("VinMax");
                sArtNummer = res.getString("ArtNummer");
                sNummer = res.getString("Nummer");
                cpAlterHelp = res.getInt("CPAlter");
                cpAlter = res.wasNull() != false ? null : new Long(cpAlterHelp);
                oChangepoint = new Changepoint(sTypDB, sWerkDB, sArt, lDatum, sVin, lVinProddatum, sVinMin, sVinMax, sArtNummer, sNummer, cpAlter);
                if (oChangepoint.auswertenChangePointKB(Long.valueOf(oFzgSucheInfo.getProduktionsdatum()))) continue;
                TeileSucheFzgDbAccess.log.debug("return false");
                var28_47 = false;
                return var28_47;
            }
            TeileSucheFzgDbAccess.log.debug("return true");
            sTypDB = cphinterlegt;
            return sTypDB;
        }
        while (res != null && res.next()) {
            cphinterlegt = true;
            TeileSucheFzgDbAccess.log.debug("in der Schleife");
            sTypDB = res.getString("Typ");
            sWerkDB = res.getString("Werk");
            sArt = res.getString("Art");
            lDatumHelp = res.getLong("Datum");
            lDatum = res.wasNull() != false ? null : new Long(lDatumHelp);
            sVin = res.getString("Vin");
            lVinProddatumHelp = res.getLong("VinProddatum");
            lVinProddatum = res.wasNull() != false ? null : new Long(lVinProddatumHelp);
            sVinMin = res.getString("VinMin");
            sVinMax = res.getString("VinMax");
            sArtNummer = res.getString("ArtNummer");
            sNummer = res.getString("Nummer");
            cpAlterHelp = res.getInt("CPAlter");
            cpAlter = res.wasNull() != false ? null : new Long(cpAlterHelp);
            oChangepoint = new Changepoint(sTypDB, sWerkDB, sArt, lDatum, sVin, lVinProddatum, sVinMin, sVinMax, sArtNummer, sNummer, cpAlter);
            if (oChangepoint.auswertenChangePointKB(Long.valueOf(oFzgSucheInfo.getProduktionsdatum()))) continue;
            TeileSucheFzgDbAccess.log.debug("return false");
            var28_48 = false;
            WebetkUtils.closeQuery(res);
            return var28_48;
        }
        {
            WebetkUtils.closeQuery(res);
            TeileSucheFzgDbAccess.log.debug("return true");
            var10_17 = cphinterlegt;
        }
        WebetkUtils.closeQuery(res);
        return var10_17;
lbl-1000:
        // 1 sources

        {
            TeileSucheFzgDbAccess.log.debug("Auswertung der Changepoints nicht m\u00f6glich (kein Produktionsdatum vorhanden");
            var10_18 = false;
        }
        WebetkUtils.closeQuery(res);
        return var10_18;
    }

    public static ResultSet searchSachnummern_Benennung(Connection con, String sSuchstring, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant, boolean bIncludeAccessoiresBildtafeln) throws SQLException {
        sSuchstring = StringUtils.substituteStringStraight(sSuchstring, "*", "%");
        sSuchstring = StringUtils.maskiereHochkommaFuerDb(sSuchstring);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        boolean bSonderlocke = false;
        boolean bSonderlocke_tr = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de") && (bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring))) {
            sSuchstring1 = sSuchstring;
            sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
        }
        if (sISO.equals("tr")) {
            boolean bl = bSonderlocke_tr = sSuchstring.indexOf("\u0131") > -1 || sSuchstring.indexOf("\u0130") > -1 || sSuchstring.indexOf("i") > -1 || sSuchstring.indexOf("I") > -1;
            if (bSonderlocke_tr) {
                sSuchstring = sSuchstring.toUpperCase(new Locale("tr", "TR"));
            }
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            if (bSonderlocke) {
                int index = 0;
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE();
                String sModellspalte = Long.toString(lModellspalte);
                StringUtils.setPreparedStatementParams(++index, sModellspalte);
                if (sLenkung.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                    StringUtils.setPreparedStatementParams(++index, sLenkung);
                }
                if (sGetriebe.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                    StringUtils.setPreparedStatementParams(++index, sGetriebe);
                }
                int nMonatAuslauf = 0;
                int nMonatEinsatz = 0;
                if (!bIdentifiedByFgstnr) {
                    nMonatEinsatz = 2;
                    nMonatAuslauf = -1;
                }
                if (sBaujahr.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
                } else {
                    String sAuslauf;
                    String sEinsatz;
                    if (sZulassungsmonat.equals("kA")) {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                    } else {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                    }
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                    StringUtils.setPreparedStatementParams(++index, sEinsatz);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                    StringUtils.setPreparedStatementParams(++index, sAuslauf);
                }
                if (!bSicherheitsrelevant) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                    StringUtils.setPreparedStatementParams(++index, "N");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
                }
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                if (bIncludeAccessoiresBildtafeln) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_SONDERLOCKE_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE());
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
                    StringUtils.setPreparedStatementParams(++index, sMarke);
                    StringUtils.setPreparedStatementParams(++index, sProduktart);
                    StringUtils.setPreparedStatementParams(++index, "BE");
                    StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_SONDERLOCKE_ASS", "");
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug("Executing: " + sSQLStatement);
                ResultSet res = ps.executeQuery();
                return res;
            }
            if (bSonderlocke_tr) {
                sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG_TR();
                int index = 0;
                String sModellspalte = Long.toString(lModellspalte);
                StringUtils.setPreparedStatementParams(++index, sModellspalte);
                if (sLenkung.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                    StringUtils.setPreparedStatementParams(++index, sLenkung);
                }
                if (sGetriebe.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                    StringUtils.setPreparedStatementParams(++index, sGetriebe);
                }
                int nMonatAuslauf = 0;
                int nMonatEinsatz = 0;
                if (!bIdentifiedByFgstnr) {
                    nMonatEinsatz = 2;
                    nMonatAuslauf = -1;
                }
                if (sBaujahr.equals("kA")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
                } else {
                    String sAuslauf;
                    String sEinsatz;
                    if (sZulassungsmonat.equals("kA")) {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                    } else {
                        sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                        sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                    }
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                    StringUtils.setPreparedStatementParams(++index, sEinsatz);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                    StringUtils.setPreparedStatementParams(++index, sAuslauf);
                }
                if (!bSicherheitsrelevant) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                    StringUtils.setPreparedStatementParams(++index, "N");
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
                }
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                if (bIncludeAccessoiresBildtafeln) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_TR());
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
                    StringUtils.setPreparedStatementParams(++index, sMarke);
                    StringUtils.setPreparedStatementParams(++index, sProduktart);
                    StringUtils.setPreparedStatementParams(++index, "BE");
                    StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", "");
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug("Executing: " + sSQLStatement);
                ResultSet res = ps.executeQuery();
                return res;
            }
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG();
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            if (bIncludeAccessoiresBildtafeln) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE() : (bSonderlocke_tr ? SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG_TR() : SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BENENNUNG());
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = bSonderlocke ? StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_SONDERLOCKE_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE()) : (bSonderlocke_tr ? StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_TR()) : StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = bSonderlocke ? StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_SONDERLOCKE_ASS", "") : StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BENENNUNG_ASS", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummern_Begriff(Connection con, Collection cBegriffePlus, Collection cBegriffeMinus, Collection cBegriffeOder, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant, boolean bIncludeAccessoiresBildtafeln) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_BEGRIFF();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffTeil = AllgemeinDbAccess.erzeugeSuchbegriffBenTeil(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffTeil == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", sSuchbegriffTeil);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf1 = 0;
            int nMonatEinsatz1 = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz1);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf1);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz1);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf1);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffTeilKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenTeilKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffTeilKomm == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", sSuchbegriffTeilKomm);
            if (bIncludeAccessoiresBildtafeln) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BEGRIFF_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BEGRIFF());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = sSuchbegriffTeil == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", sSuchbegriffTeil);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = sSuchbegriffTeilKomm == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", sSuchbegriffTeilKomm);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BEGRIFF_ASS", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BEGRIFF_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BEGRIFF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_SNR_BEGRIFF_ASS", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sSuchbegriffTeil = AllgemeinDbAccess.erzeugeSuchbegriffBenTeil(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffTeil == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", sSuchbegriffTeil);
        String sSuchbegriffTeilKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenTeilKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffTeilKomm == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", sSuchbegriffTeilKomm);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_SNrCompl(Connection con, FzgSucheInfo oFzgSucheInfo, String sSachnummer, String sSprache, boolean bIncludeAccessoiresBildtafeln, String btNummer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_SACHNUMMER_COMPL();
        String sMarke = oFzgSucheInfo.getMarke();
        String sProduktart = oFzgSucheInfo.getProduktart();
        String sKatalogumfang = oFzgSucheInfo.getKatalogumfang();
        long lModellspalte = oFzgSucheInfo.getModellspalte();
        String sLenkung = oFzgSucheInfo.getLenkung();
        String sGetriebe = oFzgSucheInfo.getGetriebe();
        String sBaujahr = oFzgSucheInfo.getBaujahr();
        String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
        boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
        boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
        sLenkung = sLenkung == null ? "kA" : sLenkung;
        sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
        sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
        String string = sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            sSachnummer = StringUtils.maskiereHochkommaFuerDb(sSachnummer);
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMER_COMPL_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMER_COMPL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMER_COMPL_ASS", "");
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSachnummer = StringUtils.maskiereHochkommaFuerDb(sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNUMMER", btNummer);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_BTNummer(Connection con, FzgSucheInfo oFzgSucheInfo, String sSachnummer, String sSprache, boolean bIncludeAccessoiresBildtafeln, String btNummer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_NUMMER_COMPL();
        String sMarke = oFzgSucheInfo.getMarke();
        String sProduktart = oFzgSucheInfo.getProduktart();
        String sKatalogumfang = oFzgSucheInfo.getKatalogumfang();
        long lModellspalte = oFzgSucheInfo.getModellspalte();
        String sLenkung = oFzgSucheInfo.getLenkung();
        String sGetriebe = oFzgSucheInfo.getGetriebe();
        String sBaujahr = oFzgSucheInfo.getBaujahr();
        String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
        boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
        boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
        sLenkung = sLenkung == null ? "kA" : sLenkung;
        sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
        sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
        String string = sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            StringUtils.setPreparedStatementParams(++index, btNummer);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMER_COMPL_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_NUMMER_COMPL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogumfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMER_COMPL_ASS", "");
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNUMMER", btNummer);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummer_SNrIncompl(Connection con, FzgSucheInfo oFzgSucheInfo, String sSachnummerIncompl, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_SACHNUMMER_INCOMPL();
        long lModellspalte = oFzgSucheInfo.getModellspalte();
        String sLenkung = oFzgSucheInfo.getLenkung();
        String sGetriebe = oFzgSucheInfo.getGetriebe();
        String sBaujahr = oFzgSucheInfo.getBaujahr();
        String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
        boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
        boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
        sLenkung = sLenkung == null ? "kA" : sLenkung;
        sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
        sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
        sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
        sSachnummerIncompl = StringUtils.substituteStringStraight(sSachnummerIncompl, "*", "%");
        sSachnummerIncompl = StringUtils.substituteStringStraight(sSachnummerIncompl, "?", "_");
        sSachnummerIncompl = StringUtils.maskiereHochkommaFuerDb(sSachnummerIncompl);
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            StringUtils.setPreparedStatementParams(++index, sSachnummerIncompl);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummerIncompl);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummer_Sachnummern(Connection con, FzgSucheInfo oFzgSucheInfo, Collection<String> aSachnummern, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_SNR_FREMDNR();
        long lModellspalte = oFzgSucheInfo.getModellspalte();
        String sLenkung = oFzgSucheInfo.getLenkung();
        String sGetriebe = oFzgSucheInfo.getGetriebe();
        String sBaujahr = oFzgSucheInfo.getBaujahr();
        String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
        boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
        boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
        sLenkung = sLenkung == null ? "kA" : sLenkung;
        sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
        sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
        String string = sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aSachnummern.size()));
            for (String sFremdNr : aSachnummern) {
                StringUtils.setPreparedStatementParams(++index, sFremdNr);
            }
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        Iterator<String> iter = aSachnummern.iterator();
        StringBuffer sbFremd = new StringBuffer("(");
        while (iter.hasNext()) {
            String sFremdNr = iter.next();
            sFremdNr = StringUtils.maskiereHochkommaFuerDb(sFremdNr);
            if (sbFremd.length() > 1) {
                sbFremd.append(", ");
            }
            sbFremd.append("'");
            sbFremd.append(sFremdNr);
            sbFremd.append("'");
        }
        sbFremd.append(")");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FREMDNUMMERN", sbFremd.toString());
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_SNrs(Connection con, Collection<String> cTeile, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant, boolean bIncludeAccessoiresBildtafeln) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_SACHNUMMERN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cTeile.size()));
            for (String sSachnummern : cTeile) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            if (bIncludeAccessoiresBildtafeln) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMERN());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
                StringUtils.setPreparedStatementParams(++index, sMarke);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cTeile.size()));
                for (String sSachnummern : cTeile) {
                    StringUtils.setPreparedStatementParams(++index, sSachnummern);
                }
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "BE");
                StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", "");
            }
            log.debug("Executing: " + sSQLStatement);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (bIncludeAccessoiresBildtafeln) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMERN());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sSachnummern = null;
        Iterator<String> iterator = cTeile.iterator();
        while (iterator.hasNext()) {
            String sSachnummer = iterator.next().toString();
            if (sSachnummern == null) {
                sSachnummern = "'" + sSachnummer + "'";
                continue;
            }
            sSachnummern = sSachnummern + ", '" + sSachnummer + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sSachnummern);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        log.debug("Executing: " + sSQLStatement);
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HGFG(Connection con, String[] asHGFG, String sSprache, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant) throws SQLException {
        String sHG;
        boolean bNurHg;
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_HGFG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sHG2;
            boolean bNurHg2;
            int index = 0;
            boolean bl = bNurHg2 = asHGFG.length == 1 && asHGFG[0].length() == 2;
            if (bNurHg2) {
                sHG2 = asHGFG[0];
                StringUtils.setPreparedStatementParams(++index, sHG2);
            } else {
                sHG2 = asHGFG[0].substring(0, 2);
                StringUtils.setPreparedStatementParams(++index, sHG2);
            }
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA") || sBaujahr.equals("AlleWerte")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (bNurHg2) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", "");
            } else {
                String sHG3 = asHGFG[0].substring(0, 2);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAF_HGFG());
                String sHgFgs = AllgemeinDbAccess.concatStrings(asHGFG, true);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGFGS", sHgFgs);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        boolean bl = bNurHg = asHGFG.length == 1 && asHGFG[0].length() == 2;
        if (bNurHg) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", "");
            sHG = asHGFG[0];
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        } else {
            sHG = asHGFG[0].substring(0, 2);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAF_HGFG());
            String sHgFgs = AllgemeinDbAccess.concatStrings(asHGFG, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGFGS", sHgFgs);
        }
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA") || sBaujahr.equals("AlleWerte")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BILDTAFS_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HG_Grafisch(Connection con, String sHG, String sSprache, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bMitGrafiken, boolean bSicherheitsrelevant) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con) && !bMitGrafiken) {
            int index = 0;
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_HG_GRAFISCH();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "T");
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            StringUtils.setPreparedStatementParams(++index, sHG);
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HG_FG_Grafisch(Connection con, String sHG, String sFG, String sSprache, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bMitGrafiken, boolean bSicherheitsrelevant) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con) && !bMitGrafiken) {
            int index = 0;
            sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_HG_FG_GRAFISCH_CENTRAL();
            StringUtils.setPreparedStatementParams(++index, "T");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            String sHGsFG = sHG + sFG;
            StringUtils.setPreparedStatementParams(++index, sHGsFG);
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = SQLStatements.TeilesucheFzg.instance.SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sHGsFG = sHG + sFG;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGFG", sHGsFG);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet checkBildtafel_HG_Grafisch(Connection con, String sHG, long lModellspalte, String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr, boolean bSicherheitsrelevant) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sSQLStatement = SQLStatements.TeilesucheFzg.instance.CHECK_BT_HG_GRAFISCH();
            String sModellspalte = Long.toString(lModellspalte);
            StringUtils.setPreparedStatementParams(++index, sModellspalte);
            if (sLenkung.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (sGetriebe.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
                StringUtils.setPreparedStatementParams(++index, sGetriebe);
            }
            int nMonatAuslauf = 0;
            int nMonatEinsatz = 0;
            if (!bIdentifiedByFgstnr) {
                nMonatEinsatz = 2;
                nMonatAuslauf = -1;
            }
            if (sBaujahr.equals("kA")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
            } else {
                String sAuslauf;
                String sEinsatz;
                if (sZulassungsmonat.equals("kA")) {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
                } else {
                    sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                    sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
                StringUtils.setPreparedStatementParams(++index, sEinsatz);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
                StringUtils.setPreparedStatementParams(++index, sAuslauf);
            }
            if (!bSicherheitsrelevant) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN());
                StringUtils.setPreparedStatementParams(++index, "N");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sHG);
            StringUtils.setPreparedStatementParams(++index, "T");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.TeilesucheFzg.instance.CHECK_BT_HG_GRAFISCH();
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        if (sLenkung.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_LENKUNG());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sGetriebe.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_GETRIEBE());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GETRIEBE", sGetriebe);
        }
        int nMonatAuslauf = 0;
        int nMonatEinsatz = 0;
        if (!bIdentifiedByFgstnr) {
            nMonatEinsatz = 2;
            nMonatAuslauf = -1;
        }
        if (sBaujahr.equals("kA")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", "");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", "");
        } else {
            String sAuslauf;
            String sEinsatz;
            if (sZulassungsmonat.equals("kA")) {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, "12", nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, "01", nMonatAuslauf);
            } else {
                sEinsatz = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatEinsatz);
                sAuslauf = WebetkUtils.modifyDate(sBaujahr, sZulassungsmonat, nMonatAuslauf);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_EINSATZ());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "EINSATZ", sEinsatz);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_BTZEILEN_AUSLAUF());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUSLAUF", sAuslauf);
        }
        sSQLStatement = !bSicherheitsrelevant ? StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", SQLStatements.TeilesucheFzg.instance.SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN()) : StringUtils.substituteString(sSQLStatement, "BEACHTE_SICHER_FLAG_STMT", "");
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

