/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileVwdgTeilDbAccess {
    private static Logger log = Logger.getLogger(TeileVwdgTeilDbAccess.class);

    public static ResultSet loadTeil(Connection con, String sSachnummer, String sMarke, String sProduktart, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilevwdgTeil.instance.RETRIEVE_TEIL_ZU_MARKE_PROD();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummer);
            ps.setString(4, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "B");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(5, sISO);
            ps.setString(6, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeil(Connection con, String sSachnummer, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilevwdgTeil.instance.RETRIEVE_TEIL();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummer);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBaureihen(Connection con, String sSachnummer, String sModellspaltenIDs, String sMarke, String sProduktart, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sSQLStatement = SQLStatements.TeilevwdgTeil.instance.RETRIEVE_BAUREIHEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
                String[] aMospIDs = sModellspaltenIDs.split(",");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
                for (int i = 0; i < aMospIDs.length; ++i) {
                    StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
                }
                StringUtils.setPreparedStatementParams(++index, sModellspaltenIDs);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", SQLStatements.TeilevwdgTeil.instance.MODELLSPALTEN_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sModellspaltenIDs);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
        }
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadModellspalten(Connection con, String sSachnummer, String sModellspaltenIDs, String sBaureihe, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sSQLStatement = SQLStatements.TeilevwdgTeil.instance.RETRIEVE_MODELLSPALTEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", SQLStatements.TeilevwdgTeil.instance.MODELLSPALTEN_STMT());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sModellspaltenIDs);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            StringUtils.setPreparedStatementParams(++index, "K");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", SQLStatements.TeilevwdgTeil.instance.MODELLSPALTEN_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sModellspaltenIDs);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
        }
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

