/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub.dbaccess;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.IntegerWrapper;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.common.BaseMarketingProdukt;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baujahr;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.BaureiheMotorrad;
import webetk.app.zub.suche.BildTafelETK;
import webetk.app.zub.suche.Getriebe;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenHauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.KeywordSucheInfo;
import webetk.app.zub.suche.Lenkung;
import webetk.app.zub.suche.Modell;
import webetk.app.zub.suche.ProduktId;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Kunde;
import webetk.db.SQLStatements;
import webetk.db.zub.SQLStatements;
import webetk.db.zub.dbaccess.MarketingDbAccess;
import webetk.db.zub.dbaccess.TechnischDbAccess;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;

public class SucheDbAccess {
    private static Logger log = Logger.getLogger(SucheDbAccess.class);
    private static HashMap noImageIcons = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HauptKategorie> ladeHauptKategorien(String produktart, String marke, int markt, String iso, String regionIso, boolean ladeOhneUk) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            List<HauptKategorie> hkList;
            con = globs.getDBConnection("zub.suche.AdminToolDbAccess.ladeHauptKategorien");
            Map ukHkMapping = new HashMap();
            if (!ladeOhneUk) {
                ukHkMapping = SucheDbAccess.abfrageAlleUnterkategorien(con, produktart, marke, markt, iso, regionIso);
            }
            List<HauptKategorie> list = hkList = SucheDbAccess.abfrageHauptkategorien(con, ukHkMapping, produktart, marke, iso, regionIso);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ladeHauptKategorien");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<HauptKategorie> abfrageHauptkategorien(Connection con, Map ukHkMapping, String produktart, String marke, String iso, String regionIso) throws SQLException {
        ArrayList<HauptKategorie> hkList;
        block10: {
            PreparedStatement hkPrep;
            block9: {
                hkPrep = null;
                String hkStatement = SQLStatements.Listenfueller.instance.LOAD_HAUPTKATEGORIE();
                log.debug("Executing SQL-Statement: " + hkStatement);
                ResultSet hks = null;
                hkList = new ArrayList<HauptKategorie>();
                try {
                    hkPrep = con.prepareStatement(hkStatement);
                    hkPrep.setString(1, produktart);
                    hkPrep.setString(2, marke);
                    hkPrep.setString(3, iso == null ? "" : iso);
                    hkPrep.setString(4, regionIso == null ? "" : regionIso);
                    hks = hkPrep.executeQuery();
                    List<HitListenUnterkategorie> ukList0 = new ArrayList<HitListenUnterkategorie>();
                    if (ukHkMapping != null && ukHkMapping.containsKey(new Integer("0"))) {
                        ukList0 = (List)ukHkMapping.get(new Integer("0"));
                    }
                    hkList.add(new HauptKategorie(0, marke, produktart, "Alle Produkte", 0, ukList0));
                    while (hks.next()) {
                        int hkId = hks.getInt(1);
                        String hMarke = hks.getString(2);
                        String hProduktArt = hks.getString(3);
                        String name = hks.getString(4);
                        byte[] blob = hks.getBytes(5);
                        int pos = hks.getInt(6);
                        ArrayList<HitListenUnterkategorie> unterkatList = new ArrayList();
                        if (ukHkMapping.containsKey(new Integer(hkId))) {
                            unterkatList = (List)ukHkMapping.get(new Integer(hkId));
                        }
                        HauptKategorie entity = new HauptKategorie(hkId, hMarke, hProduktArt, name, pos, unterkatList);
                        entity.setImageData(blob);
                        hkList.add(entity);
                    }
                    if (hks == null) break block9;
                }
                catch (Throwable throwable) {
                    if (hks != null) {
                        WebetkUtils.closeQuery(hks);
                    } else if (hkPrep != null) {
                        hkPrep.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(hks);
                break block10;
            }
            if (hkPrep != null) {
                hkPrep.close();
            }
        }
        return hkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map abfrageAlleUnterkategorien(Connection con, String produktart, String marke, int markt, String iso, String regionIso) throws SQLException, DatabaseBusyException {
        HashMap hashMap;
        Connection ukConn;
        block13: {
            Statement ukPrep;
            block12: {
                ukPrep = null;
                ResultSet ukRes = null;
                String ukStatement = SQLStatements.Listenfueller.instance.LOAD_UNTERKATEGORIE_ALLE();
                HashMap ukHkMapping = new HashMap();
                ukConn = null;
                try {
                    ukConn = ServerGlobalObjects.getInstance().getDBConnection("ermittleFallbackGrafikUk");
                    log.debug("Executing SQL-Statement:" + ukStatement);
                    ukPrep = con.prepareStatement(ukStatement);
                    ukPrep.setString(1, produktart);
                    ukPrep.setString(2, marke);
                    ukPrep.setString(3, iso == null ? "" : iso);
                    ukPrep.setString(4, regionIso == null ? "" : regionIso);
                    ukRes = ukPrep.executeQuery();
                    while (ukRes.next()) {
                        int ukId = ukRes.getInt("ukId");
                        String name = ukRes.getString("benennung");
                        Integer hkId = new Integer(ukRes.getInt("hkId"));
                        int pos = ukRes.getInt("pos");
                        boolean isLifestyle = ukRes.getString("istLifestyle").equals("J");
                        byte[] blob = ukRes.getBytes("image");
                        Integer grafikId = new Integer(ukRes.getInt("grafikid"));
                        Zubehoergrafik zubGr = new Zubehoergrafik(blob, grafikId);
                        if (blob == null || blob.length == 0) {
                            zubGr = new Zubehoergrafik(SucheDbAccess.holeNoImageIcon(ukConn, "K"), new Integer(-1));
                        }
                        if (!ukHkMapping.containsKey(hkId)) {
                            ukHkMapping.put(hkId, new ArrayList());
                        }
                        if (!ukHkMapping.containsKey(new Integer(0))) {
                            ukHkMapping.put(new Integer(0), new ArrayList());
                        }
                        HitListenUnterkategorie unterkategorie = new HitListenUnterkategorie(ukId, name, zubGr, pos, isLifestyle);
                        ((List)ukHkMapping.get(new Integer(0))).add(unterkategorie);
                        ((List)ukHkMapping.get(hkId)).add(unterkategorie);
                    }
                    hashMap = ukHkMapping;
                    if (ukRes == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ukRes != null) {
                        WebetkUtils.closeQuery(ukRes);
                    } else if (ukPrep != null) {
                        ukPrep.close();
                    }
                    if (ukConn != null) {
                        ServerGlobalObjects.getInstance().freeDBConnection(ukConn, "ermittleFallbackGrafikUk");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(ukRes);
                break block13;
            }
            if (ukPrep != null) {
                ukPrep.close();
            }
        }
        if (ukConn != null) {
            ServerGlobalObjects.getInstance().freeDBConnection(ukConn, "ermittleFallbackGrafikUk");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HitListenUnterkategorie> ladeUnterkategorien(int hauptkategorie, String produktart, String marke, int markt, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<HitListenUnterkategorie> ukatList;
        Connection ukCon;
        Connection con;
        ServerGlobalObjects globs;
        block15: {
            Statement stat;
            block14: {
                globs = ServerGlobalObjects.getInstance();
                log.debug("Now Accessing Database");
                con = null;
                ukCon = null;
                String ukStatement = SQLStatements.Listenfueller.instance.LOAD_UNTERKATEGORIE_MIT_HAUPTKATEGORIE();
                if (hauptkategorie == 0) {
                    ukStatement = SQLStatements.Listenfueller.instance.LOAD_UNTERKATEGORIE_ALLE();
                }
                stat = null;
                ResultSet rs = null;
                ukatList = new ArrayList<HitListenUnterkategorie>();
                try {
                    con = globs.getDBConnection("zub.suche.AdminToolDbAccess.ladeUnterkategorien");
                    ukCon = globs.getDBConnection("ermittleFallbackGrafikUk");
                    log.debug("Executing SQL: " + ukStatement);
                    stat = con.prepareStatement(ukStatement);
                    stat.setString(1, produktart);
                    stat.setString(2, marke);
                    stat.setString(3, iso == null ? "" : iso);
                    stat.setString(4, regIso == null ? "" : regIso);
                    if (hauptkategorie > 0) {
                        stat.setInt(5, hauptkategorie);
                    }
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        String name = rs.getString(2);
                        byte[] blob = rs.getBytes(4);
                        Integer grafikId = new Integer(rs.getInt("grafikid"));
                        boolean isLifestyle = rs.getString("istLifestyle").equals("J");
                        Zubehoergrafik zubGr = new Zubehoergrafik(blob, grafikId);
                        if (blob == null || blob.length == 0) {
                            zubGr = new Zubehoergrafik(SucheDbAccess.holeNoImageIcon(ukCon, "K"), new Integer(-1));
                        }
                        int pos = rs.getInt(5);
                        ukatList.add(new HitListenUnterkategorie(id, name, zubGr, pos, isLifestyle));
                    }
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ladeUnterkategorien");
                    }
                    if (ukCon != null) {
                        globs.freeDBConnection(ukCon, "ermittleFallbackGrafikUk");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block15;
            }
            if (stat != null) {
                stat.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ladeUnterkategorien");
        }
        if (ukCon != null) {
            globs.freeDBConnection(ukCon, "ermittleFallbackGrafikUk");
        }
        return ukatList;
    }

    private static Zubehoergrafik ermittleFallbackGrafikUk(Connection con, int id, int markt, String typ) throws SQLException, DatabaseBusyException {
        return new Zubehoergrafik(SucheDbAccess.ermittleFallbackGrafikUk(con, "K", id, markt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] ermittleFallbackGrafikUk(Connection con, String bildTyp, int id, int markt) throws SQLException, DatabaseBusyException {
        byte[] byArray;
        PreparedStatement stat;
        block5: {
            ResultSet listeBteRs;
            block6: {
                byte[] byArray2;
                block7: {
                    log.debug("Now Accessing Database");
                    stat = null;
                    listeBteRs = null;
                    try {
                        String grafikStatement = SQLStatements.Listenfueller.instance.ERMITTLE_GRAFIK_UNTERKATEGORIE_FB();
                        stat = con.prepareStatement(grafikStatement);
                        stat.setInt(1, id);
                        stat.setInt(2, markt);
                        stat.setString(3, bildTyp);
                        listeBteRs = stat.executeQuery();
                        while (listeBteRs.next()) {
                            byte[] blob = listeBteRs.getBytes(1);
                            if (listeBteRs.wasNull() || blob == null || blob.length <= 0) continue;
                            byArray = blob;
                            if (listeBteRs == null) break block5;
                            break block6;
                        }
                        byArray2 = null;
                        if (listeBteRs == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (listeBteRs != null) {
                            WebetkUtils.closeQuery(listeBteRs);
                            throw throwable;
                        }
                        if (stat == null) throw throwable;
                        stat.close();
                        throw throwable;
                    }
                    WebetkUtils.closeQuery(listeBteRs);
                    return byArray2;
                }
                if (stat == null) return byArray2;
                stat.close();
                return byArray2;
            }
            WebetkUtils.closeQuery(listeBteRs);
            return byArray;
        }
        if (stat == null) return byArray;
        stat.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProduktId> ermittleBtesZuUnterkategorie(long hauptkatid, long unterkatid, int marktId, String marke, String produktart, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Connection con;
        ServerGlobalObjects globs;
        ArrayList<ProduktId> bteListe;
        block14: {
            Statement stat;
            block13: {
                bteListe = new ArrayList<ProduktId>();
                globs = ServerGlobalObjects.getInstance();
                log.debug("Now Accessing Database");
                con = null;
                stat = null;
                ResultSet listeBteRs = null;
                try {
                    con = globs.getDBConnection("zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
                    String bteStatement = SQLStatements.ProduktSuche.instance.LISTE_BTE_UNTERKATEGORIE();
                    stat = con.prepareStatement(bteStatement);
                    stat.setString(1, "HP_PAKET");
                    stat.setString(2, "HP_PAKET");
                    stat.setInt(3, marktId);
                    if (hauptkatid > 0L) {
                        stat.setLong(4, hauptkatid);
                    } else {
                        stat.setNull(4, 4);
                    }
                    stat.setLong(5, unterkatid);
                    stat.setString(6, marke);
                    stat.setString(7, produktart);
                    stat.setString(8, iso == null ? " " : iso);
                    stat.setString(9, regIso == null ? " " : regIso);
                    stat.setString(10, iso == null ? " " : iso);
                    stat.setString(11, regIso == null ? " " : regIso);
                    listeBteRs = stat.executeQuery();
                    while (listeBteRs.next()) {
                        ProduktId id;
                        String bteNr = listeBteRs.getString(1);
                        String art = listeBteRs.getString(5);
                        String bnb = listeBteRs.getString(6);
                        String hkBez = listeBteRs.getString(7);
                        String ukBez = listeBteRs.getString(8);
                        String lkz = listeBteRs.getString(9);
                        art = art.equals("U") ? "ASS" : "FZG";
                        HauptKategorie kat = new HauptKategorie(listeBteRs.getInt("hkId"), marke, produktart, hkBez, listeBteRs.getInt("hkPos"), new ArrayList<HitListenUnterkategorie>());
                        HitListenUnterkategorie uKat = new HitListenUnterkategorie(listeBteRs.getInt("ukId"), ukBez, listeBteRs.getInt("hkPos"), listeBteRs.getString("istLifestyle").equals("J"));
                        if (bnb != null) {
                            id = new ProduktId(bteNr);
                            id.setBteArt(art);
                            id.setHauptkategorie(kat);
                            id.setUnterkategorie(uKat);
                            id.setLkz(lkz);
                            if (!bteListe.contains(id)) {
                                bteListe.add(id);
                            }
                            id = new ProduktId(bteNr, bnb);
                            id.setBteArt(art);
                            id.setHauptkategorie(kat);
                            id.setUnterkategorie(uKat);
                            id.setLkz(lkz);
                            if (bteListe.contains(id)) continue;
                            bteListe.add(id);
                            continue;
                        }
                        id = new ProduktId(bteNr);
                        id.setBteArt(art);
                        id.setHauptkategorie(kat);
                        id.setUnterkategorie(uKat);
                        id.setLkz(lkz);
                        if (bteListe.contains(id)) continue;
                        bteListe.add(id);
                    }
                    if (listeBteRs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (listeBteRs != null) {
                        WebetkUtils.closeQuery(listeBteRs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(listeBteRs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
        }
        Collections.sort(bteListe);
        return bteListe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBauartenBaum(String bteNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBauartenBaumInternal(con, bteNr, "", marke, produktArt, katalogUmfang, regionen, iso, regIso);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBnbBauartenBaum(String bteNr, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBauartenBaumInternal(con, bteNr, bildPosNr, marke, produktArt, katalogUmfang, regionen, iso, regIso);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleBauartenBaumInternal(Connection con, String bteNr, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<Bauart> arrayList;
        block14: {
            Statement stat;
            block13: {
                stat = null;
                ResultSet rs = null;
                try {
                    String statement = SQLStatements.ProduktSuche.instance.ERMITTLE_BAUARTENBAUM_FUER_PRODUKT();
                    statement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(statement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(statement, "REGIONEN", regionen);
                    stat = con.prepareStatement(statement);
                    stat.setString(1, bteNr);
                    stat.setString(2, katalogUmfang);
                    stat.setString(3, katalogUmfang);
                    stat.setString(4, marke);
                    stat.setString(5, produktArt);
                    stat.setString(6, iso == null ? "" : iso);
                    stat.setString(7, regIso == null ? "" : regIso);
                    stat.setString(8, iso == null ? "" : iso);
                    stat.setString(9, regIso == null ? "" : regIso);
                    stat.setString(10, iso == null ? "" : iso);
                    stat.setString(11, regIso == null ? "" : regIso);
                    if (bildPosNr == null || bildPosNr.length() == 0) {
                        stat.setNull(12, 1);
                    } else {
                        stat.setString(12, bildPosNr);
                    }
                    rs = stat.executeQuery();
                    ArrayList<Bauart> bauarten = new ArrayList<Bauart>();
                    while (rs.next()) {
                        List<KatalogAusfuehrung> katalogAusfuehrungen;
                        Modell modell;
                        List<Modell> modelle;
                        String bauartId = rs.getString(2);
                        String bauartName = rs.getString(3);
                        String baureiheId = rs.getString(5);
                        String baureiheName = rs.getString(6);
                        String karosserieId = rs.getString(7);
                        String karosserieName = rs.getString(8);
                        String modellName = rs.getString(9);
                        String katalogAusfuehrung = rs.getString(10);
                        Bauart bauart = new Bauart(bauartId, bauartName, new ArrayList<Baureihe>());
                        if (!bauarten.contains(bauart)) {
                            bauarten.add(bauart);
                        }
                        Baureihe baureihe = new Baureihe(baureiheId, baureiheName, new ArrayList<KarosserieForm>());
                        List<Baureihe> baureihen = ((Bauart)bauarten.get(bauarten.indexOf(bauart))).getBaureihe();
                        if (!baureihen.contains(baureihe)) {
                            baureihen.add(baureihe);
                        }
                        KarosserieForm kForm = new KarosserieForm(karosserieId, karosserieName, new ArrayList<Modell>());
                        List<KarosserieForm> karosserieFormen = baureihen.get(baureihen.indexOf(baureihe)).getKarosserieForm();
                        if (!karosserieFormen.contains(kForm)) {
                            karosserieFormen.add(kForm);
                        }
                        if (!(modelle = karosserieFormen.get(karosserieFormen.indexOf(kForm)).getModelle()).contains(modell = new Modell(modellName, new ArrayList<KatalogAusfuehrung>()))) {
                            modelle.add(modell);
                        }
                        if ((katalogAusfuehrungen = modelle.get(modelle.indexOf(modell)).getKatalogausfuehrungen()).contains(katalogAusfuehrung)) continue;
                        KatalogAusfuehrung kat = new KatalogAusfuehrung(katalogAusfuehrung);
                        katalogAusfuehrungen.add(kat);
                    }
                    arrayList = bauarten;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBaureihenBaum(String bteNr, int marktId, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBaureihenBaumInternal(con, bteNr, marktId, "", marke, produktArt, katalogUmfang, regionen, iso, regIso);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBnbBaureihenBaum(String bteNr, int marktId, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBaureihenBaumInternal(con, bteNr, marktId, bildPosNr, marke, produktArt, katalogUmfang, regionen, iso, regIso);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleBaureihenBaumInternal(Connection con, String bteNr, int marktId, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<Baureihe> arrayList;
        block13: {
            Statement stat;
            block12: {
                stat = null;
                ResultSet rs = null;
                try {
                    String statement = SQLStatements.ProduktSuche.instance.ERMITTLE_BAUREIHENBAUM_FUER_PRODUKT();
                    statement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(statement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(statement, "REGIONEN", regionen);
                    stat = con.prepareStatement(statement);
                    stat.setString(1, bteNr);
                    stat.setInt(2, marktId);
                    stat.setString(3, katalogUmfang);
                    stat.setString(4, katalogUmfang);
                    stat.setString(5, marke);
                    stat.setString(6, produktArt);
                    stat.setString(7, iso == null ? "" : iso);
                    stat.setString(8, regIso == null ? "" : regIso);
                    stat.setString(9, iso == null ? "" : iso);
                    stat.setString(10, regIso == null ? "" : regIso);
                    if (bildPosNr == null || bildPosNr.length() == 0) {
                        stat.setNull(11, 1);
                    } else {
                        stat.setString(11, bildPosNr);
                    }
                    rs = stat.executeQuery();
                    ArrayList<Baureihe> baureihen = new ArrayList<Baureihe>();
                    while (rs.next()) {
                        List<KatalogAusfuehrung> katalogAusfuehrungen;
                        Modell modell;
                        List<Modell> modelle;
                        String baureiheId = rs.getString(2);
                        String baureiheName = rs.getString(3);
                        String karosserieId = rs.getString(4);
                        String karosserieName = rs.getString(5);
                        String modellName = rs.getString(6);
                        String katalogAusfuehrung = rs.getString(7);
                        Baureihe baureihe = new Baureihe(baureiheId, baureiheName, new ArrayList<KarosserieForm>());
                        if (!baureihen.contains(baureihe)) {
                            baureihen.add(baureihe);
                        }
                        KarosserieForm kForm = new KarosserieForm(karosserieId, karosserieName, new ArrayList<Modell>());
                        List<KarosserieForm> karosserieFormen = ((Baureihe)baureihen.get(baureihen.indexOf(baureihe))).getKarosserieForm();
                        if (!karosserieFormen.contains(kForm)) {
                            karosserieFormen.add(kForm);
                        }
                        if (!(modelle = karosserieFormen.get(karosserieFormen.indexOf(kForm)).getModelle()).contains(modell = new Modell(modellName, new ArrayList<KatalogAusfuehrung>()))) {
                            modelle.add(modell);
                        }
                        if ((katalogAusfuehrungen = modelle.get(modelle.indexOf(modell)).getKatalogausfuehrungen()).contains(katalogAusfuehrung)) continue;
                        KatalogAusfuehrung kat = new KatalogAusfuehrung(katalogAusfuehrung);
                        katalogAusfuehrungen.add(kat);
                    }
                    arrayList = baureihen;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block13;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBaureihenBaumWithBauart(String bteNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso, String bauart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBaureihenBaumWithBauartInternal(con, bteNr, "", marke, produktArt, katalogUmfang, regionen, iso, regIso, bauart);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBnbBaureihenBaumWithBauart(String bteNr, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso, String bauart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleBaureihenBaum");
            List list = SucheDbAccess.ermittleBaureihenBaumWithBauartInternal(con, bteNr, bildPosNr, marke, produktArt, katalogUmfang, regionen, iso, regIso, bauart);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBaureihenBaum");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleBaureihenBaumWithBauartInternal(Connection con, String bteNr, String bildPosNr, String marke, String produktArt, String katalogUmfang, String regionen, String iso, String regIso, String bauart) throws SQLException, DatabaseBusyException {
        ArrayList<Baureihe> arrayList;
        block13: {
            Statement stat;
            block12: {
                stat = null;
                ResultSet rs = null;
                try {
                    String statement = SQLStatements.ProduktSuche.instance.ERMITTLE_BAUREIHENBAUM_FUER_PRODUKT_WITH_BAUART();
                    statement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(statement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(statement, "REGIONEN", regionen);
                    stat = con.prepareStatement(statement);
                    stat.setString(1, bteNr);
                    stat.setString(2, katalogUmfang);
                    stat.setString(3, katalogUmfang);
                    stat.setString(4, marke);
                    stat.setString(5, produktArt);
                    stat.setString(6, iso == null ? "" : iso);
                    stat.setString(7, regIso == null ? "" : regIso);
                    stat.setString(8, iso == null ? "" : iso);
                    stat.setString(9, regIso == null ? "" : regIso);
                    if (bildPosNr == null || bildPosNr.length() == 0) {
                        stat.setNull(10, 1);
                    } else {
                        stat.setString(10, bildPosNr);
                    }
                    stat.setString(11, bauart);
                    rs = stat.executeQuery();
                    ArrayList<Baureihe> baureihen = new ArrayList<Baureihe>();
                    while (rs.next()) {
                        List<KatalogAusfuehrung> katalogAusfuehrungen;
                        Modell modell;
                        List<Modell> modelle;
                        String baureiheId = rs.getString(2);
                        String baureiheName = rs.getString(3);
                        String karosserieId = rs.getString(4);
                        String karosserieName = rs.getString(5);
                        String modellName = rs.getString(6);
                        String katalogAusfuehrung = rs.getString(7);
                        Baureihe baureihe = new Baureihe(baureiheId, baureiheName, new ArrayList<KarosserieForm>());
                        if (!baureihen.contains(baureihe)) {
                            baureihen.add(baureihe);
                        }
                        KarosserieForm kForm = new KarosserieForm(karosserieId, karosserieName, new ArrayList<Modell>());
                        List<KarosserieForm> karosserieFormen = ((Baureihe)baureihen.get(baureihen.indexOf(baureihe))).getKarosserieForm();
                        if (!karosserieFormen.contains(kForm)) {
                            karosserieFormen.add(kForm);
                        }
                        if (!(modelle = karosserieFormen.get(karosserieFormen.indexOf(kForm)).getModelle()).contains(modell = new Modell(modellName, new ArrayList<KatalogAusfuehrung>()))) {
                            modelle.add(modell);
                        }
                        if ((katalogAusfuehrungen = modelle.get(modelle.indexOf(modell)).getKatalogausfuehrungen()).contains(katalogAusfuehrung)) continue;
                        KatalogAusfuehrung kat = new KatalogAusfuehrung(katalogAusfuehrung);
                        katalogAusfuehrungen.add(kat);
                    }
                    arrayList = baureihen;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block13;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProduktListenElement> ermittleProduktListeZuBtNrn(List<ProduktId> bteNrn, String firmaId, int marktId, String marktBen, String marke, String produktArt, String regionen, String katalogUmfang, String iso, String regIso, int fetchSize, int blockNr, boolean isLifestyle) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("holeMarketingInfosZuBteNrn");
            StringBuffer bteBuffer = new StringBuffer();
            HashMap<ProduktId, ProduktListenElement> mprod = new HashMap<ProduktId, ProduktListenElement>();
            List<ProduktId> bnbProdukte = SucheDbAccess.extractBte(bteBuffer, bteNrn, blockNr, fetchSize, mprod, marktBen);
            if (mprod.isEmpty()) {
                ArrayList<ProduktListenElement> arrayList = new ArrayList<ProduktListenElement>();
                return arrayList;
            }
            log.debug("Ermittle Texte zu Marketingprodukt with params: MARKTID:" + String.valueOf(marktId) + " ISO:" + iso + " SPRISO:" + regIso);
            SucheDbAccess.ermittleTexteZuMarketingProdukt(con, mprod, bteBuffer.toString(), marktId, iso, regIso);
            SucheDbAccess.ermittleTexteZuMarketingProduktPET(con, mprod, bnbProdukte, marktId, iso, regIso);
            if (!SucheDbAccess.ermittleGrafikenZuProdukt(con, mprod, bteBuffer.toString(), marktId)) {
                SucheDbAccess.ermittleGrafikenZuProdukt(con, mprod, bteBuffer.toString(), 0);
            }
            SucheDbAccess.ermittleLetzteFallbackGrafikenZuProdukt(con, mprod, bteBuffer.toString(), "T", marktId, isLifestyle);
            if (!SucheDbAccess.ermittleGrafikenZuProduktPET(con, mprod, bnbProdukte, marktId, iso, regIso)) {
                SucheDbAccess.ermittleGrafikenZuProduktPET(con, mprod, bnbProdukte, 0, iso, regIso);
            }
            SucheDbAccess.ermittleLetzteFallbackGrafikenZuProdukt(con, mprod, bnbProdukte, "T", marktId, isLifestyle);
            if (produktArt.equals("P")) {
                SucheDbAccess.ermittleBaureihen(con, mprod, marktId, regionen, bteBuffer.toString(), marke, produktArt, katalogUmfang, iso, regIso);
                SucheDbAccess.ermittleBaureihenPET(con, bnbProdukte, marktId, regionen, mprod, marke, produktArt, katalogUmfang, iso, regIso);
            } else {
                SucheDbAccess.ermittleBauarten(con, mprod, marktId, regionen, bteBuffer.toString(), marke, produktArt, katalogUmfang, iso, regIso);
                SucheDbAccess.ermittleBauartenPET(con, bnbProdukte, marktId, regionen, mprod, marke, produktArt, katalogUmfang, iso, regIso);
            }
            ArrayList<ProduktListenElement> productList = new ArrayList<ProduktListenElement>();
            Object[] elems = mprod.values().toArray();
            for (int ii = 0; ii < elems.length; ++ii) {
                productList.add((ProduktListenElement)elems[ii]);
            }
            Collections.sort(productList);
            ArrayList<ProduktListenElement> arrayList = productList;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeMarketingInfosZuBteNrn");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleTexteZuMarketingProdukt(Connection con, Map<ProduktId, ProduktListenElement> mprod, String produktListe, int marktId, String iso, String regIso) throws SQLException {
        boolean bl;
        block13: {
            PreparedStatement textPs;
            block12: {
                String marketingStatement = SQLStatements.ProduktSuche.instance.ERMITTLE_MARKETINGINFOS_ZU_PRODUKTLISTE();
                String pStatement = StringUtils.substituteString(marketingStatement, "PRODUKTLISTE", produktListe);
                textPs = null;
                ResultSet textRset = null;
                boolean found = false;
                try {
                    textPs = con.prepareStatement(pStatement);
                    textPs.setInt(1, marktId);
                    textPs.setString(2, iso == null ? "" : iso);
                    textPs.setString(3, regIso == null ? "" : regIso);
                    textRset = textPs.executeQuery();
                    while (textRset.next()) {
                        found = true;
                        String bte = textRset.getString(1);
                        byte[] bdata = textRset.getBytes("mprod_text");
                        int text_laenge = textRset.getInt("text_laenge");
                        String text = null;
                        if (bdata == null) continue;
                        try {
                            text = new String(WebetkUtils.getBytes(bdata, text_laenge), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String art = textRset.getString(3);
                        if (text != null && text.length() > 0 && art.equalsIgnoreCase("PRODUKTNAME")) {
                            text = bte + " - " + text;
                        }
                        ProduktId produktId = new ProduktId(bte);
                        MarketingDbAccess.setzeMarketingTexte(mprod.get(produktId), text, art);
                    }
                    for (ProduktListenElement el : mprod.values()) {
                        if (el.getProduktName() == null || el.getProduktName().length() == 0) {
                            MarketingDbAccess.ermittleProduktnameFallback(con, el, marktId, iso, regIso);
                        }
                        if (el.getTeaser() != null && el.getTeaser().length() != 0 || el.getDetailText() == null || el.getDetailText().length() <= 0) continue;
                        el.setTeaser(el.getDetailText());
                    }
                    bl = found;
                    if (textRset == null) break block12;
                }
                catch (Throwable throwable) {
                    if (textRset != null) {
                        WebetkUtils.closeQuery(textRset);
                    } else if (textPs != null) {
                        textPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(textRset);
                break block13;
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ermittleBTEBedingung(String btenr, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            String string;
            block29: {
                PreparedStatement textPs;
                block27: {
                    String BteBedString;
                    ResultSet textRset;
                    block25: {
                        block28: {
                            block26: {
                                con = globs.getDBConnection("holeBteBedingungText");
                                String marketingStatement = SQLStatements.ProduktSuche.instance.ERMITTLE_BTE_BEDINGUNG();
                                textPs = null;
                                textRset = null;
                                try {
                                    textPs = con.prepareStatement(marketingStatement);
                                    textPs.setString(1, btenr);
                                    textPs.setString(2, iso == null ? "" : iso);
                                    textPs.setString(3, regIso == null ? "" : regIso);
                                    textRset = textPs.executeQuery();
                                    BteBedString = "";
                                    String bedStringOG_SALA = "";
                                    String bedStringOG_SZ = "";
                                    String bedGesamtTerm = "";
                                    boolean isSZSALATerm = false;
                                    boolean isBoolExp = false;
                                    while (textRset.next()) {
                                        String bedString = "";
                                        String verknuepfung = textRset.getString(2);
                                        String vorzeichen = textRset.getString(3);
                                        String bedsala_art = textRset.getString(4);
                                        String bedsala_pnr = textRset.getString(5);
                                        String bedsala_hz = textRset.getString(6);
                                        String bedText = textRset.getString(7);
                                        String gesamtterm = textRset.getString(8);
                                        String obergruppe = textRset.getString(9);
                                        if ("T".equals(verknuepfung) || "A".equals(verknuepfung) || "R".equals(verknuepfung)) {
                                            isBoolExp = true;
                                            break;
                                        }
                                        if (gesamtterm.indexOf("SALA_P") != -1 && gesamtterm.indexOf("SZ_P") != -1) {
                                            isSZSALATerm = true;
                                            bedGesamtTerm = gesamtterm;
                                            bedString = "";
                                            if (obergruppe.equals("SALA_P")) {
                                                bedString = bedString + bedsala_art + bedsala_pnr + bedsala_hz + " " + bedText;
                                                bedString = vorzeichen.equals("-") ? bedString + " = nein " : bedString + " = ja ";
                                                if (bedStringOG_SALA == "") {
                                                    bedStringOG_SALA = bedString;
                                                    continue;
                                                }
                                                bedString = verknuepfung.equals("U") ? "<br>und " + bedString : "<br>oder " + bedString;
                                                bedStringOG_SALA = bedStringOG_SALA + " " + bedString;
                                                continue;
                                            }
                                            if (!obergruppe.equals("SZ_P")) continue;
                                            bedString = bedString + bedsala_art + bedsala_pnr + bedsala_hz + " " + bedText;
                                            bedString = vorzeichen.equals("-") ? bedString + " = nein " : bedString + " = ja ";
                                            if (bedStringOG_SZ == "") {
                                                bedStringOG_SZ = bedString;
                                                continue;
                                            }
                                            bedString = verknuepfung.equals("U") ? "<br>und " + bedString : "<br>oder " + bedString;
                                            bedStringOG_SZ = bedStringOG_SZ + " " + bedString;
                                            continue;
                                        }
                                        bedString = bedString + bedsala_art + bedsala_pnr + bedsala_hz + " " + bedText;
                                        bedString = vorzeichen.equals("-") ? bedString + " = nein " : bedString + " = ja ";
                                        if (BteBedString == "") {
                                            String bteBedText;
                                            BteBedString = bteBedText = "F\u00fcr Fahrzeuge mit " + bedString;
                                            continue;
                                        }
                                        bedString = verknuepfung.equals("U") ? "<br>und " + bedString : "<br>oder " + bedString;
                                        BteBedString = BteBedString + " " + bedString;
                                    }
                                    if (isSZSALATerm) {
                                        BteBedString = "F\u00fcr Fahrzeuge mit ";
                                        if (bedGesamtTerm.indexOf("/") != -1) {
                                            BteBedString = BteBedString + bedStringOG_SALA + " <br>oder " + bedStringOG_SZ;
                                        } else if (bedGesamtTerm.indexOf("&") != -1) {
                                            BteBedString = BteBedString + bedStringOG_SALA + " <br>und " + bedStringOG_SZ;
                                        }
                                    }
                                    if (!isBoolExp) break block25;
                                    string = "";
                                    if (textRset == null) break block26;
                                }
                                catch (Throwable throwable) {
                                    if (textRset != null) {
                                        WebetkUtils.closeQuery(textRset);
                                    } else if (textPs != null) {
                                        textPs.close();
                                    }
                                    throw throwable;
                                }
                                WebetkUtils.closeQuery(textRset);
                                break block28;
                            }
                            if (textPs != null) {
                                textPs.close();
                            }
                        }
                        return string;
                    }
                    string = BteBedString;
                    if (textRset == null) break block27;
                    WebetkUtils.closeQuery(textRset);
                    break block29;
                }
                if (textPs != null) {
                    textPs.close();
                }
            }
            return string;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBteBedingungText");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleTexteZuMarketingProduktPET(Connection con, Map mprod, List bnbProdukte, int marktId, String iso, String regIso) throws SQLException {
        boolean bl;
        block16: {
            PreparedStatement textPs;
            block15: {
                if (bnbProdukte == null || bnbProdukte.size() == 0) {
                    return true;
                }
                StringBuffer bildPosBuffer = new StringBuffer();
                for (ProduktId id : bnbProdukte) {
                    SucheDbAccess.conditionCreator(id, bildPosBuffer);
                }
                boolean productsFound = false;
                String statement = StringUtils.substituteString(SQLStatements.ProduktSuche.instance.ERMITTLE_MARKETINGINFOS_ZU_PRODUKTLISTE_PET(), "CONDITIONS", bildPosBuffer.toString());
                textPs = null;
                ResultSet textRset = null;
                try {
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, marktId);
                    textPs.setString(2, iso == null ? "" : iso);
                    textPs.setString(3, regIso == null ? "" : regIso);
                    for (int counter = 0; counter < bnbProdukte.size(); ++counter) {
                        ProduktId id = (ProduktId)bnbProdukte.get(counter);
                        textPs.setString(4 + counter * 2, id.getBteNr());
                        textPs.setString(4 + counter * 2 + 1, id.getBildPosNr());
                    }
                    textRset = textPs.executeQuery();
                    while (textRset.next()) {
                        productsFound = true;
                        String bte = textRset.getString(1);
                        String bildPos = textRset.getString(2);
                        byte[] bdata = textRset.getBytes("mprod_text");
                        int text_laenge = textRset.getInt("text_laenge");
                        String text = null;
                        if (bdata == null) continue;
                        try {
                            text = new String(WebetkUtils.getBytes(bdata, text_laenge), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String art = textRset.getString(4);
                        if (text != null && text.length() > 0 && art.equalsIgnoreCase("PRODUKTNAME")) {
                            text = bte + " " + bildPos + " - " + text;
                        }
                        ProduktId produktId = new ProduktId(bte, bildPos);
                        ProduktListenElement produktListenElement = (ProduktListenElement)mprod.get(produktId);
                        MarketingDbAccess.setzeMarketingTexte(produktListenElement, text, art);
                    }
                    for (ProduktId bnbElem : bnbProdukte) {
                        ProduktListenElement el = (ProduktListenElement)mprod.get(bnbElem);
                        if (el.getProduktName() == null || el.getProduktName().length() == 0) {
                            MarketingDbAccess.ermittleProduktnameFallback(con, el, marktId, iso, regIso);
                        }
                        if (el.getTeaser() != null && el.getTeaser().length() != 0 || el.getDetailText() == null || el.getDetailText().length() <= 0) continue;
                        el.setTeaser(el.getDetailText());
                    }
                    bl = productsFound;
                    if (textRset == null) break block15;
                }
                catch (Throwable throwable) {
                    if (textRset != null) {
                        WebetkUtils.closeQuery(textRset);
                    } else if (textPs != null) {
                        textPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(textRset);
                break block16;
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuProdukt(Connection con, Map mprod, String produktListe, int marktId) throws SQLException, DatabaseBusyException {
        boolean bl;
        block9: {
            PreparedStatement thumbNailPs;
            block8: {
                String thumbNailStatement = SQLStatements.ProduktSuche.instance.ERMITTLE_GRAFIKEN_ZU_PRODUKTLISTE();
                String tStatement = StringUtils.substituteString(thumbNailStatement, "PRODUKTLISTE", produktListe);
                thumbNailPs = null;
                ResultSet tnRset = null;
                boolean wasLoaded = false;
                try {
                    thumbNailPs = con.prepareStatement(tStatement);
                    thumbNailPs.setInt(1, marktId);
                    thumbNailPs.setString(2, "T");
                    tnRset = thumbNailPs.executeQuery();
                    while (tnRset.next()) {
                        wasLoaded = true;
                        String bte = tnRset.getString("btenr");
                        byte[] blob = tnRset.getBytes("image");
                        ProduktId produktId = new ProduktId(bte);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        if (((ProduktListenElement)mprod.get(produktId)).getThumbNail() != null) continue;
                        m.setImageData(blob);
                    }
                    for (ProduktListenElement el : mprod.values()) {
                        byte[] erstesFallbackBild;
                        if (el.getZubehoergrafik().getImageData() != null && el.getZubehoergrafik().getImageData().length != 0 || (erstesFallbackBild = SucheDbAccess.ermittleErstesFallbackBild(con, "T", el, marktId)) == null) continue;
                        wasLoaded = true;
                        el.setImageData(erstesFallbackBild);
                    }
                    bl = wasLoaded;
                    if (tnRset == null) break block8;
                }
                catch (Throwable throwable) {
                    if (tnRset != null) {
                        WebetkUtils.closeQuery(tnRset);
                    } else if (thumbNailPs != null) {
                        thumbNailPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(tnRset);
                break block9;
            }
            if (thumbNailPs != null) {
                thumbNailPs.close();
            }
        }
        return bl;
    }

    private static void ermittleLetzteFallbackGrafikenZuProdukt(Connection con, Map mprod, String produktListe, String typ, int marktId, boolean isLifestyle) throws SQLException, DatabaseBusyException {
        for (ProduktListenElement el : mprod.values()) {
            if (el.getUnterkategorie() != null) {
                isLifestyle = el.getUnterkategorie().isLifestyle();
            }
            if (el.getZubehoergrafik().getImageData() != null && el.getZubehoergrafik().getImageData().length != 0) continue;
            el.setGrafik(SucheDbAccess.ermittleLetztesFallbackBild(con, typ, el, marktId, isLifestyle));
        }
    }

    private static void ermittleLetzteFallbackGrafikenZuProdukt(Connection con, Map mprod, List bnbListe, String typ, int marktId, boolean isLifestyle) throws SQLException, DatabaseBusyException {
        for (ProduktListenElement el : mprod.values()) {
            if (el.getUnterkategorie() != null) {
                isLifestyle = el.getUnterkategorie().isLifestyle();
            }
            if (el.getZubehoergrafik().getImageData() != null && el.getZubehoergrafik().getImageData().length != 0) continue;
            el.setGrafik(SucheDbAccess.ermittleLetztesFallbackBild(con, typ, el, marktId, isLifestyle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ermittleErstesFallbackBild(Connection con, String typ, BaseMarketingProdukt produktListenElement, int marktId) throws SQLException, DatabaseBusyException {
        byte[] byArray;
        block14: {
            PreparedStatement stat;
            block12: {
                ResultSet rs;
                block10: {
                    byte[] byArray2;
                    block13: {
                        block11: {
                            stat = null;
                            rs = null;
                            String bildPosNr = produktListenElement.getBildPosNr();
                            String statement = bildPosNr != null && bildPosNr.length() > 0 ? SQLStatements.ProduktSuche.instance.ERMITTLE_PRODUKTBILDER_PET_FALLBACK() : SQLStatements.ProduktSuche.instance.ERMITTLE_PRODUKTBILDER_GESAMT_FALLBACK();
                            try {
                                stat = con.prepareStatement(statement);
                                if (bildPosNr != null && bildPosNr.length() > 0) {
                                    stat.setString(1, produktListenElement.getBteNr());
                                    stat.setString(2, bildPosNr);
                                    stat.setInt(3, marktId);
                                    stat.setString(4, typ);
                                    stat.setString(5, "SHOWROOM");
                                } else {
                                    stat.setString(1, produktListenElement.getBteNr());
                                    stat.setInt(2, marktId);
                                    stat.setString(3, typ);
                                    stat.setString(4, "SHOWROOM");
                                }
                                rs = stat.executeQuery();
                                if (!rs.next()) break block10;
                                byArray2 = rs.getBytes(1);
                                if (rs == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    WebetkUtils.closeQuery(rs);
                                } else if (stat != null) {
                                    stat.close();
                                }
                                throw throwable;
                            }
                            WebetkUtils.closeQuery(rs);
                            break block13;
                        }
                        if (stat != null) {
                            stat.close();
                        }
                    }
                    return byArray2;
                }
                byArray = null;
                if (rs == null) break block12;
                WebetkUtils.closeQuery(rs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return byArray;
    }

    public static Zubehoergrafik ermittleLetztesFallbackBild(Connection con, String typ, BaseMarketingProdukt produktListenElement, int marktId, boolean isLifestyle) throws SQLException, DatabaseBusyException {
        IntegerWrapper hkIdWrapper = new IntegerWrapper(null);
        IntegerWrapper ukIdWrapper = new IntegerWrapper(null);
        SucheDbAccess.ermittleHkUkAusProdukt(con, produktListenElement.getBteNr(), hkIdWrapper, ukIdWrapper);
        Integer ukId = ukIdWrapper.getValue();
        if (ukId != null) {
            if (isLifestyle) {
                return (Zubehoergrafik)TechnischDbAccess.ermittleExplosionsGrafik(produktListenElement.getBteNr()).get(0);
            }
            Zubehoergrafik zubGr = SucheDbAccess.ermittleUnterkategorieBild(con, ukId, typ);
            if (zubGr.getImageData() == null) {
                zubGr = new Zubehoergrafik(SucheDbAccess.holeNoImageIcon(con, typ), new Integer(-1));
                return zubGr;
            }
            if (zubGr.getImageData() != null && zubGr.getImageData().length > 0) {
                return zubGr;
            }
        }
        return new Zubehoergrafik(SucheDbAccess.holeNoImageIcon(con, typ), new Integer(-1));
    }

    private static Zubehoergrafik ermittleUnterkategorieBild(Connection con, Integer ukId, String typ) throws SQLException {
        PreparedStatement stat = con.prepareStatement(SQLStatements.Listenfueller.instance.ERMITTLE_GRAFIK_UNTERKATEGORIE_EINZELN());
        Zubehoergrafik zubGr = null;
        byte[] grafik = null;
        Integer grafikId = null;
        stat.setString(1, typ);
        stat.setInt(2, ukId);
        ResultSet rs = stat.executeQuery();
        if (rs.next()) {
            grafik = rs.getBytes("image");
            grafikId = new Integer(rs.getInt("grafikid"));
        }
        zubGr = new Zubehoergrafik(grafik, grafikId);
        rs.close();
        stat.close();
        return zubGr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] holeNoImageIcon(Connection con, String typ) throws SQLException {
        byte[] byArray;
        block14: {
            PreparedStatement stat;
            block12: {
                ResultSet rs;
                block10: {
                    byte[] byArray2;
                    block13: {
                        block11: {
                            if (noImageIcons == null) {
                                noImageIcons = new HashMap();
                            }
                            if (noImageIcons.containsKey(typ)) {
                                return (byte[])noImageIcons.get(typ);
                            }
                            stat = null;
                            rs = null;
                            String statement = SQLStatements.ProduktSuche.instance.HOLE_NO_IMAGE_ICON();
                            try {
                                stat = con.prepareStatement(statement);
                                stat.setString(1, typ);
                                rs = stat.executeQuery();
                                if (!rs.next()) break block10;
                                byte[] noImageIcon = rs.getBytes("image");
                                noImageIcons.put(typ, noImageIcon);
                                byArray2 = noImageIcon;
                                if (rs == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    WebetkUtils.closeQuery(rs);
                                } else if (stat != null) {
                                    stat.close();
                                }
                                throw throwable;
                            }
                            WebetkUtils.closeQuery(rs);
                            break block13;
                        }
                        if (stat != null) {
                            stat.close();
                        }
                    }
                    return byArray2;
                }
                log.error("'No image available'-Grafik nicht gefunden.");
                noImageIcons.put(typ, null);
                byArray = null;
                if (rs == null) break block12;
                WebetkUtils.closeQuery(rs);
                break block14;
            }
            if (stat != null) {
                stat.close();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ermittleHkUkAusProdukt(String btenr, IntegerWrapper hkId, IntegerWrapper ukId) throws SQLException, DatabaseBusyException {
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("zub.suche.AdminToolDbAccess.ermittleHkUkAusProdukt");
            SucheDbAccess.ermittleHkUkAusProdukt(con, btenr, hkId, ukId);
        }
        finally {
            if (con != null) {
                ServerGlobalObjects.getInstance().freeDBConnection(con, "zub.suche.AdminToolDbAccess.ermittleHkUkAusProdukt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleHkUkAusProdukt(Connection con, String btenr, IntegerWrapper hkId, IntegerWrapper ukId) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block10: {
            int uk;
            int hk;
            block11: {
                block13: {
                    block12: {
                        ps = null;
                        rs = null;
                        hkId.setValue(null);
                        ukId.setValue(null);
                        try {
                            ps = con.prepareStatement(SQLStatements.ProduktSuche.instance.ERMITTLE_HK_UK_ZU_PRODUKT());
                            ps.setString(1, btenr);
                            rs = ps.executeQuery();
                            if (!rs.next()) break block10;
                            hk = rs.getInt("hk");
                            uk = rs.getInt("uk");
                            if (!rs.wasNull()) break block11;
                            if (rs == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                WebetkUtils.closeQuery(rs);
                            } else if (ps != null) {
                                ps.close();
                            }
                            throw throwable;
                        }
                        WebetkUtils.closeQuery(rs);
                        break block13;
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
                return;
            }
            hkId.setValue(new Integer(hk));
            ukId.setValue(new Integer(uk));
        }
        if (rs != null) {
            WebetkUtils.closeQuery(rs);
        } else if (ps != null) {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleGrafikenZuProduktPET(Connection con, Map mprod, List bnbProdukte, int marktId, String iso, String regIso) throws SQLException {
        boolean bl;
        block11: {
            PreparedStatement tnPs;
            block10: {
                if (bnbProdukte == null || bnbProdukte.size() == 0) {
                    return true;
                }
                StringBuffer bildPosBuffer = new StringBuffer();
                for (ProduktId id : bnbProdukte) {
                    SucheDbAccess.conditionCreator(id, bildPosBuffer);
                }
                String statement = StringUtils.substituteString(SQLStatements.ProduktSuche.instance.ERMITTLE_GRAFIKEN_ZU_PRODUKTLISTE_PET(), "CONDITIONS", bildPosBuffer.toString());
                tnPs = null;
                ResultSet tnRset = null;
                boolean wasLoaded = false;
                try {
                    tnPs = con.prepareStatement(statement);
                    tnPs.setInt(1, marktId);
                    tnPs.setString(2, "T");
                    for (int counter = 0; counter < bnbProdukte.size(); ++counter) {
                        ProduktId id = (ProduktId)bnbProdukte.get(counter);
                        tnPs.setString(3 + counter * 2, id.getBteNr());
                        tnPs.setString(3 + counter * 2 + 1, id.getBildPosNr());
                    }
                    tnRset = tnPs.executeQuery();
                    while (tnRset.next()) {
                        wasLoaded = true;
                        String bte = tnRset.getString("btenr");
                        String bildPos = tnRset.getString("pos");
                        byte[] blob = tnRset.getBytes("image");
                        ProduktId produktId = new ProduktId(bte, bildPos);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        if (((ProduktListenElement)mprod.get(produktId)).getThumbNail() != null) continue;
                        m.setImageData(blob);
                    }
                    bl = wasLoaded;
                    if (tnRset == null) break block10;
                }
                catch (Throwable throwable) {
                    if (tnRset != null) {
                        WebetkUtils.closeQuery(tnRset);
                    } else if (tnPs != null) {
                        tnPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(tnRset);
                break block11;
            }
            if (tnPs != null) {
                tnPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleBtesZuUnterkategorie(long hauptkatid, long unterkatid, int marktId, String marke, String produktart, Baureihe baureihe, String regionen, String katalogUmfang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
            List list = SucheDbAccess.ermittleBteListeZuUnterkatMitFz(con, baureihe, hauptkatid, unterkatid, marktId, regionen, marke, produktart, katalogUmfang, iso, regIso);
            return list;
        }
        finally {
            globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProduktId> ermittleBtesZuUnterkategorie(long hauptkatid, long unterkatid, int marktId, String marke, String produktart, FzgSucheInfo fzInfo, String regionen, String katalogUmfang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
            List<ProduktId> list = SucheDbAccess.ermittleBteListeZuUnterkatMitFzSuchInfo(con, fzInfo, hauptkatid, unterkatid, marktId, regionen, marke, produktart, katalogUmfang, iso, regIso);
            return list;
        }
        finally {
            globs.freeDBConnection(con, "zub.suche.AdminToolDbAccess.ermittleBtesZuUnterkategorie");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ProduktId> ermittleBteListeZuUnterkatMitFzSuchInfo(Connection con, FzgSucheInfo fzInfo, long hauptkatId, long unterkatId, int marktId, String regionen, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<ProduktId> arrayList;
        block23: {
            PreparedStatement ps;
            block22: {
                if (fzInfo == null || fzInfo.getModell() == null) {
                    return SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, iso, regIso);
                }
                ArrayList<ProduktId> bteListe = new ArrayList<ProduktId>();
                ps = null;
                ResultSet rs = null;
                try {
                    String statement = SQLStatements.ProduktSuche.instance.LISTE_BTE_UNTERKATEGORIE_FAHRZEUG();
                    ps = con.prepareStatement(statement);
                    ps.setInt(1, marktId);
                    if (fzInfo.getBaureihe() == null) {
                        ps.setNull(2, 12);
                    } else {
                        ps.setString(2, fzInfo.getBaureihe());
                    }
                    if (fzInfo.getBaureihe() == null) {
                        ps.setNull(3, 12);
                    } else {
                        ps.setString(3, fzInfo.getBaureihe());
                    }
                    if (fzInfo.getKarosserie() == null) {
                        ps.setNull(4, 12);
                    } else {
                        ps.setString(4, fzInfo.getKarosserie());
                    }
                    if (fzInfo.getModell() == null) {
                        ps.setNull(5, 12);
                    } else {
                        ps.setString(5, fzInfo.getModell());
                    }
                    if (fzInfo.getRegion() == null) {
                        ps.setNull(6, 12);
                    } else {
                        ps.setString(6, fzInfo.getRegion());
                    }
                    ps.setInt(7, marktId);
                    if (hauptkatId != 0L) {
                        ps.setLong(8, hauptkatId);
                    } else {
                        ps.setNull(8, 4);
                    }
                    ps.setLong(9, unterkatId);
                    ps.setString(10, marke);
                    ps.setString(11, produktArt);
                    ps.setString(12, iso == null ? " " : iso);
                    ps.setString(13, regIso == null ? " " : regIso);
                    ps.setString(14, iso == null ? " " : iso);
                    ps.setString(15, regIso == null ? " " : regIso);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ProduktId id;
                        String bteNr = rs.getString(1);
                        String bildPosNr = rs.getString(6);
                        String art = rs.getString(5);
                        String lkz = rs.getString(9);
                        art = art.equals("U") ? "ASS" : "FZG";
                        if (bildPosNr != null) {
                            id = new ProduktId(bteNr, bildPosNr);
                            id.setBteArt(art);
                            id.setLkz(lkz);
                            if (!bteListe.contains(id)) {
                                bteListe.add(id);
                            }
                        }
                        id = new ProduktId(bteNr);
                        id.setBteArt(art);
                        id.setLkz(lkz);
                        if (bteListe.contains(id)) continue;
                        bteListe.add(id);
                    }
                    Collections.sort(bteListe);
                    arrayList = bteListe;
                    if (rs == null) break block22;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block23;
            }
            if (ps != null) {
                ps.close();
            }
        }
        return arrayList;
    }

    private static List ermittleBteListeZuUnterkatMitFz(Connection con, Baureihe baureihe, long hauptkatId, long unterkatId, int marktId, String regionen, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        if (baureihe == null || baureihe.getBaureihe() == null) {
            return SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, iso, regIso);
        }
        FzgSucheInfo info = new FzgSucheInfo();
        info.setBaureihe(baureihe.getBaureihe());
        KarosserieForm form = null;
        if (baureihe.getKarosserieForm() != null && baureihe.getKarosserieForm().size() == 1) {
            form = baureihe.getKarosserieForm().get(0);
            info.setKarosserie(baureihe.getKarosserieForm().get(0).getKarosserieForm());
        }
        Modell modell = null;
        if (form != null && form.getModelle() != null && form.getModelle().size() == 1) {
            modell = form.getModelle().get(0);
            info.setModell(modell.getModell());
        }
        KatalogAusfuehrung ausfuehrung = null;
        if (modell != null && modell.getKatalogausfuehrungen() != null && modell.getKatalogausfuehrungen().size() == 1) {
            ausfuehrung = modell.getKatalogausfuehrungen().get(0);
            info.setRegion(ausfuehrung.getKatalogAusfuehrung());
        }
        return SucheDbAccess.ermittleBteListeZuUnterkatMitFzSuchInfo(con, info, hauptkatId, unterkatId, marktId, regionen, marke, produktArt, katalogUmfang, iso, regIso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBauarten(Connection con, Map mprod, int marktId, String regionen, String produktListe, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException {
        block8: {
            PreparedStatement baureihePs;
            block7: {
                String brStatement = StringUtils.substituteString(SQLStatements.ProduktSuche.instance.ERMITTLE_BAUARTEN_ZUR_PRODUKTLISTE(), "PRODUKTLISTE", produktListe);
                brStatement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(brStatement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(brStatement, "REGIONEN", regionen);
                baureihePs = null;
                ResultSet brRset = null;
                try {
                    baureihePs = con.prepareStatement(brStatement);
                    baureihePs.setInt(1, marktId);
                    baureihePs.setString(2, katalogUmfang);
                    baureihePs.setString(3, katalogUmfang);
                    baureihePs.setString(4, marke);
                    baureihePs.setString(5, produktArt);
                    baureihePs.setString(6, iso == null ? "" : iso);
                    baureihePs.setString(7, regIso == null ? "" : regIso);
                    brRset = baureihePs.executeQuery();
                    while (brRset.next()) {
                        String bte = brRset.getString(1);
                        String bauartId = brRset.getString(2);
                        String name = brRset.getString(3);
                        Bauart bauart = new Bauart(bauartId);
                        bauart.setBezeichnung(name);
                        ProduktId produktId = new ProduktId(bte);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        m.getBauarten().add(bauart);
                    }
                    if (brRset == null) break block7;
                }
                catch (Throwable throwable) {
                    if (brRset != null) {
                        WebetkUtils.closeQuery(brRset);
                    } else if (baureihePs != null) {
                        baureihePs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(brRset);
                break block8;
            }
            if (baureihePs != null) {
                baureihePs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBauartenPET(Connection con, List bnbProdukte, int marktId, String regionen, Map mprod, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException {
        block12: {
            PreparedStatement bauartPs;
            block11: {
                if (bnbProdukte == null || bnbProdukte.size() == 0) {
                    return;
                }
                String brPetStatement = SQLStatements.ProduktSuche.instance.ERMITTLE_BAUARTEN_ZUR_PRODUKTLISTE_PET();
                brPetStatement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(brPetStatement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(brPetStatement, "REGIONEN", regionen);
                StringBuffer baureihenStmtBuffer = new StringBuffer();
                Iterator it = bnbProdukte.iterator();
                while (it.hasNext()) {
                    it.next();
                    if (baureihenStmtBuffer.length() > 0) {
                        baureihenStmtBuffer.append(" OR ");
                    }
                    baureihenStmtBuffer.append("( btzeilenz_btnr = ? AND btzeilenz_bildposnr = ? )");
                }
                brPetStatement = StringUtils.substituteString(brPetStatement, "CONDITIONS", baureihenStmtBuffer.toString());
                bauartPs = null;
                ResultSet brRset = null;
                try {
                    bauartPs = con.prepareStatement(brPetStatement);
                    bauartPs.setInt(1, marktId);
                    bauartPs.setString(2, katalogUmfang);
                    bauartPs.setString(3, katalogUmfang);
                    bauartPs.setString(4, marke);
                    bauartPs.setString(5, produktArt);
                    bauartPs.setString(6, iso == null ? "" : iso);
                    bauartPs.setString(7, regIso == null ? "" : regIso);
                    for (int counter = 0; counter < bnbProdukte.size(); ++counter) {
                        ProduktId id = (ProduktId)bnbProdukte.get(counter);
                        bauartPs.setString(8 + counter * 2, id.getBteNr());
                        bauartPs.setString(8 + counter * 2 + 1, id.getBildPosNr());
                    }
                    brRset = bauartPs.executeQuery();
                    while (brRset.next()) {
                        String bte = brRset.getString(1);
                        String bildPosNr = brRset.getString(2);
                        String bauartId = brRset.getString(3);
                        String name = brRset.getString(4);
                        Bauart bauart = new Bauart(bauartId);
                        bauart.setBezeichnung(name);
                        ProduktId produktId = new ProduktId(bte, bildPosNr);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        m.getBauarten().add(bauart);
                    }
                    if (brRset == null) break block11;
                }
                catch (Throwable throwable) {
                    if (brRset != null) {
                        WebetkUtils.closeQuery(brRset);
                    } else if (bauartPs != null) {
                        bauartPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(brRset);
                break block12;
            }
            if (bauartPs != null) {
                bauartPs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBaureihen(Connection con, Map mprod, int marktId, String regionen, String produktListe, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException {
        block8: {
            PreparedStatement baureihePs;
            block7: {
                String brStatement = StringUtils.substituteString(SQLStatements.ProduktSuche.instance.ERMITTLE_BAUREIHEN_ZUR_PRODUKTLISTE(), "PRODUKTLISTE", produktListe);
                brStatement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(brStatement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(brStatement, "REGIONEN", regionen);
                baureihePs = null;
                ResultSet brRset = null;
                try {
                    baureihePs = con.prepareStatement(brStatement);
                    baureihePs.setInt(1, marktId);
                    baureihePs.setString(2, katalogUmfang);
                    baureihePs.setString(3, katalogUmfang);
                    baureihePs.setString(4, marke);
                    baureihePs.setString(5, produktArt);
                    baureihePs.setString(6, iso == null ? "" : iso);
                    baureihePs.setString(7, regIso == null ? "" : regIso);
                    brRset = baureihePs.executeQuery();
                    while (brRset.next()) {
                        String bte = brRset.getString(1);
                        String baureiheId = brRset.getString(2);
                        String name = brRset.getString(3);
                        Baureihe baureihe = new Baureihe(baureiheId);
                        baureihe.setBezeichnung(name);
                        ProduktId produktId = new ProduktId(bte);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        m.getBaureihen().add(baureihe);
                    }
                    if (brRset == null) break block7;
                }
                catch (Throwable throwable) {
                    if (brRset != null) {
                        WebetkUtils.closeQuery(brRset);
                    } else if (baureihePs != null) {
                        baureihePs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(brRset);
                break block8;
            }
            if (baureihePs != null) {
                baureihePs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ermittleBaureihenPET(Connection con, List bnbProdukte, int marktId, String regionen, Map mprod, String marke, String produktArt, String katalogUmfang, String iso, String regIso) throws SQLException {
        block12: {
            PreparedStatement baureihePs;
            block11: {
                if (bnbProdukte == null || bnbProdukte.size() == 0) {
                    return;
                }
                String brPetStatement = SQLStatements.ProduktSuche.instance.ERMITTLE_BAUREIHEN_ZUR_PRODUKTLISTE_PET();
                brPetStatement = regionen == null || regionen.length() == 0 ? StringUtils.substituteString(brPetStatement, "REGIONEN", SQLStatements.ProduktSuche.instance.LISTE_ALLE_KATALOGAUSF()) : StringUtils.substituteString(brPetStatement, "REGIONEN", regionen);
                StringBuffer baureihenStmtBuffer = new StringBuffer();
                Iterator it = bnbProdukte.iterator();
                while (it.hasNext()) {
                    it.next();
                    if (baureihenStmtBuffer.length() > 0) {
                        baureihenStmtBuffer.append(" OR ");
                    }
                    baureihenStmtBuffer.append("( btzeilenz_btnr = ? AND btzeilenz_bildposnr = ? )");
                }
                brPetStatement = StringUtils.substituteString(brPetStatement, "CONDITIONS", baureihenStmtBuffer.toString());
                baureihePs = null;
                ResultSet brRset = null;
                try {
                    baureihePs = con.prepareStatement(brPetStatement);
                    baureihePs.setInt(1, marktId);
                    baureihePs.setString(2, katalogUmfang);
                    baureihePs.setString(3, katalogUmfang);
                    baureihePs.setString(4, marke);
                    baureihePs.setString(5, produktArt);
                    baureihePs.setString(6, iso == null ? "" : iso);
                    baureihePs.setString(7, regIso == null ? "" : regIso);
                    for (int counter = 0; counter < bnbProdukte.size(); ++counter) {
                        ProduktId id = (ProduktId)bnbProdukte.get(counter);
                        baureihePs.setString(8 + counter * 2, id.getBteNr());
                        baureihePs.setString(8 + counter * 2 + 1, id.getBildPosNr());
                    }
                    brRset = baureihePs.executeQuery();
                    while (brRset.next()) {
                        String bte = brRset.getString(1);
                        String bildPosNr = brRset.getString(2);
                        String baureiheId = brRset.getString(3);
                        String name = brRset.getString(4);
                        Baureihe baureihe = new Baureihe(baureiheId);
                        baureihe.setBezeichnung(name);
                        ProduktId produktId = new ProduktId(bte, bildPosNr);
                        ProduktListenElement m = (ProduktListenElement)mprod.get(produktId);
                        m.getBaureihen().add(baureihe);
                    }
                    if (brRset == null) break block11;
                }
                catch (Throwable throwable) {
                    if (brRset != null) {
                        WebetkUtils.closeQuery(brRset);
                    } else if (baureihePs != null) {
                        baureihePs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(brRset);
                break block12;
            }
            if (baureihePs != null) {
                baureihePs.close();
            }
        }
    }

    private static List<ProduktId> extractBte(StringBuffer bteBuffer, List<ProduktId> bteListe, int blockNr, int fetchSize, Map mprod, String marktBen) {
        int startIndex = (blockNr - 1) * fetchSize;
        int endIndex = Math.min(blockNr * fetchSize, bteListe.size());
        ArrayList<ProduktId> bnbProdukte = new ArrayList<ProduktId>();
        for (int i = startIndex; i < endIndex; ++i) {
            ProduktId produktId = bteListe.get(i);
            ProduktListenElement prod = new ProduktListenElement();
            prod.setBteNr(produktId.getBteNr());
            prod.setBildPosNr(produktId.getBildPosNr());
            prod.setUnterkategorie(produktId.getUnterkategorie());
            prod.setHauptkategorie(produktId.getHauptkategorie());
            prod.setArt(produktId.getBteArt());
            prod.setLkz(produktId.getLkz());
            if (produktId.getLkz() != null) {
                prod.setMarkt(marktBen);
            }
            mprod.put(produktId, prod);
            if (produktId.getBildPosNr() == null) {
                if (bteBuffer.length() > 0) {
                    bteBuffer.append(",");
                }
                bteBuffer.append("'").append(produktId.getBteNr()).append("'");
                continue;
            }
            bnbProdukte.add(produktId);
        }
        return bnbProdukte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List holeBauartAuswahlMotorrad(String marke, String produktart, String katalogumfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBauartAuswahlMotorrad");
            String bauartenStatement = SQLStatements.Listenfueller.instance.LOAD_BAUARTMOTORRAD_AUSWAHL();
            bauartenStatement = StringUtils.substituteString(bauartenStatement, "REGIONEN", regionen);
            textPs = con.prepareStatement(bauartenStatement);
            textPs.setString(1, marke);
            textPs.setString(2, produktart);
            textPs.setString(3, katalogumfang);
            textPs.setString(4, katalogumfang);
            textPs.setString(5, iso);
            textPs.setString(6, regIso == null ? "" : regIso);
            result = textPs.executeQuery();
            ArrayList<Bauart> bauartenListe = new ArrayList<Bauart>();
            while (result.next()) {
                Bauart br = new Bauart(result.getString("Bauart"));
                br.setBezeichnung(result.getString("ExtBauart"));
                bauartenListe.add(br);
            }
            ArrayList<Bauart> arrayList = bauartenListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBauartAuswahlMotorrad");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bauart holeBaureihenMotorradAuswahl(Bauart bauartMotorrad, String marke, String produktart, String katalogumfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBaureihenAuswahl");
            String baureihenStatement = SQLStatements.Listenfueller.instance.LOAD_BAUREIHENAUSWAHL();
            baureihenStatement = StringUtils.substituteString(baureihenStatement, "REGIONEN", regionen);
            if (produktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART_STMT", "");
            } else {
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUART());
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART", bauartMotorrad.getBauart());
            }
            textPs = con.prepareStatement(baureihenStatement);
            textPs.setString(1, marke);
            textPs.setString(2, produktart);
            textPs.setString(3, katalogumfang);
            textPs.setString(4, katalogumfang);
            textPs.setString(5, iso);
            textPs.setString(6, regIso == null ? "" : regIso);
            result = textPs.executeQuery();
            ArrayList<Baureihe> baureihenListe = new ArrayList<Baureihe>();
            while (result.next()) {
                Baureihe br = new Baureihe(result.getString("Baureihe"));
                br.setBezeichnung(result.getString("ExtBaureihe"));
                baureihenListe.add(br);
            }
            bauartMotorrad.setBaureihe(baureihenListe);
            Bauart bauart = bauartMotorrad;
            return bauart;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBaureihenAuswahl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KarosserieForm holeModellAuswahlPkw(KarosserieForm karosserieForm, String baureihe, String katalogumfang, String regionen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeModelle");
            String modellStatement = SQLStatements.Listenfueller.instance.LOAD_MODELLAUSWAHL_PKW();
            modellStatement = StringUtils.substituteString(modellStatement, "REGIONEN", regionen);
            modellStatement = StringUtils.substituteString(modellStatement, "KAROSSERIE_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_KAROSSERIE());
            modellStatement = StringUtils.substituteString(modellStatement, "KAROSSERIE", karosserieForm.getKarosserieForm());
            textPs = con.prepareStatement(modellStatement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            result = textPs.executeQuery();
            ArrayList<Modell> modellListe = new ArrayList<Modell>();
            while (result.next()) {
                Modell mod = new Modell(result.getString(1));
                modellListe.add(mod);
            }
            karosserieForm.setModelle(modellListe);
            KarosserieForm karosserieForm2 = karosserieForm;
            return karosserieForm2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeModelle");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaureiheMotorrad holeModellAuswahlMotorrad(BaureiheMotorrad baureihe, String katalogumfang, String regionen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeModelle");
            String modellStatement = SQLStatements.Listenfueller.instance.LOAD_MODELLAUSWAHL_MOTORRAD();
            modellStatement = StringUtils.substituteString(modellStatement, "REGIONEN", regionen);
            textPs = con.prepareStatement(modellStatement);
            textPs.setString(1, baureihe.getBaureihe());
            textPs.setString(2, katalogumfang);
            result = textPs.executeQuery();
            ArrayList<Modell> modellListe = new ArrayList<Modell>();
            while (result.next()) {
                Modell mod = new Modell(result.getString(1));
                modellListe.add(mod);
            }
            baureihe.setModelle(modellListe);
            BaureiheMotorrad baureiheMotorrad = baureihe;
            return baureiheMotorrad;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeModelle");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List holeBauartenAuswahl(String marke, String produktart, String katalogumfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBauartenMotorradAuswahl");
            String bauartenStatement = SQLStatements.Listenfueller.instance.LOAD_BAUARTMOTORRAD_AUSWAHL();
            bauartenStatement = StringUtils.substituteString(bauartenStatement, "REGIONEN", regionen);
            textPs = con.prepareStatement(bauartenStatement);
            textPs.setString(1, marke);
            textPs.setString(2, produktart);
            textPs.setString(3, katalogumfang);
            textPs.setString(4, katalogumfang);
            textPs.setString(5, iso);
            textPs.setString(6, regIso == null ? "" : regIso);
            result = textPs.executeQuery();
            ArrayList<Bauart> bauartenListe = new ArrayList<Bauart>();
            while (result.next()) {
                Bauart br = new Bauart(result.getString("Bauart"));
                br.setBezeichnung(result.getString("ExtBauart"));
                bauartenListe.add(br);
            }
            ArrayList<Bauart> arrayList = bauartenListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBauartenMotorradAuswahl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List holeBaureihenAuswahl(String marke, String produktart, String bauart, String katalogumfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBaureihenAuswahl");
            String baureihenStatement = SQLStatements.Listenfueller.instance.LOAD_BAUREIHENAUSWAHL();
            baureihenStatement = StringUtils.substituteString(baureihenStatement, "REGIONEN", regionen);
            if (produktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART_STMT", "");
            } else {
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART_STMT", SQLStatements.FzgIdentifikation.instance.RETRIEVE_BAUART());
                baureihenStatement = StringUtils.substituteString(baureihenStatement, "BAUART", bauart);
            }
            textPs = con.prepareStatement(baureihenStatement);
            textPs.setString(1, marke);
            textPs.setString(2, produktart);
            textPs.setString(3, katalogumfang);
            textPs.setString(4, katalogumfang);
            textPs.setString(5, iso);
            textPs.setString(6, regIso == null ? "" : regIso);
            result = textPs.executeQuery();
            ArrayList<Baureihe> baureihenListe = new ArrayList<Baureihe>();
            while (result.next()) {
                Baureihe br = new Baureihe(result.getString("Baureihe"));
                br.setBezeichnung(result.getString("ExtBaureihe"));
                baureihenListe.add(br);
            }
            ArrayList<Baureihe> arrayList = baureihenListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBaureihenAuswahl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Baureihe holeKarosserieformenAuswahl(Baureihe baureihe, String katalogumfang, String regionen, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeKarosserieformenAuswahl");
            String karosserieFormenStatement = SQLStatements.Listenfueller.instance.LOAD_KAROSSERIEFORMENAUSWAHL();
            karosserieFormenStatement = StringUtils.substituteString(karosserieFormenStatement, "REGIONEN", regionen);
            textPs = con.prepareStatement(karosserieFormenStatement);
            textPs.setString(1, baureihe.getBaureihe());
            textPs.setString(2, katalogumfang);
            textPs.setString(3, iso);
            textPs.setString(4, regIso != null ? regIso : "");
            result = textPs.executeQuery();
            ArrayList<KarosserieForm> karosserieFormenListe = new ArrayList<KarosserieForm>();
            while (result.next()) {
                KarosserieForm kf = new KarosserieForm(result.getString(1));
                kf.setBezeichnung(result.getString(2));
                karosserieFormenListe.add(kf);
            }
            baureihe.setKarosserieForm(karosserieFormenListe);
            Baureihe baureihe2 = baureihe;
            return baureihe2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeKarosserieformenAuswahl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Modell holeKatalogAuswahl(String produktart, Modell modell, String baureihe, String karosserieForm, String katalogumfang, String regionen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeKatalogAuswahl");
            String katalogStatement = SQLStatements.Listenfueller.instance.LOAD_KATALOGAUSFUEHRUNGEN();
            katalogStatement = StringUtils.substituteString(katalogStatement, "REGIONEN", regionen);
            textPs = con.prepareStatement(katalogStatement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            textPs.setString(3, karosserieForm);
            textPs.setString(4, modell.getModell());
            result = textPs.executeQuery();
            ArrayList<KatalogAusfuehrung> katalogListe = new ArrayList<KatalogAusfuehrung>();
            while (result.next()) {
                KatalogAusfuehrung kat = new KatalogAusfuehrung(result.getString(1));
                if (produktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                    kat = SucheDbAccess.holeKatalogAusfuehrung(baureihe, karosserieForm, modell.getModell(), result.getString(1), katalogumfang);
                } else if (produktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                    kat = SucheDbAccess.holeKatalogAusfuehrungMotorrad(baureihe, karosserieForm, modell.getModell(), result.getString(1), katalogumfang);
                }
                katalogListe.add(kat);
            }
            modell.setKatalogausfuehrungen(katalogListe);
            Modell modell2 = modell;
            return modell2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeKatalogAuswahl");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KatalogAusfuehrung holeKatalogAusfuehrung(String baureihe, String karosserieForm, String modell, String katalogAusf, String katalogumfang) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeLenkungen");
            KatalogAusfuehrung kat = new KatalogAusfuehrung(katalogAusf);
            String statement = SQLStatements.Listenfueller.instance.LOAD_LENKUNGEN();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            textPs.setString(3, karosserieForm);
            textPs.setString(4, modell);
            textPs.setString(5, katalogAusf);
            result = textPs.executeQuery();
            while (result.next()) {
                Lenkung lenkung = SucheDbAccess.holeLenkung(baureihe, karosserieForm, modell, katalogAusf, result.getString("Lenkung"), katalogumfang);
                kat.addLenkung(lenkung);
            }
            KatalogAusfuehrung katalogAusfuehrung = kat;
            return katalogAusfuehrung;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeLenkungen");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KatalogAusfuehrung holeKatalogAusfuehrungMotorrad(String baureihe, String karosserieForm, String modell, String katalogAusf, String katalogumfang) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBaujahre");
            String statement = SQLStatements.Listenfueller.instance.LOAD_PRODUKTIONSMONAT_MOTORRAD();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            textPs.setString(3, karosserieForm);
            textPs.setString(4, modell);
            textPs.setString(5, katalogAusf);
            result = textPs.executeQuery();
            KatalogAusfuehrung katausfuehrung = new KatalogAusfuehrung(katalogAusf);
            while (result.next()) {
                Baujahr baujahr = new Baujahr(result.getString("monat").substring(0, 4));
                baujahr.addMonat(result.getString("monat").substring(4, 6));
                while (result.next()) {
                    String jahr = result.getString("monat").substring(0, 4);
                    if (!jahr.equals(baujahr.getBaujahr())) {
                        katausfuehrung.addBaujahrMotorrad(baujahr);
                        baujahr = new Baujahr(jahr);
                    }
                    baujahr.addMonat(result.getString("monat").substring(4, 6));
                }
                katausfuehrung.addBaujahrMotorrad(baujahr);
            }
            KatalogAusfuehrung katalogAusfuehrung = katausfuehrung;
            return katalogAusfuehrung;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBaujahre");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lenkung holeLenkung(String baureihe, String karosserieForm, String modell, String katalogAusf, String sLenkung, String katalogumfang) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeLenkungen");
            String statement = SQLStatements.Listenfueller.instance.LOAD_GETRIEBE();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            textPs.setString(3, karosserieForm);
            textPs.setString(4, modell);
            textPs.setString(5, katalogAusf);
            textPs.setString(6, sLenkung);
            result = textPs.executeQuery();
            Lenkung lenkung = new Lenkung(sLenkung);
            while (result.next()) {
                Getriebe getriebe = SucheDbAccess.holeGetriebe(baureihe, karosserieForm, modell, katalogAusf, lenkung.getLenkung(), result.getString("Getriebe"), katalogumfang);
                lenkung.addGetriebe(getriebe);
            }
            Lenkung lenkung2 = lenkung;
            return lenkung2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeLenkungen");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Getriebe holeGetriebe(String baureihe, String karosserieForm, String modell, String katalogAusf, String lenkung, String sGetriebe, String katalogumfang) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeBaujahre");
            String statement = SQLStatements.Listenfueller.instance.LOAD_PRODUKTIONSMONAT();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, baureihe);
            textPs.setString(2, katalogumfang);
            textPs.setString(3, karosserieForm);
            textPs.setString(4, modell);
            textPs.setString(5, katalogAusf);
            textPs.setString(6, lenkung);
            textPs.setString(7, sGetriebe);
            result = textPs.executeQuery();
            Getriebe getriebe = new Getriebe(sGetriebe);
            while (result.next()) {
                Baujahr baujahr = new Baujahr(result.getString("monat").substring(0, 4));
                baujahr.addMonat(result.getString("monat").substring(4, 6));
                while (result.next()) {
                    String jahr = result.getString("monat").substring(0, 4);
                    if (!jahr.equals(baujahr.getBaujahr())) {
                        getriebe.addBaujahr(baujahr);
                        baujahr = new Baujahr(jahr);
                    }
                    baujahr.addMonat(result.getString("monat").substring(4, 6));
                }
                getriebe.addBaujahr(baujahr);
            }
            Getriebe getriebe2 = getriebe;
            return getriebe2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeBaujahre");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List holeKundenZuNummer(String kundennummer, String iso, String regIso, String produktart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("holeKunde");
            String kundenStatement = SQLStatements.KundenIdentifikation.instance.ERMITTLE_KUNDE_UEBER_NUMMER();
            textPs = con.prepareStatement(kundenStatement);
            textPs.setString(1, kundennummer + "%");
            result = textPs.executeQuery();
            ArrayList<Kunde> kundenListe = new ArrayList<Kunde>();
            while (result.next()) {
                Kunde kunde = new Kunde(result.getString("nummer"), result.getString("anrede"), result.getString("name"), result.getString("vorname"), result.getString("strasse"), result.getString("hausnummer"), result.getString("land"), result.getString("plz"), result.getString("stadt"), result.getString("postfach"), result.getString("tel"), result.getString("mobil"), result.getString("fax"), result.getString("email"), result.getString("bemerkung"));
                kunde.setKundenId(result.getInt("id"));
                String gebDat = result.getString("gebdatum");
                if (gebDat != null) {
                    kunde.setGeburtsDatum(gebDat);
                }
                kunde.setFahrzeuge(SucheDbAccess.holeFahrzeuge(result.getInt("id"), iso, regIso, produktart));
                kundenListe.add(kunde);
            }
            ArrayList<Kunde> arrayList = kundenListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "holeKunde");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List holeKundenZuName(String kundenname, String iso, String regIso, String produktart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("holeKunden");
            String kundenStatement = SQLStatements.KundenIdentifikation.instance.ERMITTLE_KUNDEN_UEBER_NAME();
            textPs = con.prepareStatement(kundenStatement);
            kundenname = kundenname.replace(' ', '%') + "%";
            kundenname = kundenname.toUpperCase();
            textPs.setString(1, kundenname);
            result = textPs.executeQuery();
            ArrayList<Kunde> kundenListe = new ArrayList<Kunde>();
            while (result.next()) {
                Kunde kunde = new Kunde(result.getString("nummer"), result.getString("anrede"), result.getString("name"), result.getString("vorname"), result.getString("strasse"), result.getString("hausnummer"), result.getString("land"), result.getString("plz"), result.getString("stadt"), result.getString("postfach"), result.getString("tel"), result.getString("mobil"), result.getString("fax"), result.getString("email"), result.getString("bemerkung"));
                kunde.setKundenId(result.getInt("id"));
                String gebDat = result.getString("gebdatum");
                if (gebDat != null) {
                    kunde.setGeburtsDatum(gebDat);
                }
                kunde.setFahrzeuge(SucheDbAccess.holeFahrzeuge(result.getInt("id"), iso, regIso, produktart));
                kundenListe.add(kunde);
            }
            ArrayList<Kunde> arrayList = kundenListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "holeKunden");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List holeFahrzeuge(int kundenId, String iso, String regIso, String produktart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("holeFahrzeuge");
            String fahrzeugStatement = SQLStatements.KundenIdentifikation.instance.ERMITTLE_KUNDENFAHRZEUGE();
            textPs = con.prepareStatement(fahrzeugStatement);
            textPs.setInt(1, kundenId);
            result = textPs.executeQuery();
            ArrayList<Fahrzeug> fahrzeuge = new ArrayList<Fahrzeug>();
            while (result.next()) {
                Fahrzeug fz = null;
                fz = SucheDbAccess.holeFahrzeugDetailsAusVin(result.getString("vin"), iso, regIso);
                fz.setKennzeichen(result.getString("kennzeichen"));
                fahrzeuge.add(fz);
            }
            ArrayList<Fahrzeug> arrayList = fahrzeuge;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "holeFahrzeuge");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fahrzeug holeFahrzeugDetailsAusVin(String vin, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("holeFahrzeugDetails");
            String fahrzeugStatement = SQLStatements.FahrzeugIdentifikation.instance.ERMITTLE_FAHRZEUGDATEN_AUS_VIN();
            textPs = con.prepareStatement(fahrzeugStatement);
            textPs.setString(1, iso == null ? "  " : iso);
            textPs.setString(2, iso == null ? "  " : iso);
            textPs.setString(3, iso == null ? "  " : iso);
            textPs.setString(4, regIso == null ? "  " : regIso);
            textPs.setString(5, regIso == null ? "  " : regIso);
            textPs.setString(6, regIso == null ? "  " : regIso);
            if (vin.length() == 17) {
                vin = vin.substring(10, 17);
            }
            textPs.setString(7, vin);
            textPs.setString(8, vin.substring(0, 2));
            result = textPs.executeQuery();
            if (!result.next()) {
                Fahrzeug fahrzeug = new Fahrzeug();
                fahrzeug.setFahrgestellnummer(vin);
                Fahrzeug fahrzeug2 = fahrzeug;
                return fahrzeug2;
            }
            boolean sichtschutz = result.getString("sichtschutz").equalsIgnoreCase("J");
            Fahrzeug fahrzeug = new Fahrzeug(result.getString("marke"), result.getString("produktart").charAt(0), result.getString("bauart").charAt(0), result.getString("bauartBez"), vin, result.getLong("mospid"), result.getString("typschl"), result.getString("vbereich"), result.getString("lenkung"), result.getString("getriebe"), result.getString("baureihe"), result.getString("baureiheBez"), result.getString("katalogausf"), result.getString("vbezeichnung"), result.getString("vbezeichnungerw"), result.getString("motor"), result.getString("karosserie"), result.getString("karosserieBez"), result.getString("katalysator"), sichtschutz);
            fahrzeug.setProduktionsdatum(result.getString("produktionsdatum"));
            Fahrzeug fahrzeug3 = fahrzeug;
            return fahrzeug3;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeFahrzeugDetails");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fahrzeug holeFahrzeugDetailsAusMospid(long mospid, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            Fahrzeug fahrzeug;
            con = globs.getDBConnection("holeFahrzeugDetailsAusMospid");
            String fahrzeugStatement = SQLStatements.FahrzeugIdentifikation.instance.ERMITTLE_FAHRZEUGDATEN_AUS_MOSPID();
            textPs = con.prepareStatement(fahrzeugStatement);
            textPs.setString(1, iso == null ? "  " : iso);
            textPs.setString(2, iso == null ? "  " : iso);
            textPs.setString(3, iso == null ? "  " : iso);
            textPs.setString(4, regIso == null ? "  " : regIso);
            textPs.setString(5, regIso == null ? "  " : regIso);
            textPs.setString(6, regIso == null ? "  " : regIso);
            textPs.setLong(7, mospid);
            result = textPs.executeQuery();
            if (!result.next()) {
                Fahrzeug fahrzeug2 = new Fahrzeug();
                fahrzeug2.setModellspalte(mospid);
                Fahrzeug fahrzeug3 = fahrzeug2;
                return fahrzeug3;
            }
            boolean sichtschutz = result.getString("sichtschutz").equalsIgnoreCase("J");
            Fahrzeug fahrzeug4 = fahrzeug = new Fahrzeug(result.getString("marke"), result.getString("produktart").charAt(0), result.getString("bauart").charAt(0), result.getString("bauartBez"), null, mospid, null, result.getString("vbereich"), null, null, result.getString("baureihe"), result.getString("baureiheBez"), result.getString("katalogausf"), result.getString("vbezeichnung"), result.getString("vbezeichnungerw"), result.getString("motor"), result.getString("karosserie"), result.getString("karosserieBez"), result.getString("katalysator"), sichtschutz);
            return fahrzeug4;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "holeFahrzeugDetailsAusMospid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleHitListeAusString(String keyword, int marktId, String marktBen, Baureihe baureihe, Fahrzeug info, Integer hauptKategorieId, Integer unterKategorieId, String marke, String produktArt, String sprache, String region) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        try {
            con = globs.getDBConnection("ermittleHitListeAusString");
            KeywordSucheInfo sucheInfo = new KeywordSucheInfo();
            if (baureihe != null) {
                sucheInfo.setBaureihe(baureihe);
            }
            if (info != null) {
                sucheInfo.setFzInfo(info);
            }
            if (hauptKategorieId != null) {
                sucheInfo.setHauptKategorie(hauptKategorieId);
            }
            if (unterKategorieId != null) {
                sucheInfo.setUnterKategorie(unterKategorieId);
            }
            if (keyword != null) {
                sucheInfo.setKeywordString(keyword);
            }
            sucheInfo.setMarktId(marktId);
            ArrayList hkListe = new ArrayList();
            if (!SucheDbAccess.executeHitlistSearch1(con, hkListe, SQLStatements.ProduktSuche.instance.SUCHE_SZ_SAZ(), produktArt, marke, sprache, region, sucheInfo.getSuchString("bedsala_art+''+bedsala_pnr+''+bedsala_hz", sprache.equalsIgnoreCase("tr"), marktId), marktId)) {
                SucheDbAccess.executeHitlistSearch(con, hkListe, SQLStatements.ProduktSuche.instance.SUCHE_PRODUCT(), produktArt, marke, sprache, region, sucheInfo.getSuchString("ben1.ben_text", sprache.equalsIgnoreCase("tr"), marktId), marktId);
                SucheDbAccess.executeHitlistSearch(con, hkListe, SQLStatements.ProduktSuche.instance.SUCHE_KEYWORDS(), produktArt, marke, sprache, region, sucheInfo.getSuchString("mkeyw_keyword", sprache.equalsIgnoreCase("tr"), marktId), marktId);
                SucheDbAccess.executeHitlistSearchProdukt(con, hkListe, SQLStatements.ProduktSuche.instance.SUCHE_TEASERTEXT(), produktArt, marke, sprache, region, sucheInfo.getSuchString("mprod_text", sprache.equalsIgnoreCase("tr"), marktId), keyword, marktId);
            }
            Collections.sort(hkListe, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    HitListenHauptKategorie kat1 = (HitListenHauptKategorie)arg0;
                    HitListenHauptKategorie kat2 = (HitListenHauptKategorie)arg1;
                    return new Integer(kat1.getPos()).compareTo(new Integer(kat2.getPos()));
                }
            });
            Iterator it = hkListe.iterator();
            while (it.hasNext()) {
                List<HitListenUnterkategorie> ukListe = ((HitListenHauptKategorie)it.next()).getUnterkategorie();
                Collections.sort(ukListe, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        HitListenUnterkategorie ukat1 = (HitListenUnterkategorie)arg0;
                        HitListenUnterkategorie ukat2 = (HitListenUnterkategorie)arg1;
                        return new Integer(ukat1.getPos()).compareTo(new Integer(ukat2.getPos()));
                    }
                });
                Iterator<HitListenUnterkategorie> ukIt = ukListe.iterator();
                while (ukIt.hasNext()) {
                    Collections.sort(ukIt.next().getBteNrn());
                }
            }
            ArrayList arrayList = hkListe;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleHitListeAusString");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeHitlistSearch1(Connection con, List hkListe, String statement, String produktArt, String marke, String sprache, String region, String addStatement, int marktId) throws SQLException {
        boolean bl;
        block7: {
            PreparedStatement kwPs;
            block6: {
                kwPs = null;
                ResultSet result = null;
                String sqlStatement = StringUtils.substituteString(statement, "SUCHSTRING", addStatement);
                try {
                    kwPs = con.prepareStatement(sqlStatement);
                    kwPs.setString(1, sprache == null ? "" : sprache);
                    kwPs.setString(2, region == null ? "" : region);
                    kwPs.setString(3, sprache == null ? "" : sprache);
                    kwPs.setString(4, region == null ? "" : region);
                    kwPs.setString(5, "HP_PAKET");
                    kwPs.setString(6, "HP_PAKET");
                    kwPs.setString(7, marke);
                    kwPs.setString(8, produktArt);
                    kwPs.setInt(9, marktId);
                    result = kwPs.executeQuery();
                    bl = SucheDbAccess.verarbeiteFreitextsuche(hkListe, produktArt, marke, result);
                    if (result == null) break block6;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        WebetkUtils.closeQuery(result);
                    } else if (kwPs != null) {
                        kwPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(result);
                break block7;
            }
            if (kwPs != null) {
                kwPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeHitlistSearch(Connection con, List hkListe, String statement, String produktArt, String marke, String sprache, String region, String addStatement, int marktId) throws SQLException {
        boolean bl;
        block7: {
            PreparedStatement kwPs;
            block6: {
                kwPs = null;
                ResultSet result = null;
                String sqlStatement = StringUtils.substituteString(statement, "SUCHSTRING", addStatement);
                try {
                    kwPs = con.prepareStatement(sqlStatement);
                    kwPs.setString(1, sprache == null ? "" : sprache);
                    kwPs.setString(2, region == null ? "" : region);
                    kwPs.setString(3, sprache == null ? "" : sprache);
                    kwPs.setString(4, region == null ? "" : region);
                    kwPs.setString(5, sprache == null ? "" : sprache);
                    kwPs.setString(6, region == null ? "" : region);
                    kwPs.setString(7, "HP_PAKET");
                    kwPs.setString(8, "HP_PAKET");
                    kwPs.setString(9, marke);
                    kwPs.setString(10, produktArt);
                    kwPs.setInt(11, marktId);
                    result = kwPs.executeQuery();
                    bl = SucheDbAccess.verarbeiteFreitextsuche(hkListe, produktArt, marke, result);
                    if (result == null) break block6;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        WebetkUtils.closeQuery(result);
                    } else if (kwPs != null) {
                        kwPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(result);
                break block7;
            }
            if (kwPs != null) {
                kwPs.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeHitlistSearchProdukt(Connection con, List hkListe, String statement, String produktArt, String marke, String sprache, String region, String addStatement, String suchString, int marktId) throws SQLException {
        block7: {
            PreparedStatement kwPs;
            block6: {
                kwPs = null;
                ResultSet result = null;
                String sqlStatement = StringUtils.substituteString(statement, "SUCHSTRING", addStatement);
                try {
                    kwPs = con.prepareStatement(sqlStatement);
                    kwPs.setString(1, sprache == null ? "" : sprache);
                    kwPs.setString(2, region == null ? "" : region);
                    kwPs.setString(3, sprache == null ? "" : sprache);
                    kwPs.setString(4, region == null ? "" : region);
                    kwPs.setString(5, sprache == null ? "" : sprache);
                    kwPs.setString(6, region == null ? "" : region);
                    kwPs.setString(7, "HP_PAKET");
                    kwPs.setString(8, "HP_PAKET");
                    kwPs.setString(9, marke);
                    kwPs.setString(10, produktArt);
                    kwPs.setInt(11, marktId);
                    kwPs.setString(12, "TEASERTEXT");
                    result = kwPs.executeQuery();
                    SucheDbAccess.verarbeiteFreitextsucheBlob(hkListe, produktArt, marke, result, suchString);
                    if (result == null) break block6;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        WebetkUtils.closeQuery(result);
                    } else if (kwPs != null) {
                        kwPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(result);
                break block7;
            }
            if (kwPs != null) {
                kwPs.close();
            }
        }
    }

    private static boolean verarbeiteFreitextsucheBlob(List hkListe, String produktArt, String marke, ResultSet result, String suchString) throws SQLException {
        boolean treffer = false;
        while (result.next()) {
            byte[] bdata = result.getBytes("mprod_text");
            int text_laenge = result.getInt("text_laenge");
            String text = null;
            if (bdata == null) continue;
            try {
                HitListenUnterkategorie ukat;
                List<HitListenUnterkategorie> unterkatList;
                text = new String(WebetkUtils.getBytes(bdata, text_laenge), "UTF-8");
                if (suchString == null || suchString.equals("") || text.toUpperCase().indexOf(suchString.toUpperCase().toString()) <= -1) continue;
                treffer = true;
                String btNr = result.getString(1);
                String btArt = result.getString(2);
                if (btArt == null) {
                    log.error("BTE " + btNr + " no btArt loaded.");
                }
                btArt = btArt != null && btArt.equals("U") ? "ASS" : "FZG";
                String bildPosNr = result.getString(3);
                int hkId = result.getInt(4);
                String hkBez = result.getString(5);
                int hkPos = result.getInt(6);
                int ukId = result.getInt(7);
                String ukBez = result.getString(8);
                int ukPos = result.getInt(9);
                String lkz = result.getString(10);
                boolean isLifestyle = result.getString("istLifestyle").equals("J");
                HitListenHauptKategorie kat = new HitListenHauptKategorie(hkId, marke, produktArt, hkBez, hkPos, (List)new ArrayList());
                if (!hkListe.contains(kat)) {
                    hkListe.add(kat);
                }
                if (!(unterkatList = ((HitListenHauptKategorie)hkListe.get(hkListe.indexOf(kat))).getUnterkategorie()).contains(ukat = new HitListenUnterkategorie(ukId, ukBez, new byte[0], ukPos, isLifestyle))) {
                    unterkatList.add(ukat);
                }
                List<ProduktId> bteList = unterkatList.get(unterkatList.indexOf(ukat)).getBteNrn();
                if (bildPosNr != null && bildPosNr.length() > 0) {
                    ProduktId hId = new ProduktId(btNr, bildPosNr);
                    hId.setUnterkategorie(ukat);
                    hId.setHauptkategorie(kat);
                    hId.setLkz(lkz);
                    if (!bteList.contains(hId)) {
                        hId.setBteArt(btArt);
                        bteList.add(hId);
                    }
                }
                ProduktId id = new ProduktId(btNr);
                id.setUnterkategorie(ukat);
                id.setHauptkategorie(kat);
                id.setLkz(lkz);
                if (bteList.contains(id)) continue;
                id.setBteArt(btArt);
                bteList.add(id);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return treffer;
    }

    private static boolean verarbeiteFreitextsuche(List hkListe, String produktArt, String marke, ResultSet result) throws SQLException {
        boolean treffer = false;
        while (result.next()) {
            HitListenUnterkategorie ukat;
            List<HitListenUnterkategorie> unterkatList;
            treffer = true;
            String btNr = result.getString(1);
            String btArt = result.getString(2);
            if (btArt == null) {
                log.error("BTE " + btNr + " no btArt loaded.");
            }
            btArt = btArt != null && btArt.equals("U") ? "ASS" : "FZG";
            String bildPosNr = result.getString(3);
            int hkId = result.getInt(4);
            String hkBez = result.getString(5);
            int hkPos = result.getInt(6);
            int ukId = result.getInt(7);
            String ukBez = result.getString(8);
            int ukPos = result.getInt(9);
            String lkz = result.getString(10);
            boolean isLifestyle = result.getString("istLifestyle").equals("J");
            HitListenHauptKategorie kat = new HitListenHauptKategorie(hkId, marke, produktArt, hkBez, hkPos, (List)new ArrayList());
            if (!hkListe.contains(kat)) {
                hkListe.add(kat);
            }
            if (!(unterkatList = ((HitListenHauptKategorie)hkListe.get(hkListe.indexOf(kat))).getUnterkategorie()).contains(ukat = new HitListenUnterkategorie(ukId, ukBez, new byte[0], ukPos, isLifestyle))) {
                unterkatList.add(ukat);
            }
            List<ProduktId> bteList = unterkatList.get(unterkatList.indexOf(ukat)).getBteNrn();
            if (bildPosNr != null && bildPosNr.length() > 0) {
                ProduktId hId = new ProduktId(btNr, bildPosNr);
                hId.setUnterkategorie(ukat);
                hId.setHauptkategorie(kat);
                hId.setLkz(lkz);
                if (!bteList.contains(hId)) {
                    hId.setBteArt(btArt);
                    bteList.add(hId);
                }
            }
            ProduktId id = new ProduktId(btNr);
            id.setUnterkategorie(ukat);
            id.setHauptkategorie(kat);
            id.setLkz(lkz);
            if (bteList.contains(id)) continue;
            id.setBteArt(btArt);
            bteList.add(id);
        }
        return treffer;
    }

    private static void conditionCreator(ProduktId id, StringBuffer buf) {
        if (id.getBildPosNr() != null) {
            if (buf.length() > 0) {
                buf.append(" OR ");
            }
            buf.append("( bildtafzbnb_btnr = ? AND bildtafzbnb_bildpos = ? )");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ermittleDefaultMarktId(String sprache, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("ermittleDefaultMarktId");
            stat = con.prepareStatement(SQLStatements.Listenfueller.instance.ERMITTLE_DEFAULT_MARKT());
            stat.setString(1, sprache == null ? " " : sprache);
            stat.setString(2, regIso == null ? " " : regIso);
            stat.setString(3, sprache == null ? " " : sprache);
            stat.setString(4, regIso == null ? " " : regIso);
            rs = stat.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleDefaultMarktId");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ermittleMarktZuId(int marktid, String sprache, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("ermittleMarktZuId");
            stat = con.prepareStatement(SQLStatements.Listenfueller.instance.ERMITTLE_MARKT_ZU_ID());
            stat.setInt(1, marktid);
            stat.setString(2, sprache == null ? " " : sprache);
            stat.setString(3, regIso == null ? " " : regIso);
            rs = stat.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "ermittleMarktZuId");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Long> ladeMospIdsZuAuswahl(String baureihe, String karosserie, String erwvbez, String katalog) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs;
        Connection con;
        ArrayList<Long> mospids;
        block16: {
            PreparedStatement prep;
            block15: {
                mospids = new ArrayList<Long>();
                con = null;
                globs = ServerGlobalObjects.getInstance();
                prep = null;
                String statement = SQLStatements.Listenfueller.instance.LOAD_MODELLSPALTEN();
                statement = StringUtils.substituteString(statement, "BAUREIHE", baureihe);
                if (karosserie != null && karosserie.length() > 0) {
                    statement = StringUtils.substituteString(statement, "KAROSSERIE_STMT", SQLStatements.Listenfueller.instance.LOAD_MODELLSPALTEN_KAROSSERIE());
                    statement = StringUtils.substituteString(statement, "KAROSSERIE", karosserie);
                } else {
                    statement = StringUtils.substituteString(statement, "KAROSSERIE_STMT", "");
                }
                if (erwvbez != null && erwvbez.length() > 0) {
                    statement = StringUtils.substituteString(statement, "ERW_VBEZ_STMT", SQLStatements.Listenfueller.instance.LOAD_MODELLSPALTEN_ERW_VBEZ());
                    statement = StringUtils.substituteString(statement, "ERW_VBEZ", erwvbez);
                } else {
                    statement = StringUtils.substituteString(statement, "ERW_VBEZ_STMT", "");
                }
                if (katalog != null && katalog.length() > 0) {
                    statement = StringUtils.substituteString(statement, "KATALOG_STMT", SQLStatements.Listenfueller.instance.LOAD_MODELLSPALTEN_KATALOG());
                    statement = StringUtils.substituteString(statement, "KATALOG", katalog);
                } else {
                    statement = StringUtils.substituteString(statement, "KATALOG_STMT", "");
                }
                log.debug("Executing SQL-Statement: " + statement);
                ResultSet res = null;
                try {
                    con = globs.getDBConnection("zub.suche.ladeMospIdsZuAuswahl");
                    prep = con.prepareStatement(statement);
                    res = prep.executeQuery();
                    while (res.next()) {
                        Long mospid = new Long(res.getLong("Mospid"));
                        mospids.add(mospid);
                    }
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        WebetkUtils.closeQuery(res);
                    } else if (prep != null) {
                        prep.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "zub.suche.ladeMospIdsZuAuswahl");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                break block16;
            }
            if (prep != null) {
                prep.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.suche.ladeMospIdsZuAuswahl");
        }
        return mospids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List sucheProdukteEtk(String suchBezeichnung, Fahrzeug fahrzeug, String marke, String produktArt, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        ArrayList<BildTafelETK> produkte = new ArrayList<BildTafelETK>();
        String statement = SQLStatements.ProduktSuche.instance.SUCHE_PRODUKTNAME_ETK();
        if (iso.equalsIgnoreCase("tr")) {
            statement = SQLStatements.ProduktSuche.instance.SUCHE_PRODUKTNAME_ETK_TR();
            suchBezeichnung = suchBezeichnung.replace('*', '%').toUpperCase();
        } else {
            suchBezeichnung = suchBezeichnung.replace('*', '%');
        }
        try {
            if (!suchBezeichnung.endsWith("%")) {
                suchBezeichnung = suchBezeichnung.concat("%");
            }
            con = globs.getDBConnection("sucheProdukteEtk");
            statement = StringUtils.substituteString(statement, "SUCHBEGRIFF", StringUtils.maskiereHochkommaFuerDb(suchBezeichnung));
            statement = fahrzeug != null && fahrzeug.getModellspalte() > -1L ? StringUtils.substituteString(statement, "ADD", " and bildtaf_btnr in (select btzeilenv_btnr from w_btzeilen_verbauung where btzeilenv_mospid = " + fahrzeug.getModellspalte() + ") ") : StringUtils.substituteString(statement, "ADD", "");
            stat = con.prepareStatement(statement);
            stat.setString(1, iso);
            stat.setString(2, regIso == null ? " " : regIso);
            stat.setString(3, marke);
            stat.setString(4, produktArt);
            rs = stat.executeQuery();
            while (rs.next()) {
                String btnr = rs.getString("btnr");
                String hg = rs.getString("hg");
                String fg = rs.getString("fg");
                String benennung = rs.getString("benennung");
                produkte.add(new BildTafelETK(btnr, hg, fg, benennung));
            }
            ArrayList<BildTafelETK> arrayList = produkte;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "sucheProdukteEtk");
            }
        }
    }

    public static String[] ermittlePrio1Sprache(Connection con, int marktId, String iso, String regIso) throws SQLException {
        String[] isoRegion = new String[2];
        PreparedStatement stat = con.prepareStatement(SQLStatements.Listenfueller.instance.ERMITTLE_DEFAULT_SPRACHE_MARKT());
        stat.setInt(1, marktId);
        ResultSet rs = stat.executeQuery();
        if (rs.next()) {
            isoRegion[0] = rs.getString("iso");
            isoRegion[1] = rs.getString("regIso");
        } else {
            isoRegion[0] = iso;
            isoRegion[1] = regIso;
        }
        rs.close();
        stat.close();
        return isoRegion;
    }
}

