/*
 * Decompiled with CFR 0.152.
 */
package webetk.etkclientws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import webetk.etkclientws.IScoreService;
import webetk.etkclientws.IZubScoreService;
import webetk.etkscore.EtkScoreFiliale;
import webetk.etkscore.EtkScoreTeileliste;
import webetk.etkscore.EtkScoreTeilelisteAb12;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.etkscore.ZubIspaZubehoerpakete;

public class EtkClientScore {
    private static ClassLoader cl = null;
    private static IScoreService scoreService = null;
    private static IZubScoreService zubscoreService = null;

    public void showTeileinformation(String nutzerID, String passwort, String filialID, String sprache, String sachnummer) {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            iScoreService.showTeileinformation(nutzerID, passwort, filialID, sprache, sachnummer);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas showTeileinformation");
            ex.printStackTrace();
        }
    }

    public void showTeilesuche(String nutzerID, String passwort, String filialID, String sprache, String sachnummer, String vin, EtkScoreVerbauung[] vbg) {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            iScoreService.showTeilesuche(nutzerID, passwort, filialID, sprache, sachnummer, vin, vbg);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas showTeilesuche");
            ex.printStackTrace();
        }
    }

    public EtkScoreTeileliste editTeileliste(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, String teilelistenID, EtkScoreTeileliste liste) {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            return iScoreService.editTeileliste(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, teilelistenID, liste);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas editTeileliste");
            ex.printStackTrace();
            return liste;
        }
    }

    public EtkScoreTeilelisteAb12 editTeilelisteAb12(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, String teilelistenID, EtkScoreTeilelisteAb12 liste) {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            return iScoreService.editTeilelisteAb12(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, teilelistenID, liste);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas editTeileliste");
            ex.printStackTrace();
            return liste;
        }
    }

    public boolean isAlive() {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            return iScoreService.isAlive();
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas isAlive");
            ex.printStackTrace();
            return false;
        }
    }

    public EtkScoreFiliale[] ermittleFilialen() {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            return iScoreService.ermittleFilialen();
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas ermittleFilialen");
            ex.printStackTrace();
            return new EtkScoreFiliale[0];
        }
    }

    public void closeETK() {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            iScoreService.closeETK();
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientApas closeETK");
            ex.printStackTrace();
        }
    }

    public String exchangeVersion(String scoreVersion) {
        try {
            IScoreService iScoreService = EtkClientScore.getScoreService();
            return iScoreService.exchangeVersion(scoreVersion);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientScore exchangeVersion");
            ex.printStackTrace();
            return "";
        }
    }

    public ZubIspaZubehoerpakete holeZubehoerpakete(String nutzerID, String passwort, String filialID, String sprache, String vin, EtkScoreVerbauung[] vbg, String kundennummer, Integer angebotsnummer, String produktid) {
        try {
            IZubScoreService iZubScoreService = EtkClientScore.getZubScoreService();
            return iZubScoreService.holeZubehoerpakete(nutzerID, passwort, filialID, sprache, vin, vbg, kundennummer, angebotsnummer);
        }
        catch (Exception ex) {
            System.out.println("Exception in EtkClientScore holeZubehoerpakete");
            ex.printStackTrace();
            return new ZubIspaZubehoerpakete();
        }
    }

    private static IScoreService getScoreService() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (scoreService == null) {
            Class cScoreService = EtkClientScore.loadClass("webetk.javaclient.score.ScoreService");
            Object newObject = cScoreService.newInstance();
            scoreService = (IScoreService)newObject;
        }
        return scoreService;
    }

    private static IZubScoreService getZubScoreService() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (zubscoreService == null) {
            Class cScoreService = EtkClientScore.loadClass("de.esg.zub.score.ZubScoreService");
            Object newObject = cScoreService.newInstance();
            zubscoreService = (IZubScoreService)newObject;
        }
        return zubscoreService;
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = EtkClientScore.getClassLoaderInstance();
        return cl.loadClass(name);
    }

    private static ClassLoader getClassLoaderInstance() {
        if (cl == null) {
            String[] paths = new String[]{"classes", "classes/javaclient.jar", "classes/zubclient.jar", "classes/javaserver.jar", "tomcat/webapps/axis/WEB-INF/classes"};
            URL[] urls = EtkClientScore.convertToUrls(paths);
            ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
            cl = new URLClassLoader(urls, oldClassloader);
        }
        return cl;
    }

    private static URL[] convertToUrls(String[] paths) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i]);
            if (!f.exists()) {
                System.out.println("Warnung: Pfad " + paths[i] + " exisitert nicht");
                continue;
            }
            try {
                URL url = f.getAbsoluteFile().toURL();
                list.add(url);
                continue;
            }
            catch (MalformedURLException ex) {
                System.out.println("Warnung: Pfad " + paths[i] + " konnte nicht in eine URL konvertiert werden");
            }
        }
        URL[] ret = new URL[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (URL)list.get(i);
        }
        return ret;
    }
}

