/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.log4j.Logger;

public class ConnectionConfiguration {
    private static Logger log = Logger.getLogger(ConnectionConfiguration.class);
    private HostConfiguration hostConfig = null;
    private boolean bPreemptiveAuth = true;
    private Credentials proxyCredentials = null;
    private String sProxyRealm = null;
    private String sProxyHost = null;
    private Credentials hostCredentials = null;
    private String sHostRealm = null;
    private String sHostHost = null;

    public ConnectionConfiguration() {
    }

    public ConnectionConfiguration(String sProxy, int nPort) {
        this.hostConfig = new HostConfiguration();
        this.hostConfig.setProxy(sProxy, nPort);
        log.debug("Proxy set to: " + sProxy + ":" + Integer.toString(nPort));
    }

    public HostConfiguration getHostConfig() {
        return this.hostConfig;
    }

    public int getPort() {
        return this.hostConfig == null ? -1 : this.hostConfig.getProxyPort();
    }

    public String getProxy() {
        return this.hostConfig == null ? null : this.hostConfig.getProxyHost();
    }

    public void setProxy(String sProxy, int nPort) {
        if (this.hostConfig == null) {
            this.hostConfig = new HostConfiguration();
        }
        this.hostConfig.setProxy(sProxy, nPort);
    }

    public boolean isPreemptiveAuth() {
        return this.bPreemptiveAuth;
    }

    public void setPreemptiveAuth(boolean b) {
        this.bPreemptiveAuth = b;
    }

    public Credentials getHostCredentials() {
        return this.hostCredentials;
    }

    public Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    public void setHostCredentials(String sUsername, String sPassword, String sRealm, String sHost) {
        this.hostCredentials = new UsernamePasswordCredentials(sUsername, sPassword);
        this.sHostRealm = sRealm;
        this.sHostHost = sHost;
    }

    public void setProxyCredentials(String sUsername, String sPassword, String sRealm, String sHost) {
        this.proxyCredentials = new UsernamePasswordCredentials(sUsername, sPassword);
        this.sProxyRealm = sRealm;
        this.sProxyHost = sHost;
    }

    public void setHostNTCredentials(String sUsername, String sPassword, String sNTDomain, String sNTHost, String sHost) {
        this.hostCredentials = new NTCredentials(sUsername, sPassword, sNTHost, sNTDomain);
        this.sHostRealm = null;
        this.sHostHost = sHost;
    }

    public void setProxyNTCredentials(String sUsername, String sPassword, String sNTDomain, String sNTHost, String sHost) {
        this.proxyCredentials = new NTCredentials(sUsername, sPassword, sNTHost, sNTDomain);
        this.sProxyRealm = null;
        this.sProxyHost = sHost;
    }

    public String getCredentialHost() {
        return this.sHostHost;
    }

    public String getCredentialRealm() {
        return this.sHostRealm;
    }

    public String getCredentialProxyHost() {
        return this.sProxyHost;
    }

    public String getCredentialProxyRealm() {
        return this.sProxyRealm;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Proxy: ");
        s.append(this.getHostConfig().toString()).append(", Credentials: ");
        s.append(this.getProxyCredentials().toString()).append(", ").append(this.getCredentialProxyHost());
        s.append(", ").append(this.getCredentialProxyRealm()).append("Preemptive: ").append(this.isPreemptiveAuth());
        return s.toString();
    }
}

