/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import webetk.DatabaseBusyException;
import webetk.app.ServerGlobalObjects;
import webetk.communication.utils.EasySSLProtocolSocketFactory;
import webetk.interfaces.domsowu.ConnectionConfiguration;
import webetk.interfaces.domsowu.JAXBContextFactory;

public abstract class Manager {
    public static final String CONST_JAVA_SERVER = "JavaServer";
    public static final String CONST_HTML = "Html";
    protected static final String VIN_PARAM = "vin";
    protected static final String LANG_PARAM = "lang";
    protected static final String VERSION_PARAM = "version";
    protected static final String ASAP_PSESSID_PARAM = "PSESSID";
    private HttpClient client = new HttpClient();
    private GetMethod getMethod = null;
    private ConnectionConfiguration config = null;
    private static final String loggerQuery = "INSERT INTO W_ETK_TIME_LOG (REQUESTED_URL,REQUESTED_PARAMETER,REQUESTED_TIME,REQUESTED_VIN,TIME_DURATION) VALUES (?,?,?,?,?)";
    private static Logger log = Logger.getLogger(Manager.class);
    private static Logger logTime = Logger.getLogger("time");
    private static String authStringEncINT = "UVFFRE9NMDpmdW5EaTRybg==";
    private static String INT_URL = "https://dom-etk-apisec-int";
    private static String authStringEncPROD = "UVFFRE9NMTpoZjB0NWo5YXY=";
    private static String PROD_URL = "https://dom-etk-apisec-prod";

    public Manager(String psEnv) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        if (psEnv.equalsIgnoreCase(CONST_JAVA_SERVER)) {
            System.setProperty("jsse.enableSNIExtension", "false");
            Protocol myhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)myhttps);
        }
    }

    protected String getVIN17Information(String sServerUrl) throws IOException {
        log.debug("Sending XML request ...");
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        if (sServerUrl == null || sServerUrl.length() == 0) {
            log.error("Not properly initialized! Server URL is missing.");
            throw new IllegalStateException("Not properly initialized! Server URL is missing.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss:SSS");
        long time = -System.currentTimeMillis();
        InputStream is = this.connectToServer(sServerUrl);
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException | SAXException ex) {
            log.error("Error during unmarshalling: " + ex.getMessage());
        }
        Element root = doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("vehicle");
        String result = "";
        boolean first = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || node == null) continue;
            Element eElement = (Element)node;
            String vinLong = eElement.getAttribute("vinLong");
            Node basicTypeChildNode = eElement.getLastChild().getPreviousSibling();
            Element elementBasicType = (Element)basicTypeChildNode;
            String vinType = elementBasicType.getAttribute("basicTypeNo");
            vinLong = vinLong + ":" + vinType;
            if (first) {
                result = result + vinLong;
                first = false;
                continue;
            }
            result = result + "," + vinLong;
        }
        logTime.debug("********* Dauer (" + sServerUrl + ") *********:" + sdf.format(time += System.currentTimeMillis()));
        return result;
    }

    protected Object getInformation(Class<?> targetClass, String sServerUrl) throws JAXBException, IOException {
        log.debug("Sending XML request ...");
        if (sServerUrl == null || sServerUrl.length() == 0) {
            log.error("Not properly initialized! Server URL is missing.");
            throw new IllegalStateException("Not properly initialized! Server URL is missing.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss:SSS");
        long time = -System.currentTimeMillis();
        InputStream is = this.connectToServer(sServerUrl);
        try {
            JAXBContextFactory factory = JAXBContextFactory.getInstance();
            JAXBContext jc = factory.getJaxBContext(targetClass);
            log.debug("Getting Jaxb context from a factory...ETK_WS_DOM_SOW");
            Unmarshaller unmarsh = jc.createUnmarshaller();
            Object object = unmarsh.unmarshal((Reader)new InputStreamReader(is, "UTF-8"));
            return object;
        }
        catch (JAXBException ex) {
            log.error("Error during unmarshalling: " + ex.getMessage());
            throw new JAXBException(null, "Error during unmarshalling: " + ex.getMessage());
        }
        finally {
            if (this.getMethod != null) {
                this.getMethod.releaseConnection();
            }
            logTime.debug("********* Dauer (" + sServerUrl + ") *********:" + sdf.format(time += System.currentTimeMillis()));
            int index = sServerUrl.indexOf(63);
            int index1 = sServerUrl.indexOf(38);
            String requestedURL = sServerUrl.substring(0, index);
            String requestedParam = sServerUrl.substring(index, sServerUrl.length());
            String vinString = sServerUrl.substring(index + 1, index1);
            String vinNumber = vinString.substring(4, vinString.length());
            if (ServerGlobalObjects.getInstance().isTimerDBLogginRequired()) {
                this.insertWebETKTimeLogInfo(requestedURL, requestedParam, sdf.format(time), vinNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWebETKTimeLogInfo(String URL2, String param, String time, String VIN) {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement ps = null;
        try {
            con = gObj.getDBConnection("WebETKTimerlog.insert");
            ps = con.prepareStatement(loggerQuery);
            ps.setString(1, URL2);
            ps.setString(2, param);
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.setString(4, VIN);
            ps.setString(5, time);
            ps.executeUpdate();
        }
        catch (SQLException | DatabaseBusyException e) {
            log.error("Error during logging data in W_ETK_TIME_LOG: " + e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error("Error during closig PreparedStatement Object: " + e.getMessage());
                }
                if (con != null) {
                    try {
                        gObj.freeDBConnection(con, "WebETKTimerlog.insert");
                    }
                    catch (SQLException e) {
                        log.error("Error during closing connection to W_ETK_TIME_LOG: " + e.getMessage());
                    }
                }
            }
        }
    }

    protected InputStream connectToServer(String sServerUrl) throws IOException {
        log.debug("Connection to information source ...");
        this.getMethod = null;
        try {
            ConnectionConfiguration config = this.getHostConfig();
            if (config != null) {
                if (config.getHostConfig() != null) {
                    this.client.setHostConfiguration(config.getHostConfig());
                }
                this.client.getState().setAuthenticationPreemptive(config.isPreemptiveAuth());
                if (config.getHostCredentials() != null) {
                    log.debug("Setting credentials to: " + config.getHostCredentials());
                    this.client.getState().setCredentials(config.getCredentialRealm(), config.getCredentialHost(), config.getHostCredentials());
                }
                if (config.getProxyCredentials() != null) {
                    log.debug("Setting proxy credentials to: " + config.getProxyCredentials());
                    this.client.getState().setProxyCredentials(config.getCredentialProxyRealm(), config.getCredentialProxyHost(), config.getProxyCredentials());
                }
            }
            if (log.isDebugEnabled()) {
                this.logHttpClient(this.client);
            }
            this.getMethod = new GetMethod(sServerUrl);
            if (sServerUrl.startsWith(PROD_URL)) {
                this.getMethod.setRequestHeader("Authorization", "Basic " + authStringEncPROD);
                this.getMethod.setRequestHeader("Accept", "application/json");
                this.getMethod.setRequestHeader("Connection", "close");
            } else if (sServerUrl.startsWith(INT_URL)) {
                this.getMethod.setRequestHeader("Authorization", "Basic " + authStringEncINT);
                this.getMethod.setRequestHeader("Accept", "application/json");
                this.getMethod.setRequestHeader("Connection", "close");
            }
            log.debug("Executing request ...");
            this.client.setConnectionTimeout(30000);
            this.client.setTimeout(60000);
            this.client.executeMethod((HttpMethod)this.getMethod);
            if (this.getMethod.getStatusCode() == 401) {
                log.error("HTTP Connection got error! Status: " + this.getMethod.getStatusLine());
            } else if (this.getMethod.getStatusCode() != 200) {
                log.error("HTTP Connection got error! Status: " + this.getMethod.getStatusLine());
            }
            if (this.getMethod.getStatusCode() != 200) {
                logTime.error("-->>> HTTP Connection got error! Status: " + this.getMethod.getStatusLine() + " -->>> for URL: " + sServerUrl + " -->>> client.setConnectionTimeout(30000);" + " -->>> client.setTimeout(60000);");
            }
            if (log.isDebugEnabled()) {
                this.logHttpMethod((HttpMethod)this.getMethod);
            }
            InputStream is = this.getMethod.getResponseBodyAsStream();
            return is;
        }
        catch (HttpException ex) {
            log.error("HTTP Error during communication: " + ex.getMessage());
            logTime.error("-->>> HTTP Error during communication: " + ex.getMessage() + " -->>> for URL: " + sServerUrl + " -->>> client.setConnectionTimeout(30000);" + " -->>> client.setTimeout(60000);");
            throw ex;
        }
        catch (IOException ex) {
            log.error("IO Error during communication: " + ex.getMessage());
            logTime.error("-->>> IO Error during communication: " + ex.getMessage() + " -->>> for URL: " + sServerUrl);
            throw ex;
        }
        catch (Throwable t) {
            log.error(" throwable cause " + t.getCause() + " throwable message " + t.getMessage());
            t.printStackTrace();
            logTime.error("-->>> throwable cause " + t.getCause() + " throwable message " + t.getMessage() + " -->>> for URL: " + sServerUrl);
            return null;
        }
    }

    public void setHostConfig(ConnectionConfiguration oConfig) {
        this.config = oConfig;
    }

    protected ConnectionConfiguration getHostConfig() {
        return this.config;
    }

    private void logHttpClient(HttpClient client) {
        HttpState state;
        log.debug("CLIENT------------------------------------------------------------------");
        log.debug("Client state: " + client.getState().toString());
        log.debug("Client state: " + client.getHostConfiguration().toString());
        log.debug("Host: " + client.getHostConfiguration().getHost());
        try {
            log.debug("HostURL: " + client.getHostConfiguration().getHostURL());
        }
        catch (IllegalStateException e) {
            log.debug("HostURL: " + e.getMessage());
        }
        log.debug("Host Port: " + client.getHostConfiguration().getPort());
        log.debug("Proxy: " + client.getHostConfiguration().getProxyHost());
        log.debug("Proxy Port: " + client.getHostConfiguration().getProxyPort());
        log.debug("Virtual Host: " + client.getHostConfiguration().getVirtualHost());
        log.debug("Local Adress: " + client.getHostConfiguration().getLocalAddress());
        if (client.getHostConfiguration().getLocalAddress() != null) {
            log.debug("** Canonical Host Name: " + client.getHostConfiguration().getLocalAddress().getCanonicalHostName());
            log.debug("** Host Adress: " + client.getHostConfiguration().getLocalAddress().getHostAddress());
            log.debug("** Host Name: " + client.getHostConfiguration().getLocalAddress().getHostName());
        }
        log.debug("Protocol: " + client.getHostConfiguration().getProtocol());
        if (client.getHostConfiguration().getProtocol() != null) {
            log.debug("** Default Port: " + client.getHostConfiguration().getProtocol().getDefaultPort());
            log.debug("** Scheme: " + client.getHostConfiguration().getProtocol().getScheme());
        }
        if ((state = client.getState()) != null) {
            log.debug("## Credentials: " + state.getCredentials(null, null));
            log.debug("## Proxy Credentials: " + state.getProxyCredentials(null, null));
        }
        log.debug("------------------------------------------------------------------------");
    }

    private void logHttpMethod(HttpMethod method) {
        log.debug("METHOD------------------------------------------------------------------");
        log.debug("Name: " + method.getName());
        log.debug("Path: " + method.getPath());
        log.debug("QueryString: " + method.getQueryString());
        log.debug("Status Line: " + method.getStatusLine());
        if (method.getStatusLine() != null) {
            log.debug("Status Code: " + method.getStatusCode());
            log.debug("Status: " + method.getStatusText());
        }
        log.debug("Do Authentification: " + method.getDoAuthentication());
        log.debug("Follow Redirects: " + method.getFollowRedirects());
        log.debug("Name: " + method.getStatusLine());
        log.debug("------------------------------------------------------------------------");
    }
}

