/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import webetk.communication.utils.UrlEncodedQueryString;
import webetk.interfaces.domsowu.CallSOWUWebService;
import webetk.interfaces.domsowu.Manager;
import webetk.interfaces.sowu.Sowu;

public class SoWuManager
extends Manager {
    private static Logger logger = Logger.getLogger(SoWuManager.class);

    public SoWuManager(String psEnv) {
        super(psEnv);
    }

    protected Sowu getSowuInformation(String sServerUrl) throws JAXBException, IOException {
        return (Sowu)this.getInformation(Sowu.class, sServerUrl);
    }

    public String retrieveInfo(String sServerUrl, String sVin, String sLang) {
        URI uri;
        try {
            uri = new URI(sServerUrl);
        }
        catch (URISyntaxException ex) {
            logger.error("Invalid ServerURL for SoWu server: " + sServerUrl + " - " + ex.getMessage(), ex);
            return null;
        }
        UrlEncodedQueryString ueqs = UrlEncodedQueryString.parse(uri);
        ueqs.append("vin", sVin);
        ueqs.append("lang", sLang);
        logger.info("Accessing SoWu using URL: " + uri.toString());
        try {
            CallSOWUWebService sowuWebService = new CallSOWUWebService();
            return sowuWebService.callSoapWebService(uri.toString(), sVin, sLang);
        }
        catch (Exception ex) {
            logger.error("Invalid response from SoWu server. Parsing failed: " + ex.getMessage(), ex);
            return null;
        }
    }
}

