/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import webetk.communication.utils.UrlEncodedQueryString;
import webetk.interfaces.dom.options.VehicleOptions;
import webetk.interfaces.domsowu.Manager;

public class VehicleOptionsManager
extends Manager {
    private static Logger logger = Logger.getLogger(VehicleOptionsManager.class);

    public VehicleOptionsManager(String psEnv) {
        super(psEnv);
    }

    protected VehicleOptions getDomOptionsVehicleInformation(String sServerUrl) throws JAXBException, IOException {
        return (VehicleOptions)this.getInformation(VehicleOptions.class, sServerUrl);
    }

    public VehicleOptions retrieveInfo(String sServerUrl, String sVin, String sLang, String sAsapSessId) {
        URI uri;
        try {
            uri = new URI(sServerUrl);
        }
        catch (URISyntaxException ex) {
            logger.error("Invalid ServerURL for DOM Options server: " + sServerUrl + " - " + ex.getMessage(), ex);
            return null;
        }
        UrlEncodedQueryString ueqs = UrlEncodedQueryString.parse(uri);
        ueqs.append("vin", sVin);
        ueqs.append("lang", sLang);
        ueqs.append("version", "06.01");
        if (sAsapSessId != null) {
            ueqs.append("PSESSID", sAsapSessId);
        }
        uri = ueqs.apply(uri);
        logger.info("Accessing DOM Options using URL: " + uri.toString());
        try {
            return this.getDomOptionsVehicleInformation(uri.toString());
        }
        catch (IOException ex) {
            logger.error("Communication to DOM Options server failed: " + ex.getMessage(), ex);
            return null;
        }
        catch (JAXBException ex) {
            logger.error("Invalid response from DOM Options server. Parsing failed: " + ex.getMessage(), ex);
            return null;
        }
    }
}

