/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.sowu;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.interfaces.sowu.Line;
import webetk.interfaces.sowu.Message;
import webetk.interfaces.sowu.Sowu;
import webetk.interfaces.sowu.SowuType;
import webetk.interfaces.sowu.SowuTypes;
import webetk.interfaces.sowu.Title;
import webetk.interfaces.sowu.Vehicle;

public class SowuVO {
    private static Logger log = Logger.getLogger(SowuVO.class);
    private String messageCode = null;
    private String messageText = null;
    private String interieur = null;
    private Collection<String> textZeilen = null;

    public SowuVO(Sowu oSowu) {
        if (oSowu == null) {
            log.warn("Initialization with empty data! (data was null)!");
            return;
        }
        Vehicle vhc = oSowu.getVehicle();
        Message msg = vhc.getMessage();
        if (msg != null) {
            this.messageCode = msg.getCode();
            this.messageText = msg.getValue();
        }
        this.interieur = vhc.getInterieur();
        SowuTypes types = vhc.getSowuTypes();
        if (types != null) {
            this.textZeilen = new Vector<String>();
            List<SowuType> listTypes = types.getSowuType();
            for (int ii = 0; ii < listTypes.size(); ++ii) {
                Title title;
                SowuType type = listTypes.get(ii);
                if (type == null) continue;
                if (this.textZeilen.size() > 0) {
                    this.textZeilen.add("");
                }
                if ((title = type.getTitle()) != null) {
                    String content;
                    String zeile = "";
                    String code = title.getCode();
                    if (code != null) {
                        zeile = code;
                    }
                    if ((content = title.getValue()) != null) {
                        zeile = zeile + " " + content;
                    }
                    this.textZeilen.add(zeile);
                }
                List<Line> listLines = type.getLine();
                for (int kk = 0; kk < listLines.size(); ++kk) {
                    Line line = listLines.get(kk);
                    if (line == null) continue;
                    String zeile = "";
                    String content = line.getValue();
                    if (content != null) {
                        zeile = zeile + "  " + content;
                    }
                    this.textZeilen.add(zeile);
                }
            }
        }
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public Collection<String> getTextZeilen() {
        return this.textZeilen;
    }

    public String getInterieur() {
        return this.interieur;
    }
}

