/*
 * Decompiled with CFR 0.152.
 */
package webetk.isisLaunch;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.catalina.startup.Bootstrap;
import org.apache.log4j.Logger;

public class IsisRunServer {
    private static Logger log = null;

    private static final void abort(String msg) {
        log.fatal("abort: " + msg);
        System.out.println("abort: " + msg);
        System.exit(10);
    }

    public static void main(String[] args) {
        String logFile;
        System.out.println("args:" + Arrays.toString(args));
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option apacheOpt = parser.addStringOption('a', "apache");
        CmdLineParser.Option catalinaOpt = parser.addStringOption('c', "catalina");
        CmdLineParser.Option logLevelOpt = parser.addStringOption('l', "loglevel");
        CmdLineParser.Option logFileOpt = parser.addStringOption('L', "Logfile");
        CmdLineParser.Option shutdownOpt = parser.addBooleanOption('s', "shutdown");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            IsisRunServer.abort("start aborted due to: " + e.getMessage());
        }
        String logLevelString = (String)parser.getOptionValue(logLevelOpt);
        if (logLevelString == null) {
            logLevelString = "INFO";
        }
        if ((logFile = (String)parser.getOptionValue(logFileOpt)) == null) {
            logFile = "tomcatEmbed.log";
        }
        log = Logger.getLogger(IsisRunServer.class);
        Boolean shutdownBool = (Boolean)parser.getOptionValue(shutdownOpt);
        boolean shutdown = false;
        if (shutdownBool != null && shutdownBool.booleanValue()) {
            shutdown = true;
        }
        try {
            File score;
            File config;
            String catalinaHomeDir = (String)parser.getOptionValue(catalinaOpt);
            if (catalinaHomeDir == null) {
                catalinaHomeDir = ".";
                log.info("catalina.home defaults to .");
            }
            File catalinaHome = new File(catalinaHomeDir).getCanonicalFile();
            log.info("catalina.home: " + catalinaHome);
            File confdir = new File(catalinaHome, "conf");
            if (!confdir.exists() || !confdir.isDirectory()) {
                IsisRunServer.abort("no configuration directory at " + confdir);
            }
            if (!(config = new File(confdir, "server.xml")).exists()) {
                IsisRunServer.abort("missing config file " + config);
            } else {
                log.info("use config: " + config);
            }
            System.setProperty("catalina.home", catalinaHomeDir);
            String apacheHomeDir = (String)parser.getOptionValue(apacheOpt);
            if (apacheHomeDir == null) {
                apacheHomeDir = "P:/iBase/Basis/Tomcat_Embedded/apache-tomcat-embed";
                log.info("apache.home defaults to: " + apacheHomeDir);
            }
            if ((score = new File(apacheHomeDir).getCanonicalFile()).isDirectory() && score.exists()) {
                log.info("runserver: my TOMCAT directory is a SOURCE version at " + score);
            } else {
                IsisRunServer.abort("runserver: I cannot find a TOMCAT installation directory in the workspace: " + score);
            }
            ArrayList<String> my = new ArrayList<String>();
            my.add("-config");
            my.add(config.toString());
            if (shutdown) {
                my.add("stop");
            } else {
                my.add("start");
            }
            String[] cmdar = my.toArray(new String[my.size()]);
            System.setProperty("catalina.base", score.toString());
            log.info("catalina.base: " + score.toString());
            Bootstrap.main((String[])cmdar);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

