/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaserver.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidSessionException;
import webetk.MultiLingualMsg;
import webetk.WebetkUtils;
import webetk.app.BmwNetz;
import webetk.app.ImageCache;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Nutzer;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommController;
import webetk.communication.CommandExecutionException;
import webetk.communication.LoginException;
import webetk.communication.LoginInfo;
import webetk.communication.command.TransferableCommand;
import webetk.communication.command.TrfTeilelisteCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfHashMap;
import webetk.db.dbaccess.KonfigurationDbAccess;
import webetk.javaserver.app.GlobalObjects;
import webetk.javaserver.framework.SessionInfo;
import webetk.javaserver.framework.UserInfo;
import webetk.javaserver.servlet.BaseServlet;
import webetk.mrkprd.Marken;
import webetk.xmlapi.XmlRpcCommand;

public class ClientService
extends BaseServlet {
    private static final long serialVersionUID = -7092029020873273332L;
    protected Logger log = Logger.getLogger(ClientService.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.debug("Starting request ... ");
        this.doService(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.debug("Starting request ... ");
        this.doService(request, response);
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SessionInfo sessInfo;
        Transferable trf;
        ObjectInputStream streamIn;
        block27: {
            this.log.debug("Checking commands ... ");
            if (this.checkOverrulingCommands(request, response)) {
                return;
            }
            String sTest = request.getParameter("Test");
            if (sTest != null && sTest.equals("J")) {
                this.doTest(response);
                return;
            }
            this.log.debug("No overruling commands. continue with transferables.");
            this.log.debug("Checking MIME type ...");
            String contenttype = request.getContentType();
            if (contenttype == null || !contenttype.equals("application/x-javaserializedobject webetk.communication.transferables.Transferable")) {
                this.log.error("Illegal MIME type in request!");
                throw new IOException("Illegal mime type in request.");
            }
            this.log.debug("Reading input stream ...");
            try {
                streamIn = new ObjectInputStream((InputStream)request.getInputStream());
            }
            catch (IOException e1) {
                this.log.error("Could not open Input Stream for Object: " + e1.getMessage());
                throw e1;
            }
            trf = null;
            sessInfo = null;
            try {
                trf = Transferable.read(streamIn);
                this.log.debug("Transferable created. Checking Session ...");
                if (this.log.isDebugEnabled()) {
                    HashMap<String, String> serverParams = trf.getServerParameter();
                    if (serverParams != null) {
                        Iterator<String> iter = serverParams.keySet().iterator();
                        this.log.debug("Parameters for Server URL:");
                        while (iter.hasNext()) {
                            String key = iter.next();
                            String val = serverParams.get(key);
                            this.log.debug("### Parameter: " + key.toString() + ", Value: " + val.toString());
                        }
                    }
                    this.log.debug("No parameters for Server URL.");
                }
                if (trf.getCommand().equals(Command.GET_IMAGE_NO_SESSION) || trf.getCommand().equals(Command.LOAD_FILIALEN) || trf.getCommand().equals(Command.EXIST_FIRMAID) || trf.getCommand().equals(Command.EXIST_USERID) || trf.getCommand().equals(Command.LOAD_DEFAULTFILIALE_PASSWORT) || trf.getCommand().equals(Command.LOAD_NUTZER_FUNKTIONSRECHTE) || trf.getCommand().equals(Command.EXIST_EINE_FIRMA_FILIALE_NUTZER) || trf.getCommand().equals(Command.LOAD_FIRMEN) || trf.getCommand().equals(Command.LOAD_PROGRAMM_VERSION) || trf.getCommand().equals(Command.LOAD_FILIALEN) || trf.getCommand().equals(Command.CHECK_IS_ISIS) || trf.getCommand().equals(Command.LOAD_BMW_NETZ_INFOS)) {
                    this.log.debug("Session is not required. Hence session is not checked!");
                } else {
                    sessInfo = this.getCurrentSession(request, trf);
                    this.log.debug("Session retrieved.");
                }
            }
            catch (ClassNotFoundException e) {
                this.log.error("No valid Transferable found!", e);
                throw new ServletException("No valid Transferable found in stream!");
            }
            catch (InvalidSessionException e) {
                this.log.error("No valid Session found!");
                if (trf != null) {
                    trf.setError(new CommandExecutionException("No valid session"));
                }
            }
            catch (LoginException e) {
                this.log.error("Login failed!", e);
                if (trf == null) break block27;
                trf.setError(e);
            }
        }
        if (trf.getError() == null && !Command.LOGIN.equals(trf.getCommand())) {
            if (Command.INSERT_US_LISTEN.equals(trf.getCommand())) {
                if (!(trf instanceof TrfHashMap)) {
                    this.log.error("No TrfHashMap Transferable, though there is no session!");
                    trf.setError(new InvalidSessionException("No TrfHashMap Transferable, though INSERT_US_LISTEN command!"));
                }
                TrfHashMap trfMap = (TrfHashMap)trf;
                String szUSFilename = (String)trfMap.getValue("us_filename");
                try {
                    this.createUSListen(sessInfo, szUSFilename);
                }
                catch (Exception ex) {
                    this.log.error("createUSListen failed", ex);
                    trf.setError(ex);
                }
            } else {
                try {
                    this.log.info("Calling interpret Request");
                    this.interpretRequest(trf, sessInfo);
                }
                catch (CommandExecutionException e) {
                    this.log.error("Error during execution of TransferableCommand!", e);
                    trf.setError(e);
                }
            }
        }
        ObjectOutputStream streamOut = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            Transferable.send(streamOut, trf);
        }
        catch (IOException e) {
            this.log.error("Error during sending Transferable to client!", e);
            throw new IOException("cannot send data to network");
        }
        try {
            streamIn.close();
            streamOut.close();
        }
        catch (Exception e) {
            this.log.error("Could not close stream", e);
        }
    }

    protected void doTest(HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        ServletOutputStream out = response.getOutputStream();
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<etktest>");
        Date now = new Date();
        String sTime = WebetkUtils.getStringFromDateTime(now, "de", 0, 0);
        out.println("<timestamp>" + sTime + "</timestamp>");
        out.println("<status_webserver>OK</status_webserver>");
        String sDb = "OK";
        try {
            Nutzer oNutzer = new Nutzer("", "", null);
            oNutzer.existNutzerId();
        }
        catch (Exception ex) {
            sDb = "Error: " + ex.getMessage();
        }
        out.println("<status_database>" + sDb + "</status_database>");
        out.println("<memory_jvm>");
        Runtime rt = Runtime.getRuntime();
        long lTotalMemory = rt.totalMemory();
        long lFreeMemory = rt.freeMemory();
        long lMaxMemory = rt.maxMemory();
        String sTotalMemory = Long.toString(lTotalMemory);
        String sFreeMemory = Long.toString(lFreeMemory);
        String sMaxMemory = Long.toString(lMaxMemory);
        out.println("<max>" + sMaxMemory + "</max>");
        out.println("<total>" + sTotalMemory + "</total>");
        out.println("<free>" + sFreeMemory + "</free>");
        out.println("</memory_jvm>");
        out.println("</etktest>");
    }

    public SessionInfo getCurrentSession(HttpServletRequest request, Transferable trf) throws InvalidSessionException, LoginException {
        SessionInfo sessInfo = this.getSessionInfo(request);
        if (sessInfo != null && !Command.LOGIN.equals(trf.getCommand())) {
            this.log.debug("Session retrieved: " + sessInfo.getId());
            return sessInfo;
        }
        if (!Command.LOGIN.equals(trf.getCommand())) {
            this.log.error("No login request, though there is no session!");
            throw new InvalidSessionException("No login request, though there is no session!");
        }
        if (!(trf instanceof TrfHashMap)) {
            this.log.error("No TrfHashMap Transferable, though there is no session!");
            throw new InvalidSessionException("No TrfHashMap Transferable, though there is no session!");
        }
        TrfHashMap trfMap = (TrfHashMap)trf;
        String sFirmaId = (String)trfMap.getValue("firmaid");
        String sFilialId = (String)trfMap.getValue("filialid");
        String sFilialIdAlt = (String)trfMap.getValue("filialid_alt");
        String sUser = (String)trfMap.getValue("username");
        String sPassword = (String)trfMap.getValue("pwd");
        String szUSFilename = (String)trfMap.getValue("us_filename");
        if (sFirmaId == null || sFilialId == null || sUser == null || sPassword == null) {
            this.log.error("Login failed! No company, subsidiary, user or password was given.");
            throw new LoginException("Missing company, subsidiary, username or password");
        }
        try {
            if (!UserInfo.checkUser(sFirmaId, sUser, sPassword)) {
                this.log.error("No such user or illegal password: (" + sUser + "," + sPassword + ")");
                throw new LoginException("Illegal Password for user (" + sUser + "," + sPassword + ")");
            }
        }
        catch (DatabaseBusyException ex) {
            this.log.error("Database access failed: " + ex.getMessage());
            throw new InvalidSessionException(ex.getMessage());
        }
        catch (SQLException ex) {
            this.log.error("SQL Error during check: " + ex.getMessage());
            throw new InvalidSessionException(ex.getMessage());
        }
        sessInfo = this.createNewSession(request);
        if (sessInfo == null) {
            this.log.error("Could not create session!");
            throw new InvalidSessionException("Could not create session!");
        }
        try {
            GlobalObjects oGlob;
            BmwNetz oBmwNetz;
            String sCentralServerUrl;
            sessInfo.loadUser(sFirmaId, sFilialId, sUser);
            this.log.debug("user-settings loaded");
            sessInfo.retrieveUserRechte(sessInfo.getUserInfo());
            this.log.debug("user-rights loaded");
            sessInfo.deleteTeilenotizen(sessInfo.getUserInfo());
            this.log.debug("delete abgelaufene teilenotizen");
            if (!sFilialId.equals(sFilialIdAlt)) {
                this.moveTeilelisten(sFirmaId, sUser, sFilialId, sFilialIdAlt);
                this.changeDefaultFiliale(sFirmaId, sUser, sFilialId);
            }
            this.initInterfaces(sessInfo);
            this.createUSListen(sessInfo, szUSFilename);
            if (sessInfo.getUserMarken().contains(Marken.getInstance().getMarke("RR").getBerechtigung())) {
                this.createRrSapListe(sessInfo);
            }
            if ((sCentralServerUrl = (oBmwNetz = (oGlob = GlobalObjects.getInstance()).getCentralServerSettings()).getCentralServerUrl()) != null && sCentralServerUrl.length() > 0) {
                String sCentralProxyName = oBmwNetz.getProxyName();
                int nCentralProxyPort = oBmwNetz.getProxyPort();
                String sCentralRealm = oBmwNetz.getProxyRealm();
                String sProxyHost = null;
                String sCentralUsername = oBmwNetz.getProxyUserName();
                String sCentralPassword = oBmwNetz.getProxyPasswort();
                String sCentralNtDomain = oBmwNetz.getProxyNtDomain();
                String sCentralNtHost = oBmwNetz.getProxyNtHost();
                CommController oCommController = CommController.getInstance();
                this.log.debug("sCentralProxyName: " + sCentralProxyName);
                if (sCentralProxyName == null || nCentralProxyPort == 0) {
                    this.log.debug("*** no proxy settings - new commController with central server url >" + sCentralServerUrl + "< only ***");
                    oCommController.init(sCentralServerUrl);
                } else {
                    this.log.debug("*** proxy settings - new commController with central server url >" + sCentralServerUrl + "< and proxy name, port ... (" + sCentralProxyName + "/" + nCentralProxyPort + "/" + sCentralRealm + "/" + sProxyHost + "/" + sCentralUsername + "/" + sCentralPassword + "/" + sCentralNtDomain + "/" + sCentralNtHost + ") ***");
                    oCommController.init(sCentralServerUrl, sCentralProxyName, nCentralProxyPort, sCentralRealm, sProxyHost, sCentralUsername, sCentralPassword, sCentralNtDomain, sCentralNtHost);
                }
                int nConnectionTimeout = oGlob.getTimeoutConnection();
                int nSocketTimeout = oGlob.getTimeoutSocket();
                int nHttpConnectionFactoryTimeout = oGlob.getTimeoutConnection();
                oCommController.setTimeouts(nConnectionTimeout, nSocketTimeout, nHttpConnectionFactoryTimeout);
            } else {
                this.log.debug("no CentralServerUrl");
            }
        }
        catch (DatabaseBusyException ex) {
            this.log.error("Database access failed: " + ex.getMessage());
            throw new InvalidSessionException(ex.getMessage());
        }
        catch (SQLException ex) {
            this.log.error("SQL Error during load: " + ex.getMessage());
            throw new InvalidSessionException(ex.getMessage());
        }
        catch (Exception ex) {
            this.log.error("Could not intialize the communication controller!" + ex.getMessage());
            throw new InvalidSessionException(ex.getMessage());
        }
        this.prepareUserInfo(sessInfo, trfMap);
        this.log.debug("user prepared");
        return sessInfo;
    }

    protected void initInterfaces(SessionInfo sessInfo) throws SQLException, DatabaseBusyException {
        GlobalObjects oGlob = GlobalObjects.getInstance();
        String sXmlDmsServerUrl = oGlob.getXmlDmsServerUrl();
        String sXmlDmsSchemaUrl = oGlob.getXmlDmsSchemaUrl();
        this.log.info("initializing DMS interface with SchemaUrl: " + sXmlDmsSchemaUrl + " ServerUrl: " + sXmlDmsServerUrl);
        XmlRpcCommand.setSchemaUrlDms(sXmlDmsSchemaUrl);
        XmlRpcCommand.setServerUrlDms(sXmlDmsServerUrl);
        sXmlDmsSchemaUrl = sXmlDmsSchemaUrl == null ? "" : sXmlDmsSchemaUrl;
        sXmlDmsServerUrl = sXmlDmsServerUrl == null ? "" : sXmlDmsServerUrl;
        boolean bDMSAngeschlossen = !sXmlDmsSchemaUrl.trim().equals("") && !sXmlDmsServerUrl.trim().equals("");
        boolean bDMSVerwenden = Nutzer.checkDMSVerwenden(sessInfo.getUserInfo().getFirmaID(), sessInfo.getUserInfo().getFilialeID());
        sessInfo.setDMSVerwenden(bDMSAngeschlossen && bDMSVerwenden);
        sessInfo.setDMSAngeschlossen(bDMSAngeschlossen);
        String sXmlVinServerUrl = null;
        String sXmlVinSchemaUrl = oGlob.getXmlVinSpecSchemaUrl();
        this.log.info("initializing VIN interface with SchemaUrl: " + sXmlVinSchemaUrl + " ServerUrl: " + sXmlVinServerUrl);
        XmlRpcCommand.setSchemaUrlVin(sXmlVinSchemaUrl);
        XmlRpcCommand.setServerUrlVin(sXmlVinServerUrl);
        sXmlVinSchemaUrl = sXmlVinSchemaUrl == null ? "" : sXmlVinSchemaUrl;
        sXmlVinServerUrl = sXmlVinServerUrl == null ? "" : sXmlVinServerUrl;
        boolean bVinSpecAngeschlossen = !sXmlVinSchemaUrl.trim().equals("") && !sXmlVinServerUrl.trim().equals("");
        sessInfo.setVINSpecAngeschlossen(bVinSpecAngeschlossen);
        boolean bVinSpecVerwenden = true;
        sessInfo.setVINSpecVerwenden(bVinSpecAngeschlossen && bVinSpecVerwenden);
        boolean bIGDOMAngeschlossen = GlobalObjects.getInstance().isIgdomAccess();
        sessInfo.setIGDOMAngeschlossen(bIGDOMAngeschlossen);
        sessInfo.setIGDOMVerwenden(bIGDOMAngeschlossen);
    }

    protected void createUSListen(SessionInfo sessInfo, String szUSFilename) throws SQLException, DatabaseBusyException {
        if (szUSFilename != null && szUSFilename.length() > 0) {
            String sSprache = sessInfo.getAktuelleSprache();
            String sNutzerId = sessInfo.getUserInfo().getID();
            String sFirma = sessInfo.getUserInfo().getFirmaID();
            String sFiliale = sessInfo.getUserInfo().getFilialeID();
            Collection<String> aMarken = sessInfo.getUserMarken();
            for (String sMarke : aMarken) {
                String sUSListenId = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.usListenIds", "unknown-" + sMarke);
                Teileliste objTeileliste = new Teileliste(sMarke, sNutzerId, sUSListenId, sSprache);
                objTeileliste.setMarke(sMarke);
                objTeileliste.insert(sFirma, sFiliale);
            }
        }
    }

    protected void createRrSapListe(SessionInfo sessionInfo) {
        String sNutzerId = sessionInfo.getUserInfo().getID();
        String sFirma = sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = sessionInfo.getUserInfo().getFilialeID();
        try {
            Vector<ComboTeilelisteItem> aListen = Teileliste.getRrListen(sNutzerId, sFirma, sFiliale);
            if (aListen.size() > 0) {
                return;
            }
            String sHaendlerNr = null;
            TrfTeilelisteCommand.createRrSapListe(sessionInfo, sHaendlerNr);
        }
        catch (Exception ex) {
            this.log.error("Could not create RR SAP List", ex);
        }
    }

    protected void interpretRequest(Transferable trf, SessionInfo sessInfo) throws CommandExecutionException {
        String strTrfName = trf.getClass().getName();
        String strCommandName = "Command.";
        strCommandName = strCommandName + strTrfName.substring(strTrfName.lastIndexOf(46) + 1);
        strCommandName = strCommandName + "Command";
        this.log.debug("Commandname is: " + strCommandName);
        try {
            Class<?> objClass = Class.forName(strCommandName);
            TransferableCommand objCommand = (TransferableCommand)objClass.newInstance();
            this.log.debug("Class for command created successfully.");
            objCommand.setEnvironment(sessInfo);
            objCommand.setTransferable(trf);
            this.log.debug("Executing command.");
            objCommand.execute();
            Exception ex = trf.getError();
            if (ex != null) {
                if (ex instanceof UnknownHostException) {
                    this.log.error("UnknownHostException: " + ex.getMessage());
                    String sSprache = sessInfo.getAktuelleSprache();
                    String sMsg = MultiLingualMsg.getMsgText("UnknownHost", sSprache);
                    throw new CommandExecutionException(sMsg);
                }
                if (ex instanceof ConnectException) {
                    this.log.error("ConnectException: " + ex.getMessage());
                    String sSprache = sessInfo.getAktuelleSprache();
                    String sMsg = MultiLingualMsg.getMsgText("ConnectionRefused", sSprache);
                    throw new CommandExecutionException(sMsg);
                }
                if (ex instanceof HttpConnection.ConnectionTimeoutException) {
                    this.log.error("ConnectionTimeoutException: " + ex.getMessage());
                    String sSprache = sessInfo.getAktuelleSprache();
                    String sMsg = MultiLingualMsg.getMsgText("ConnectionTimedOut", sSprache);
                    throw new CommandExecutionException(sMsg);
                }
                if (ex instanceof NoRouteToHostException) {
                    this.log.error("NoRouteToHostException: " + ex.getMessage());
                    String sSprache = sessInfo.getAktuelleSprache();
                    String sMsg = MultiLingualMsg.getMsgText("ConnectionNoRouteToHost", sSprache);
                    throw new CommandExecutionException(sMsg);
                }
                if (ex instanceof BindException) {
                    this.log.error("BindException: " + ex.getMessage());
                    String sSprache = sessInfo.getAktuelleSprache();
                    String sMsg = MultiLingualMsg.getMsgText("ConnectionBindFailed", sSprache);
                    throw new CommandExecutionException(sMsg);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error("Couldn't find " + strCommandName, e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (ClassCastException e) {
            this.log.error("Couldn't cast to " + strCommandName, e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (InstantiationException e) {
            this.log.error("Couldn't instantiate " + strCommandName, e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log.error("Couldn't access " + strCommandName, e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (DatabaseBusyException e) {
            this.log.error("Database access was denied because database is busy!", e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (InvalidDataException e) {
            this.log.error("Inconsistency in the data detetced!", e);
            throw new CommandExecutionException(e.getMessage());
        }
        catch (SQLException e) {
            this.log.error("Error in execution of SQL!", e);
            throw new CommandExecutionException(e.getMessage());
        }
    }

    protected boolean checkOverrulingCommands(HttpServletRequest request, HttpServletResponse response) {
        String sCommand = request.getParameter("command");
        if (sCommand == null) {
            return false;
        }
        if (sCommand.equals("getImage")) {
            this.sendImageToHttpStream(request, response);
        }
        if (sCommand.equals("showVersion")) {
            this.getVersionInformation(request, response);
        }
        return true;
    }

    protected void sendImageToHttpStream(HttpServletRequest request, HttpServletResponse response) {
        this.log.debug("Loading image on direct command.");
        String sBildID = request.getParameter("imgid");
        String sBildFormFactor = request.getParameter("imgff");
        if (sBildID == null || sBildFormFactor == null) {
            this.log.error("Don't have ID or formfactor of image! Can't load.");
            response.setContentType("text/html");
            try {
                PrintWriter out = response.getWriter();
                out.println("<html><head><title>JavaServer direct command error</title></head>");
                out.println("<body><p>Es wurde keine Bild-ID oder kein Formfaktor angegeben! Bild konnte nicht geladen werden.");
                out.println("</body></html>");
                out.close();
            }
            catch (IOException ex) {
                this.log.fatal("Could not get outputstream!", ex);
            }
            return;
        }
        this.log.debug("Loading image for ID:" + sBildID + ", Form: " + sBildFormFactor);
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            String imageFormat = ImageCache.requestImageAsByteArray(outStream, sBildID, sBildFormFactor);
            if (imageFormat == null) {
                this.log.error("Could not get the image!");
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html><head><title>JavaServer direct command error</title></head>");
                out.println("<body><p>Das Bild konnte nicht geladen werden!");
                out.println("</body></html>");
                out.close();
                return;
            }
            this.writeImageToHttpResponse(outStream, imageFormat, response);
        }
        catch (DatabaseBusyException e) {
            Logger.getLogger(ClientService.class).error("Database is busy!", e);
        }
        catch (SQLException e) {
            Logger.getLogger(ClientService.class).error("Database error detected: " + e.getMessage(), e);
        }
        catch (IOException e) {
            Logger.getLogger(ClientService.class).error("IO error detected: " + e.getMessage(), e);
        }
    }

    protected void getVersionInformation(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html><head><title>JavaServer Version</title></head>");
            out.println("<body><p>Version: 1.0");
            out.println("</body></html>");
            out.close();
        }
        catch (IOException ex) {
            this.log.error("Could not get output stream!", ex);
        }
    }

    protected void prepareUserInfo(SessionInfo sessInfo, TrfHashMap trf) {
        this.log.info("prepareUserInfo MSG");
        UserInfo userInfo = sessInfo.getPlUserInfo();
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setLogin(userInfo.getID());
        loginInfo.setRechte(userInfo.getRechte());
        loginInfo.setUserMarken(sessInfo.getUserMarken());
        loginInfo.setUserProdukte(sessInfo.getUserProdukte());
        loginInfo.setUserKatUmfang(sessInfo.getUserKatUmfang());
        loginInfo.hasRechtAnzeigeProddatum(sessInfo.hasRechtAnzeigeProddatum());
        loginInfo.setFirmaId(userInfo.getFirmaID());
        loginInfo.setFilialeId(userInfo.getFilialeID());
        loginInfo.setSession(sessInfo.getId());
        loginInfo.setDMSAngeschlossen(sessInfo.getDMSAngschlossen());
        loginInfo.setDMSVerwenden(sessInfo.getDMSVerwenden());
        loginInfo.setVINSpecAngeschlossen(sessInfo.getVINSpecAngschlossen());
        loginInfo.setVINSpecVerwenden(sessInfo.getVINSpecVerwenden());
        loginInfo.setIGDOMAngeschlossen(sessInfo.getIGDOMAngeschlossen());
        loginInfo.setIGDOMVerwenden(sessInfo.getIGDOMVerwenden());
        loginInfo.setEinstellungenDisharmonie(userInfo.getEinstellungenDisharmonie());
        loginInfo.setUserMaerkte(sessInfo.loadMarktAndDealerType());
        loginInfo.setSettings(userInfo.getSettings());
        trf.setValue("webetkSession", loginInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageToHttpResponse(ByteArrayOutputStream imageStream, String imageFormat, HttpServletResponse response) throws IOException {
        Logger.getLogger(ClientService.class).info("Type: " + imageFormat);
        response.setContentType(WebetkUtils.getMimeType(imageFormat));
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] data = imageStream.toByteArray();
            out.write(data);
            out.flush();
        }
        finally {
            out.close();
            imageStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTeilelisten(String sFirmaId, String sNutzerId, String sFilialIdNeu, String sFilialIdAlt) {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Logger.getLogger(TrfHashMap.class).info("Move Teilelisten");
        Connection con = null;
        try {
            con = gObj.getDBConnection("TrfHashMap.moveTeilelisten");
            KonfigurationDbAccess.moveTeilelisten(con, sFirmaId, sNutzerId, sFilialIdNeu, sFilialIdAlt);
        }
        catch (Exception e) {
            Logger.getLogger(ClientService.class).error("Error detected: " + e.getMessage(), e);
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.moveTeilelisten");
            }
            catch (SQLException ex) {
                Logger.getLogger(ClientService.class).error("Error detected: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDefaultFiliale(String sFirmaId, String sNutzerId, String sFilialId) {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Logger.getLogger(TrfHashMap.class).info("Change Default-Filiale");
        Connection con = null;
        try {
            con = gObj.getDBConnection("TrfHashMap.changeDefaultFiliale");
            KonfigurationDbAccess.changeDefaultFiliale(con, sFirmaId, sNutzerId, sFilialId);
        }
        catch (Exception e) {
            Logger.getLogger(ClientService.class).error("Error detected: " + e.getMessage(), e);
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.changeDefaultFiliale");
            }
            catch (SQLException ex) {
                Logger.getLogger(ClientService.class).error("Error detected: " + ex.getMessage(), ex);
            }
        }
    }

    public void destroy() {
        Logger.getLogger(ClientService.class).error("destroy");
        this.m_objGlobal.closeAllConnections();
    }
}

