/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi;

import org.apache.log4j.BasicConfigurator;
import webetk.xmlapi.XmlCommunicationException;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.XmlRpcCommand;
import webetk.xmlapi.dms.commands.XmlDmsBarverkauf;
import webetk.xmlapi.dms.commands.XmlDmsEilauftrag;
import webetk.xmlapi.dms.commands.XmlDmsFilialabfrage;
import webetk.xmlapi.dms.commands.XmlDmsFzgIdAuftrag;
import webetk.xmlapi.dms.commands.XmlDmsFzgIdKfzKennzeichen;
import webetk.xmlapi.dms.commands.XmlDmsInit;
import webetk.xmlapi.dms.commands.XmlDmsKostenvoranschlag;
import webetk.xmlapi.dms.commands.XmlDmsNeuteileAuftrag;
import webetk.xmlapi.dms.commands.XmlDmsStammsatzanlage;
import webetk.xmlapi.dms.commands.XmlDmsTeileinfo;
import webetk.xmlapi.dms.commands.XmlDmsTeilelistenInfo;
import webetk.xmlapi.dms.commands.XmlDmsWerkstattAuftrag;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPosition;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionErweitert;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionKomplett;
import webetk.xmlapi.dms.commands.typen.XmlDmsMwst;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilelistenPosition;

public class ConTest {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            XmlRpcCommand.setServerUrlDms("http://localhost:8090/xmlDms?Art=Dms");
            ConTest.doBarverkauf();
            ConTest.doEilauftrag();
            ConTest.doFilialabfrage();
            ConTest.doFzgIdAuftrag();
            ConTest.doFzgIdKfz();
            ConTest.doInit();
            ConTest.doKostenvoranschlag();
            ConTest.doNeuteilauftrag();
            ConTest.doStammsatz();
            ConTest.doTeileInfo();
            ConTest.doTeilelisteninfo();
            ConTest.doWerkstattauftrag();
        }
        catch (XmlParseException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (XmlCommunicationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
    }

    public static void doTeilelisteninfo() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsTeilelistenInfo xmlReq = new XmlDmsTeilelistenInfo();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", null, -1, "BMW", new String[]{"2222222", "3434343", "2232112"});
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Kundennummer: " + Integer.toString(xmlReq.getKundennummer()));
        for (int i = 0; i < xmlReq.getTeileCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i));
            System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode(i)));
            System.out.println("Bezeichung: " + xmlReq.getTeilebezeichnung(i));
            System.out.println("Bedarfshinweis: " + xmlReq.getBedarfshinweis(i));
            System.out.println("HPreis: " + Double.toString(xmlReq.getHaendlerpreis(i)));
            if (xmlReq.getAUME(i) != null) {
                System.out.println("AUME: " + xmlReq.getAUME(i).toString());
            } else {
                System.out.println("AUME: ");
            }
            System.out.println("Dispo: " + Integer.toString(xmlReq.getDispoCode(i)));
            System.out.println("KodStufe: " + xmlReq.getKodierungsstufe(i));
            System.out.println("Lagerbestand: " + xmlReq.getLagerbestand(i).toString());
            System.out.println("Mindestbestand: " + xmlReq.getMindestbestand(i).toString());
            System.out.println("Lagerort: " + xmlReq.getLagerort(i));
            if (xmlReq.getMwst(i) != null) {
                System.out.println("MWST: " + xmlReq.getMwst(i).toString());
            } else {
                System.out.println("MWST: ");
            }
            if (xmlReq.getRabatt(i) != null) {
                System.out.println("Rabatt: " + xmlReq.getRabatt(i).toString());
            } else {
                System.out.println("Rabatt: ");
            }
            System.out.println("Sondersteuer: " + xmlReq.getSondersteuer(i).toString());
            System.out.println("Suffix: " + Integer.toString(xmlReq.getSuffix(i)));
        }
    }

    public static void doTeileInfo() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsTeileinfo xmlReq = new XmlDmsTeileinfo();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", "2222222", "BMW");
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Tnr: " + xmlReq.getTeilenummer());
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Bezeichung: " + xmlReq.getTeilebezeichnung());
        System.out.println("HPreis: " + Double.toString(xmlReq.getHaendlerpreis()));
        System.out.println("KodStufe: " + xmlReq.getKodierungsstufe());
        System.out.println("Lagerbestand: " + xmlReq.getLagerbestand());
        System.out.println("Mindestbestand: " + xmlReq.getMindestbestand());
        System.out.println("Lagerort: " + xmlReq.getLagerort());
        if (xmlReq.getMehrwertsteuer() != null) {
            System.out.println("MWST: " + xmlReq.getMehrwertsteuer().toString());
        } else {
            System.out.println("MWST: ");
        }
        System.out.println("Sondersteuer: " + xmlReq.getSondersteuer());
        System.out.println("Preis\u00e4nderung: " + xmlReq.getPreisaenderungsdatum().toString());
    }

    public static void doKostenvoranschlag() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsKostenvoranschlag xmlReq = new XmlDmsKostenvoranschlag();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", 1234, "Blafasl", "auf3", 1234567);
        XmlDmsBestellPositionKomplett pos = new XmlDmsBestellPositionKomplett("3444444", "MINI", "Halo2", 45.0, 12.54, 12.0, "4", "L", 1, 1, "1", "1", 11.9, "tt", "Bemerkung 1");
        xmlReq.addPosition(pos);
        pos = new XmlDmsBestellPositionKomplett("2332222", "BMW", "Ha22", 54.0, 13.53, 122.0, "24", "33L", 2, 2, "2", "2", 22.9, "uu", "Bemerkung 2");
        xmlReq.addPosition(pos);
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Auftragsnummer: " + xmlReq.getAuftragsnummer());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
        }
    }

    public static void doWerkstattauftrag() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsWerkstattAuftrag xmlReq = new XmlDmsWerkstattAuftrag();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", 1234, "Blafasl", "auf3", false);
        XmlDmsBestellPositionKomplett pos = new XmlDmsBestellPositionKomplett("3444444", "MINI", "Halo2", 45.0, 12.54, 12.0, "4", "L", 1, 1, "1", "1", 11.9, "tt", "Bemerkung 1");
        xmlReq.addPosition(pos);
        pos = new XmlDmsBestellPositionKomplett("2332222", "BMW", "Ha22", 54.0, 13.53, 122.0, "24", "33L", 2, 2, "2", "2", 22.9, "ee", "Bemerkung 2");
        xmlReq.addPosition(pos);
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Auftragsnummer: " + xmlReq.getAuftragsnummer());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
        }
    }

    public static void doFzgIdAuftrag() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsFzgIdAuftrag xmlReq = new XmlDmsFzgIdAuftrag();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", "auf2");
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Auftragsnummer: " + xmlReq.getAuftragsnummer());
        System.out.println("Fgstnr: " + xmlReq.getFahrgestellnummer());
        System.out.println("Kundenname: " + xmlReq.getKundenname());
        System.out.println("Kundennummer: " + Integer.toString(xmlReq.getKundennummer()));
        System.out.println("Marke: " + xmlReq.getMarke());
    }

    public static void doFzgIdKfz() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsFzgIdKfzKennzeichen xmlReq = new XmlDmsFzgIdKfzKennzeichen();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", "M-AU3120", "BMW");
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Auftragsnummer: " + xmlReq.getAuftragsnummer());
        System.out.println("Fgstnr: " + xmlReq.getFahrgestellnummer());
        System.out.println("Kundenname: " + xmlReq.getKundenname());
        System.out.println("Kundennummer: " + Integer.toString(xmlReq.getKundennummer()));
        System.out.println("Marke: " + xmlReq.getMarke());
    }

    public static void doFilialabfrage() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsFilialabfrage xmlReq = new XmlDmsFilialabfrage();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC");
        xmlReq.addPosition(new XmlDmsTeilelistenPosition("11111", "MINI"));
        xmlReq.addPosition(new XmlDmsTeilelistenPosition("22222", "BMW"));
        xmlReq.addPosition(new XmlDmsTeilelistenPosition("3333333", "RR"));
        xmlReq.addPosition(new XmlDmsTeilelistenPosition("1212312", "POL"));
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("TNr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
            for (int j = 0; j < xmlReq.getFilialbestandlCount(i); ++j) {
                System.out.println("Filiale: " + xmlReq.getFiliale(i, j) + " has: " + Double.toString(xmlReq.getBestand(i, j)));
            }
        }
    }

    public static void doEilauftrag() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsEilauftrag xmlReq = new XmlDmsEilauftrag();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC");
        xmlReq.addPosition(new XmlDmsBestellPositionErweitert("11111", "MINI", "Cooper", 1.0, "A1", -1, "kein Kunde"));
        xmlReq.addPosition(new XmlDmsBestellPositionErweitert("22222", "BMW", "Schnell", 1.0, "A2", 3, "alles da"));
        xmlReq.addPosition(new XmlDmsBestellPositionErweitert("3333333", "RR", "Geht", 3.0, null, -1, "nix da"));
        xmlReq.addPosition(new XmlDmsBestellPositionErweitert("1212312", "POL", "Das", 2.0, null, 2, "nur Kunde"));
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
        }
    }

    public static void doNeuteilauftrag() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsNeuteileAuftrag xmlReq = new XmlDmsNeuteileAuftrag();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC");
        xmlReq.addPosition(new XmlDmsBestellPosition("11111", "MINI", "Cooper", 1.0));
        xmlReq.addPosition(new XmlDmsBestellPosition("22222", "BMW", "Schnell", 1.0));
        xmlReq.addPosition(new XmlDmsBestellPosition("3333333", "RR", "Geht", 3.0));
        xmlReq.addPosition(new XmlDmsBestellPosition("1212312", "POL", "Das", 2.0));
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
        }
    }

    public static void doBarverkauf() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsBarverkauf xmlReq = new XmlDmsBarverkauf();
        xmlReq.setInputParameters("ascarsy", "ESG", "MUC", 1234, "Blafasl", "auf1", 5555, "ascarsy111", true, false, false, 1, 20.0, 320.0);
        xmlReq.addPosition(new XmlDmsBestellPositionKomplett("6262626", "MINI", "HallO", 55.0, 22.4, 22.5, "10.0", "A", 2, 5, "6", "4", 33.0, "ww", "Bemerkung 1"));
        xmlReq.addPosition(new XmlDmsBestellPositionKomplett("5545453", "BMW", "Hall", 54.0, 12.3, 13.8, "5.6", "T", 3, 54, "12", "3", 34.0, "33", "Bemerkung 2"));
        xmlReq.addPosition(new XmlDmsBestellPositionKomplett("7767576", "RR", "H234234", 35.0, 55.0, 44.0, "23", "J", 1, 2, "3", "4", 99.0, "ss", "Bemerkung 3"));
        xmlReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(xmlReq.getErgebnisCode()));
        System.out.println("Firma: " + xmlReq.getFirma());
        System.out.println("Auftragsnummer: " + xmlReq.getAuftragsnummer());
        for (int i = 0; i < xmlReq.getErgebnisCount(); ++i) {
            System.out.println("Tnr: " + xmlReq.getTeilenummer(i) + " has: " + Integer.toString(xmlReq.getErgebnisCode(i)));
        }
    }

    public static void doInit() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsInit initReq = new XmlDmsInit();
        initReq.setInputParameters("ascarsy", "ESG", "MUC", "ascarsy");
        initReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(initReq.getErgebnisCode()));
        System.out.println("Firma: " + initReq.getFirma());
        System.out.println("PLZ: " + initReq.getPostleitzahl());
        System.out.println("Strasse: " + initReq.getStrasse());
        System.out.println("Ort: " + initReq.getOrt());
        System.out.println("Tel: " + initReq.getTelefon());
        System.out.println("PkwNr: " + initReq.getNummerPKW());
        System.out.println("KradNr: " + initReq.getNummerKrad());
        System.out.println("Bar: " + initReq.getBarverkaufsNummer());
        if (initReq.getAtSteuer() != null) {
            System.out.println("AT Steuer: " + initReq.getAtSteuer().toString());
        } else {
            System.out.println("AT Steuer: ");
        }
        System.out.println("Nachkomma: " + Integer.toString(initReq.getNachkommaStellen()));
        System.out.println("Art: " + initReq.getIndikatorSatzAusfuehrung());
        System.out.println("Marke: " + initReq.getMarke());
        for (int i = 0; i < initReq.getMwstCount(); ++i) {
            XmlDmsMwst mwst = initReq.getMwst(i);
            System.out.println("MWST[" + Integer.toString(mwst.getId()) + "]: " + Double.toString(mwst.getProzentsatz()));
        }
    }

    public static void doStammsatz() throws XmlCommunicationException, IllegalArgumentException, XmlParseException, IllegalStateException {
        XmlDmsStammsatzanlage initReq = new XmlDmsStammsatzanlage();
        initReq.setInputParameters("ascarsy", "ESG", "MUC", "111111", "BMW", "Sch\u00f6nes Teil", 23.09, -1.0, "H", "3", "34", 200, 300, -1, true);
        initReq.requestService();
        System.out.println("Ergebniscode: " + Integer.toString(initReq.getErgebnisCode()));
        System.out.println("Firma: " + initReq.getFirma());
    }
}

