/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeBestandsabfrageRequest;
import webetk.interfaces.dms.TypeBestandsabfrageResponse;
import webetk.interfaces.dms.TypeMarke;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsBestandsabfrage
extends XmlDmsCommand {
    private static Logger log = Logger.getLogger(XmlDmsBestandsabfrage.class);
    private String[] teilenummern;
    private String[] marken;
    private List<TypeBestandsabfrageResponse.Bestandsinformation> bestandinfos = new ArrayList<TypeBestandsabfrageResponse.Bestandsinformation>();

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, Collection cTeilenummern, Collection cMarken) throws IllegalArgumentException, XmlParseException {
        String[] tnrs = new String[cTeilenummern.size()];
        Iterator iterTnr = cTeilenummern.iterator();
        int index = 0;
        while (iterTnr.hasNext()) {
            tnrs[index++] = (String)iterTnr.next();
        }
        String[] marken = null;
        marken = cTeilenummern.size() > cMarken.size() ? new String[cMarken.size()] : new String[cTeilenummern.size()];
        Iterator iterMarken = cMarken.iterator();
        index = 0;
        while (iterMarken.hasNext()) {
            marken[index++] = (String)iterMarken.next();
        }
        this.setInputParameters(sUsername, sFirma, sFiliale, tnrs, marken);
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String[] aTeilenummern, String[] aMarken) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.teilenummern = aTeilenummern;
        this.marken = aMarken;
        if (this.teilenummern.length == 0) {
            log.error("Teilenummer is not defined!");
            throw new IllegalArgumentException("Teilenummer ist nicht definiert!");
        }
        if (this.marken.length != this.teilenummern.length) {
            log.error("Marke is not defined!");
            throw new IllegalArgumentException("Marke ist nicht definiert!");
        }
        log.debug("Input seems to be in order.");
        log.debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        log.debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsBestandsabfrage() == null) {
            log.error("XML-Objekt is not a DmsBestandsabfrage Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsBestandsabfrage", "Response is not of type DmsBestandsabfrage!");
        }
        if (ergebnisObjekt.getDmsBestandsabfrage().getDmsResponse() == null) {
            log.error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsBestandsabfrage", "XML-Stream does not contain response objekt for DmsBestandsabfrage!");
        }
        TypeBestandsabfrageResponse resp = ergebnisObjekt.getDmsBestandsabfrage().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.bestandinfos.clear();
        this.bestandinfos = resp.getBestandsinformation();
        log.debug("Information has been extracted.");
    }

    public int getTeileCount() {
        return this.bestandinfos.size();
    }

    public TypeBestandsabfrageResponse.Bestandsinformation getBestandsinformation(int index) {
        return this.bestandinfos.get(index);
    }

    public int getErgebnisCode(int teilIndex) throws IndexOutOfBoundsException {
        TypeBestandsabfrageResponse.Bestandsinformation bi = this.getBestandsinformation(teilIndex);
        if (bi.getErgebnisCode() == null) {
            return -1;
        }
        return bi.getErgebnisCode().intValue();
    }

    public String getTeilenummer(int teilIndex) throws IndexOutOfBoundsException {
        return this.getBestandsinformation(teilIndex).getTeilenummer();
    }

    public Double getLagerbestand(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getBestandsinformation(teilIndex).getLagerbestand() == null) {
            return null;
        }
        return new Double(this.getBestandsinformation(teilIndex).getLagerbestand().doubleValue());
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsBestandsabfrage.class).debug("Constructing XML-Objekt from input parameters for DmsBestandsabfrage Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsBestandsabfrage(new DmsMessage.DmsBestandsabfrage());
        root.getDmsBestandsabfrage().setDmsRequest(new TypeBestandsabfrageRequest());
        TypeBestandsabfrageRequest inputPars = root.getDmsBestandsabfrage().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        for (int i = 0; i < this.teilenummern.length; ++i) {
            inputPars.getTeilenummerAndMarke().add(this.teilenummern[i]);
            if (this.marken.length <= i) continue;
            inputPars.getTeilenummerAndMarke().add((Object)XmlDmsBestandsabfrage.fromValue(this.marken[i]));
        }
        this.XmlMessageRoot = root;
        log.debug("XML-Objekt constructed.");
    }

    public static TypeMarke fromValue(String v) {
        for (TypeMarke c : TypeMarke.values()) {
            if (!v.equalsIgnoreCase(c.value())) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }
}

