/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TeilErgebnis;
import webetk.interfaces.dms.TeilelistenPosition;
import webetk.interfaces.dms.TypeFilialabfrageRequest;
import webetk.interfaces.dms.TypeFilialabfrageResponse;
import webetk.interfaces.dms.TypeMarke;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsFilialbestand;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilFilialInfo;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilelistenPosition;

public class XmlDmsFilialabfrage
extends XmlDmsCommand {
    private ArrayList<XmlDmsTeilFilialInfo> ergebnisse = new ArrayList();

    @Override
    public void setInputParameters(String sUsername, String sFirma, String sFiliale) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        Logger.getLogger(XmlDmsFilialabfrage.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public void addPosition(XmlDmsTeilelistenPosition position) {
        TypeFilialabfrageRequest inputPars = this.XmlMessageRoot.getDmsFilialabfrage().getDmsRequest();
        TeilelistenPosition pos = new TeilelistenPosition();
        pos.setMarke(TypeMarke.fromValue(position.getMarke()));
        pos.setTeilenummer(position.getTeilenummer());
        inputPars.getPosition().add(pos);
    }

    public void clearPositionen() {
        this.XmlMessageRoot.getDmsFilialabfrage().getDmsRequest().getPosition().clear();
    }

    public int getErgebnisCount() {
        return this.ergebnisse.size();
    }

    public String getTeilenummer(int index) {
        return this.ergebnisse.get(index).getTeilenummer();
    }

    public int getErgebnisCode(int index) {
        return this.ergebnisse.get(index).getErgebniscode();
    }

    public int getFilialbestandlCount(int index) {
        return this.ergebnisse.get(index).getFilialbestaende().size();
    }

    public double getBestand(int teilIndex, int filialIndex) {
        return this.ergebnisse.get((int)teilIndex).getFilialbestand((int)filialIndex).bestand;
    }

    public String getFiliale(int teilIndex, int filialIndex) {
        return this.ergebnisse.get((int)teilIndex).getFilialbestand((int)filialIndex).filiale;
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsFilialabfrage.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsFilialabfrage() == null) {
            Logger.getLogger(XmlDmsFilialabfrage.class).error("XML-Objekt is not a DmsFilialabfrage Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFilialabfrage", "Response is not of type DmsFilialabfrage!");
        }
        if (ergebnisObjekt.getDmsFilialabfrage().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsFilialabfrage.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFilialabfrage", "XML-Stream does not contain response objekt for DmsFilialabfrage!");
        }
        TypeFilialabfrageResponse resp = ergebnisObjekt.getDmsFilialabfrage().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        for (TypeFilialabfrageResponse.FilialErgebnis filialErgebnis : resp.getFilialErgebnis()) {
            TeilErgebnis teilErgebnis = filialErgebnis.getTeilErgebnis();
            int tlErgebnisCode = -1;
            if (teilErgebnis.getErgebnisCode() != null) {
                tlErgebnisCode = teilErgebnis.getErgebnisCode().intValue();
            }
            String tlNummer = teilErgebnis.getTeilenummer();
            ArrayList<XmlDmsFilialbestand> alBestaende = new ArrayList<XmlDmsFilialbestand>();
            for (TypeFilialabfrageResponse.FilialErgebnis.FilialBestand filBestand : filialErgebnis.getFilialBestand()) {
                double bestand = 0.0;
                if (filBestand.getBestand() != null) {
                    bestand = filBestand.getBestand().doubleValue();
                }
                XmlDmsFilialbestand infoFil = new XmlDmsFilialbestand(filBestand.getFiliale(), bestand);
                alBestaende.add(infoFil);
            }
            XmlDmsTeilFilialInfo infoTeilFil = new XmlDmsTeilFilialInfo(tlNummer, tlErgebnisCode, alBestaende);
            this.ergebnisse.add(infoTeilFil);
        }
        Logger.getLogger(XmlDmsFilialabfrage.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsFilialabfrage.class).debug("Constructing XML-Objekt from input parameters for DmsFilialabfrage Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsFilialabfrage(new DmsMessage.DmsFilialabfrage());
        root.getDmsFilialabfrage().setDmsRequest(new TypeFilialabfrageRequest());
        TypeFilialabfrageRequest inputPars = root.getDmsFilialabfrage().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.getPosition().clear();
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsFilialabfrage.class).debug("XML-Objekt constructed.");
    }
}

