/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeFahrzeugidentRequest;
import webetk.interfaces.dms.TypeFahrzeugidentResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsFzgIdAuftrag
extends XmlDmsCommand {
    private String auftragsnummer;
    private int kundennummer;
    private String kundenname;
    private String fahrgestellnummer;
    private String marke;
    private static Logger log = Logger.getLogger(XmlDmsFzgIdAuftrag.class);

    public String getAuftragsnummer() {
        return this.auftragsnummer;
    }

    public int getKundennummer() {
        return this.kundennummer;
    }

    public String getKundenname() {
        return this.kundenname;
    }

    public String getFahrgestellnummer() {
        return this.fahrgestellnummer;
    }

    public String getMarke() {
        return this.marke;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sAuftragsnummer) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.auftragsnummer = sAuftragsnummer;
        if (this.auftragsnummer == null || this.auftragsnummer.length() == 0) {
            Logger.getLogger(XmlDmsFzgIdAuftrag.class).error("Auftragsnummer is not defined!");
            throw new IllegalArgumentException("Die Auftragsnummer ist nicht definiert!");
        }
        Logger.getLogger(XmlDmsFzgIdAuftrag.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    public void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        log.debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsFzgIdAuftrag() == null) {
            log.error("XML-Objekt is not a DmsFzgIdAuftrag Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFzgIdAuftrag", "Response is not of type DmsFzgIdAuftrag!");
        }
        if (ergebnisObjekt.getDmsFzgIdAuftrag().getDmsResponse() == null) {
            log.error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFzgIdAuftrag", "XML-Stream does not contain response objekt for DmsFzgIdAuftrag!");
        }
        try {
            TypeFahrzeugidentResponse resp = ergebnisObjekt.getDmsFzgIdAuftrag().getDmsResponse();
            this.ergebnisCode = resp.getErgebnisCode().intValue();
            this.meldungstext = resp.getMessageText();
            this.auftragsnummer = resp.getAuftragsnummer();
            this.kundennummer = resp.getKundennummer() != null ? resp.getKundennummer().intValue() : -1;
            this.kundenname = resp.getKundenname();
            this.fahrgestellnummer = resp.getFahrgestellnummer();
            if (resp.getMarke() != null) {
                this.marke = resp.getMarke().value();
            }
        }
        catch (Exception e) {
            log.error("Common DMS Error", e);
            throw new XmlParseException("DmsFzgIdAuftrag", "Common DMS Error");
        }
        log.debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsFzgIdAuftrag.class).debug("Constructing XML-Objekt from input parameters for DmsFzgIdAuftrag Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsFzgIdAuftrag(new DmsMessage.DmsFzgIdAuftrag());
        root.getDmsFzgIdAuftrag().setDmsRequest(new TypeFahrzeugidentRequest());
        TypeFahrzeugidentRequest inputPars = root.getDmsFzgIdAuftrag().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setAuftragsnummer(this.auftragsnummer);
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsFzgIdAuftrag.class).debug("XML-Objekt constructed.");
    }
}

