/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeDmsAusfuehrungsart;
import webetk.interfaces.dms.TypeInitRequest;
import webetk.interfaces.dms.TypeInitResponse;
import webetk.interfaces.dms.TypeMehrwertsteuerSatz;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsMwst;

public class XmlDmsInit
extends XmlDmsCommand {
    private String password;
    private String postleitzahl;
    private String strasse;
    private String ort;
    private String telefon;
    private String nummerPKW;
    private String nummerKrad;
    private int barverkaufsNummer;
    private Double atSteuer;
    private int nachkommaStellen;
    private boolean indikatorSatzAusfuehrung;
    private String marke;
    public ArrayList<XmlDmsMwst> aMwstSaetze = new ArrayList();

    public String getPostleitzahl() {
        return this.postleitzahl;
    }

    public String getStrasse() {
        return this.strasse;
    }

    public String getOrt() {
        return this.ort;
    }

    public String getTelefon() {
        return this.telefon;
    }

    public String getNummerPKW() {
        return this.nummerPKW;
    }

    public String getNummerKrad() {
        return this.nummerKrad;
    }

    public int getBarverkaufsNummer() {
        return this.barverkaufsNummer;
    }

    public Double getAtSteuer() {
        return this.atSteuer;
    }

    public int getNachkommaStellen() {
        return this.nachkommaStellen;
    }

    public boolean getIndikatorSatzAusfuehrung() {
        return this.indikatorSatzAusfuehrung;
    }

    public String getMarke() {
        return this.marke;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sPassword) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.password = sPassword;
        Logger.getLogger(XmlDmsInit.class).info("Defining input: (" + this.username + ", " + this.firma + ", " + this.filiale + ", " + this.password + ")");
        if (sUsername == null || sFirma == null || sFiliale == null || sPassword == null || sUsername.length() == 0 || sFirma.length() == 0 || sFiliale.length() == 0) {
            throw new IllegalArgumentException("Mandatory argument is null or empty!");
        }
        Logger.getLogger(XmlDmsInit.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public int getMwstCount() {
        return this.aMwstSaetze.size();
    }

    public XmlDmsMwst getMwst(int index) throws IndexOutOfBoundsException {
        return this.aMwstSaetze.get(index);
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsInit.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsInit() == null) {
            Logger.getLogger(XmlDmsInit.class).error("XML-Objekt is not a DmsInit Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsInit", "Response is not of type DmsInit!");
        }
        if (ergebnisObjekt.getDmsInit().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsInit.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsInit", "XML-Stream does not contain response objekt for DmsInit!");
        }
        TypeInitResponse resp = ergebnisObjekt.getDmsInit().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.firma = resp.getFirma();
        this.postleitzahl = resp.getPLZ();
        this.strasse = resp.getStrasse();
        this.ort = resp.getOrt();
        this.telefon = resp.getTelefon();
        this.nummerPKW = resp.getHaendlernummerPkw();
        this.nummerKrad = resp.getHaendlernummerKrad();
        this.barverkaufsNummer = resp.getKundennummerBarverkauf().intValue();
        this.atSteuer = resp.getATSteuer() != null ? new Double(resp.getATSteuer().doubleValue()) : null;
        this.nachkommaStellen = resp.getNachkommastellen().intValue();
        if (resp.getAusfuehrungsart() != null) {
            this.indikatorSatzAusfuehrung = resp.getAusfuehrungsart().equals((Object)TypeDmsAusfuehrungsart.SATZ);
        }
        this.marke = resp.getMarke().value();
        this.aMwstSaetze.clear();
        for (TypeMehrwertsteuerSatz xmlMwst : resp.getMehrwertsteuer()) {
            XmlDmsMwst mwst = new XmlDmsMwst(xmlMwst.getMwstId(), xmlMwst.getSteuersatz().doubleValue());
            this.aMwstSaetze.add(mwst);
        }
        Logger.getLogger(XmlDmsInit.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsInit.class).debug("Constructing XML-Objekt from input parameters for DmsInit Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsInit(new DmsMessage.DmsInit());
        root.getDmsInit().setDmsRequest(new TypeInitRequest());
        TypeInitRequest inputPars = root.getDmsInit().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setPassword(this.password);
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsInit.class).debug("XML-Objekt constructed.");
    }
}

