/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.util.Date;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeTeileinfoRequest;
import webetk.interfaces.dms.TypeTeileinfoResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsTeileinfo
extends XmlDmsCommand {
    protected String teilenummer;
    protected String marke;
    private String teilebezeichnung;
    private double haendlerpreis;
    private Date preisaenderungsdatum;
    private String kodierungsstufe;
    private String lagerort;
    private Double lagerbestand;
    private Double mindestbestand;
    private Double mehrwertsteuer;
    private Double sondersteuer;
    private static Logger log = Logger.getLogger(XmlDmsTeileinfo.class);

    public String getTeilenummer() {
        return this.teilenummer;
    }

    public String getTeilebezeichnung() {
        return this.teilebezeichnung;
    }

    public double getHaendlerpreis() {
        return this.haendlerpreis;
    }

    public Date getPreisaenderungsdatum() {
        return this.preisaenderungsdatum;
    }

    public String getKodierungsstufe() {
        return this.kodierungsstufe;
    }

    public String getLagerort() {
        return this.lagerort;
    }

    public Double getLagerbestand() {
        return this.lagerbestand;
    }

    public Double getMindestbestand() {
        return this.mindestbestand;
    }

    public Double getMehrwertsteuer() {
        return this.mehrwertsteuer;
    }

    public Double getSondersteuer() {
        return this.sondersteuer;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String nTeilenummer, String sMarke) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.teilenummer = nTeilenummer;
        this.marke = sMarke;
        if (this.teilenummer == null || this.teilenummer.length() < 1 || this.teilenummer.length() > 11) {
            log.error("Teilenummer is not defined!");
            throw new IllegalArgumentException("Teilenummer ist nicht definiert!");
        }
        if (this.marke == null || this.marke.length() == 0) {
            log.error("Marke is not defined!");
            throw new IllegalArgumentException("Marke ist nicht definiert!");
        }
        log.debug("Input seems to be in order.");
        log.debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        log.debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsTeileInfo() == null) {
            log.error("XML-Objekt is not a DmsTeileInfo Element: " + ergebnisObjekt);
            throw new XmlParseException("XmlDmsTeileinfo", "Response is not of type DmsTeileInfo!");
        }
        if (ergebnisObjekt.getDmsTeileInfo().getDmsResponse() == null) {
            log.error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsTeileInfo", "XML-Stream does not contain response objekt for DmsTeileInfo!");
        }
        TypeTeileinfoResponse resp = ergebnisObjekt.getDmsTeileInfo().getDmsResponse();
        this.ergebnisCode = 0;
        if (resp.getErgebnisCode() != null) {
            this.ergebnisCode = resp.getErgebnisCode().intValue();
        }
        try {
            this.meldungstext = resp.getMessageText();
            this.teilenummer = resp.getTeilenummer();
            this.teilebezeichnung = resp.getBezeichnung();
            this.haendlerpreis = 0.0;
            if (resp.getHaendlerpreis() != null) {
                this.haendlerpreis = resp.getHaendlerpreis().doubleValue();
            }
            if (resp.getPreisaenderungsdatum() != null) {
                this.preisaenderungsdatum = resp.getPreisaenderungsdatum().toGregorianCalendar().getTime();
            }
            if (resp.getKodierungsstufe() != null) {
                this.kodierungsstufe = resp.getKodierungsstufe();
            }
            this.lagerort = "";
            if (resp.getLagerort() != null) {
                this.lagerort = resp.getLagerort();
            }
            this.lagerbestand = resp.getLagerbestand() != null ? new Double(resp.getLagerbestand().doubleValue()) : null;
            this.mindestbestand = resp.getMindestbestand() != null ? new Double(resp.getMindestbestand().doubleValue()) : null;
            this.mehrwertsteuer = resp.getMehrwertsteuer() != null ? new Double(resp.getMehrwertsteuer().doubleValue()) : null;
            this.sondersteuer = resp.getSondersteuer() != null ? new Double(resp.getSondersteuer().doubleValue()) : null;
            log.debug("Information has been extracted.");
        }
        catch (Exception e) {
            log.error("Not all values are set!", e);
            throw new XmlParseException("DmsTeileInfo", "Not all values are set!");
        }
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        log.debug("Constructing XML-Objekt from input parameters for DmsTeileinfo Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsTeileInfo(new DmsMessage.DmsTeileInfo());
        root.getDmsTeileInfo().setDmsRequest(new TypeTeileinfoRequest());
        TypeTeileinfoRequest inputPars = root.getDmsTeileInfo().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setTeilenummer(this.teilenummer);
        inputPars.setMarke(TypeMarke.fromValue(this.marke));
        this.XmlMessageRoot = root;
        log.debug("XML-Objekt constructed.");
    }
}

