/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup;
    private Renderable renderer;
    private boolean hasOverflowed;
    private Integer imageHeight;
    private Integer imageWidth;
    private Integer imageX;
    private String anchorName;
    private String hyperlinkReference;
    private Boolean hyperlinkWhen;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected final JRLineBox initLineBox;
    protected JRLineBox lineBox;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, image, factory);
        this.initLineBox = image.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super(image, factory);
        this.initLineBox = image.getLineBox().clone(this);
        this.evaluationGroup = image.evaluationGroup;
    }

    @Override
    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        this.lineBox = null;
        if (this.providerStyle != null) {
            this.lineBox = this.initLineBox.clone(this);
            JRStyleResolver.appendBox(this.lineBox, this.providerStyle.getLineBox());
        }
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return JRStyleResolver.getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.providerStyle == null || this.providerStyle.getOwnScaleImageValue() == null ? ((JRImage)this.parent).getOwnScaleImageValue() : this.providerStyle.getOwnScaleImageValue();
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.providerStyle == null || this.providerStyle.getOwnHorizontalAlignmentValue() == null ? ((JRImage)this.parent).getOwnHorizontalAlignmentValue() : this.providerStyle.getOwnHorizontalAlignmentValue();
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.providerStyle == null || this.providerStyle.getOwnVerticalAlignmentValue() == null ? ((JRImage)this.parent).getOwnVerticalAlignmentValue() : this.providerStyle.getOwnVerticalAlignmentValue();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    @Override
    public Boolean getUsingCache() {
        return ((JRImage)this.parent).getUsingCache();
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    @Override
    public void setLazy(boolean isLazy) {
    }

    @Override
    public OnErrorTypeEnum getOnErrorTypeValue() {
        return ((JRImage)this.parent).getOnErrorTypeValue();
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRImage)this.parent).getEvaluationTimeValue();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox == null ? this.initLineBox : this.lineBox;
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRImage)this.parent).getHyperlinkTypeValue();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    @Override
    public String getLinkTarget() {
        return ((JRImage)this.parent).getLinkTarget();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return ((JRImage)this.parent).getHyperlinkWhenExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected Renderable getRenderable() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        JRTemplateImage template = new JRTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_HEIGHT || this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            template.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        }
        return template;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.hasOverflowed = false;
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.evaluateStyle(evaluation);
        JRExpression expression = this.getExpression();
        Renderable newRenderer = null;
        Object source = this.evaluateExpression(expression, evaluation);
        if (source != null) {
            Boolean isUsingCache = this.getUsingCache();
            if (isUsingCache == null) {
                isUsingCache = source instanceof String;
            }
            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedImage(source)) {
                newRenderer = this.filler.fillContext.getLoadedImage(source).getRenderable();
            } else {
                Object img;
                JRRenderable deprecatedRenderable;
                JRRenderable jRRenderable = deprecatedRenderable = source instanceof JRRenderable ? (JRRenderable)source : null;
                if (source instanceof Image) {
                    img = (Image)source;
                    newRenderer = RenderableUtil.getInstance(this.filler.getJasperReportsContext()).getRenderable((Image)img, this.getOnErrorTypeValue());
                } else if (source instanceof InputStream) {
                    InputStream is = (InputStream)source;
                    newRenderer = RenderableUtil.getInstance(this.filler.getJasperReportsContext()).getRenderable(is, this.getOnErrorTypeValue());
                } else if (source instanceof URL) {
                    URL url = (URL)source;
                    newRenderer = RenderableUtil.getInstance(this.filler.getJasperReportsContext()).getRenderable(url, this.getOnErrorTypeValue());
                } else if (source instanceof File) {
                    File file = (File)source;
                    newRenderer = RenderableUtil.getInstance(this.filler.getJasperReportsContext()).getRenderable(file, this.getOnErrorTypeValue());
                } else if (source instanceof String) {
                    String location = (String)source;
                    newRenderer = RenderableUtil.getInstance(this.filler.getJasperReportsContext()).getRenderable(location, this.getOnErrorTypeValue(), this.isLazy());
                } else {
                    Renderable wrappingRenderable;
                    newRenderer = source instanceof Renderable ? (Renderable)source : (deprecatedRenderable != null ? (wrappingRenderable = RenderableUtil.getWrappingRenderable(deprecatedRenderable)) : JRImageRenderer.getOnErrorRenderer(this.getOnErrorTypeValue(), new JRException("Unknown image source class " + source.getClass().getName())));
                }
                if (isUsingCache.booleanValue()) {
                    img = new JRTemplatePrintImage(this.getJRTemplateImage(), this.printElementOriginator);
                    img.setRenderable(newRenderer);
                    this.filler.fillContext.registerLoadedImage(source, (JRPrintImage)img);
                }
            }
        }
        this.setValueRepeating(this.renderer == newRenderer);
        this.renderer = newRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkWhen = (Boolean)this.evaluateExpression(this.getHyperlinkWhenExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderable() == null) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight < this.getRelativeY() + this.getHeight()) {
                    isToPrint = false;
                    willOverflow = true;
                } else if (!(this.isLazy() || this.getScaleImageValue() != ScaleImageEnum.REAL_HEIGHT && this.getScaleImageValue() != ScaleImageEnum.REAL_SIZE)) {
                    int padding = this.getLineBox().getBottomPadding() + this.getLineBox().getTopPadding();
                    boolean reprinted = isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues());
                    boolean imageOverflowAllowed = this.filler.isBandOverFlowAllowed() && !reprinted && !this.hasOverflowed;
                    boolean fits = this.fitImage(availableHeight - this.getRelativeY() - padding, imageOverflowAllowed, this.getHorizontalAlignmentValue());
                    if (fits) {
                        if (this.imageHeight != null) {
                            this.setStretchHeight(this.imageHeight + padding);
                        }
                    } else {
                        this.hasOverflowed = true;
                        isToPrint = false;
                        willOverflow = true;
                        this.setStretchHeight(availableHeight - this.getRelativeY() - padding);
                    }
                }
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected void reset() {
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        super.reset();
    }

    protected boolean fitImage(int availableHeight, boolean overflowAllowed, HorizontalAlignEnum hAlign) throws JRException {
        boolean fitted;
        Dimension2D imageSize;
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageX = null;
        Dimension2D dimension2D = imageSize = this.renderer == null ? null : this.renderer.getDimension(this.filler.getJasperReportsContext());
        if (imageSize == null) {
            return true;
        }
        int realHeight = (int)imageSize.getHeight();
        int realWidth = (int)imageSize.getWidth();
        int reducedHeight = realHeight;
        int reducedWidth = realWidth;
        if (realWidth > this.getWidth()) {
            double wRatio = (double)this.getWidth() / (double)realWidth;
            reducedHeight = (int)(wRatio * (double)realHeight);
            reducedWidth = this.getWidth();
        }
        if (reducedHeight <= availableHeight) {
            this.imageHeight = reducedHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                this.imageWidth = reducedWidth;
            }
            fitted = true;
        } else if (overflowAllowed) {
            fitted = false;
        } else {
            this.imageHeight = availableHeight;
            if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
                double hRatio = (double)availableHeight / (double)realHeight;
                this.imageWidth = (int)(hRatio * (double)realWidth);
            }
            fitted = true;
        }
        if (this.imageWidth != null && this.imageWidth.intValue() != this.getWidth()) {
            switch (hAlign) {
                case RIGHT: {
                    this.imageX = this.getX() + this.getWidth() - this.imageWidth;
                    break;
                }
                case CENTER: {
                    this.imageX = this.getX() + (this.getWidth() - this.imageWidth) / 2;
                    break;
                }
            }
        }
        return fitted;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (this.isEvaluateAuto()) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage(), this.printElementOriginator);
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage(), this.printElementOriginator);
            recordedValuesImage = null;
        }
        printImage.setUUID(this.getUUID());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        if (this.isEvaluateNow()) {
            this.copy(printImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setUUID(this.getUUID());
        if (this.imageX != null) {
            printImage.setX(this.imageX);
        }
        if (this.imageWidth != null) {
            printImage.setWidth(this.imageWidth);
        }
        printImage.setRenderable(this.getRenderable());
        printImage.setAnchorName(this.getAnchorName());
        if (this.getHyperlinkWhenExpression() == null || this.hyperlinkWhen == Boolean.TRUE) {
            printImage.setHyperlinkReference(this.getHyperlinkReference());
        } else {
            printImage.setHyperlinkReference(null);
        }
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(printImage);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        JRPrintImage printImage = (JRPrintImage)element;
        if (this.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            int padding = printImage.getLineBox().getBottomPadding() + printImage.getLineBox().getTopPadding();
            this.fitImage(this.getHeight() - padding, false, printImage.getHorizontalAlignmentValue());
        }
        this.copy(printImage);
        this.filler.getFillContext().updateBookmark(element);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    @Override
    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkWhenExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

