/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.standalone;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import webetk.install.lookandfeel.WebETKTheme;
import webetk.install.resources.Resource;
import webetk.install.standalone.DummyFrame;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LimitedTextField;

public class AskProperties
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int BLOCKSIZE = 64000;
    private static Logger log = null;
    private Container mContentPane;
    private JButton mButtonUebernehmen;
    private JLabel mZeile1;
    private JLabel mNameUrlDmsServer;
    private JLabel mCommentUrlDmsServer;
    private JTextField mtfUrlDmsServer;
    private JCheckBox mChkUSFile;
    private JLabel mNameUSFile;
    private JLabel mCommentUSFile;
    private JTextField mtfUSFile;
    private String msDefaultUSFile;
    private String mszServerPropertyFile;
    private String mszBmwetkFile;
    private String mszServerJarFile;
    private String mszVersionFile;
    private String mszClientPropertyFile;
    private String mszAdminToolPropertyFile;
    private String mszMigrationPropertyFile;
    private String mszClientInstallPath;
    private String mszSrcDir;
    private String mszTargetDir;
    private boolean mbIsStandalone;

    public AskProperties(boolean bIsStandalone, String szTargetDir, String szSrcDir) {
        super(DummyFrame.getInstance());
        log.info(" *** AskProperties Parameter bIsStandalone: " + bIsStandalone + " *** ");
        log.info(" *** AskProperties Parameter szTargetDir: " + szTargetDir + " *** ");
        log.info(" *** AskProperties Parameter szSrcDir: " + szSrcDir + " *** ");
        this.mbIsStandalone = bIsStandalone;
        this.mszSrcDir = szSrcDir;
        this.mszTargetDir = szTargetDir;
        if (this.mbIsStandalone) {
            this.mbIsStandalone = true;
            this.mszServerPropertyFile = szTargetDir + "\\javaclient\\tomcat\\webapps\\WEB-INF\\javaclient.properties";
            this.mszBmwetkFile = szTargetDir + "\\javaclient\\tomcat\\webapps\\WEB-INF\\bmwetk.properties";
            this.mszAdminToolPropertyFile = szTargetDir + "\\admintool\\admintool.properties";
            this.mszMigrationPropertyFile = szTargetDir + "\\migration\\migration.properties";
            this.mszClientPropertyFile = szTargetDir + "\\javaclient\\classes\\javaclient.properties";
            this.mszServerJarFile = szTargetDir + "\\javaclient\\tomcat\\webapps\\javaserver.war";
            this.mszVersionFile = szTargetDir + "\\javaclient\\tomcat\\webapps\\WEB-INF\\version.txt";
            this.mszClientInstallPath = null;
        } else {
            this.mbIsStandalone = false;
            this.mszClientPropertyFile = szTargetDir + "\\javaclient.properties";
            this.mszClientInstallPath = this.mszSrcDir + "\\setup.exe";
            log.info(" *** mszClientInstallPath from setup: >" + this.mszClientInstallPath + "< *** ");
            if (this.mszClientInstallPath.substring(0, 1).matches("[A-Z]|[a-z]") && this.mszClientInstallPath.indexOf(":") == 1) {
                log.info(" *** mszClientInstallPath from setup mit Laufwerksbuchstaben - keine Anpassung notwendig *** ");
            } else {
                this.mszClientInstallPath = "\\" + this.mszClientInstallPath;
                log.info(" *** mszClientInstallPath from setup ohne Laufwerksbuchstaben/UNC Pfad - Anpassung notwendig: >" + this.mszClientInstallPath + "< *** ");
            }
            this.mszServerPropertyFile = null;
            this.mszBmwetkFile = null;
            this.mszAdminToolPropertyFile = null;
            this.mszMigrationPropertyFile = null;
            this.mszServerJarFile = null;
            this.mszVersionFile = null;
        }
        this.setModal(true);
        this.setSize(620, 420);
        this.initComponents();
    }

    public static void main(String[] args) throws Exception {
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sBuf.append(args[i]);
            sBuf.append("\n");
        }
        PatternLayout pl = new PatternLayout("%d: %m:  %l " + System.getProperty("line.separator"));
        File tempDir = new File(System.getProperty("user.dir") + File.separator + "tempAskProperties");
        boolean bmkDir = tempDir.exists();
        if (!bmkDir) {
            bmkDir = tempDir.mkdir();
        }
        if (bmkDir) {
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)pl, System.getProperty("user.dir") + File.separator + "tempAskProperties" + File.separator + "AskProperties.log");
            fileAppender.setMaxBackupIndex(1);
            fileAppender.setMaximumFileSize(1000000L);
            fileAppender.setThreshold(Priority.INFO);
            log = Logger.getLogger(AskProperties.class);
            log.addAppender(fileAppender);
        }
        if (log != null) {
            log.info("*** webetk.install.standalone.AskProperties started with following arguments: " + sBuf);
        }
        if (args.length != 4) {
            System.out.println("Usage: AskProperties LangISO client/standalone Targetdir Srcdir");
            System.exit(0);
        }
        MetalLookAndFeel.setCurrentTheme(new WebETKTheme());
        BasicConfigurator.configure();
        Resource.setLanguage(args[0]);
        WebETKTheme.changeFont(args[0].substring(0, 2));
        boolean bIsStandalone = args[1].equals("standalone");
        AskProperties dlg = new AskProperties(bIsStandalone, args[2], args[3]);
        dlg.setVisible(true);
        System.exit(0);
    }

    private void initComponents() {
        this.setTitle(Resource.getInstance().getEigenschaften());
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mZeile1 = new JLabel(Resource.getInstance().getWerteFuerEigenschaftenAngeben());
        this.mNameUrlDmsServer = new JLabel("xmldms.serverurl");
        this.mCommentUrlDmsServer = new JLabel(Resource.getInstance().getDmsServerUrl());
        this.mtfUrlDmsServer = new LimitedTextField(256, 60);
        this.mNameUSFile = new JLabel("usdealer.filename");
        this.mCommentUSFile = new JLabel(Resource.getInstance().getUSFile());
        this.mtfUSFile = new LimitedTextField(256, 60);
        this.mChkUSFile = new JCheckBox(Resource.getInstance().getUsFileVerwenden());
        this.mChkUSFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AskProperties.this.mChkUSFile.isSelected()) {
                    AskProperties.this.mtfUSFile.setText("");
                    AskProperties.this.mtfUSFile.setEnabled(false);
                    AskProperties.this.mtfUSFile.setEditable(false);
                } else {
                    AskProperties.this.mtfUSFile.setEnabled(true);
                    AskProperties.this.mtfUSFile.setEditable(true);
                    AskProperties.this.mtfUSFile.setText(AskProperties.this.msDefaultUSFile);
                }
            }
        });
        this.loadProperties();
        this.layoutAll();
    }

    private void layoutAll() {
        this.mContentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContentPane.setLayout(l);
        JPanel content = this.createContent();
        this.mContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{5, 0};
        int[] heights = new int[]{10, 0, 1, 0, 1};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{5, 0, 10, 0, 380, 0, 10};
        int[] heights = null;
        heights = this.mszServerPropertyFile != null ? new int[]{10, 0, 10, 0, 5, 0, 10, 0, 5, 0, 15, 0, 2, 0, 5, 0, 5} : new int[]{10, 0, 15, 0, 2, 0, 5, 0, 15, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        if (this.mszServerPropertyFile != null) {
            panel.add((Component)this.mZeile1, c.rcwh(2, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mCommentUrlDmsServer, c.rcwh(4, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mNameUrlDmsServer, c.rc(6, 2, "l"));
            panel.add((Component)this.mtfUrlDmsServer, c.rcwh(6, 4, 3, 1, "tlbr"));
            panel.add((Component)this.mChkUSFile, c.rcwh(12, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mCommentUSFile, c.rcwh(14, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mNameUSFile, c.rc(16, 2, "l"));
            panel.add((Component)this.mtfUSFile, c.rcwh(16, 4, 3, 1, "tlbr"));
        } else {
            panel.add((Component)this.mZeile1, c.rcwh(2, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mChkUSFile, c.rcwh(4, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mCommentUSFile, c.rcwh(6, 2, 6, 1, "tlbr"));
            panel.add((Component)this.mNameUSFile, c.rc(8, 2, "l"));
            panel.add((Component)this.mtfUSFile, c.rcwh(8, 4, 3, 1, "tlbr"));
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-3, 0, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(3, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.saveProperties();
                AskProperties.this.dispose();
            }
        });
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Properties oProperties;
        FileInputStream in;
        if (this.mszServerPropertyFile != null) {
            in = null;
            try {
                oProperties = new Properties();
                in = new FileInputStream(this.mszServerPropertyFile);
                oProperties.load(in);
                this.mtfUrlDmsServer.setText(oProperties.getProperty("xmldms.serverurl"));
                System.out.println("Loaded Server-Properties from file" + this.mszServerPropertyFile);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        in = null;
        try {
            oProperties = new Properties();
            in = new FileInputStream(this.mszClientPropertyFile);
            oProperties.load(in);
            this.msDefaultUSFile = oProperties.getProperty("usdealer.filename.default");
            String sUSFile = oProperties.getProperty("usdealer.filename");
            if (sUSFile == null || sUSFile.length() < 1) {
                this.mChkUSFile.setSelected(false);
                this.mtfUSFile.setEnabled(false);
                this.mtfUSFile.setEditable(false);
                this.mtfUSFile.setText("");
            } else {
                this.mChkUSFile.setSelected(true);
                this.mtfUSFile.setEnabled(true);
                this.mtfUSFile.setEditable(true);
                this.mtfUSFile.setText(sUSFile);
            }
            System.out.println("Loaded Client-Properties from file" + this.mszClientPropertyFile);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void saveProperties() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.mbIsStandalone) {
            this.saveServerProperties();
            this.saveBmwEtkProperties();
            this.updateJarFile();
        }
        this.saveClientProperties();
        if (this.mszAdminToolPropertyFile != null) {
            this.saveAdmintoolProperties();
        }
        if (this.mszMigrationPropertyFile != null) {
            this.saveMigrationProperties();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveBmwEtkProperties() {
        try {
            String szVersion = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszVersionFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("Version.Programme=") == 0) {
                    szVersion = szLine.substring(18);
                }
                szLine = in.readLine();
            }
            in.close();
            boolean bBTMailFound = false;
            Vector<String> aszZeilen = new Vector<String>();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszBmwetkFile)));
            szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("application.version = ") == 0) {
                    szLine = "application.version = " + szVersion;
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            if (!bBTMailFound) {
                szLine = "# The name for the attachment to the mail that contains the Diagram";
                aszZeilen.add(szLine);
                szLine = "mail.AttachmentName.Diagram = Diagram";
                aszZeilen.add(szLine);
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszBmwetkFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void saveServerProperties() {
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszServerPropertyFile)));
            boolean bFoundTicker = false;
            boolean bFoundSowu = false;
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("xmldms.serverurl") == 0) {
                    szLine = "xmldms.serverurl=" + this.mtfUrlDmsServer.getText();
                } else if (szLine.indexOf("ticker.dir =") == 0) {
                    bFoundTicker = true;
                } else if (szLine.indexOf("sowu.connection =") == 0) {
                    bFoundSowu = true;
                    if (szLine.indexOf("sowu.connection = 0") == 0) {
                        szLine = "sowu.connection = 1";
                    }
                }
                if (szLine.indexOf("#TARGETDIR#") >= 0) {
                    szLine = AskProperties.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                }
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            if (!bFoundTicker) {
                szLine = "# Directory for Ticker texts";
                aszZeilen.add(szLine);
                szLine = "ticker.dir = #TARGETDIR#\\ticker";
                szLine = AskProperties.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
            }
            if (!bFoundSowu) {
                szLine = "# connection to SOWU (0 AUTO or 1)";
                aszZeilen.add(szLine);
                szLine = "sowu.connection = 1";
                aszZeilen.add(szLine);
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszServerPropertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void saveClientProperties() {
        try {
            boolean bClientInstallPathGeschrieben = false;
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszClientPropertyFile)));
            String szLine = in.readLine();
            boolean bFoundPortPool = false;
            boolean bFoundTimeouts = false;
            boolean bFoundRrSap = false;
            while (szLine != null) {
                if (szLine.indexOf("usdealer.filename") == 0 && szLine.indexOf("usdealer.filename.") < 0) {
                    String szValue = this.mtfUSFile.getText();
                    szValue = szValue == null ? "" : szValue.trim();
                    szLine = "usdealer.filename=" + szValue;
                } else if (szLine.indexOf("keyreader.filename") == 0 && szLine.indexOf("keyreader.filename.") < 0) {
                    szLine = "keyreader.filename=";
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                } else if (szLine.indexOf("standalone") == 0) {
                    if (this.mszAdminToolPropertyFile != null) {
                        szLine = "standalone=1";
                    }
                } else if (szLine.indexOf("setup.path") == 0 && this.mszClientInstallPath != null) {
                    szLine = "setup.path = " + this.mszClientInstallPath;
                    bClientInstallPathGeschrieben = true;
                } else if (szLine.indexOf("# Bereich aus denen der Client und das ASAP-Applet die Ports fuer ihre Kommunikation suchen") == 0) {
                    bFoundPortPool = true;
                } else if (szLine.indexOf("# Timeouts (in seconds)") == 0) {
                    bFoundTimeouts = true;
                } else if (szLine.indexOf("# SAP Communication for RR") == 0) {
                    bFoundRrSap = true;
                }
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            if (!bFoundPortPool) {
                szLine = "# Bereich aus denen der Client und das ASAP-Applet die Ports fuer ihre Kommunikation suchen";
                aszZeilen.add(szLine);
                szLine = "# asap.port.from=4101";
                aszZeilen.add(szLine);
                szLine = "# asap.port.to=4199";
                aszZeilen.add(szLine);
            }
            if (!bFoundTimeouts) {
                szLine = "# Timeouts (in seconds)";
                aszZeilen.add(szLine);
                szLine = "# waiting for connection";
                aszZeilen.add(szLine);
                szLine = "timeout.connection = 60";
                aszZeilen.add(szLine);
                szLine = "# waiting for Data";
                aszZeilen.add(szLine);
                szLine = "timeout.socket = 600";
                aszZeilen.add(szLine);
            }
            if (!bFoundRrSap) {
                szLine = "# SAP Communication for RR";
                aszZeilen.add(szLine);
                szLine = "# maximum number of parts in a list for which a SAP communication is allowed";
                aszZeilen.add(szLine);
                szLine = "rrsap.maxparts = 250";
                aszZeilen.add(szLine);
                szLine = "# Number of times the wait dialog asks the server for a reply";
                aszZeilen.add(szLine);
                szLine = "rrsap.wait.steps = 20";
                aszZeilen.add(szLine);
                szLine = "# time in ms the wait dialog waits before asking again for a reply";
                aszZeilen.add(szLine);
                szLine = "rrsap.wait.time = 2000";
                aszZeilen.add(szLine);
            }
            if (!bClientInstallPathGeschrieben && this.mszClientInstallPath != null) {
                szLine = "setup.path = " + this.mszClientInstallPath;
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszClientPropertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void saveAdmintoolProperties() {
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszAdminToolPropertyFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("standalone") == 0) {
                    szLine = "standalone=1";
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                } else if (szLine.indexOf("device") == 0) {
                    String szPath = this.mszSrcDir;
                    szLine = "device=" + szPath;
                    if ((szLine = AskProperties.maskBackSlash(szLine)).endsWith("\\\\")) {
                        szLine = szLine.substring(0, szLine.length() - 2);
                    }
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszAdminToolPropertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void saveMigrationProperties() {
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszMigrationPropertyFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("standalone") == 0) {
                    szLine = "standalone=1";
                } else if (szLine.indexOf("language") == 0) {
                    szLine = "language=" + Resource.getInstance().getLanguage();
                } else if (szLine.indexOf("device") == 0) {
                    String szPath = this.mszSrcDir;
                    szLine = "device=" + szPath;
                    szLine = AskProperties.maskBackSlash(szLine);
                } else if (szLine.indexOf("xmldms.serverurl") == 0) {
                    szLine = "xmldms.serverurl=" + this.mtfUrlDmsServer.getText();
                    szLine = AskProperties.maskBackSlash(szLine);
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszMigrationPropertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void updateJarFile() {
        block12: {
            try {
                JarFile jarFile = new JarFile(this.mszServerJarFile);
                JarOutputStream output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.mszServerJarFile + "_out.war")));
                if (log != null) {
                    log.info("--> new from 2.0.39 allways new jarentry to avoid zipexception");
                }
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = new JarEntry(jarEntries.nextElement().getName());
                    InputStream input = null;
                    boolean change = false;
                    if (entry.getName().equals("WEB-INF/javaclient.properties")) {
                        input = new FileInputStream(this.mszServerPropertyFile);
                        change = true;
                    } else if (entry.getName().equals("WEB-INF/bmwetk.properties")) {
                        input = new FileInputStream(this.mszBmwetkFile);
                        change = true;
                    } else if (entry.getName().equals("WEB-INF/version.txt")) {
                        input = new FileInputStream(this.mszVersionFile);
                        change = true;
                    } else {
                        input = jarFile.getInputStream(entry);
                    }
                    AskProperties.updateJarEntry(entry, output, new BufferedInputStream(input), change, this, log);
                }
                output.close();
                jarFile.close();
                File jarold = new File(this.mszServerJarFile);
                File jarnew = new File(this.mszServerJarFile + "_out.war");
                boolean bRet = jarold.delete();
                if (!bRet && log != null) {
                    log.error("*** error while deleting old jar file ***" + jarold.getAbsolutePath());
                }
                if (!(bRet = jarnew.renameTo(jarold)) && log != null) {
                    log.error("*** error while renaming new jar file ***" + jarnew.getAbsolutePath() + " -> " + jarold.getAbsolutePath());
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "*** error while updating jar file *** \n" + e.getMessage() + "\n" + e.getStackTrace(), "AskProperties.updateJarFile()", 1);
                if (log == null) break block12;
                log.error("*** error while updating jar file ***", e);
            }
        }
    }

    public static void updateJarEntry(JarEntry jarentry, JarOutputStream jarout, BufferedInputStream input, boolean change, JDialog thisDialog, Logger plog) {
        try {
            if (change) {
                jarentry.setMethod(0);
            }
            byte[] buffer = new byte[64000];
            int nread = 0;
            input.mark(999999999);
            int size = 0;
            while ((nread = input.read(buffer, 0, buffer.length)) != -1) {
                size += nread;
            }
            jarentry.setSize(size);
            if (change) {
                jarentry.setCompressedSize(size);
            }
            input.reset();
            buffer = size == 0 ? new byte[1] : new byte[size];
            nread = 0;
            while ((nread = input.read(buffer, 0, buffer.length)) != -1) {
                if (change && size > 0) {
                    CRC32 crc = new CRC32();
                    crc.update(buffer);
                    jarentry.setCrc(crc.getValue());
                }
                jarout.putNextEntry(jarentry);
                if (size <= 0) continue;
                jarout.write(buffer, 0, nread);
            }
            jarout.closeEntry();
            input.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(thisDialog, "Konnte Eintrags im Jar-File nicht updaten: " + jarentry.getName() + "\n" + e.getMessage() + "\n" + e.getStackTrace(), "AskProperties.updateJarFile()", 1);
            if (plog != null) {
                plog.error("Konnte Eintrags im Jar-File nicht updaten: " + jarentry.getName(), e);
            }
            System.out.println("Konnte Eintrags im Jar-File nicht updaten: " + jarentry.getName() + " " + e.getMessage());
        }
    }

    private static String maskBackSlash(String sSource) {
        if (sSource == null) {
            return sSource;
        }
        int nIndex = sSource.indexOf("\\");
        while (nIndex != -1) {
            String sNewString;
            if (nIndex < sSource.length() - 2 && sSource.charAt(nIndex + 1) == '\\') {
                nIndex = sSource.indexOf("\\", nIndex + 2);
                continue;
            }
            sSource = sNewString = sSource.substring(0, nIndex) + "\\\\" + sSource.substring(nIndex + 1, sSource.length());
            nIndex = sSource.indexOf("\\", nIndex + 2);
        }
        return sSource;
    }

    private static String substituteString(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = "";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }
}

