/*
 * Decompiled with CFR 0.152.
 */
package com.centerkey.utils;

import java.net.URI;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class BareBonesBrowserLaunch {
    static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
    static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(String url) {
        try {
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
        }
        catch (Exception ignore) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    for (String b : browsers) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{browser = b, url});
                    }
                    if (browser == null) {
                        throw new Exception(Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
            }
        }
    }
}

