/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.IEtkData;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.BmwNetzeInfos;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.infotool.InfoObject;
import webetk.app.konfiguration.Filiale;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Scoreliste;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfMisc;
import webetk.communication.transferables.TrfString;
import webetk.etkscore.EtkScoreVerbauung;
import webetk.javaclient.dialog.hilfe.version.Version;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.infotool.TickerThread;
import webetk.javaclient.infotool.TippsTricksDlg;
import webetk.javaclient.infotool.TippsTricksUebersichtDlg;
import webetk.javaclient.utils.CommunicationUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class EtkData
implements IEtkData {
    private static Logger log = Logger.getLogger(EtkData.class);
    private JavaSucheInfo sucheInfo = null;
    private String msPasswort = null;
    private HashMap<String, Object> mBackInfo = new HashMap();
    private String msAsapUrl = null;
    private BmwNetzeInfos moBmwNetzeInfos = null;
    private String msAsapSessionId = null;
    private String msAsapUserId = null;
    private String msClipboardSachnummer = null;
    private HashMap<String, Object> moZurueckDialogInfo = new HashMap();
    private String msScoreFunction = null;
    private String msScoreListenID = null;
    private String msScoreFgstnr = null;
    private String msScoreMarke = null;
    private String msScoreProduktart = null;
    private String msScoreKatalogumfang = null;
    private Scoreliste moScoreListe = null;
    private EtkScoreVerbauung[] maScoreAusstattungen = null;
    private String msScoreJobId = null;
    private String msScoreSrpId = null;
    private TickerThread moTickerThread = null;
    private Boolean mbExisTippsTricks = null;
    private ArrayList<String> maVins = new ArrayList();

    public EtkData() {
        log.info((Object)"Constructing ...");
    }

    @Override
    public JavaSucheInfo getSucheInfo() {
        return this.sucheInfo;
    }

    @Override
    public JavaFzgSucheInfo getFzgSucheInfo() {
        if (this.sucheInfo == null || !(this.sucheInfo instanceof JavaFzgSucheInfo)) {
            return null;
        }
        return (JavaFzgSucheInfo)this.sucheInfo;
    }

    @Override
    public void setFzgSucheInfo(FzgSucheInfo fzgSucheInfo) {
        this.sucheInfo = new JavaFzgSucheInfo(fzgSucheInfo);
    }

    @Override
    public JavaAssSucheInfo getAssSucheInfo() {
        if (this.sucheInfo == null || !(this.sucheInfo instanceof JavaAssSucheInfo)) {
            return null;
        }
        return (JavaAssSucheInfo)this.sucheInfo;
    }

    @Override
    public void setSucheInfo(JavaSucheInfo oSucheInfo) {
        this.sucheInfo = oSucheInfo;
    }

    @Override
    public void startTicker() {
        this.interruptTickerThread();
        Collection aTickertexte = this.getTickertexte();
        if (aTickertexte == null || aTickertexte.size() == 0) {
            return;
        }
        TickerThread thread = GlobalObjects.getInstance().getEtkData().getTickerThread();
        if (thread == null) {
            thread = new TickerThread(aTickertexte, MainView.getInstance());
            this.setTickerThread(thread);
        }
        try {
            thread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setTickerThread(TickerThread thread) {
        if (this.moTickerThread != null && this.moTickerThread.isAlive()) {
            this.moTickerThread.interrupt();
        }
        this.moTickerThread = thread;
    }

    @Override
    public TickerThread getTickerThread() {
        return this.moTickerThread;
    }

    @Override
    public void interruptTickerThread() {
        if (this.moTickerThread != null && this.moTickerThread.isAlive()) {
            this.moTickerThread.interrupt();
        }
        this.moTickerThread = null;
    }

    @Override
    public void resetSucheInfo() {
        this.sucheInfo = null;
    }

    @Override
    public void resetAssSucheInfo() {
        if (this.sucheInfo instanceof JavaAssSucheInfo) {
            this.sucheInfo = null;
        }
    }

    @Override
    public void resetFzgSucheInfo() {
        if (this.sucheInfo instanceof JavaFzgSucheInfo) {
            this.sucheInfo = null;
        }
    }

    @Override
    public String getDefaultImage() {
        return GlobalObjects.getInstance().getAppProperties().getProperty("gui.default.image");
    }

    @Override
    public String getDateischnittstelleDefaultFilename() {
        return GlobalObjects.getInstance().getAppProperties().getProperty("dateischnittstelle.defaultfilename");
    }

    @Override
    public String getUSDealerFilename() {
        return GlobalObjects.getInstance().getAppProperties().getProperty("usdealer.filename");
    }

    @Override
    public void setKeyReaderFilename(String sKeyReaderFilename) {
        GlobalObjects.getInstance().getAppProperties().setProperty("keyreader.filename", sKeyReaderFilename);
    }

    @Override
    public void setUSDealerFilename(String sUSDealerFilename) {
        GlobalObjects.getInstance().getAppProperties().setProperty("usdealer.filename", sUSDealerFilename);
    }

    private Properties loadInfoProperties() {
        Properties props = new Properties();
        String sFile = "infos.properties";
        String sUser = GlobalObjects.getInstance().getSessionInfo().getLogin();
        if (sUser != null) {
            sFile = sUser + "_" + "infos.properties";
        }
        try {
            FileInputStream in = new FileInputStream(sFile);
            log.debug((Object)("Loading property file <" + sFile + "> ..."));
            props.load(in);
            ((InputStream)in).close();
            return props;
        }
        catch (FileNotFoundException e) {
            log.info((Object)("Could not find property file <" + sFile + ">."));
            return null;
        }
        catch (IOException e) {
            log.warn((Object)("Could not load property file <" + sFile + ">. Continuing without Psi Info: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getPsiInfo() {
        Properties props = this.loadInfoProperties();
        if (props == null) {
            log.info((Object)"Could not find information about last Psi configuration. Continuing without.");
            return null;
        }
        return props.getProperty("asap.psi.info");
    }

    @Override
    public void storePsiInfo(String psiInfo) {
        if (psiInfo == null || psiInfo.length() == 0) {
            log.info((Object)"The Psi Information is not stored because it is null!");
            return;
        }
        Properties props = this.loadInfoProperties();
        if (props == null) {
            props = new Properties();
        }
        props.put("asap.psi.info", psiInfo);
        String sFile = "infos.properties";
        String sUser = GlobalObjects.getInstance().getSessionInfo().getLogin();
        if (sUser != null) {
            sFile = sUser + "_" + "infos.properties";
        }
        try {
            FileOutputStream out = new FileOutputStream(sFile);
            props.store(out, "Diese Datei nicht \u00e4ndern! Der ETK JavaClient schreibt hier Daten rein.");
        }
        catch (FileNotFoundException e) {
            log.info((Object)("Could not write to property file <" + sFile + ">: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.info((Object)("Could not write to property file <" + sFile + ">: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    @Override
    public Properties getAsapAppletParameters() {
        if (this.msAsapUrl == null) {
            this.msAsapUrl = "";
            TrfString trf = new TrfString(null);
            String sIbaseConnectionType = GlobalObjects.getInstance().getAppProperties().getProperty("IbaseConnectionType");
            trf.setString(sIbaseConnectionType);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_ASAP_URL);
            }
            catch (CommunicationException ex) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                return null;
            }
            if (trf.getError() != null) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                return null;
            }
            this.msAsapUrl = trf.getString();
        }
        String sAppletPort = GlobalObjects.getInstance().getAppProperties().getProperty("asap.applet.port");
        String sClientPort = GlobalObjects.getInstance().getAppProperties().getProperty("asap.client.port");
        String sPortFrom = GlobalObjects.getInstance().getAppProperties().getProperty("asap.port.from");
        String sPortTo = GlobalObjects.getInstance().getAppProperties().getProperty("asap.port.to");
        if (this.msAsapUrl == null || this.msAsapUrl.length() == 0 || (sPortFrom == null || sPortTo == null || sPortFrom.length() == 0 || sPortTo.length() == 0) && (sAppletPort == null || sClientPort == null || sAppletPort.length() == 0 || sClientPort.length() == 0)) {
            log.info((Object)"ASAP applet communication is not available. ");
            return null;
        }
        Properties asapParameters = new Properties();
        asapParameters.put("com.bmw.tetis.psi.startUrl", this.msAsapUrl);
        if (sAppletPort != null) {
            asapParameters.put("com.bmw.tetis.psi.listenPort.applet", sAppletPort);
        }
        if (sClientPort != null) {
            asapParameters.put("com.bmw.tetis.psi.listenPort.client", sClientPort);
        }
        if (sPortFrom != null) {
            asapParameters.put("com.bmw.tetis.psi.listenPoolPort.start", sPortFrom);
        }
        if (sPortTo != null) {
            asapParameters.put("com.bmw.tetis.psi.listenPoolPort.end", sPortTo);
        }
        return asapParameters;
    }

    @Override
    public boolean requireAsapSessionId(boolean bAccessIGDOM) {
        String sSuchraum = GlobalObjects.getInstance().getSessionInfo().getSettings().getSuchraum();
        if (sSuchraum != null && sSuchraum.equals("Z") || bAccessIGDOM) {
            log.debug((Object)"Communication with BMW AG is required!");
            TrfString trf = new TrfString(null);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_ASAP_TUNNEL_FLAG);
            }
            catch (CommunicationException ex) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                log.error((Object)ex);
                return true;
            }
            if (trf.getError() != null) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                log.error((Object)trf.getError());
                return true;
            }
            String sAsapTunnel = trf.getString();
            if (sAsapTunnel != null && sAsapTunnel.equals("J")) {
                log.debug((Object)"ASAP SessionId is required!");
                return true;
            }
        }
        log.debug((Object)"No ASAP SessionId is required.");
        return false;
    }

    @Override
    public String getEpcFile() {
        return System.getenv("EPC_FILE");
    }

    @Override
    public String getEpcAction() {
        return System.getenv("EPC_ACTION");
    }

    @Override
    public boolean isDateischnittstelleAktiv() {
        String sEpcFile = this.getEpcFile();
        String sEpcAction = this.getEpcAction();
        return sEpcFile != null && sEpcAction != null;
    }

    @Override
    public boolean isDateischnittstelleFurImportAktiv() {
        if (GlobalObjects.isMSWindows()) {
            String sEpcFile = this.getEpcFile();
            String sEpcAction = this.getEpcAction();
            boolean bEpcActionOK = sEpcAction != null && sEpcAction.equals("SEARCH_1");
            boolean bEpcFileOK = sEpcFile != null;
            return bEpcActionOK && bEpcFileOK;
        }
        return false;
    }

    @Override
    public boolean isUSSchnittstelleAktiv() {
        String sFilename = this.getUSDealerFilename();
        return sFilename != null && sFilename.length() > 0;
    }

    @Override
    public String getPasswort() {
        return this.msPasswort;
    }

    @Override
    public void setPasswort(String sPasswort) {
        this.msPasswort = sPasswort;
    }

    @Override
    public void appendBackInfo(String sKey, WorkflowStateData oBackInfo) {
        if (this.mBackInfo.get(sKey) != null) {
            this.mBackInfo.remove(sKey);
        }
        this.mBackInfo.put(sKey, oBackInfo);
    }

    @Override
    public WorkflowStateData getBackInfo(String sKey) {
        return (WorkflowStateData)this.mBackInfo.get(sKey);
    }

    @Override
    public void copySachnummerIntoClipboard(String sSachnummer) {
        if (sSachnummer == null || sSachnummer.trim().equals("")) {
            this.msClipboardSachnummer = null;
        }
        this.msClipboardSachnummer = StringUtils.substituteStringStraight(sSachnummer, " ", "");
    }

    @Override
    public void resetSachnummerInClipboard() {
        this.msClipboardSachnummer = null;
    }

    @Override
    public String getSachnummerAusClipboard() {
        if (this.msClipboardSachnummer == null) {
            return "";
        }
        return this.msClipboardSachnummer;
    }

    @Override
    public void setZurueckDialogInfo(String sDialogBezeichung, AbstractDialogViewController oDialogController, AbstractDialogModel oDialogModel, AbstractDialogView oDialogView) {
        this.moZurueckDialogInfo.put("bezeichnung_" + sDialogBezeichung, sDialogBezeichung);
        this.moZurueckDialogInfo.put("controller_" + sDialogBezeichung, oDialogController);
        this.moZurueckDialogInfo.put("model_" + sDialogBezeichung, oDialogModel);
        this.moZurueckDialogInfo.put("view_" + sDialogBezeichung, oDialogView);
    }

    @Override
    public Vector<String> getZurueckBezeichnungen() {
        Vector<String> oErgebnis = new Vector<String>();
        Set<Map.Entry<String, Object>> oSet = this.moZurueckDialogInfo.entrySet();
        for (Map.Entry<String, Object> oObj : oSet) {
            String oKey = oObj.getKey();
            if (!oKey.startsWith("bezeichnung_")) continue;
            String sValue = (String)oObj.getValue();
            oErgebnis.add(sValue);
        }
        return oErgebnis;
    }

    @Override
    public AbstractDialogViewController getZurueckDialogController(String sBezeichnung) {
        AbstractDialogViewController oController = (AbstractDialogViewController)this.moZurueckDialogInfo.get("controller_" + sBezeichnung);
        return oController;
    }

    @Override
    public AbstractDialogModel getZurueckDialogModel(String sBezeichnung) {
        AbstractDialogModel oModel = (AbstractDialogModel)this.moZurueckDialogInfo.get("model_" + sBezeichnung);
        return oModel;
    }

    @Override
    public AbstractDialogView getZurueckDialogView(String sBezeichnung) {
        AbstractDialogView oView = (AbstractDialogView)this.moZurueckDialogInfo.get("view_" + sBezeichnung);
        return oView;
    }

    @Override
    public String getZurueckMenuitemText(String sBezeichnung) {
        if (sBezeichnung.equals("bestellliste")) {
            return Resource.getInstance().getZurBestellliste();
        }
        if (sBezeichnung.equals("bt_anzeige")) {
            return Resource.getInstance().getZurBildtafel();
        }
        if (sBezeichnung.equals("erstbevorratung")) {
            return Resource.getInstance().getZurErstbevorratung();
        }
        if (sBezeichnung.equals("fahrzeugidentifikation")) {
            return Resource.getInstance().getZurFahrzeugidentifikation();
        }
        if (sBezeichnung.equals("interpretation")) {
            return Resource.getInstance().getZurInterpretation();
        }
        if (sBezeichnung.equals("lagerzeitbeschraenkung")) {
            return Resource.getInstance().getZurLagerzeitbeschraenkung();
        }
        if (sBezeichnung.equals("normteile")) {
            return Resource.getInstance().getZuNormteile();
        }
        if (sBezeichnung.equals("notizuebersicht")) {
            return Resource.getInstance().getZurNotizuebersicht();
        }
        if (sBezeichnung.equals("satz_einzelteile_einzelteile")) {
            return Resource.getInstance().getZuEinzelteile();
        }
        if (sBezeichnung.equals("satz_einzelteile_satz")) {
            return Resource.getInstance().getZurSatzauswahl();
        }
        if (sBezeichnung.equals("suchergebnisse_bt")) {
            return Resource.getInstance().getZurBildtafelUebersicht();
        }
        if (sBezeichnung.equals("suchergebnisse_bt_tnr")) {
            return Resource.getInstance().getZurTnrBtUebersicht();
        }
        if (sBezeichnung.equals("technische_literatur")) {
            return Resource.getInstance().getZurTechnischenLiteratur();
        }
        if (sBezeichnung.equals("teileersetzung")) {
            return Resource.getInstance().getZurTeileersetzung();
        }
        if (sBezeichnung.equals("teileinfo")) {
            return Resource.getInstance().getZurTeileinformation();
        }
        if (sBezeichnung.equals("teileliste")) {
            return Resource.getInstance().getZurTeileliste();
        }
        if (sBezeichnung.equals("teilesuche")) {
            return Resource.getInstance().getZurTeilesuche();
        }
        if (sBezeichnung.equals("teileverwendung_FZG")) {
            return Resource.getInstance().getZurTeileverwendung();
        }
        if (sBezeichnung.equals("teileverwendung_teil")) {
            return Resource.getInstance().getZurTeileverwendung();
        }
        if (sBezeichnung.equals("value_line")) {
            return Resource.getInstance().getZurueckValueLine();
        }
        return Resource.getInstance().getZurueck();
    }

    @Override
    public void removeZurueckDialog(String sBezeichnung) {
        this.moZurueckDialogInfo.remove("bezeichnung_" + sBezeichnung);
        this.moZurueckDialogInfo.remove("controller_" + sBezeichnung);
        this.moZurueckDialogInfo.remove("model_" + sBezeichnung);
        this.moZurueckDialogInfo.remove("view_" + sBezeichnung);
    }

    @Override
    public void resetZurueckDialoge() {
        this.moZurueckDialogInfo.clear();
    }

    @Override
    public void setScoreFunction(String sScoreFunction) {
        this.msScoreFunction = sScoreFunction;
    }

    @Override
    public String getScoreFunction() {
        return this.msScoreFunction;
    }

    @Override
    public void setScoreFgstnr(String sScoreFgstnr) {
        this.msScoreFgstnr = sScoreFgstnr;
    }

    @Override
    public String getScoreFgstnr() {
        return this.msScoreFgstnr;
    }

    @Override
    public void setScoreMarke(String sScoreMarke) {
        this.msScoreMarke = sScoreMarke;
    }

    @Override
    public String getScoreMarke() {
        return this.msScoreMarke;
    }

    @Override
    public void setScoreProduktart(String sScoreProduktart) {
        this.msScoreProduktart = sScoreProduktart;
    }

    @Override
    public String getScoreProduktart() {
        return this.msScoreProduktart;
    }

    @Override
    public void setScoreKatalogumfang(String sScoreKatalogumfang) {
        this.msScoreKatalogumfang = sScoreKatalogumfang;
    }

    @Override
    public String getScoreKatalogumfang() {
        return this.msScoreKatalogumfang;
    }

    @Override
    public void setScoreAusstattungen(EtkScoreVerbauung[] aScoreAusstattungen) {
        this.maScoreAusstattungen = aScoreAusstattungen;
    }

    @Override
    public EtkScoreVerbauung[] getScoreAusstattungen() {
        return this.maScoreAusstattungen;
    }

    @Override
    public boolean isScoreTeilesuche() {
        if (this.msScoreFunction == null) {
            return false;
        }
        return this.msScoreFunction.equals("Score_Teilesuche");
    }

    @Override
    public Scoreliste getScoreListe() {
        return this.moScoreListe;
    }

    @Override
    public void setScoreListe(Scoreliste oScoreListe) {
        this.moScoreListe = oScoreListe;
    }

    @Override
    public String getScoreListenID() {
        return this.msScoreListenID;
    }

    @Override
    public void setScoreListenID(String sScoreListenID) {
        this.msScoreListenID = sScoreListenID;
    }

    @Override
    public String getScoreJobId() {
        return this.msScoreJobId;
    }

    @Override
    public void setScoreJobId(String sScoreJobId) {
        this.msScoreJobId = sScoreJobId;
    }

    @Override
    public String getScoreSrpId() {
        return this.msScoreSrpId;
    }

    @Override
    public void setScoreSrpId(String sScoreSrpId) {
        this.msScoreSrpId = sScoreSrpId;
    }

    @Override
    public void setMainViewTitle() {
        TrfHashMap versionHashMap;
        String webetkVersion;
        String sSuchraum = "L";
        String sIdFiliale = null;
        String sIdFirma = null;
        if (GlobalObjects.getInstance().getSessionInfo() != null) {
            sSuchraum = GlobalObjects.getInstance().getSessionInfo().getSettings().getSuchraum();
            sIdFiliale = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
            sIdFirma = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        }
        String sTitel = (webetkVersion = (String)(versionHashMap = Version.loadVersionsinformation_external(false)).getValue("webetkversion")) != null && webetkVersion.length() > 0 ? webetkVersion : "ETK";
        TrfHashMap trfFilialeInfo = new TrfHashMap(null);
        trfFilialeInfo.setValue("firmaid", sIdFirma);
        trfFilialeInfo.setValue("filialid", sIdFiliale);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFilialeInfo, Command.LOAD_FILIALE_INFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Service: " + Command.LOAD_FILIALE_INFO + " URL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (!CommunicationUtils.checkError(trfFilialeInfo, Resource.getInstance().getKonfiguration())) {
            return;
        }
        Filiale oFiliale = (Filiale)trfFilialeInfo.getValue("filiale");
        if (sIdFiliale != null && oFiliale != null && oFiliale.isSingleFiliale() != null && !oFiliale.isSingleFiliale().booleanValue()) {
            sTitel = sTitel + " - " + oFiliale.getBezeichnung();
        }
        if (sSuchraum.equals("Z")) {
            sTitel = sTitel + " (" + Resource.getInstance().getSucheIm() + " " + Resource.getInstance().getZentralenKatalog() + ")";
        }
        MainView.getInstance().setTitle(sTitel);
    }

    @Override
    public String getMarkeTeilRepraesentant(Collection<String> aMarkenTeil, String sMarkeVorgabe) {
        Collection<String> aMarkenSM = this.getSchnittmengeMarkenTeilUser(aMarkenTeil);
        if (aMarkenSM.size() == 1) {
            return (String)aMarkenSM.toArray()[0];
        }
        for (String sMarkeComp : aMarkenSM) {
            if (!sMarkeComp.equalsIgnoreCase(sMarkeVorgabe)) continue;
            return sMarkeComp;
        }
        String sMarkeEinstellungen = GlobalObjects.getInstance().getSessionInfo().getMarke();
        for (String sMarkeComp : aMarkenSM) {
            if (!sMarkeComp.equalsIgnoreCase(sMarkeEinstellungen)) continue;
            return sMarkeComp;
        }
        return null;
    }

    @Override
    public String getMarkeFuerTeileliste(ComboTeilelisteItem oTeileliste, Collection<String> cMarken) {
        String sMarke = oTeileliste.getMarke();
        if (sMarke != null && !sMarke.equals("")) {
            return sMarke;
        }
        if (sMarke == null || sMarke.equals("")) {
            if (cMarken.size() == 1) {
                sMarke = (String)cMarken.toArray()[0];
            }
            return sMarke;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        sMarke = oLoginInfo.getMarke();
        return sMarke;
    }

    @Override
    public Collection<String> getSchnittmengeMarkenTeilUser(Collection<String> aMarkenTeil) {
        Collection<String> aMarkenUser = GlobalObjects.getInstance().getSessionInfo().getUserMarken();
        Vector<String> aMarkenSM = new Vector<String>();
        for (String sHelp1 : aMarkenTeil) {
            for (String sHelp2 : aMarkenUser) {
                if (!sHelp1.equalsIgnoreCase(sHelp2)) continue;
                aMarkenSM.add(sHelp1);
            }
        }
        return aMarkenSM;
    }

    @Override
    public void anzeigenTippsTricks(boolean bNeuLaden) {
        Collection cTippTrickWichtig = this.ladenTippsTricks(true, true);
        Iterator iter = cTippTrickWichtig.iterator();
        boolean bGefundenUngelesen = false;
        while (iter.hasNext()) {
            InfoObject oObject = (InfoObject)iter.next();
            if (oObject.isGelesen()) continue;
            bGefundenUngelesen = true;
            break;
        }
        if (cTippTrickWichtig.size() > 0 && bGefundenUngelesen) {
            TippsTricksDlg dlg = new TippsTricksDlg(MainView.getInstance(), (List<InfoObject>)cTippTrickWichtig, -1, 2);
            dlg.setVisible(true);
            return;
        }
        Collection cTippTrickNormal = this.ladenTippsTricks(false, true);
        if (cTippTrickNormal.size() > 0) {
            TippsTricksDlg dlg = new TippsTricksDlg(MainView.getInstance(), (List<InfoObject>)cTippTrickNormal, -1, 1);
            dlg.setVisible(true);
        }
    }

    @Override
    public void anzeigenTippsTricksUebersicht() {
        Collection<InfoObject> cTippsTricksWichtig = GlobalObjects.getInstance().getEtkData().ladenTippsTricks(true, true);
        Collection<InfoObject> cTippsTricksNormal = GlobalObjects.getInstance().getEtkData().ladenTippsTricks(false, true);
        if (cTippsTricksWichtig.size() > 0 || cTippsTricksNormal.size() > 0) {
            TippsTricksUebersichtDlg dlg = new TippsTricksUebersichtDlg(MainView.getInstance());
            dlg.setVisible(true);
        }
    }

    public List<InfoObject> ladenTippsTricks(boolean bWichtig, boolean bNurBasisdaten) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTipps = new TrfHashMap(null);
        String sIsWichtig = bWichtig ? "J" : "N";
        trfTipps.setValue("is_wichtig", sIsWichtig);
        Command command = bNurBasisdaten ? Command.LOAD_TIPPS_TRICKS_BASISINFO : Command.LOAD_TIPPS_TRICKS_DETAILS;
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTipps, command);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Service: " + command + " URL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        boolean ok = CommunicationUtils.checkError(trfTipps, "Tipps und Tricks");
        List cTippsTricks = (List)trfTipps.getValue("tipps");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (!ok || cTippsTricks == null) {
            return new ArrayList<InfoObject>();
        }
        return cTippsTricks;
    }

    @Override
    public boolean existTippsTricks() {
        if (this.mbExisTippsTricks != null) {
            return this.mbExisTippsTricks;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTipps = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTipps, Command.EXIST_TIPPS_TRICKS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Service: " + Command.EXIST_TIPPS_TRICKS + " URL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        boolean ok = CommunicationUtils.checkError(trfTipps, Resource.getInstance().getTippsTricks());
        if (!ok) {
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        this.mbExisTippsTricks = (Boolean)trfTipps.getValue("boolean");
        return this.mbExisTippsTricks;
    }

    public List<String> getTickertexte() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTickertexte = new TrfHashMap(null);
        List cTickertexte = null;
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTickertexte, Command.LOAD_TICKERTEXTE);
            cTickertexte = (List)trfTickertexte.getValue("arraylist_of_string");
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfTickertexte.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTickertexte.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTickertexte.getError().getMessage(), Resource.getInstance().getTippsTricks(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return cTickertexte;
    }

    @Override
    public int getRrSapMaxParts() {
        String sProp = GlobalObjects.getInstance().getAppProperties().getProperty("rrsap.maxparts");
        if (sProp == null || sProp.length() < 1) {
            return 1;
        }
        return Integer.parseInt(sProp);
    }

    @Override
    public int getRrSapWaitSteps() {
        String sProp = GlobalObjects.getInstance().getAppProperties().getProperty("rrsap.wait.steps");
        if (sProp == null || sProp.length() < 1) {
            return 1;
        }
        return Integer.parseInt(sProp);
    }

    @Override
    public int getRrSapWaitTime() {
        String sProp = GlobalObjects.getInstance().getAppProperties().getProperty("rrsap.wait.time");
        if (sProp == null || sProp.length() < 1) {
            return 1;
        }
        return Integer.parseInt(sProp);
    }

    @Override
    public Iterator<String> getVins() {
        if (this.maVins == null) {
            return null;
        }
        return this.maVins.iterator();
    }

    @Override
    public void addVin(String vin) {
        for (String entry : this.maVins) {
            String vin7Zeichen;
            String entry7Zeichen;
            if (entry.length() < 7 || vin.length() < 7 || !(entry7Zeichen = entry.substring(0, 7)).equalsIgnoreCase(vin7Zeichen = vin.substring(0, 7))) continue;
            return;
        }
        if (this.maVins.size() == 10) {
            this.maVins.remove(0);
        }
        this.maVins.add(vin);
    }

    @Override
    public void setBmwNetzeInfos(BmwNetzeInfos oBmwNetzeInfos) {
        this.moBmwNetzeInfos = oBmwNetzeInfos;
    }

    @Override
    public BmwNetzeInfos getBmwNetzeInfos() {
        if (this.moBmwNetzeInfos == null) {
            TrfMisc misc = new TrfMisc(null);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.LOAD_BMW_NETZ_INFOS);
                this.moBmwNetzeInfos = (BmwNetzeInfos)misc.getValue("Bmw_Netz_Infos");
            }
            catch (CommunicationException comEx) {
                log.error((Object)"Kommunikationsfehler beim LOAD_BMW_NETZ_INFOS am Server!", (Throwable)comEx);
            }
            if (misc.getError() != null) {
                log.error((Object)"Sonstiger Fehler beim LOAD_BMW_NETZ_INFOS Server!", (Throwable)misc.getError());
            }
        }
        return this.moBmwNetzeInfos;
    }

    @Override
    public void setAsapSessionId(String sAsapSessionId) {
        this.msAsapSessionId = sAsapSessionId;
    }

    @Override
    public String getAsapSessionId() {
        return this.msAsapSessionId;
    }

    @Override
    public String getAsapSessionIdWithoutIndex() {
        return this.msAsapSessionId != null ? this.msAsapSessionId.substring(0, this.msAsapSessionId.lastIndexOf(".")) : null;
    }

    @Override
    public String getAsapUserId() {
        return this.msAsapUserId;
    }

    @Override
    public void setAsapUserId(String pAsapUserId) {
        this.msAsapUserId = pAsapUserId;
    }

    @Override
    public boolean isAsapSessionIdRequired(boolean bForceAsapSessionIdIsRequired) {
        String sSuchraum = GlobalObjects.getInstance().getSessionInfo().getSettings().getSuchraum();
        if (sSuchraum != null && sSuchraum.equals("Z") || bForceAsapSessionIdIsRequired) {
            return this.getBmwNetzeInfos().isAsapRequired();
        }
        return false;
    }
}

