/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient;

import com.bmw.kr.gki.exception.KrGkiException;
import com.bmw.kr.gki.exception.NoKeyException;
import de.esg.commonclient.ETKKrGkiKeyReader;
import de.esg.commonclient.GkiZugriffException;
import java.util.Properties;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class GkiZugriff {
    private static GkiZugriff mInstance;
    private static Logger log;
    private ETKKrGkiKeyReader mGkiEtk = null;
    private boolean mKeyreaderAktiv = false;

    public static GkiZugriff getInstance() {
        if (mInstance == null) {
            mInstance = new GkiZugriff();
        }
        return mInstance;
    }

    private GkiZugriff() {
        log.debug((Object)"Initilisiere GKI Keyreader Zugriff");
        try {
            this.mGkiEtk = new ETKKrGkiKeyReader(this.createPropertiesForProductionMode());
            log.debug((Object)"GKI Bibliothek initilisiert, pruefe auf aktiven Keyreader");
            this.mKeyreaderAktiv = this.mGkiEtk.existKeyReader();
        }
        catch (Exception ex) {
            this.mKeyreaderAktiv = false;
            log.error((Object)"Exception bei der Initialisierung des Keyreaders", (Throwable)ex);
        }
        catch (Error er) {
            this.mKeyreaderAktiv = false;
            log.error((Object)"Error bei der Initialisierung des Keyreaders", (Throwable)er);
        }
        if (this.mKeyreaderAktiv) {
            log.debug((Object)"GKI Keyreader aktiv");
        } else {
            log.debug((Object)"GKI Keyreader nicht aktiv");
        }
    }

    public boolean isKeyreaderAktiv() {
        return this.mKeyreaderAktiv;
    }

    public String retrieveVin() throws GkiZugriffException {
        try {
            return this.mGkiEtk.retrieveVin();
        }
        catch (NoKeyException ex) {
            log.warn((Object)"Kein Schluessel gefunden", (Throwable)ex);
            throw new GkiZugriffException(" " + Resource.getInstance().getMsgNoKey() + " " + ex.getMessage());
        }
        catch (KrGkiException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new GkiZugriffException(ex.getMessage());
        }
        catch (RuntimeException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new GkiZugriffException(ex.getMessage());
        }
    }

    private Properties createPropertiesForProductionMode() {
        Properties props = new Properties();
        props.setProperty("ksdDir", "");
        props.setProperty("kaImplDir", "libs\\ka_impl.jar");
        return props;
    }

    static {
        log = Logger.getLogger(GkiZugriff.class);
    }
}

