/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.browser;

import de.esg.commonclient.GlobalObjects;
import de.esg.tools.win32.registry.WindowsRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import webetk.communication.LoginInfo;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;

public class HelpViewer {
    private static Logger log = Logger.getLogger(HelpViewer.class);
    static HelpViewer instance;

    private HelpViewer() {
    }

    private static StringBuffer getBaseURL(boolean bIpac) {
        StringBuffer url = null;
        if (GlobalObjects.getInstance().getIstStandalone()) {
            String sWorkDir = System.getProperty("user.dir");
            url = !HelpViewer.isMSWindowsNT() ? new StringBuffer("file://" + sWorkDir + "\\tomcat\\webapps\\") : new StringBuffer("file:" + sWorkDir + "\\tomcat\\webapps\\");
            if (bIpac) {
                url.append("Zubwbt\\");
            } else {
                url.append("javaserver\\html\\");
            }
        } else {
            String serverURL = GlobalObjects.getInstance().getServerUrl();
            url = new StringBuffer(serverURL.substring(0, serverURL.lastIndexOf("/javaserver/rest")));
            if (bIpac) {
                url.append("/Zubwbt/");
            } else {
                url.append("/javaserver/html/");
            }
        }
        return url;
    }

    private static StringBuffer getBaseURLWithLanguage() {
        LoginInfo info = GlobalObjects.getInstance().getSessionInfo();
        boolean bIpac = false;
        StringBuffer url = HelpViewer.getBaseURL(bIpac);
        if (info.getLanguage() != null) {
            url.append(info.getLanguage());
            if (info.getLangRegion() != null) {
                url.append(info.getLangRegion().trim());
            }
        } else {
            url.append(GlobalObjects.getInstance().getLanguage().trim());
        }
        return url;
    }

    public static void showHelp() {
        LoginInfo info = GlobalObjects.getInstance().getSessionInfo();
        StringBuffer url = HelpViewer.getBaseURLWithLanguage();
        if (GlobalObjects.getInstance().getIstStandalone()) {
            url.append("\\Hilfe\\");
            if (info.displayMarkeProduktKatalogumfang()) {
                url.append("bg\\");
            } else {
                url.append("mr\\");
            }
        } else {
            url.append("/Hilfe/");
            if (info.displayMarkeProduktKatalogumfang()) {
                url.append("bg/");
            } else {
                url.append("mr/");
            }
        }
        url.append("helpcontents1.htm");
        String sUrl = url.toString();
        HelpViewer.showInBrowser(sUrl);
    }

    public static void showHelpIpac(String target) {
        if (target == null || target.length() < 1) {
            log.error((Object)"No target!");
            return;
        }
        LoginInfo info = GlobalObjects.getInstance().getSessionInfo();
        boolean bIpac = true;
        StringBuffer url = HelpViewer.getBaseURL(bIpac);
        url.append("index_t.htm");
        url.append("?brand=");
        Collection<String> marken = info.getUserMarken();
        String marke = null;
        ArrayList<String> sIpacHilfeMarken = new ArrayList<String>();
        for (String sValueMarke : marken) {
            String sValueIpacHilfe = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sValueMarke, "marke.ipacHilfe", null);
            if (sValueIpacHilfe == null || sValueIpacHilfe.length() <= 0 || sIpacHilfeMarken.contains(sValueIpacHilfe)) continue;
            sIpacHilfeMarken.add(sValueIpacHilfe);
        }
        marke = sIpacHilfeMarken.size() >= 2 ? Marken.getInstance().getMarke("GROUP").getIpacHilfe() : (sIpacHilfeMarken.isEmpty() ? Marken.getInstance().getMarke("BMW").getIpacHilfe() : (String)sIpacHilfeMarken.get(0));
        url.append(marke);
        url.append("&lang=");
        url.append(GlobalObjects.getInstance().getLanguage());
        url.append("&target=");
        String selMarke = info.getMarke();
        if (selMarke != null && selMarke.equals(Marken.getInstance().getMarke("MINI").getBerechtigung()) && !target.equals("i0101") && !target.equals("i1100")) {
            target = "i1" + target.substring(1);
        }
        url.append(target);
        url.append("&market=");
        url.append(info.getSettings().getMarktKuerzel());
        url.append("&user=");
        url.append(info.getLogin());
        url.append("&product=");
        String produkt = info.getUserProdukte().size() > 1 ? Produkte.getInstance().getProdukt("ALLE").getIpacHilfe() : Produkte.getInstance().getProduktEigenschaft("produkt.berechtigung", info.getUserProdukte().iterator().next(), "produkt.ipacHilfe", null);
        url.append(produkt);
        String sUrl = url.toString();
        HelpViewer.showInBrowser(sUrl);
    }

    public static void showIndividual() {
        StringBuffer url = HelpViewer.getBaseURLWithLanguage();
        if (GlobalObjects.getInstance().getIstStandalone()) {
            url.append("\\Zusatzinfo\\Individual.htm");
        } else {
            url.append("/Zusatzinfo/Individual.htm");
        }
        String sUrl = url.toString();
        HelpViewer.showInBrowser(sUrl);
    }

    public static void showCDInfo() {
        StringBuffer url = HelpViewer.getBaseURLWithLanguage();
        if (GlobalObjects.getInstance().getIstStandalone()) {
            url.append("\\CD-Info\\Readme.htm");
        } else {
            url.append("/CD-Info/Readme.htm");
        }
        String sUrl = url.toString();
        HelpViewer.showInBrowser(sUrl);
    }

    private static void showInBrowser(String sUrl) {
        try {
            String sPath = HelpViewer.getBrowserExecutablePath();
            if (sPath != null && !HelpViewer.isMSWindowsNT()) {
                sPath = StringUtils.substituteStringStraight(sPath, "\"%1\"", "");
                Runtime.getRuntime().exec(sPath + " " + sUrl);
            } else if (GlobalObjects.getInstance().getIstStandalone() || HelpViewer.isMSWindowsNT()) {
                Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + sUrl);
            } else {
                Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler javascript:location.href='" + sUrl + "'");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getBrowserExecutablePath() {
        return WindowsRegistry.getValueAsString("HKEY_CLASSES_ROOT\\http\\shell\\open\\command", "");
    }

    public static HelpViewer getInstance() {
        if (instance == null) {
            instance = new HelpViewer();
        }
        return instance;
    }

    public static boolean isMSWindowsNT() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.equalsIgnoreCase("Windows NT");
    }
}

