/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog;

import de.esg.commonclient.dialog.EnhancedTextDocument;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class LimitedNumberField
extends JTextField {
    private static final long serialVersionUID = -8221255184510704855L;

    public LimitedNumberField(int maxChars) {
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(int maxChars, int nLen) {
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(nLen, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(nLen);
        ehDoc = new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
    }

    public LimitedNumberField(int maxChars, boolean acceptWildcards) {
        if (acceptWildcards) {
            EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 3);
            this.setDocument(ehDoc);
        } else {
            EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 1);
            this.setDocument(ehDoc);
        }
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(int maxChars, boolean acceptPrice, boolean acceptSign) {
        EnhancedTextDocument ehDoc = null;
        ehDoc = acceptPrice ? (acceptSign ? new EnhancedTextDocument(maxChars, 6) : new EnhancedTextDocument(maxChars, 5)) : new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(int maxChars, int nLen, boolean acceptPrice, boolean acceptSign) {
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(nLen, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(nLen);
        ehDoc = null;
        ehDoc = acceptPrice ? (acceptSign ? new EnhancedTextDocument(maxChars, 6) : new EnhancedTextDocument(maxChars, 5)) : new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(Pattern pattern) {
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(pattern);
        this.setDocument(ehDoc);
        this.setText("0");
    }

    public void setPreferredSizeToDigitLength(int numberOfDigits) {
        StringBuffer sb = new StringBuffer(numberOfDigits);
        for (int i = 0; i < numberOfDigits; ++i) {
            sb.append("0");
        }
        String oldText = this.getText();
        this.setText(sb.toString());
        Dimension s = this.getPreferredSize();
        this.setPreferredSize(new Dimension(s.width + 2, s.height));
        this.setText(oldText);
    }
}

