/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog.extras.login;

import de.esg.commonclient.dialog.AbstractDialogModel;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Funktionsrecht;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.workflow.WorkflowStateData;

public class DlgLoginModel
extends AbstractDialogModel {
    private LoginInfo sessionInformation = new LoginInfo();
    private static Logger log = Logger.getLogger(DlgLoginModel.class);
    private TrfHashMap moFilialen = null;
    private String msPasswort = null;
    private String msFiliale = null;
    private String msFilialeAlt = null;
    private String msFilialeBezeichnung = null;
    private String msFilialeSprache = null;
    private List<Funktionsrecht> oNutzerFunktionsrechte = null;
    private String msUserId = null;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        this.msUserId = (String)oWFStateData.getWert("NUTZER");
    }

    public TrfHashMap getFilialen() {
        return this.moFilialen;
    }

    public void storeFilialen(TrfHashMap oFilialen) {
        this.moFilialen = oFilialen;
    }

    public void resetFilialen() {
        this.moFilialen = null;
    }

    public int getAnzahlFilialen() {
        int nAnzahlFilialen = 0;
        if (this.moFilialen != null) {
            String sBezeichnung;
            int ii = 1;
            while ((sBezeichnung = (String)this.moFilialen.getValue(ii + "benennung")) != null) {
                ++nAnzahlFilialen;
                ++ii;
            }
        }
        return nAnzahlFilialen;
    }

    public LoginInfo getSessionInfos() {
        return this.sessionInformation;
    }

    public void storeSessionInfos(TrfHashMap trf) throws CommunicationException {
        if (trf == null) {
            log.fatal((Object)"Received session information is null!");
            throw new CommunicationException("No valid TrfHashMap received!");
        }
        this.sessionInformation = (LoginInfo)trf.getValue("webetkSession");
    }

    public String getFiliale() {
        return this.msFiliale;
    }

    public String getPasswort() {
        return this.msPasswort;
    }

    public void setFiliale(String string) {
        this.msFiliale = string;
    }

    public void setPasswort(String string) {
        this.msPasswort = string;
    }

    public String getFilialeBezeichnung() {
        return this.msFilialeBezeichnung;
    }

    public void setFilialeBezeichnung(String string) {
        this.msFilialeBezeichnung = string;
    }

    public List<Funktionsrecht> getNutzerFunktionsrechte() {
        return this.oNutzerFunktionsrechte;
    }

    public void storeNutzerFunktionsrechte(List<Funktionsrecht> pFunktionsrechtList) {
        this.oNutzerFunktionsrechte = pFunktionsrechtList;
    }

    public String getFilialeAlt() {
        return this.msFilialeAlt;
    }

    public void setFilialeAlt(String string) {
        this.msFilialeAlt = string;
    }

    public String getFilialeSprache() {
        return this.msFilialeSprache;
    }

    public void setFilialeSprache(String string) {
        this.msFilialeSprache = string;
    }

    public String getUserId() {
        return this.msUserId;
    }

    public void setUserId(String string) {
        this.msUserId = string;
    }
}

