/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog.tableconfig;

import de.esg.commonclient.dialog.tableconfig.DlgTableConfigModel;
import de.esg.commonclient.dialog.tableconfig.DlgTableConfigView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class DlgTableConfigController
implements ActionListener {
    protected DlgTableConfigModel model;
    protected DlgTableConfigView view;
    protected ArrayList<String> resultValue = null;
    public static final int MOVE_TOP = 1;
    public static final int MOVE_UP = 2;
    public static final int MOVE_DOWN = 3;
    public static final int MOVE_BOTTOM = 4;

    public DlgTableConfigController(String title, String zusatz, ArrayList<String> allColumns, ArrayList<String> selectedColumns) {
        this.model = new DlgTableConfigModel(allColumns, selectedColumns);
        this.view = new DlgTableConfigView((Frame)MainView.getInstance(), title);
        this.view.init(this);
        this.view.setVisible(true);
    }

    public ArrayList<String> getResult() {
        return this.resultValue;
    }

    private void moveEntry(String column, int mode) {
        LinkedList<String> cols = this.getSelectedColumns();
        if (cols.contains(column)) {
            int index = 0;
            switch (mode) {
                case 1: {
                    index = 0;
                    cols.remove(column);
                    cols.addFirst(column);
                    break;
                }
                case 2: {
                    index = cols.indexOf(column);
                    if (index <= 0) break;
                    cols.remove(column);
                    cols.add(--index, column);
                    break;
                }
                case 3: {
                    index = cols.indexOf(column);
                    if (index >= cols.size() - 1) break;
                    cols.remove(column);
                    cols.add(++index, column);
                    break;
                }
                case 4: {
                    index = cols.size() - 1;
                    cols.remove(column);
                    cols.addLast(column);
                }
            }
            this.view.updateDialog();
            this.view.getSelectedList().setSelectedIndex(index);
        }
    }

    private void setSelected(Object[] columns, boolean selected) {
        for (Object o : columns) {
            if (!(o instanceof String)) continue;
            String column = (String)o;
            if (!this.getAllColumns().contains(column)) continue;
            if (selected) {
                this.getSelectedColumns().add(column);
                continue;
            }
            this.getSelectedColumns().remove(column);
        }
    }

    private ArrayList<String> getAllColumns() {
        return this.model.getAllColumns();
    }

    public LinkedList<String> getSelectedColumns() {
        return this.model.getSelectedColumns();
    }

    public ArrayList<String> getDeselectedColumns() {
        ArrayList<String> cols = new ArrayList<String>(this.model.getAllColumns());
        for (String col : this.model.getSelectedColumns()) {
            cols.remove(col);
        }
        return cols;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (button.getName().equals("Ok")) {
                this.performOk();
            } else if (button.getName().equals("Abbrechen")) {
                this.performAbbrechen();
            } else if (button.getName().equals("Select")) {
                this.performSelect();
            } else if (button.getName().equals("Deselect")) {
                this.performDeselect();
            } else if (button.getName().equals("Top")) {
                this.performMoveEntry(1);
            } else if (button.getName().equals("Up")) {
                this.performMoveEntry(2);
            } else if (button.getName().equals("Down")) {
                this.performMoveEntry(3);
            } else if (button.getName().equals("Bottom")) {
                this.performMoveEntry(4);
            }
        }
    }

    private void performOk() {
        this.resultValue = new ArrayList<String>(this.getSelectedColumns());
        this.view.dispose();
    }

    private void performAbbrechen() {
        this.view.dispose();
    }

    private void performSelect() {
        this.setSelected(this.view.getDeselectedList().getSelectedValues(), true);
        this.view.updateDialog();
    }

    private void performDeselect() {
        this.setSelected(this.view.getSelectedList().getSelectedValues(), false);
        this.view.updateDialog();
    }

    private void showMessageNurEinDS() {
        JOptionPane.showMessageDialog(this.view, Resource.getInstance().getNurEinDsText(), Resource.getInstance().getNurEinDsTitel(), 1);
    }

    private void performMoveEntry(int mode) {
        if (this.view.getSelectedList().getSelectedValues().length != 1) {
            this.showMessageNurEinDS();
        } else {
            String column = (String)this.view.getSelectedList().getSelectedValue();
            this.moveEntry(column, mode);
        }
    }
}

