/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog.tableconfig;

import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.tableconfig.DlgTableConfigController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.resources.Resource;

public class DlgTableConfigView
extends JDialog {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgTableConfigView.class);
    private static final Dimension DIALOG_PREFERRED_SIZE = new Dimension(600, 400);
    public static final String SELECT = "Select";
    public static final String DESELECT = "Deselect";
    public static final String TOP = "Top";
    public static final String UP = "Up";
    public static final String DOWN = "Down";
    public static final String BOTTOM = "Bottom";
    public static final String OK = "Ok";
    public static final String ABBRECHEN = "Abbrechen";
    private static final Dimension BUTTON_SIZE = new Dimension(40, 25);
    private JPanel panMain;
    private JPanel panButtons;
    private JPanel panDeselectedColumns;
    private JPanel panSelectedColumns;
    private JList lstDeselectedColumns;
    private JList lstSelectedColumns;
    private JButtonEx butSelect;
    private JButtonEx butDeselect;
    private JButtonEx butMoveTop;
    private JButtonEx butMoveUp;
    private JButtonEx butMoveDown;
    private JButtonEx butMoveBottom;
    private JButtonEx butOk;
    private JButtonEx butAbbrechen;
    DlgTableConfigController controller;

    public DlgTableConfigView(Frame owner, String title) {
        super(owner, title);
    }

    public void init(DlgTableConfigController controller) {
        this.log.debug((Object)"init");
        this.controller = controller;
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanMain(), "Center");
        this.add((Component)this.getPanButtons(), "South");
        this.setMinimumSize(DIALOG_PREFERRED_SIZE);
        this.setMaximumSize(DIALOG_PREFERRED_SIZE);
        this.setLocation();
        this.setModal(true);
        this.updateDialog();
    }

    private JPanel getPanMain() {
        if (this.panMain == null) {
            this.panMain = new TitledPanel(Resource.getInstance().getTabellenkonfiguration());
            this.panMain.setLayout(new GridBagLayout());
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 1, 17, new Insets(10, 10, 10, 0));
            this.panMain.add((Component)this.getPanDeselectedColumns(), gbc);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 0, 15, new Insets(0, 20, 20, 20));
            this.panMain.add((Component)this.getButSelect(), gbc);
            gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 0, 11, new Insets(0, 20, 0, 20));
            this.panMain.add((Component)this.getButDeselect(), gbc);
            gbc = this.setGridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 1, 13, new Insets(10, 0, 10, 10));
            this.panMain.add((Component)this.getPanSelectedColumns(), gbc);
        }
        return this.panMain;
    }

    private JPanel getPanDeselectedColumns() {
        if (this.panDeselectedColumns == null) {
            this.panDeselectedColumns = new TitledPanel(Resource.getInstance().getSpaltenAusblenden());
            this.lstDeselectedColumns = new JList();
            JScrollPane pan = new JScrollPane(this.lstDeselectedColumns);
            pan.setPreferredSize(new Dimension(200, 200));
            this.panDeselectedColumns.add(pan);
        }
        return this.panDeselectedColumns;
    }

    private JPanel getPanSelectedColumns() {
        if (this.panSelectedColumns == null) {
            this.panSelectedColumns = new TitledPanel(Resource.getInstance().getSpaltenEinblenden());
            this.panSelectedColumns.setLayout(new GridBagLayout());
            this.lstSelectedColumns = new JList();
            JScrollPane pan = new JScrollPane(this.lstSelectedColumns);
            pan.setPreferredSize(new Dimension(200, 200));
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 0, 10, new Insets(0, 0, 10, 0));
            this.panSelectedColumns.add((Component)pan, gbc);
            this.butMoveTop = new JButtonEx(ImageCache.getInstance().getIcon("move_top.gif"));
            this.butMoveTop.setName(TOP);
            this.butMoveTop.setPreferredSize(BUTTON_SIZE);
            this.butMoveTop.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 0, 13, new Insets(0, 0, 10, 0));
            this.panSelectedColumns.add((Component)this.butMoveTop, gbc);
            this.butMoveUp = new JButtonEx(ImageCache.getInstance().getIcon("move_up.gif"));
            this.butMoveUp.setName(UP);
            this.butMoveUp.setPreferredSize(BUTTON_SIZE);
            this.butMoveUp.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 13, new Insets(0, 10, 10, 0));
            this.panSelectedColumns.add((Component)this.butMoveUp, gbc);
            this.butMoveDown = new JButtonEx(ImageCache.getInstance().getIcon("move_down.gif"));
            this.butMoveDown.setName(DOWN);
            this.butMoveDown.setPreferredSize(BUTTON_SIZE);
            this.butMoveDown.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 10, 10, 0));
            this.panSelectedColumns.add((Component)this.butMoveDown, gbc);
            this.butMoveBottom = new JButtonEx(ImageCache.getInstance().getIcon("move_bottom.gif"));
            this.butMoveBottom.setName(BOTTOM);
            this.butMoveBottom.setPreferredSize(BUTTON_SIZE);
            this.butMoveBottom.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 0, 17, new Insets(0, 10, 10, 0));
            this.panSelectedColumns.add((Component)this.butMoveBottom, gbc);
        }
        return this.panSelectedColumns;
    }

    private JButton getButSelect() {
        if (this.butSelect == null) {
            this.butSelect = new JButtonEx(ImageCache.getInstance().getIcon("move_right.gif"));
            this.butSelect.setName(SELECT);
            this.butSelect.setPreferredSize(BUTTON_SIZE);
            this.butSelect.addActionListener(this.controller);
        }
        return this.butSelect;
    }

    private JButton getButDeselect() {
        if (this.butDeselect == null) {
            this.butDeselect = new JButtonEx(ImageCache.getInstance().getIcon("move_left.gif"));
            this.butDeselect.setName(DESELECT);
            this.butDeselect.setPreferredSize(BUTTON_SIZE);
            this.butDeselect.addActionListener(this.controller);
        }
        return this.butDeselect;
    }

    private JPanel getPanButtons() {
        if (this.panButtons == null) {
            this.panButtons = new JPanel();
            this.panButtons.setLayout(new GridBagLayout());
            this.butOk = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
            this.butOk.setName(OK);
            this.butOk.addActionListener(this.controller);
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 13, new Insets(10, 0, 10, 20));
            this.panButtons.add((Component)this.butOk, gbc);
            this.butAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
            this.butAbbrechen.setName(ABBRECHEN);
            this.butAbbrechen.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 20, 10, 0));
            this.panButtons.add((Component)this.butAbbrechen, gbc);
        }
        return this.panButtons;
    }

    private void setLocation() {
        Point locOwner = this.getOwner().getLocation();
        Dimension dimOwner = this.getOwner().getSize();
        int xDialog = dimOwner.width / 2 + locOwner.x - DlgTableConfigView.DIALOG_PREFERRED_SIZE.width / 2;
        int yDialog = dimOwner.height / 2 + locOwner.y - DlgTableConfigView.DIALOG_PREFERRED_SIZE.height / 2;
        this.setSize(DIALOG_PREFERRED_SIZE);
        this.setLocation(xDialog, yDialog);
        this.setResizable(false);
    }

    public void updateDialog() {
        this.lstDeselectedColumns.setListData(this.controller.getDeselectedColumns().toArray());
        this.lstSelectedColumns.setListData(this.controller.getSelectedColumns().toArray());
        this.lstDeselectedColumns.updateUI();
        this.lstSelectedColumns.updateUI();
    }

    public JList getSelectedList() {
        return this.lstSelectedColumns;
    }

    public JList getDeselectedList() {
        return this.lstDeselectedColumns;
    }

    protected GridBagConstraints setGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, int anchor, Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        c.insets = insets;
        c.anchor = anchor;
        return c;
    }
}

