/*
 * Decompiled with CFR 0.152.
 */
package webetk;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;

public class ConnectionPool {
    private Vector<Connection> mFreeConnections = new Vector();
    private HashMap<Connection, SQLException> mUsedConnections = new HashMap();
    private int mnMaxConnections;
    private String msDbUser = null;
    private String msDbPwd = null;
    private int mnTimeOut;
    private String msConnectionString = null;
    private static Logger log = Logger.getLogger(ConnectionPool.class);

    public ConnectionPool(String sDbUser, String sDbPwd, String sConString, int nMaxConns, int nInitConns, int nTimeOut) {
        this.msDbUser = sDbUser;
        this.msDbPwd = sDbPwd;
        this.msConnectionString = sConString;
        this.mnMaxConnections = nMaxConns >= nInitConns ? nMaxConns : nInitConns;
        this.mnTimeOut = nTimeOut == 0 ? 5 : nTimeOut;
        String sMsg = "ConnectionPool created with (User: " + sDbUser + ")";
        log.info((Object)sMsg, null);
        sMsg = "Database: " + sConString;
        log.info((Object)sMsg, null);
        sMsg = "MaxCons: " + Integer.toString(nMaxConns) + ", InitCons: " + Integer.toString(nInitConns) + ", TimeOut: " + Integer.toString(nTimeOut);
        log.warn((Object)sMsg, null);
        this.initPool(nInitConns);
    }

    private void initPool(int nInitConns) {
        for (int i = 0; i < nInitConns; ++i) {
            try {
                Connection pc = this.newConnection();
                if (pc == null) {
                    log.error((Object)"Received null connection!", null);
                    break;
                }
                this.mFreeConnections.addElement(pc);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)"Could not create connection!", (Throwable)e);
            }
        }
    }

    public void closeAllConnections() {
        Iterator<Connection> iter = this.mFreeConnections.iterator();
        while (iter.hasNext()) {
            Connection con = iter.next();
            try {
                con.close();
                iter.remove();
            }
            catch (SQLException ex) {
                log.warn((Object)"Could not close free connection!", (Throwable)ex);
            }
        }
        Iterator<Connection> iter1 = this.mUsedConnections.keySet().iterator();
        while (iter1.hasNext()) {
            Connection con = iter1.next();
            try {
                con.close();
                iter1.remove();
            }
            catch (SQLException ex) {
                log.warn((Object)"Could not close used connection!", (Throwable)ex);
            }
        }
    }

    private Connection newConnection() throws SQLException {
        if (this.mUsedConnections.size() + this.mFreeConnections.size() == this.mnMaxConnections) {
            log.warn((Object)("Maximale gleichzeitige DB Verbindungen erreicht! (max:" + this.mnMaxConnections));
            return null;
        }
        Connection conn = null;
        conn = this.msDbUser == null ? DriverManager.getConnection(this.msConnectionString) : DriverManager.getConnection(this.msConnectionString, this.msDbUser, this.msDbPwd);
        conn.setTransactionIsolation(2);
        log.info((Object)"New connection created!", null);
        return conn;
    }

    public Connection getConnection() throws SQLException, DatabaseBusyException {
        log.log((Priority)Level.ALL, (Object)"Request for connection received.", null);
        return this.getConnection(this.mnTimeOut * 1000);
    }

    private synchronized Connection getConnection(long lTimeOut) throws SQLException, DatabaseBusyException {
        long startTime = System.currentTimeMillis();
        long remaining = lTimeOut;
        Connection conn = null;
        while ((conn = this.getPooledConnection()) == null) {
            try {
                log.log((Priority)Level.ALL, (Object)("Waiting for connection! Timeout = " + Long.toString(remaining)));
                this.wait(remaining);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if ((remaining = lTimeOut - (System.currentTimeMillis() - startTime)) > 0L) continue;
            log.error((Object)"Timed out while waiting for connection!");
            throw new DatabaseBusyException("DatabaseBusy");
        }
        conn.setAutoCommit(true);
        this.mUsedConnections.put(conn, new SQLException("Missing connection"));
        log.log((Priority)Level.ALL, (Object)"Delivered Connection from Pool");
        return conn;
    }

    private synchronized Connection getPooledConnection() throws SQLException {
        Connection conn = null;
        if (this.mFreeConnections.size() > 0) {
            conn = this.mFreeConnections.firstElement();
            this.mFreeConnections.removeElementAt(0);
        } else {
            conn = this.newConnection();
        }
        return conn;
    }

    public synchronized void freeConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        if (this.mUsedConnections.size() <= 0) {
            throw new SQLException("unexpected connection returned");
        }
        if (this.mFreeConnections.contains(conn)) {
            throw new SQLException("unexpected connection returned");
        }
        if (this.mUsedConnections.remove(conn) == null) {
            throw new SQLException("unexpected connection returned");
        }
        this.mFreeConnections.addElement(conn);
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.notifyAll();
        log.log((Priority)Level.ALL, (Object)"Connection has been returned to pool.", null);
    }

    public String getFreeDBConnections() {
        return String.valueOf(this.mFreeConnections.size());
    }

    public String getUsedConnections() {
        return String.valueOf(this.mUsedConnections.size());
    }

    public String getTimeout() {
        return String.valueOf(this.mnTimeOut);
    }

    public String getConnectionString() {
        return this.msConnectionString;
    }

    public String getDBUser() {
        return this.msDbUser;
    }

    public int getMaxDatabaseConnections() {
        return this.mnMaxConnections;
    }

    public void setMaxDatabaseConnections(int max) {
        this.mnMaxConnections = max;
    }
}

