/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.Bedingung")
public class Bedingung
implements Comparable<Bedingung>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private boolean mbSchnittstellenBedingung = false;
    @XmlElement
    private boolean mbIsBteBedingung = false;
    @XmlElement
    private boolean mbIsSAZ = false;
    @XmlElement
    private char mcBedingungsOberart = '\u0000';
    @XmlElement
    private String msBedingungsartSS = null;
    @XmlElement
    private Long mlId = null;
    @XmlElement
    private String msCode = null;
    @XmlElement
    private String msName = null;
    @XmlElement
    private String msNameSS = null;
    @XmlElement
    private String msLackArtSS = null;
    @XmlElement
    private String msLackCodeSS = null;
    @XmlElement
    private String msAFPolstercodeSS = null;
    @XmlElement
    private String msAFCodeSS = null;
    private String msSalaArtSS = null;
    @XmlElement
    private String msSalaPrimanummerSS = null;
    @XmlElement
    private String msSalaHZaehlerSS = null;
    @XmlElement
    private String msGruppe = null;
    @XmlElement
    private long mlEGruppenPos = -1L;
    @XmlElement
    private String msSalaPrimanummer = null;
    @XmlElement
    private boolean mbSicherheitsrelevant = false;
    @XmlElement
    private boolean mbHasBedZusatzInfo = false;
    @XmlElement
    private boolean mbShowBedZusatzInfo = true;

    public Bedingung() {
    }

    public Bedingung(Long lId, String sName, String sGruppe, long lEGPos) {
        this.mcBedingungsOberart = (char)84;
        this.msBedingungsartSS = null;
        this.mbSchnittstellenBedingung = false;
        this.mlId = lId;
        this.msCode = "";
        this.msName = sName;
        this.msGruppe = sGruppe;
        this.mlEGruppenPos = lEGPos;
    }

    public Bedingung(Long lId, String sCode, String sName, String sGruppe, long lEGPos, String sPrimanummer) {
        this.mcBedingungsOberart = (char)83;
        this.msBedingungsartSS = null;
        this.mbSchnittstellenBedingung = false;
        this.mlId = lId;
        this.msCode = sCode;
        this.msName = sName;
        this.msGruppe = sGruppe;
        this.mlEGruppenPos = lEGPos;
        this.msSalaPrimanummer = sPrimanummer;
    }

    public Bedingung(Long lId, String sCode, String sName, String sNameSS, String sGruppe, long lEGPos, String sPrimanummer, String sBedArtSchnittstelle) {
        this.mcBedingungsOberart = (char)83;
        this.msBedingungsartSS = sBedArtSchnittstelle;
        this.mbSchnittstellenBedingung = true;
        this.mlId = lId;
        this.msCode = sCode;
        this.msName = sName;
        this.msNameSS = sNameSS;
        this.msGruppe = sGruppe;
        this.mlEGruppenPos = lEGPos;
        this.msSalaPrimanummer = sPrimanummer;
    }

    public Bedingung(String sArt, String sPrimanummer, String sHZaehler, String sNameSS, String sBedArtSchnittstelle) {
        this.mcBedingungsOberart = (char)83;
        this.msBedingungsartSS = sBedArtSchnittstelle;
        this.mbSchnittstellenBedingung = true;
        this.msNameSS = sNameSS;
        this.msSalaArtSS = sArt;
        this.msSalaPrimanummerSS = sPrimanummer;
        this.msSalaHZaehlerSS = sHZaehler;
    }

    public Bedingung(Long lId, String sCode, String sName, String sGruppe, long lEGPos) {
        this.mcBedingungsOberart = (char)65;
        this.msBedingungsartSS = null;
        this.mbSchnittstellenBedingung = false;
        this.mlId = lId;
        this.msCode = sCode;
        this.msName = sName;
        this.msGruppe = sGruppe;
        this.mlEGruppenPos = lEGPos;
    }

    public Bedingung(String sCode, boolean bPolstercode, String sNameSS, String sBedingungsart) {
        this.mcBedingungsOberart = (char)65;
        this.msBedingungsartSS = sBedingungsart;
        this.mbSchnittstellenBedingung = true;
        this.msNameSS = sNameSS;
        if (bPolstercode) {
            this.msAFPolstercodeSS = sCode;
        } else {
            this.msAFCodeSS = sCode;
        }
    }

    public Bedingung(Long lId, String sCode, String sName, String sNameSS, String sGruppe, long lEGPos, String sBedingungsart) {
        this.mcBedingungsOberart = (char)65;
        this.msBedingungsartSS = sBedingungsart;
        this.mbSchnittstellenBedingung = true;
        this.mlId = lId;
        this.msCode = sCode;
        this.msName = sName;
        this.msNameSS = sNameSS;
        this.msGruppe = sGruppe;
        this.mlEGruppenPos = lEGPos;
    }

    public Bedingung(String sLackArt, String sLackCode, String sNameSS) {
        this.mcBedingungsOberart = (char)65;
        this.msBedingungsartSS = "L";
        this.mbSchnittstellenBedingung = true;
        this.msNameSS = sNameSS;
        this.msLackArtSS = sLackArt;
        this.msLackCodeSS = sLackCode;
    }

    public boolean equals(Object oObj) {
        if (oObj instanceof Bedingung) {
            Bedingung oBed = (Bedingung)oObj;
            return this.mcBedingungsOberart == oBed.getBedingungsOberart() && this.mlId == oBed.getId();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.mcBedingungsOberart;
        if (this.mlId != null) {
            long id = this.mlId;
            result = 37 * result + (int)(id ^ id >>> 32);
        }
        return result;
    }

    @Override
    public int compareTo(Bedingung obj) {
        if (!(obj instanceof Bedingung)) {
            throw new IllegalArgumentException();
        }
        return this.compareTo(obj, "btanzeige_ungefiltert");
    }

    public int compareTo(Bedingung bed, String sArtDerAnzeige) {
        if (this.equals(bed)) {
            return 0;
        }
        if (this.getBedingungsOberart() != bed.getBedingungsOberart()) {
            if (this.getBedingungsOberart() == 'T') {
                return 1;
            }
            if (this.getBedingungsOberart() == 'A') {
                return -1;
            }
            if (bed.getBedingungsOberart() == 'T') {
                return -1;
            }
            if (bed.getBedingungsOberart() == 'A') {
                return 1;
            }
        }
        if (this.getBedingungsOberart() == 'A') {
            if (!this.getCode().equals(bed.getCode())) {
                return this.getCode().compareTo(bed.getCode());
            }
            if (!this.getName().equals(bed.getName())) {
                return this.getName().compareTo(bed.getName());
            }
            return this.getId().compareTo(bed.getId());
        }
        if (this.getBedingungsOberart() == 'S') {
            if (!this.getPrimaNummer().equals(bed.getPrimaNummer())) {
                return this.getPrimaNummer().compareTo(bed.getPrimaNummer());
            }
            if (!this.getName().equals(bed.getName())) {
                return this.getName().compareTo(bed.getName());
            }
            return this.getId().compareTo(bed.getId());
        }
        if (this.getBedingungsOberart() == 'T') {
            return this.getName().compareTo(bed.getName());
        }
        return 0;
    }

    public Long getId() {
        return this.mlId;
    }

    public String getCode() {
        return this.msCode;
    }

    public String getName() {
        return this.msName;
    }

    public String getNameSS() {
        return this.msNameSS;
    }

    public boolean isSchnittstellenBed() {
        return this.mbSchnittstellenBedingung;
    }

    public boolean isBteBedingung() {
        return this.mbIsBteBedingung;
    }

    public boolean isSAZ() {
        return this.mbIsSAZ;
    }

    public String getGruppe() {
        return this.msGruppe;
    }

    public boolean isExclusive() {
        return this.msGruppe != null;
    }

    public String getPrimaNummer() {
        return this.msSalaPrimanummer;
    }

    public long getGruppenPosition() {
        return this.mlEGruppenPos;
    }

    public char getBedingungsOberart() {
        return this.mcBedingungsOberart;
    }

    public String getBedingungsartSS() {
        return this.msBedingungsartSS;
    }

    public String getCodeSS() {
        String sCode = null;
        if (this.msBedingungsartSS.equals("AF")) {
            if (this.msAFCodeSS != null) {
                return this.msAFCodeSS;
            }
            return this.msAFPolstercodeSS;
        }
        if (this.msBedingungsartSS.equals("L")) {
            if (this.msLackArtSS != null) {
                sCode = this.msLackArtSS;
            }
            if (this.msLackCodeSS != null) {
                sCode = sCode + this.msLackCodeSS;
            }
            return sCode;
        }
        if (this.msBedingungsartSS.equals("S_SERIE") || this.msBedingungsartSS.equals("S_SONDER") || this.msBedingungsartSS.equals("S_INFORMATION")) {
            if (this.msSalaArtSS != null) {
                sCode = this.msSalaArtSS;
            }
            if (this.msSalaPrimanummerSS != null) {
                sCode = sCode + this.msSalaPrimanummerSS;
            }
            if (this.msSalaHZaehlerSS != null) {
                sCode = sCode + this.msSalaHZaehlerSS;
            }
            return sCode;
        }
        return null;
    }

    public boolean isPolstercodeSS() {
        return this.msAFPolstercodeSS != null;
    }

    public String getLackArtSS() {
        return this.msLackArtSS;
    }

    public String getLackCodeSS() {
        return this.msLackCodeSS;
    }

    public String getAFLCodeSS() {
        if (this.msAFCodeSS != null) {
            return this.msAFCodeSS;
        }
        return this.msAFPolstercodeSS;
    }

    public String getSalaArtSS() {
        return this.msSalaArtSS;
    }

    public String getSalaPrimanummerSS() {
        return this.msSalaPrimanummerSS;
    }

    public String getSalaHZaehlerSS() {
        return this.msSalaHZaehlerSS;
    }

    public boolean isSicherheitsrelevant() {
        return this.mbSicherheitsrelevant;
    }

    public boolean hasBedZusatzInfo() {
        return this.mbHasBedZusatzInfo;
    }

    public boolean showBedZusatzInfo() {
        return this.mbShowBedZusatzInfo;
    }

    public void isSicherheitsrelevant(boolean bSicherheitsrelevant) {
        this.mbSicherheitsrelevant = bSicherheitsrelevant;
    }

    public void showBedZusatzInfo(boolean bShowBedZusatzInfo) {
        this.mbShowBedZusatzInfo = bShowBedZusatzInfo;
    }

    public void isBteBedingung(boolean bIsBteBedingung) {
        this.mbIsBteBedingung = bIsBteBedingung;
    }

    public void isSAZ(boolean bIsSAZ) {
        this.mbIsSAZ = bIsSAZ;
    }

    public void hasBedZusatzInfo(boolean bHasBedZusatzInfo) {
        this.mbHasBedZusatzInfo = bHasBedZusatzInfo;
    }

    public boolean showBed(String sArt, String sAktWert) {
        if (!sArt.equals("ausstattungen")) {
            if (this.mlId < 0L) {
                return false;
            }
            if (this.mbSicherheitsrelevant) {
                return false;
            }
            if (!this.mbIsBteBedingung) {
                return false;
            }
            if (sArt.equals("btanzeige_gefiltert") && this.isExclusive() && sAktWert.equals("2")) {
                return false;
            }
            if (this.mbSchnittstellenBedingung) {
                return this.msBedingungsartSS != null;
            }
        } else {
            if (!this.mbSchnittstellenBedingung) {
                return false;
            }
            if (this.msBedingungsartSS == null) {
                return false;
            }
            if (this.msBedingungsartSS.equals("A") || this.msBedingungsartSS.equals("F")) {
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        Bedingung copy = (Bedingung)super.clone();
        copy.mbSchnittstellenBedingung = this.mbSchnittstellenBedingung;
        copy.mbIsBteBedingung = this.mbIsBteBedingung;
        copy.mbIsSAZ = this.mbIsSAZ;
        copy.mcBedingungsOberart = this.mcBedingungsOberart;
        copy.msBedingungsartSS = this.msBedingungsartSS == null ? null : new String(this.msBedingungsartSS);
        copy.mlId = this.mlId == null ? null : new Long(this.mlId);
        copy.msCode = this.msCode == null ? null : new String(this.msCode);
        copy.msName = this.msName == null ? null : new String(this.msName);
        copy.msNameSS = this.msNameSS == null ? null : new String(this.msNameSS);
        copy.msLackArtSS = this.msLackArtSS == null ? null : new String(this.msLackArtSS);
        copy.msLackCodeSS = this.msLackCodeSS == null ? null : new String(this.msLackCodeSS);
        copy.msAFPolstercodeSS = this.msAFPolstercodeSS == null ? null : new String(this.msAFPolstercodeSS);
        copy.msAFCodeSS = this.msAFCodeSS == null ? null : new String(this.msAFCodeSS);
        copy.msSalaArtSS = this.msSalaArtSS == null ? null : new String(this.msSalaArtSS);
        copy.msSalaPrimanummerSS = this.msSalaPrimanummerSS == null ? null : new String(this.msSalaPrimanummerSS);
        copy.msSalaHZaehlerSS = this.msSalaHZaehlerSS == null ? null : new String(this.msSalaHZaehlerSS);
        copy.msGruppe = this.msGruppe == null ? null : new String(this.msGruppe);
        copy.mlEGruppenPos = this.mlEGruppenPos;
        copy.msSalaPrimanummer = this.msSalaPrimanummer == null ? null : new String(this.msSalaPrimanummer);
        copy.mbSicherheitsrelevant = this.mbSicherheitsrelevant;
        copy.mbHasBedZusatzInfo = this.mbHasBedZusatzInfo;
        copy.mbShowBedZusatzInfo = this.mbShowBedZusatzInfo;
        return copy;
    }

    public Bedingung copy() throws CloneNotSupportedException {
        Object copy = this.clone();
        if (copy instanceof Bedingung) {
            return (Bedingung)copy;
        }
        throw new CloneNotSupportedException("Not an instance of class " + this.getClass().getName());
    }

    public boolean isMbSchnittstellenBedingung() {
        return this.mbSchnittstellenBedingung;
    }

    public void setMbSchnittstellenBedingung(boolean mbSchnittstellenBedingung) {
        this.mbSchnittstellenBedingung = mbSchnittstellenBedingung;
    }

    public boolean isMbIsBteBedingung() {
        return this.mbIsBteBedingung;
    }

    public void setMbIsBteBedingung(boolean mbIsBteBedingung) {
        this.mbIsBteBedingung = mbIsBteBedingung;
    }

    public boolean isMbIsSAZ() {
        return this.mbIsSAZ;
    }

    public void setMbIsSAZ(boolean mbIsSAZ) {
        this.mbIsSAZ = mbIsSAZ;
    }

    public char getMcBedingungsOberart() {
        return this.mcBedingungsOberart;
    }

    public void setMcBedingungsOberart(char mcBedingungsOberart) {
        this.mcBedingungsOberart = mcBedingungsOberart;
    }

    public String getMsBedingungsartSS() {
        return this.msBedingungsartSS;
    }

    public void setMsBedingungsartSS(String msBedingungsartSS) {
        this.msBedingungsartSS = msBedingungsartSS;
    }

    public Long getMlId() {
        return this.mlId;
    }

    public void setMlId(Long mlId) {
        this.mlId = mlId;
    }

    public String getMsCode() {
        return this.msCode;
    }

    public void setMsCode(String msCode) {
        this.msCode = msCode;
    }

    public String getMsName() {
        return this.msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    public String getMsNameSS() {
        return this.msNameSS;
    }

    public void setMsNameSS(String msNameSS) {
        this.msNameSS = msNameSS;
    }

    public String getMsLackArtSS() {
        return this.msLackArtSS;
    }

    public void setMsLackArtSS(String msLackArtSS) {
        this.msLackArtSS = msLackArtSS;
    }

    public String getMsLackCodeSS() {
        return this.msLackCodeSS;
    }

    public void setMsLackCodeSS(String msLackCodeSS) {
        this.msLackCodeSS = msLackCodeSS;
    }

    public String getMsAFPolstercodeSS() {
        return this.msAFPolstercodeSS;
    }

    public void setMsAFPolstercodeSS(String msAFPolstercodeSS) {
        this.msAFPolstercodeSS = msAFPolstercodeSS;
    }

    public String getMsAFCodeSS() {
        return this.msAFCodeSS;
    }

    public void setMsAFCodeSS(String msAFCodeSS) {
        this.msAFCodeSS = msAFCodeSS;
    }

    public String getMsSalaArtSS() {
        return this.msSalaArtSS;
    }

    public void setMsSalaArtSS(String msSalaArtSS) {
        this.msSalaArtSS = msSalaArtSS;
    }

    public String getMsSalaPrimanummerSS() {
        return this.msSalaPrimanummerSS;
    }

    public void setMsSalaPrimanummerSS(String msSalaPrimanummerSS) {
        this.msSalaPrimanummerSS = msSalaPrimanummerSS;
    }

    public String getMsSalaHZaehlerSS() {
        return this.msSalaHZaehlerSS;
    }

    public void setMsSalaHZaehlerSS(String msSalaHZaehlerSS) {
        this.msSalaHZaehlerSS = msSalaHZaehlerSS;
    }

    public String getMsGruppe() {
        return this.msGruppe;
    }

    public void setMsGruppe(String msGruppe) {
        this.msGruppe = msGruppe;
    }

    public long getMlEGruppenPos() {
        return this.mlEGruppenPos;
    }

    public void setMlEGruppenPos(long mlEGruppenPos) {
        this.mlEGruppenPos = mlEGruppenPos;
    }

    public String getMsSalaPrimanummer() {
        return this.msSalaPrimanummer;
    }

    public void setMsSalaPrimanummer(String msSalaPrimanummer) {
        this.msSalaPrimanummer = msSalaPrimanummer;
    }

    public boolean isMbSicherheitsrelevant() {
        return this.mbSicherheitsrelevant;
    }

    public void setMbSicherheitsrelevant(boolean mbSicherheitsrelevant) {
        this.mbSicherheitsrelevant = mbSicherheitsrelevant;
    }

    public boolean isMbHasBedZusatzInfo() {
        return this.mbHasBedZusatzInfo;
    }

    public void setMbHasBedZusatzInfo(boolean mbHasBedZusatzInfo) {
        this.mbHasBedZusatzInfo = mbHasBedZusatzInfo;
    }

    public boolean isMbShowBedZusatzInfo() {
        return this.mbShowBedZusatzInfo;
    }

    public void setMbShowBedZusatzInfo(boolean mbShowBedZusatzInfo) {
        this.mbShowBedZusatzInfo = mbShowBedZusatzInfo;
    }
}

