/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.basesuche;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.app.SearchBTETeile;
import webetk.app.SucheInfo;
import webetk.framework.ServerSessionInfo;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class BaseBegriffSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String msSuchbegriff;
    protected Collection<String> mcBegriffePlus;
    protected Collection<String> mcBegriffeMinus;
    protected Collection<String> mcBegriffeOder;

    public BaseBegriffSuche() {
    }

    public BaseBegriffSuche(String sBegriff) throws InvalidInitializationException {
        this.mcBegriffePlus = new Vector<String>();
        this.mcBegriffeMinus = new Vector<String>();
        this.mcBegriffeOder = new Vector<String>();
        this.msSuchbegriff = sBegriff = this.aufbereitenBegriff(sBegriff);
        while (!sBegriff.equals("")) {
            int nCount;
            char cHelp1 = sBegriff.charAt(0);
            if (cHelp1 == ' ') {
                sBegriff = sBegriff.substring(1);
                continue;
            }
            String sTerm = "";
            int nIndex = 0;
            if (cHelp1 == '+' || cHelp1 == '-') {
                if (sBegriff.length() == 1) {
                    sBegriff = "";
                    continue;
                }
                char cHelp2 = (sBegriff = sBegriff.substring(1)).charAt(0);
                if (cHelp2 == '\'') {
                    sBegriff = sBegriff.substring(1);
                    nIndex = sBegriff.indexOf("'");
                } else {
                    nIndex = this.getIndex(sBegriff);
                }
                if (nIndex != -1) {
                    sTerm = sBegriff.substring(0, nIndex);
                    sBegriff = sBegriff.substring(nIndex + 1);
                } else {
                    sTerm = sBegriff;
                    sBegriff = "";
                }
                int nCount2 = this.countCharNotEqual(sTerm, '*');
                if (nCount2 < 3) {
                    throw new InvalidInitializationException("Suchterm mu\u00df mindestens 3-stellig angegeben werden!");
                }
                if (sTerm.charAt(sTerm.length() - 1) != '*') {
                    sTerm = sTerm + "*";
                }
                if (sTerm.charAt(0) != '*') {
                    sTerm = "*" + sTerm;
                }
                if (cHelp1 == '+') {
                    this.mcBegriffePlus.add(sTerm);
                    continue;
                }
                this.mcBegriffeMinus.add(sTerm);
                continue;
            }
            if (cHelp1 == '\'') {
                nIndex = (sBegriff = sBegriff.substring(1)).indexOf("'");
                if (nIndex != -1) {
                    sTerm = sBegriff.substring(0, nIndex);
                    sBegriff = sBegriff.substring(nIndex + 1);
                } else {
                    sTerm = sBegriff;
                    sBegriff = "";
                }
                nCount = this.countCharNotEqual(sTerm, '*');
                if (nCount < 3) {
                    throw new InvalidInitializationException("Suchterm mu\u00df mindestens 3-stellig angegeben werden!");
                }
                if (sTerm.charAt(sTerm.length() - 1) != '*') {
                    sTerm = sTerm + "*";
                }
                this.mcBegriffeOder.add(sTerm);
                continue;
            }
            nIndex = this.getIndex(sBegriff);
            if (nIndex != -1) {
                sTerm = sBegriff.substring(0, nIndex);
                sBegriff = sBegriff.substring(nIndex);
            } else {
                sTerm = sBegriff;
                sBegriff = "";
            }
            nCount = this.countCharNotEqual(sTerm, '*');
            if (nCount < 3) {
                throw new InvalidInitializationException("Suchterm mu\u00df mindestens 3-stellig angegeben werden!");
            }
            if (sTerm.charAt(sTerm.length() - 1) != '*') {
                sTerm = sTerm + "*";
            }
            this.mcBegriffeOder.add(sTerm);
        }
        if (!this.mcBegriffePlus.isEmpty() || !this.mcBegriffeMinus.isEmpty()) {
            this.mcBegriffeOder.clear();
        }
    }

    @Override
    public abstract int performSearch(SucheInfo var1, String var2, ServerSessionInfo var3) throws SQLException, DatabaseBusyException;

    private String aufbereitenBegriff(String sBegriff) {
        if (sBegriff.equals("")) {
            return sBegriff;
        }
        int nLengthAlt = sBegriff.length();
        int nLengthNeu = 0;
        while (nLengthNeu != nLengthAlt) {
            nLengthAlt = sBegriff.length();
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "  ", " ");
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "+ ", "+");
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "++", "+");
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "- ", "-");
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "--", "-");
            sBegriff = StringUtils.substituteStringStraight(sBegriff, "**", "*");
            nLengthNeu = sBegriff.length();
        }
        nLengthAlt = sBegriff.length();
        nLengthNeu = 0;
        while (nLengthNeu != nLengthAlt) {
            nLengthAlt = sBegriff.length();
            char cFirst = sBegriff.charAt(0);
            if (cFirst == ' ') {
                sBegriff = sBegriff.substring(1);
            }
            nLengthNeu = sBegriff.length();
        }
        nLengthAlt = sBegriff.length();
        nLengthNeu = 0;
        while (nLengthNeu != nLengthAlt) {
            nLengthAlt = sBegriff.length();
            char cLast = sBegriff.charAt(nLengthAlt - 1);
            if (cLast == '+' || cLast == '-' || cLast == ' ') {
                sBegriff = sBegriff.substring(0, nLengthAlt - 2);
            }
            nLengthNeu = sBegriff.length();
        }
        return sBegriff;
    }

    private int getIndex(String sString) {
        if (sString.equals("")) {
            return -1;
        }
        int nIndex = 0;
        int nIndexPl = sString.indexOf("+");
        int nIndexMi = sString.indexOf(" -");
        int nIndexBl = sString.indexOf(" ");
        if (nIndexPl == -1 && nIndexMi == -1 && nIndexBl == -1) {
            return -1;
        }
        if (nIndexPl == -1) {
            nIndexPl = 10000000;
        }
        if (nIndexMi == -1) {
            nIndexMi = 10000000;
        }
        if (nIndexBl == -1) {
            nIndexBl = 10000000;
        }
        nIndex = Math.min(nIndexPl, nIndexMi);
        nIndex = Math.min(nIndex, nIndexBl);
        return nIndex;
    }

    private int countCharNotEqual(String sString, char cChar) {
        int nCount = 0;
        for (int i = 0; i < sString.length(); ++i) {
            if (sString.charAt(i) == cChar) continue;
            ++nCount;
        }
        return nCount;
    }
}

