/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.BTVerweisZeile;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.Textteil;
import webetk.app.bteanzeige.Zeile;

public class BteZeilen {
    private int mnTitelCounter = 0;
    private int mnRowCounter = 0;
    private String msHighlightBnb = "";
    private String msScrollTarget = null;
    private String msScrollTargetBNr = null;
    private boolean mbHighlightDone = false;
    private boolean mbHighlightStarted = false;
    private Collection mcZeilen = null;
    private transient Iterator miZeilen = null;
    private Collection maHighlightSachnummern = new Vector();
    private boolean mbScrollToSachnummer = true;
    private AbstractZeile moZeile = null;
    private static Logger log = Logger.getLogger(BteZeilen.class);

    public BteZeilen(Textteil currBteTextteil) {
        this.initialize(currBteTextteil);
    }

    private void logStatus(String sPosition) {
        String sZeilenId = "null";
        String sNumberOfZeilen = "None";
        if (this.mcZeilen != null) {
            sZeilenId = this.mcZeilen.toString();
            sNumberOfZeilen = Integer.toString(this.mcZeilen.size());
        }
        String sCurrentCounter = Integer.toString(this.mnRowCounter);
        String sZeilenType = "Type of Zeile: ";
        String sZeilenInfo = "";
        if (this.moZeile == null) {
            sZeilenType = sZeilenType + "null";
            sZeilenInfo = "not applicable";
        } else if (this.moZeile instanceof Zeile) {
            sZeilenType = sZeilenType + "Zeile";
            sZeilenInfo = ((Zeile)this.moZeile).toString();
        } else if (this.moZeile instanceof KommZeile) {
            sZeilenType = sZeilenType + "KommZeile";
            sZeilenInfo = ((KommZeile)this.moZeile).toString();
        } else if (this.moZeile instanceof BTVerweisZeile) {
            sZeilenType = sZeilenType + "BTVerweisZeile";
            sZeilenInfo = ((BTVerweisZeile)this.moZeile).toString();
        } else {
            sZeilenType = sZeilenType + "unknown";
            sZeilenInfo = "not applicable";
        }
        log.debug((Object)"##-------------------------------------##");
        log.debug((Object)("Zeilen-Counter     : " + sCurrentCounter));
        log.debug((Object)("Number of Zeilen   : " + sNumberOfZeilen));
        log.debug((Object)("Current Zeilen-ID  : " + sZeilenId));
        log.debug((Object)("Current Zeilen-Type: " + sZeilenType));
        log.debug((Object)("Current Zeilen-Info: " + sZeilenInfo));
        log.debug((Object)"##-------------------------------------##");
    }

    public boolean isEmpty() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0;
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    public int getRowNumber() {
        return this.mnRowCounter;
    }

    public boolean isTitel() {
        return this.mnTitelCounter == 0;
    }

    public boolean isKommentarZeile() {
        return this.moZeile != null && this.moZeile instanceof KommZeile;
    }

    public boolean isBTVerweisZeile() {
        return this.moZeile != null && this.moZeile instanceof BTVerweisZeile;
    }

    public String getText() {
        if (this.moZeile == null) {
            return "";
        }
        if (this.moZeile instanceof Zeile) {
            return ((Zeile)this.moZeile).getTeilebenennung();
        }
        if (this.moZeile instanceof KommZeile) {
            return ((KommZeile)this.moZeile).getText();
        }
        if (this.moZeile instanceof BTVerweisZeile) {
            return ((BTVerweisZeile)this.moZeile).getText();
        }
        return "";
    }

    public boolean isScrollTarget(boolean bClear) {
        if (this.maHighlightSachnummern.size() > 0 && this.mbScrollToSachnummer) {
            for (String sHighlightSachnummer : this.maHighlightSachnummern) {
                if (!sHighlightSachnummer.equals(this.getSachnummer())) continue;
                this.mbScrollToSachnummer = false;
                return true;
            }
        }
        if (this.msScrollTarget == null) {
            return false;
        }
        try {
            int nScrollTarget = Integer.parseInt(this.msScrollTarget);
            return this.mnRowCounter == nScrollTarget;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Illegal Scroll Target:" + this.msScrollTarget), (Throwable)e);
            return false;
        }
    }

    public boolean hasScrollTarget() {
        return this.msScrollTarget != null;
    }

    public String getKompSign() {
        try {
            Zeile oZ = (Zeile)this.moZeile;
            if (!oZ.isKomprimierungszeile()) {
                return "S";
            }
            if (oZ.isKomprimiert()) {
                return "C";
            }
            return "E";
        }
        catch (Exception e) {
            return "S";
        }
    }

    public boolean hasTeileInfo() {
        if (this.moZeile == null || this.moZeile instanceof KommZeile || this.moZeile instanceof BTVerweisZeile) {
            return false;
        }
        return !((Zeile)this.moZeile).isKomprimierungszeile();
    }

    public String getMenge() {
        try {
            return ((Zeile)this.moZeile).getMenge();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEinsatzdatum() {
        try {
            return ((Zeile)this.moZeile).getEinsatzdatum();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getAuslaufdatum() {
        try {
            return ((Zeile)this.moZeile).getAuslaufdatum();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getKatalysator() {
        try {
            return ((Zeile)this.moZeile).getKatalysator();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getGetriebe() {
        try {
            return ((Zeile)this.moZeile).getGetriebe();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLenkung() {
        try {
            return ((Zeile)this.moZeile).getLenkung();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getTeilenummer() {
        try {
            return ((Zeile)this.moZeile).getTeilenummer(true);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getSachnummer() {
        try {
            return ((Zeile)this.moZeile).getSachnummer(false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean getSatzteilIndikator() {
        try {
            return ((Zeile)this.moZeile).getSatzteilIndikator();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hatChangepoints() {
        try {
            return ((Zeile)this.moZeile).hatChangepoints();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getAustausch() {
        try {
            return ((Zeile)this.moZeile).getAustausch();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getTechnischeInfo() {
        try {
            return ((Zeile)this.moZeile).getTechnischeInfo();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getMMG() {
        try {
            return ((Zeile)this.moZeile).getMMG();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEMG() {
        try {
            return ((Zeile)this.moZeile).getEMG();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean highlightingPerformed() {
        return this.mbHighlightDone;
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = (AbstractZeile)this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error((Object)"Store object in row collection is no AbstractRow!", (Throwable)e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
        this.mnTitelCounter = 0;
        this.mnRowCounter = 1;
        this.mbHighlightDone = false;
        this.mbHighlightStarted = false;
        this.logStatus("BteZeilen.first");
    }

    public boolean next() {
        if (this.mbHighlightStarted) {
            this.mbHighlightDone = true;
        }
        if (this.hasNext()) {
            try {
                this.moZeile = (AbstractZeile)this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Store object in row collection is no AbstractRow!", (Throwable)e);
                this.moZeile = null;
                return false;
            }
            if (++this.mnTitelCounter == 15) {
                this.mnTitelCounter = 0;
            }
            ++this.mnRowCounter;
            return true;
        }
        log.log((Priority)Level.ALL, (Object)"No more Zeilen.");
        return false;
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public String getId() {
        if (this.moZeile == null) {
            return "";
        }
        if (this.moZeile instanceof Zeile) {
            return ((Zeile)this.moZeile).getId();
        }
        if (this.moZeile instanceof KommZeile) {
            return "";
        }
        if (this.moZeile instanceof BTVerweisZeile) {
            return "";
        }
        return null;
    }

    public String getZusatz() {
        if (this.moZeile == null) {
            return "";
        }
        if (this.moZeile instanceof Zeile) {
            return ((Zeile)this.moZeile).getZusatz();
        }
        if (this.moZeile instanceof KommZeile) {
            return ((KommZeile)this.moZeile).getZusatz();
        }
        return "";
    }

    public String getBTENummer() {
        if (this.moZeile == null) {
            return "";
        }
        if (this.moZeile instanceof BTVerweisZeile) {
            return ((BTVerweisZeile)this.moZeile).getBTENummer();
        }
        return "";
    }

    public boolean getDarstellungFett() {
        try {
            return ((KommZeile)this.moZeile).getDarstellung().equals("F");
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBildnummer() {
        try {
            return ((Zeile)this.moZeile).getBildnummer();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void initialize(Textteil currBteTextteil) {
        if (currBteTextteil == null) {
            this.mcZeilen = null;
            this.msHighlightBnb = "";
            this.msScrollTarget = null;
            this.msScrollTargetBNr = null;
            log.info((Object)"Given BTE is null! (Init?)");
            return;
        }
        this.mcZeilen = currBteTextteil.getZeilen();
        if (this.mcZeilen == null) {
            log.info((Object)"The Zeilen collection is null!");
        } else {
            this.miZeilen = this.mcZeilen.iterator();
        }
        this.mnTitelCounter = 0;
        this.mnRowCounter = 0;
        this.msScrollTarget = currBteTextteil.getScrollTarget();
        this.msScrollTargetBNr = currBteTextteil.getScrollTargetBNr();
        this.mbScrollToSachnummer = true;
        this.maHighlightSachnummern.clear();
        this.msHighlightBnb = currBteTextteil.getHighlight();
        if (this.msHighlightBnb == null) {
            this.msHighlightBnb = "";
        }
        this.mbHighlightDone = false;
        this.mbHighlightStarted = false;
        this.logStatus("BteZeilen Constructor");
    }
}

