/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgid;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.Bedingung;
import webetk.app.ComplexTypeAdapter;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgid.ZusatzInfo;
import webetk.db.dbaccess.FzgIdDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BedZusatzInfo
extends ZusatzInfo {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Collection<Vector<String>> mcKommentare = new Vector<Vector<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Collection<Bedingung> cFzgBedingungen, String sISO, String sRegISO) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        this.mcKommentare = new Vector<Vector<String>>();
        String sFzgBed = "";
        for (Bedingung oBed : cFzgBedingungen) {
            if (!oBed.hasBedZusatzInfo() || !oBed.showBedZusatzInfo()) continue;
            if (sFzgBed.length() > 0) {
                sFzgBed = sFzgBed + ", ";
            }
            sFzgBed = sFzgBed + String.valueOf(oBed.getId());
        }
        if (sFzgBed.length() == 0) {
            return;
        }
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("BedZusatzInfo.load");
            res = FzgIdDbAccess.getBedZusatzInfo(con, sISO, sRegISO, sFzgBed);
            int nOldKommId = 0;
            Vector<String> cKomZeilen = null;
            while (res != null && res.next()) {
                int nKommId = res.getInt("KommId");
                String sBen = res.getString("Ben");
                if (nKommId != nOldKommId) {
                    if (cKomZeilen != null) {
                        this.mcKommentare.add(cKomZeilen);
                    }
                    nOldKommId = nKommId;
                    cKomZeilen = new Vector<String>();
                }
                cKomZeilen.add(sBen);
            }
            if (cKomZeilen != null) {
                this.mcKommentare.add(cKomZeilen);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BedZusatzInfo.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BedZusatzInfo.load");
    }

    public boolean hatInfotexte() {
        return this.mcKommentare != null && !this.mcKommentare.isEmpty();
    }

    public Collection<Vector<String>> getKommentare() {
        return this.mcKommentare;
    }

    public Collection<String> getKommentarZeilen() {
        Vector<String> cRet = new Vector<String>();
        boolean bFirst = true;
        Iterator<Vector<String>> iter = this.mcKommentare.iterator();
        while (iter.hasNext()) {
            if (!bFirst) {
                cRet.add("");
            } else {
                bFirst = false;
            }
            Collection cZeilen = iter.next();
            cRet.addAll(cZeilen);
        }
        return cRet;
    }
}

