/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.hilfe;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.HilfeDbAccess;

public class VersionInfo {
    private static Logger log = Logger.getLogger(VersionInfo.class);
    private String msDBErzeugt = null;
    private String msDBVersion = null;
    private String msApplVersion = null;

    public VersionInfo() throws SQLException, DatabaseBusyException {
        this.performLoad();
        this.msApplVersion = ServerGlobalObjects.getInstance().getApplicationInfo();
    }

    public String getDBVersion() {
        return this.msDBVersion;
    }

    public String getDBErzeugt() {
        return this.msDBErzeugt;
    }

    public String getApplVersion() {
        return this.msApplVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLoad() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("VersionInfo.performLoadDB");
            log.debug((Object)"Loading Information...");
            res = HilfeDbAccess.retrieveVersionInfo(con);
            while (res != null && res.next()) {
                String sInfo = res.getString("Info");
                String sWert = res.getString("Wert");
                if (sInfo.equals("DB_DATEN_VOM")) {
                    long lDBErzeugt = Long.parseLong(sWert);
                    this.msDBErzeugt = lDBErzeugt == 0L ? "" : WebetkUtils.getStringFromDate(WebetkUtils.getDateFromLong(lDBErzeugt), "de", 2);
                }
                if (!sInfo.equals("DB_VERSION")) continue;
                this.msDBVersion = sWert;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "VersionInfo.performLoadDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "VersionInfo.performLoadDB");
    }
}

