/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Funktionsrecht;
import webetk.db.dbaccess.KonfigurationDbAccess;

public class Funktionsrechte {
    private static Logger log = Logger.getLogger(Funktionsrechte.class);
    private String msIso;
    private String msRegIso;
    private String msFirmaId;
    private String msUserId;
    private Vector<Funktionsrecht> mcFunktionsrechte;

    public Funktionsrechte(String sIso, String sRegIso) {
        this.msIso = sIso;
        this.msRegIso = sRegIso;
        this.mcFunktionsrechte = new Vector();
    }

    public Funktionsrechte(String sFirmaId, String sUserId, Vector<Funktionsrecht> cFunktionsrechte, String sIso, String sRegIso) {
        this.msFirmaId = sFirmaId;
        this.msUserId = sUserId;
        this.msIso = sIso;
        this.msRegIso = sRegIso;
        this.mcFunktionsrechte = cFunktionsrechte == null ? new Vector() : cFunktionsrechte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFunktionsrechte() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Funktionsrechte");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Funktionsrechte.load");
            res = KonfigurationDbAccess.loadFunktionsrechte(con, this.msIso, this.msRegIso);
            if (res != null) {
                while (res.next()) {
                    String sText = res.getString("Text");
                    String sBezeichnung = res.getString("Bezeichnung");
                    this.mcFunktionsrechte.add(new Funktionsrecht(sBezeichnung, sText));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Funktionsrechte.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Funktionsrechte.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNutzerFunktionsrechte() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Funktionsrechte");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Funktionsrechte.load");
            res = KonfigurationDbAccess.loadNutzerFunktionsrechte(con, this.msFirmaId, this.msUserId, this.msIso, this.msRegIso);
            if (res != null) {
                while (res.next()) {
                    String sText = res.getString("Text");
                    String sBezeichnung = res.getString("Bezeichnung");
                    this.mcFunktionsrechte.add(new Funktionsrecht(sBezeichnung, sText));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Funktionsrechte.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Funktionsrechte.load");
    }

    public Vector<Funktionsrecht> getFunktionsrechte() {
        return this.mcFunktionsrechte;
    }

    public void store(Connection con) throws SQLException, DatabaseBusyException {
        log.info((Object)"Store Funktionsrechte");
        KonfigurationDbAccess.storeNutzerFunktionsrechte(con, this.msFirmaId, this.msUserId, this.mcFunktionsrechte);
    }

    public boolean hatFunktionsrecht(String sRechtName) {
        if (this.mcFunktionsrechte == null) {
            return false;
        }
        for (Funktionsrecht oRecht : this.mcFunktionsrechte) {
            if (!oRecht.getBezeichnung().equals(sRechtName)) continue;
            return true;
        }
        return false;
    }
}

