/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.KonfigurationDbAccess;

@XmlRootElement(name="KonfigurationETK")
@XmlType(name="webetk.app.konfiguration.Konfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Konfiguration
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Konfiguration.class);
    private String msHaendleranschriftZeile1 = null;
    private String msHaendleranschriftZeile2 = null;
    private String msHaendleranschriftZeile3 = null;
    private String msHaendleranschriftPLZ = null;
    private String msHaendleranschriftOrt = null;
    private String msHaendleranschriftTelefon = null;
    private String msHaendlernummerPKW = null;
    private String msHaendlernummerMotorrad = null;
    private String msMWStSatzNiedrig = null;
    private String msMWStSatzHoch = null;
    private String msMWStSatzAltteile = null;
    private String msMWStSatz3 = null;
    private String msMWStSatz4 = null;
    private String msRechnungsnummer = null;
    private String msStandardBarVerkaufsNummer = null;
    private String msStandardAuftragsNummer = null;
    private String msStandardKundenNummer = null;
    private String msMailserver = null;
    private String msDMSSchnittstelleVerwenden = null;
    private String msAbwicklung = null;
    private String msBestandFiliale = null;
    private String msDatenabgleich = null;
    private String msFirma = null;
    private String msFiliale = null;

    Konfiguration() {
    }

    public Konfiguration(String sFirma, String sFiliale) {
        this.msFirma = sFirma;
        this.msFiliale = sFiliale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadKonfiguration() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Konfiguration.loadKonfiguration");
            log.debug((Object)"Loading Konfiguration...");
            res = KonfigurationDbAccess.loadKonfiguration(con, this.msFirma, this.msFiliale);
            if (res != null && res.next()) {
                this.msHaendleranschriftZeile1 = res.getString("Firma");
                this.msHaendleranschriftZeile2 = res.getString("Zusatz");
                this.msHaendleranschriftZeile3 = res.getString("Strasse");
                this.msHaendleranschriftPLZ = res.getString("Plz");
                this.msHaendleranschriftOrt = res.getString("Ort");
                this.msHaendleranschriftTelefon = res.getString("Telefon");
                this.msHaendlernummerPKW = res.getString("Pkw");
                this.msHaendlernummerMotorrad = res.getString("Motorrad");
                this.msMWStSatzNiedrig = res.getString("MwstNiedrig");
                this.msMWStSatzHoch = res.getString("MwstHoch");
                this.msMWStSatzAltteile = res.getString("MwstAltteile");
                this.msMWStSatz3 = res.getString("Mwst3");
                this.msMWStSatz4 = res.getString("Mwst4");
                this.msRechnungsnummer = res.getString("RechnungsNr");
                this.msStandardBarVerkaufsNummer = res.getString("BarverkaufsNr");
                this.msStandardAuftragsNummer = res.getString("AuftragsNr");
                this.msStandardKundenNummer = res.getString("KundenNr");
                this.msMailserver = res.getString("Mailserver");
                this.msDMSSchnittstelleVerwenden = res.getString("Verwenden");
                this.msAbwicklung = res.getString("Abwicklung");
                this.msBestandFiliale = res.getString("Bestandfiliale");
                this.msDatenabgleich = res.getString("Datenabgleich");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Konfiguration.loadKonfiguration");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Konfiguration.loadKonfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKonfiguration() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Konfiguration.saveKonfiguration");
            log.debug((Object)"Saving Konfiguration...");
            KonfigurationDbAccess.saveKonfiguration(con, this.msFirma, this.msFiliale, this);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Konfiguration.saveKonfiguration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrementRechungsnummer(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            long lRechungsnummer;
            con = gObj.getDBConnectionNutzer("Konfiguration.incrementRechungsnummer");
            long l = lRechungsnummer = KonfigurationDbAccess.incrementRechungsnummer(con, sFirma, sFiliale);
            return l;
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Konfiguration.incrementRechungsnummer");
        }
    }

    public String getHaendleranschriftZeile1() {
        if (this.msHaendleranschriftZeile1 == null || this.msHaendleranschriftZeile1.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftZeile1;
    }

    public String getHaendleranschriftZeile2() {
        if (this.msHaendleranschriftZeile2 == null || this.msHaendleranschriftZeile2.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftZeile2;
    }

    public String getHaendleranschriftZeile3() {
        if (this.msHaendleranschriftZeile3 == null || this.msHaendleranschriftZeile3.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftZeile3;
    }

    public String getHaendleranschriftPLZ() {
        if (this.msHaendleranschriftPLZ == null || this.msHaendleranschriftPLZ.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftPLZ;
    }

    public String getHaendleranschriftOrt() {
        if (this.msHaendleranschriftOrt == null || this.msHaendleranschriftOrt.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftOrt;
    }

    public String getHaendleranschriftTelefon() {
        if (this.msHaendleranschriftTelefon == null || this.msHaendleranschriftTelefon.equalsIgnoreCase("")) {
            return "";
        }
        return this.msHaendleranschriftTelefon;
    }

    public String getHaendlernummerPKW() {
        if (this.msHaendlernummerPKW == null || this.msHaendlernummerPKW.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msHaendlernummerPKW;
    }

    public String getHaendlernummerMotorrad() {
        if (this.msHaendlernummerMotorrad == null || this.msHaendlernummerMotorrad.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msHaendlernummerMotorrad;
    }

    public String getMWStSatzNiedrig() {
        if (this.msMWStSatzNiedrig == null || this.msMWStSatzNiedrig.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMWStSatzNiedrig;
    }

    public String getMWStSatzHoch() {
        if (this.msMWStSatzHoch == null || this.msMWStSatzHoch.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMWStSatzHoch;
    }

    public String getMWStSatzAltteile() {
        if (this.msMWStSatzAltteile == null || this.msMWStSatzAltteile.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMWStSatzAltteile;
    }

    public String getMWStSatz3() {
        if (this.msMWStSatz3 == null || this.msMWStSatz3.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMWStSatz3;
    }

    public String getMWStSatz4() {
        if (this.msMWStSatz4 == null || this.msMWStSatz4.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMWStSatz4;
    }

    public String getRechnungsnummer() {
        if (this.msRechnungsnummer == null || this.msRechnungsnummer.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msRechnungsnummer;
    }

    public String getStandardBarVerkaufsNummer() {
        if (this.msStandardBarVerkaufsNummer == null || this.msStandardBarVerkaufsNummer.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msStandardBarVerkaufsNummer;
    }

    public String getStandardAuftragsNummer() {
        if (this.msStandardAuftragsNummer == null || this.msStandardAuftragsNummer.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msStandardAuftragsNummer;
    }

    public String getStandardKundenNummer() {
        if (this.msStandardKundenNummer == null || this.msStandardKundenNummer.equalsIgnoreCase("")) {
            return "0";
        }
        return this.msStandardKundenNummer;
    }

    public String getMailserver() {
        if (this.msMailserver == null || this.msMailserver.equalsIgnoreCase("")) {
            return "";
        }
        return this.msMailserver;
    }

    public String getDMSSchnittstelleVerwenden() {
        if (this.msDMSSchnittstelleVerwenden == null || this.msDMSSchnittstelleVerwenden.equalsIgnoreCase("")) {
            return "";
        }
        return this.msDMSSchnittstelleVerwenden;
    }

    public String getAbwicklung() {
        if (this.msAbwicklung == null || this.msAbwicklung.equalsIgnoreCase("")) {
            return "";
        }
        return this.msAbwicklung;
    }

    public String getBestandFiliale() {
        if (this.msBestandFiliale == null || this.msBestandFiliale.equalsIgnoreCase("")) {
            return "";
        }
        return this.msBestandFiliale;
    }

    public String getDatenabgleich() {
        if (this.msDatenabgleich == null || this.msDatenabgleich.equalsIgnoreCase("")) {
            return "";
        }
        return this.msDatenabgleich;
    }

    public void setHaendleranschriftZeile1(String sHaendleranschriftZeile1) {
        this.msHaendleranschriftZeile1 = sHaendleranschriftZeile1;
    }

    public void setHaendleranschriftZeile2(String sHaendleranschriftZeile2) {
        this.msHaendleranschriftZeile2 = sHaendleranschriftZeile2;
    }

    public void setHaendleranschriftZeile3(String sHaendleranschriftZeile3) {
        this.msHaendleranschriftZeile3 = sHaendleranschriftZeile3;
    }

    public void setHaendleranschriftPLZ(String sHaendleranschriftPLZ) {
        this.msHaendleranschriftPLZ = sHaendleranschriftPLZ;
    }

    public void setHaendleranschriftOrt(String sHaendleranschriftOrt) {
        this.msHaendleranschriftOrt = sHaendleranschriftOrt;
    }

    public void setHaendleranschriftTelefon(String sHaendleranschriftTelefon) {
        this.msHaendleranschriftTelefon = sHaendleranschriftTelefon;
    }

    public void setHaendlernummerPKW(String sHaendlernummerPKW) {
        this.msHaendlernummerPKW = sHaendlernummerPKW;
    }

    public void setHaendlernummerMotorrad(String sHaendlernummerMotorrad) {
        this.msHaendlernummerMotorrad = sHaendlernummerMotorrad;
    }

    public void setMWStSatzNiedrig(String sMWStSatzNiedrig) {
        this.msMWStSatzNiedrig = sMWStSatzNiedrig;
    }

    public void setMWStSatzHoch(String sMWStSatzHoch) {
        this.msMWStSatzHoch = sMWStSatzHoch;
    }

    public void setMWStSatzAltteile(String sMWStSatzAltteile) {
        this.msMWStSatzAltteile = sMWStSatzAltteile;
    }

    public void setMWStSatz3(String sMWStSatz3) {
        this.msMWStSatz3 = sMWStSatz3;
    }

    public void setMWStSatz4(String sMWStSatz4) {
        this.msMWStSatz4 = sMWStSatz4;
    }

    public void setRechnungsnummer(String sRechnungsnummer) {
        this.msRechnungsnummer = sRechnungsnummer;
    }

    public void setStandardBarVerkaufsNummer(String sStandardBarVerkaufsNummer) {
        this.msStandardBarVerkaufsNummer = sStandardBarVerkaufsNummer;
    }

    public void setStandardAuftragsNummer(String sStandardAuftragsNummer) {
        this.msStandardAuftragsNummer = sStandardAuftragsNummer;
    }

    public void setStandardKundenNummer(String sStandardKundenNummer) {
        this.msStandardKundenNummer = sStandardKundenNummer;
    }

    public void setMailserver(String sMailserver) {
        this.msMailserver = sMailserver;
    }

    public void setDMSSchnittstelleVerwenden(String sDMSSchnittstelleVerwenden) {
        this.msDMSSchnittstelleVerwenden = sDMSSchnittstelleVerwenden;
    }

    public void setAbwicklung(String sAbwicklung) {
        this.msAbwicklung = sAbwicklung;
    }

    public void setBestandFiliale(String sBestandFiliale) {
        this.msBestandFiliale = sBestandFiliale;
    }

    public void setDatenabgleich(String sDatenabgleich) {
        this.msDatenabgleich = sDatenabgleich;
    }

    public String getFirma() {
        return this.msFirma;
    }

    public void setFirma(String msFirma) {
        this.msFirma = msFirma;
    }

    public String getFiliale() {
        return this.msFiliale;
    }

    public void setFiliale(String msFiliale) {
        this.msFiliale = msFiliale;
    }
}

