/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.technischeliteratur;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.technischeliteratur.TLZeile;
import webetk.db.dbaccess.TechnischeLiteraturDbAccess;

public class TLZeilen {
    private static Logger log = Logger.getLogger(TLZeilen.class);
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private Collection<TLZeile> mcZeilen = new Vector<TLZeile>();
    private Iterator<TLZeile> miZeilen = null;
    private TLZeile moZeile = null;
    private int mnTitelCounter = 0;
    private int mnIndex = 0;

    public TLZeilen(String sLang, long lModellspalte, String sMarke, String sProduktart, String sKatalogumfang, String sFG, String sLangTL) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.mcZeilen.clear();
        this.miZeilen = null;
        this.moZeile = null;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.performSearch(sLang, lModellspalte, sMarke, sProduktart, sKatalogumfang, sFG, sLangTL);
    }

    public TLZeilen() {
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error((Object)"Store object in row collection is no TLZeile!", (Throwable)e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
        this.mnTitelCounter = 0;
        this.mnIndex = 0;
    }

    public void next() {
        if (this.miZeilen != null && this.miZeilen.hasNext()) {
            try {
                this.moZeile = this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Store object in row collection is no TLZeile!", (Throwable)e);
                this.moZeile = null;
                return;
            }
            ++this.mnIndex;
            if (++this.mnTitelCounter == 16) {
                this.mnTitelCounter = 1;
            }
        }
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public boolean isEmpty() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0;
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    public boolean isTitel() {
        return this.mnTitelCounter == 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSearch(String sLang, long lModellspalte, String sMarke, String sProduktart, String sKatalogumfang, String sFG, String sLangTL) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("TLZeilen.performSearch");
            log.debug((Object)"Loading TL-Zeilen...");
            res = TechnischeLiteraturDbAccess.loadTechnischeLiteratur(con, sLang, lModellspalte, sMarke, sProduktart, sKatalogumfang, sFG, sLangTL);
            while (res != null && res.next()) {
                String sHG = res.getString("HG");
                String sUG = res.getString("UG");
                String sSachnummer = res.getString("Sachnummer");
                String sTeilenummer = sHG + sUG + sSachnummer;
                String sBenennung = res.getString("Benennung");
                String sKommentar = res.getString("Kommentar");
                String sZusatz = res.getString("Zusatz");
                String sEinsatz = res.getString("Einsatz");
                long lEinsatz = 0L;
                if (sEinsatz != null) {
                    lEinsatz = Long.parseLong(sEinsatz);
                }
                String sAuslauf = res.getString("Auslauf");
                long lAuslauf = 0L;
                if (sAuslauf != null) {
                    lAuslauf = Long.parseLong(sAuslauf);
                }
                String sMAM = res.getString("MAM");
                String sIstEBA = res.getString("istEBA");
                boolean bIstEBA = sIstEBA != null && sIstEBA.equalsIgnoreCase("J");
                boolean bIstDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J");
                TLZeile oZeile = new TLZeile(sSachnummer, sTeilenummer, sBenennung, sKommentar, sZusatz, lEinsatz, lAuslauf, sMAM, bIstEBA, bIstDiebstahlrelevant);
                this.mcZeilen.add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "TLZeilen.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "TLZeilen.performSearch");
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public String getCurrentIndex() {
        if (this.moZeile == null) {
            return "0";
        }
        return new Integer(this.mnIndex).toString();
    }

    public String getCurrentSachnummer() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getSachnummer();
    }

    public String getCurrentTeilenummer() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilenummer();
    }

    public boolean isCurrentDiebstahlrelevant() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isTeilDiebstahlrelevant();
    }

    public String getCurrentTeilenummerUndBenennung() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilenummer() + " - " + this.moZeile.getTeilebenennung();
    }

    public String getCurrentTeilebenennung() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilebenennung();
    }

    public String getCurrentKommentar() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getKommentar();
    }

    public String getCurrentZusatz() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getZusatz();
    }

    public String getCurrentEinsatz() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getEinsatz();
    }

    public String getCurrentAuslauf() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getAuslauf();
    }

    public String getCurrentMAM() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getMAM();
    }

    public boolean isCurrentEBA() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.isEBA();
    }
}

