/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.valueline;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.app.valueline.Hg;
import webetk.app.valueline.ValueLineSatz;
import webetk.db.dbaccess.ValueLineDbAccess;
import webetk.mrkprd.Produkte;

public class ValueLine {
    private static Logger log = Logger.getLogger(ValueLine.class);
    public static final String SUCHART_SAETZE = "saetze";
    public static final String SUCHART_BIDTAFELN = "bildtafeln";
    public static final String SUCHART_TEILENUMMERN = "teilenummern";
    private String mMarke = null;
    private String mProduktart = null;
    private String mUmfang = null;
    private Collection mHgs;
    private String mExpandedHg = null;
    private Collection mBaureihen;
    private String mExpandedBaureihe = null;
    private Collection mTeilenummern;

    public ValueLine(String marke, String produktart, String umfang) {
        this.mMarke = marke;
        this.mProduktart = produktart;
        this.mUmfang = umfang;
    }

    public void setExpandedHg(String expandedHg) {
        this.mExpandedHg = expandedHg;
    }

    public void setExpandedBaureihe(String expandedBaureihe) {
        this.mExpandedBaureihe = expandedBaureihe;
    }

    public static ValueLine loadHgsIntoValueLine(String marke, String produktart, String sprache) throws SQLException, DatabaseBusyException {
        ValueLine valueLine = new ValueLine(marke, produktart, SUCHART_SAETZE);
        Collection<Hg> hgs = ValueLine.loadHgs(marke, produktart, sprache);
        valueLine.setHgs(hgs);
        valueLine.setExpandedHg(null);
        return valueLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Hg> loadHgs(String marke, String produktart, String sprache) throws SQLException, DatabaseBusyException {
        ArrayList<Hg> hgs = new ArrayList<Hg>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("ValueLine.loadHgs");
            log.debug((Object)"Loading HGs");
            res = ValueLineDbAccess.loadHGs(con, sprache, marke, produktart);
            while (res != null && res.next()) {
                String sHG = res.getString("HG");
                String sBenennung = res.getString("Benennung");
                Hg oHg = new Hg(sHG, sBenennung);
                hgs.add(oHg);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "ValueLine.loadHgs");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "ValueLine.loadHgs");
        return hgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ValueLineSatz> loadSaetze(String marke, String produktart, String katalogumfang, String sprache, String hg, String landkuerzel) throws SQLException, DatabaseBusyException {
        ArrayList<ValueLineSatz> saetze = new ArrayList<ValueLineSatz>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("ValueLine.loadSaetze");
            log.debug((Object)"Loading Saetze");
            res = ValueLineDbAccess.loadSaetze(con, sprache, marke, produktart, katalogumfang, hg, landkuerzel);
            while (res != null && res.next()) {
                String ug = res.getString("UG");
                String sachnummer = res.getString("Sachnummer");
                String benennung = res.getString("Benennung");
                String zusatz = res.getString("Zusatz");
                String vorhandenSISatz = res.getString("vorhandenSI");
                String idKommentar = res.getString("BenKommentarId");
                boolean bIsReach = res.getString("Reach") != null && res.getString("Reach").equals("J");
                boolean bIsAspg = res.getString("Aspg") != null && res.getString("Aspg").equals("J");
                boolean bIsDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J");
                String zi = vorhandenSISatz != null && vorhandenSISatz.equalsIgnoreCase("J") || idKommentar != null && !idKommentar.equals("0") || bIsReach ? "I" : "";
                String tc = res.getString("TC") == null ? "" : "C";
                ValueLineSatz satz = new ValueLineSatz(sachnummer, hg, ug, benennung, zusatz, zi + tc, bIsDiebstahlrelevant);
                saetze.add(satz);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "ValueLine.loadSaetze");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "ValueLine.loadSaetze");
        return saetze;
    }

    public static ValueLine loadSaetzeIntoValueLine(String marke, String produktart, String katalogumfang, String sprache, String hg) throws SQLException, DatabaseBusyException {
        ValueLine valueLine = new ValueLine(marke, produktart, SUCHART_SAETZE);
        String landkuerzel = null;
        Collection<Hg> hgs = ValueLine.loadHgs(marke, produktart, sprache);
        Collection<ValueLineSatz> saetze = ValueLine.loadSaetze(marke, produktart, katalogumfang, sprache, hg, landkuerzel);
        ArrayList<Serializable> hgsUndSaetze = new ArrayList<Serializable>();
        for (Hg aktHg : hgs) {
            hgsUndSaetze.add(aktHg);
            if (!aktHg.getHg().equals(hg)) continue;
            hgsUndSaetze.addAll(saetze);
        }
        valueLine.setHgs(hgsUndSaetze);
        valueLine.setExpandedHg(hg);
        return valueLine;
    }

    public static ValueLine loadBteBaureihenIntoValueLine(AssSucheInfo oAssSucheInfo, String sLang, Collection cRegionen) throws SQLException, DatabaseBusyException {
        ValueLine valueLine = new ValueLine(oAssSucheInfo.getMarke(), oAssSucheInfo.getProduktart(), SUCHART_BIDTAFELN);
        Collection<Baureihe> baureihen = ValueLine.loadBteBaureihen(oAssSucheInfo, sLang, cRegionen);
        valueLine.setBaureihen(baureihen);
        return valueLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Baureihe> loadBteBaureihen(AssSucheInfo oAssSucheInfo, String sLang, Collection cRegionen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        ArrayList<Baureihe> cBaureihen = new ArrayList<Baureihe>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("loadBteBaureihen");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogumfang = oAssSucheInfo.getKatalogumfang();
            res = ValueLineDbAccess.loadBteBaureihen(con, sLang, sMarke, sProduktart, sKatalogumfang, cRegionen);
            while (res != null && res.next()) {
                String sBaureihe = res.getString("BAUREIHE");
                String sExtBaureihe = res.getString("EXT_BAUREIHE");
                Baureihe objBaureihe = new Baureihe(sBaureihe, sExtBaureihe, false);
                cBaureihen.add(objBaureihe);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "loadBteBaureihen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "loadBteBaureihen");
        return cBaureihen;
    }

    public static ValueLine loadBildtafelnIntoValueLine(AssSucheInfo oAssSucheInfo, String sLang, String sBaureihe, Collection cRegionen) throws SQLException, DatabaseBusyException {
        ValueLine valueLine = new ValueLine(oAssSucheInfo.getMarke(), oAssSucheInfo.getProduktart(), SUCHART_BIDTAFELN);
        Collection<Baureihe> baureihen = ValueLine.loadBteBaureihen(oAssSucheInfo, sLang, cRegionen);
        ArrayList<Serializable> brUndBtes = new ArrayList<Serializable>();
        for (Baureihe aktBr : baureihen) {
            brUndBtes.add(aktBr);
            if (!aktBr.getID().equals(sBaureihe)) continue;
            aktBr.setExpandiert(true);
            Collection<Modellspalte> btes = ValueLine.loadBildtafeln(oAssSucheInfo, sLang, sBaureihe, aktBr.getBenennung(), cRegionen);
            brUndBtes.addAll(btes);
        }
        valueLine.setBaureihen(brUndBtes);
        valueLine.setExpandedBaureihe(sBaureihe);
        return valueLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Modellspalte> loadBildtafeln(AssSucheInfo oAssSucheInfo, String sLang, String sBaureiheId, String sBaureiheBen, Collection cRegionen) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        ArrayList<Modellspalte> cBTEs = new ArrayList<Modellspalte>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("loadBildtafeln");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogumfang = oAssSucheInfo.getKatalogumfang();
            res = ValueLineDbAccess.loadBildtafeln(con, sLang, sBaureiheId, sMarke, sProduktart, sKatalogumfang, cRegionen);
            while (res != null && res.next()) {
                String sBTNummer = res.getString("BildtafelNr");
                String sBTUeberschrift = res.getString("Benennung");
                String sKarosserie = res.getString("Karosserie");
                String sKarosserieId = res.getString("KarosserieId");
                String sBauart = res.getString("Bauart");
                String sModell = res.getString("Modell");
                String sRegion = res.getString("Region");
                String sKommentar = res.getString("Kommentar");
                String sCPVorhanden = res.getString("CPVorhanden");
                boolean bCPVorhanden = sCPVorhanden.equals("J");
                String sBedignungKZ = res.getString("BedingungKZ");
                boolean bHasBtInfo = sKommentar != null || bCPVorhanden || sBedignungKZ != null;
                Modellspalte obj = new Modellspalte();
                obj.setBaureiheID(sBaureiheId);
                obj.setBaureihe(sBaureiheBen);
                obj.hasBtInfo(bHasBtInfo);
                obj.setModell(sModell);
                obj.setKarosserie(sKarosserie);
                if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                    obj.setBauartKarosserieID(sBauart);
                } else {
                    obj.setBauartKarosserieID(sKarosserieId);
                }
                obj.setRegion(sRegion);
                obj.setBTNummer(sBTNummer);
                obj.setBTUeberschrift(sBTUeberschrift);
                obj.setMenge("");
                cBTEs.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "loadBildtafeln");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "loadBildtafeln");
        return cBTEs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SearchBTETeile.PartOrBTE> loadTeilenummern(String marke, String produktart, String sprache) throws SQLException, DatabaseBusyException {
        ArrayList<SearchBTETeile.PartOrBTE> teile = new ArrayList<SearchBTETeile.PartOrBTE>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("ValueLine.loadTeilenummern");
            log.debug((Object)"Loading Teilenummern");
            res = ValueLineDbAccess.loadTeilenummern(con, sprache, marke, produktart);
            while (res != null && res.next()) {
                String sHG = res.getString("Hauptgruppe");
                String sUG = res.getString("Untergruppe");
                String sSachnummer = res.getString("Sachnummer");
                String sTeilenummer = sHG + sUG + sSachnummer;
                String sBenennung = res.getString("Benennung");
                String sZusatz = res.getString("Zusatz");
                String sKommentar = res.getString("Kommentar");
                String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
                SearchBTETeile.PartOrBTE teil = new SearchBTETeile.PartOrBTE(sTeilenummer, sBenennung, sZusatz, sKommentar, sDiebstahlrelevant);
                teile.add(teil);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "ValueLine.loadTeilenummern");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "ValueLine.loadTeilenummern");
        return teile;
    }

    public String getMarke() {
        return this.mMarke;
    }

    public String getProduktart() {
        return this.mProduktart;
    }

    public String getUmfang() {
        return this.mUmfang;
    }

    public Collection getHgs() {
        return this.mHgs;
    }

    public void setHgs(Collection hgs) {
        this.mHgs = hgs;
    }

    public Collection getBaureihen() {
        return this.mBaureihen;
    }

    public void setBaureihen(Collection baureihen) {
        this.mBaureihen = baureihen;
    }

    public Collection getTeilenummern() {
        return this.mTeilenummern;
    }

    public void setTeilenummern(Collection teilenummern) {
        this.mTeilenummern = teilenummern;
    }

    public Collection getHashtableCollection() {
        Vector<Hashtable> cZeilen = new Vector<Hashtable>();
        if (this.mUmfang == null) {
            return cZeilen;
        }
        Iterator iter = this.getZeilenIterator();
        if (iter == null) {
            return cZeilen;
        }
        int zeilenIndex = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            Hashtable zeilenHashtable = this.getHashTable(obj);
            zeilenHashtable.put("Index", Integer.toString(zeilenIndex));
            if (zeilenIndex % 15 == 0) {
                zeilenHashtable.put("istTitel", "J");
            }
            cZeilen.add(zeilenHashtable);
            ++zeilenIndex;
        }
        return cZeilen;
    }

    private Iterator getZeilenIterator() {
        if (this.mUmfang.equals(SUCHART_SAETZE) && this.mHgs != null) {
            return this.mHgs.iterator();
        }
        if (this.mUmfang.equals(SUCHART_BIDTAFELN) && this.mBaureihen != null) {
            return this.mBaureihen.iterator();
        }
        if (this.mUmfang.equals(SUCHART_TEILENUMMERN) && this.mTeilenummern != null) {
            return this.mTeilenummern.iterator();
        }
        return null;
    }

    private Hashtable getHashTable(Object obj) {
        Hashtable<String, String> zeilenHashtable = null;
        if (obj instanceof Hg) {
            Hg oHg = (Hg)obj;
            zeilenHashtable = oHg.getHashtable();
            if (oHg.getHg().equals(this.mExpandedHg)) {
                zeilenHashtable.put("istExpandiert", "J");
            } else {
                zeilenHashtable.put("istNichtExpandiert", "J");
            }
        } else if (obj instanceof ValueLineSatz) {
            ValueLineSatz satz = (ValueLineSatz)obj;
            zeilenHashtable = satz.getHashtable();
        } else if (obj instanceof Baureihe) {
            Baureihe oBaureihe = (Baureihe)obj;
            zeilenHashtable = oBaureihe.getHashtable();
            if (oBaureihe.getID().equals(this.mExpandedBaureihe)) {
                zeilenHashtable.put("istExpandiert", "J");
            } else {
                zeilenHashtable.put("istNichtExpandiert", "J");
            }
        } else if (obj instanceof Modellspalte) {
            Modellspalte mosp = (Modellspalte)obj;
            zeilenHashtable = mosp.getHashtable();
        } else if (obj instanceof SearchBTETeile.PartOrBTE) {
            SearchBTETeile.PartOrBTE oPartOrBTE = (SearchBTETeile.PartOrBTE)obj;
            zeilenHashtable = oPartOrBTE.getHashtable();
        }
        return zeilenHashtable;
    }
}

