/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.transferables;

import org.apache.log4j.Logger;
import webetk.communication.transferables.AsapInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.LoginController;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TransferableDecorator;

public class AsapAuthenticationDecorator
implements TransferableDecorator {
    private LoginController mLoginController;
    private static Logger log = Logger.getLogger(AsapAuthenticationDecorator.class);

    public AsapAuthenticationDecorator(LoginController pLoginController) {
        this.mLoginController = pLoginController;
    }

    @Override
    public void decorate(Transferable pTransferable) {
        AsapInfo asapInfo;
        Command command = pTransferable.getCommand();
        if (command.isAsapRelevant() && !pTransferable.isForceLocalServerOnly() && (asapInfo = this.mLoginController.getAsapInfo(pTransferable.isIgdom())) != null) {
            log.debug((Object)("decorating transferable for command: " + command));
            pTransferable.setAsapUserId(asapInfo.getAsapUserId());
            pTransferable.setAsapSessionId(asapInfo.getAsapSessionId());
            pTransferable.setServerParameter("PSESSID", asapInfo.getAsapSessionId());
            pTransferable.setServerParameter("user_id", asapInfo.getAsapUserId());
        }
        if (command.isAsapRelevant() && pTransferable.isForceAsap() && (asapInfo = this.mLoginController.getAsapInfo()) != null) {
            log.debug((Object)("decorating transferable for command: " + command));
            pTransferable.setAsapUserId(asapInfo.getAsapUserId());
            pTransferable.setAsapSessionId(asapInfo.getAsapSessionId());
            pTransferable.setServerParameter("PSESSID", asapInfo.getAsapSessionId());
            pTransferable.setServerParameter("user_id", asapInfo.getAsapUserId());
        }
    }
}

