/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.transferables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.ThrowableAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Transferable
extends Observable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Command mCommand = Command.NO_OPERATION;
    @XmlJavaTypeAdapter(value=ThrowableAdapter.class)
    protected Exception exception = null;
    private int ID = 0;
    @XmlTransient
    private static int m_IDCounter = 1;
    @XmlTransient
    private boolean isAsyncSending = false;
    @XmlTransient
    private int queueCounter = 0;
    @XmlElement
    protected HashMap<String, String> serverParameter = new HashMap();
    private String mAsapSessionId;
    private String mAsapUserId;
    private boolean mForceLocalServerOnly = false;
    private boolean mIgdom = false;
    private boolean forceAsapLogin = false;

    public Transferable() {
    }

    protected Transferable(Observer objObserver) {
        this.ID = m_IDCounter++;
        this.exception = null;
        this.serverParameter = null;
        if (objObserver != null) {
            this.addObserver(objObserver);
        }
    }

    public final boolean hadCommError() {
        return this.exception != null;
    }

    public Exception getError() {
        return this.exception;
    }

    public void setError(Exception e) {
        this.exception = e;
    }

    public final int getID() {
        return this.ID;
    }

    public void setCommand(Command mCommand) {
        this.mCommand = mCommand;
    }

    public Command getCommand() {
        return this.mCommand;
    }

    public final boolean hasSameIdAs(Transferable trf) {
        return this.ID == trf.ID;
    }

    @Override
    public final void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    public void copyData(Transferable trf) throws ClassCastException {
        this.exception = trf.exception;
        this.mCommand = trf.mCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(ObjectOutputStream streamOut, Transferable trfToSend) throws IOException {
        try {
            streamOut.writeObject(trfToSend);
            streamOut.flush();
        }
        finally {
            streamOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transferable read(ObjectInputStream streamIn) throws IOException, ClassCastException, ClassNotFoundException {
        Transferable trfInput = null;
        try {
            trfInput = (Transferable)streamIn.readObject();
        }
        finally {
            streamIn.close();
        }
        return trfInput;
    }

    public final boolean isInSendQueue() {
        return this.queueCounter > 0;
    }

    public final void startAsyncComm() {
        this.isAsyncSending = true;
    }

    public final void endAsyncComm() {
        --this.queueCounter;
        this.isAsyncSending = false;
    }

    public void setServerParameter(HashMap<String, String> map) {
        this.serverParameter = map;
    }

    public void setServerParameter(String sParameter, String sValue) {
        if (sParameter == null) {
            throw new IllegalArgumentException("Server Parameter name is null!");
        }
        if (this.serverParameter == null) {
            this.serverParameter = new HashMap();
        }
        this.serverParameter.put(sParameter, sValue == null ? "" : sValue);
    }

    public HashMap<String, String> getServerParameter() {
        return this.serverParameter;
    }

    public String getAsapSessionId() {
        return this.mAsapSessionId;
    }

    public void setAsapSessionId(String pAsapSessionId) {
        this.mAsapSessionId = pAsapSessionId;
    }

    public String getAsapUserId() {
        return this.mAsapUserId;
    }

    public void setAsapUserId(String pAsapUserId) {
        this.mAsapUserId = pAsapUserId;
    }

    public boolean isForceLocalServerOnly() {
        return this.mForceLocalServerOnly;
    }

    public void setForceLocalServerOnly(boolean pForceLocalServerOnly) {
        this.mForceLocalServerOnly = pForceLocalServerOnly;
    }

    public boolean isIgdom() {
        return this.mIgdom;
    }

    public void setIgdom(boolean pIgdom) {
        this.mIgdom = pIgdom;
    }

    public boolean isForceAsap() {
        return this.forceAsapLogin;
    }

    public void setForceAsap(boolean forceAsapLogin) {
        this.forceAsapLogin = forceAsapLogin;
    }
}

