/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class NewstexteDbAccess {
    private static Logger log = Logger.getLogger(NewstexteDbAccess.class);

    public static void saveNewstext(Connection con, String sMarke, String sIso, String sRegIso, String sText, String sIsAktuell, String sIsStandard) throws SQLException {
        try {
            Statement stmt;
            con.setAutoCommit(false);
            String sSQLStatement = null;
            sText = StringUtils.maskiereHochkommaFuerDb(sText);
            int result = 1;
            if (sIsStandard.equals("J")) {
                sSQLStatement = SQLStatements.News.instance.UPDATE_NEWSTEXT();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXT", sText);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AKTUELL", sIsAktuell);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "STANDARD", sIsStandard);
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                result = stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            if (sIsStandard.equals("N") || result != 1) {
                sSQLStatement = SQLStatements.News.instance.INSERT_NEWSTEXT();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXT", sText);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AKTUELL", sIsAktuell);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "STANDARD", sIsStandard);
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                result = stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static ResultSet loadNewstexte(Connection con, String sMarke, String sIso, String sRegIso) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.News.instance.LOAD_NEWSTEXTE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sMarke = StringUtils.maskiereHochkommaFuerDb(sMarke);
            ps.setString(1, sMarke);
            sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
            ps.setString(2, sIso);
            sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
            ps.setString(3, sRegIso);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.News.instance.LOAD_NEWSTEXTE();
        sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
        sMarke = StringUtils.maskiereHochkommaFuerDb(sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static int deleteNewstext(Connection con, String sMarke, String sIso, String sRegIso, String sText) throws SQLException {
        String sSQLStatement = SQLStatements.News.instance.DELETE_NEWSTEXT();
        sText = StringUtils.maskiereHochkommaFuerDb(sText);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXT", sText);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int res = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return res;
    }

    public static void updateNewstexte(Connection con, String sMarke, String sIso, String sRegIso, String sText, String sIsAktuell) throws SQLException {
        try {
            con.setAutoCommit(false);
            String sSQLStatement = SQLStatements.News.instance.UPDATE_NEWSTEXT_AKTIVIERUNG();
            sText = StringUtils.maskiereHochkommaFuerDb(sText);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXT", sText);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AKTUELL", sIsAktuell);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static void saveImage(Connection con, String sMarke, byte[] image) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con.setAutoCommit(false);
            String sSQLStatement = SQLStatements.News.instance.DELETE_IMAGE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            stmt = con.createStatement();
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.News.instance.INSERT_IMAGE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            stmt = con.createStatement();
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.News.instance.UPDATE_IMAGE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            stmt = con.createStatement();
            log.debug((Object)("Executing: " + sSQLStatement));
            rs = stmt.executeQuery(sSQLStatement);
            OutputStream os = null;
            if (rs.next()) {
                Blob jBlob = rs.getBlob(1);
                os = jBlob.setBinaryStream(0L);
                try {
                    os.write(image);
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SQLException("IO Exception 1");
                }
            }
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SQLException("IO Exception 2");
            }
            con.commit();
        }
        catch (SQLException ex) {
            try {
                if (rs != null) {
                    rs.close();
                }
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            con.rollback();
            throw ex;
        }
        finally {
            rs.close();
            stmt.close();
            con.setAutoCommit(true);
        }
    }

    public static ResultSet loadImage(Connection con, String sMarke) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.News.instance.LOAD_IMAGE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sMarke);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.News.instance.LOAD_IMAGE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadImageMarken(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.News.instance.LOAD_IMAGE_MARKEN();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

