/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.fzgid.Auftrag;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.RrNutzerdaten;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.db.SQLStatements;
import webetk.mrkprd.Marken;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileListeDbAccess {
    private static Logger log = Logger.getLogger(TeileListeDbAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void storeTeileliste(Connection con, Teileliste objTeileliste, boolean bNeuanlage) throws SQLException {
        try {
            con.setAutoCommit(false);
            nRowsUpdated = 0;
            if (!bNeuanlage) {
                bTryUpdate = true;
                if (HtmlUtils.isConnectionSourceOracle(con)) {
                    sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_LISTE_ALLG();
                    ps = con.prepareStatement(sSQLStatement);
                    ps.setString(1, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                    ps.setString(2, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                    TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                    res = null;
                    try {
                        res = ps.executeQuery();
                        if (res == null || !res.next()) {
                            bTryUpdate = false;
                        }
                        if (objTeileliste.getMarke() != null) {
                            if (objTeileliste.getMarke().equals(res.getString("Marke"))) ** GOTO lbl50
                            bTryUpdate = false;
                        }
                        if (res.getString("Marke") == null) ** GOTO lbl50
                        bTryUpdate = false;
                    }
                    finally {
                        WebetkUtils.closeQuery(res);
                    }
                } else {
                    sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_LISTE_ALLG();
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                    TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                    stmt = null;
                    res = null;
                    try {
                        stmt = con.createStatement();
                        res = stmt.executeQuery(sSQLStatement);
                        if (res == null || !res.next()) {
                            bTryUpdate = false;
                        } else if (objTeileliste.getMarke() != null) {
                            if (!objTeileliste.getMarke().equals(res.getString("Marke"))) {
                                bTryUpdate = false;
                            }
                        } else if (res.getString("Marke") != null) {
                            bTryUpdate = false;
                        }
                    }
                    finally {
                        WebetkUtils.closeQuery(res);
                    }
                }
                if (bTryUpdate) {
                    stmt = null;
                    sSQLStatement = SQLStatements.TeilelisteHTML.instance.UPDATE_LISTE_ALLG();
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getBemerkung()));
                    lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatErstellung());
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "ERZEUGT", Long.toString(lDate));
                    lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getMarke()));
                    sSQLStatement = objTeileliste.getDringlichkeit() == null || objTeileliste.getDringlichkeit().length() < 1 ? StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "NULL") : StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getDringlichkeit()) + "'");
                    sSQLStatement = objTeileliste.getVIN() == null || objTeileliste.getVIN().length() < 1 ? StringUtils.substituteString(sSQLStatement, "VIN", "NULL") : StringUtils.substituteString(sSQLStatement, "VIN", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getVIN()) + "'");
                    TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                    stmt = con.createStatement();
                    nRowsUpdated = stmt.executeUpdate(sSQLStatement);
                    stmt.close();
                }
            }
            if (nRowsUpdated == 0) {
                sSQLStatement = SQLStatements.TeilelisteHTML.instance.INSERT_LISTE_ALLG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getBemerkung()));
                lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatErstellung());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ERZEUGT", Long.toString(lDate));
                lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getMarke()));
                sSQLStatement = objTeileliste.getDringlichkeit() == null || objTeileliste.getDringlichkeit().length() < 1 ? StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "NULL") : StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getDringlichkeit()) + "'");
                sSQLStatement = objTeileliste.getVIN() == null || objTeileliste.getVIN().length() < 1 ? StringUtils.substituteString(sSQLStatement, "VIN", "NULL") : StringUtils.substituteString(sSQLStatement, "VIN", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getVIN()) + "'");
                TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            sSQLStatement = SQLStatements.TeilelisteHTML.instance.DELETE_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
            TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            cTeile = objTeileliste.getTeile();
            iteratorTeile = cTeile.iterator();
            nPosition = 0;
            while (iteratorTeile.hasNext()) {
                objTeil = (Teil)iteratorTeile.next();
                sSQLStatement = SQLStatements.TeilelisteHTML.instance.INSERT_LISTE_POS();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", StringUtils.maskiereHochkommaFuerDb(objTeil.getSachnummer()));
                sPos = new Integer(++nPosition).toString();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", sPos);
                sMenge = objTeil.getMenge();
                if (sMenge.length() > 5) {
                    sMenge = sMenge.substring(0, 5);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MENGE", StringUtils.maskiereHochkommaFuerDb(sMenge));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeil.getBemerkung()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FISTRING", StringUtils.maskiereHochkommaFuerDb(objTeil.getFIString()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ASPGTYP", StringUtils.maskiereHochkommaFuerDb(objTeil.getAspgTyp()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ASPGREF", StringUtils.maskiereHochkommaFuerDb(objTeil.getAspgRef()));
                sAspgMenge = objTeil.getAspgMenge();
                if (objTeil.getAspgMenge() != null && sAspgMenge.length() > 5) {
                    sAspgMenge = sAspgMenge.substring(0, 5);
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ASPGMENGE", StringUtils.maskiereHochkommaFuerDb(sAspgMenge));
                TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    private static void insertJob(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID, String sJobId, String sJobBen, boolean bLock) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.INSERT_JOB();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "JOBID", StringUtils.maskiereHochkommaFuerDb(sJobId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "JOBBEN", StringUtils.maskiereHochkommaFuerDb(sJobBen));
        sSQLStatement = bLock ? StringUtils.substituteString(sSQLStatement, "LOCK", "J") : StringUtils.substituteString(sSQLStatement, "LOCK", "N");
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    private static void insertSrp(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID, String sSrpId, String sJobId, String sSrpBen, boolean bLock, String sQuelle) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.INSERT_SRP();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SRPID", StringUtils.maskiereHochkommaFuerDb(sSrpId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "JOBID", StringUtils.maskiereHochkommaFuerDb(sJobId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SRPBEN", StringUtils.maskiereHochkommaFuerDb(sSrpBen));
        sSQLStatement = bLock ? StringUtils.substituteString(sSQLStatement, "LOCK", "J") : StringUtils.substituteString(sSQLStatement, "LOCK", "N");
        sSQLStatement = sQuelle == null || sQuelle.length() == 0 ? StringUtils.substituteString(sSQLStatement, "QUELLE", "NULL") : StringUtils.substituteString(sSQLStatement, "QUELLE", "'" + sQuelle + "'");
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static ResultSet loadJobs(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_JOBS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSrps(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_SRPS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    private static void insertTeilInListe(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID, boolean bBestellliste, String sJobId, String sSrpId, Teil objTeil, int nPosition) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = !bBestellliste ? SQLStatements.TeilelisteJAVA.instance.INSERT_LISTE_POS() : SQLStatements.TeilelisteJAVA.instance.INSERT_BESTELLLISTE_POS();
        String sPos = new Integer(nPosition).toString();
        sSQLStatement = TeileListeDbAccess.substituteInListePosSqlString(sSQLStatement, sID, sFirma, sFiliale, sNutzerID, bBestellliste, sJobId, sSrpId, objTeil, sPos);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static int updateTeilInListe(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID, boolean bBestellliste, String sJobId, String sSrpId, Teil objTeil) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = !bBestellliste ? SQLStatements.TeilelisteJAVA.instance.UPDATE_LISTE_POS() : SQLStatements.TeilelisteJAVA.instance.UPDATE_BESTELLLISTE_POS();
        sSQLStatement = TeileListeDbAccess.substituteInListePosSqlString(sSQLStatement, sID, sFirma, sFiliale, sNutzerID, bBestellliste, sJobId, sSrpId, objTeil, objTeil.getPos());
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int nRowsUpdated = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return nRowsUpdated;
    }

    private static String substituteInListePosSqlString(String sSQLStatement, String sID, String sFirma, String sFiliale, String sNutzerID, boolean bBestellliste, String sJobId, String sSrpId, Teil objTeil, String sPosition) {
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        if (!bBestellliste) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", sPosition);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeil.getBemerkung()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGUG", StringUtils.maskiereHochkommaFuerDb(objTeil.getHG() + objTeil.getUG()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", StringUtils.maskiereHochkommaFuerDb(objTeil.getSachnummer()));
        sSQLStatement = objTeil.getMenge() != null && objTeil.getMenge().length() > 0 ? StringUtils.substituteString(sSQLStatement, "MENGE", StringUtils.maskiereHochkommaFuerDb(objTeil.getMenge())) : StringUtils.substituteString(sSQLStatement, "MENGE", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BENENNUNG", StringUtils.maskiereHochkommaFuerDb(objTeil.getBenennung()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ZUSATZ", StringUtils.maskiereHochkommaFuerDb(objTeil.getZusatz()));
        sSQLStatement = objTeil.getLagerbestand() != null ? StringUtils.substituteString(sSQLStatement, "LAGERBESTAND", objTeil.getLagerbestand().toString()) : StringUtils.substituteString(sSQLStatement, "LAGERBESTAND", "NULL");
        sSQLStatement = objTeil.getMinimalbestand() != null ? StringUtils.substituteString(sSQLStatement, "MINIMALBESTAND", objTeil.getMinimalbestand().toString()) : StringUtils.substituteString(sSQLStatement, "MINIMALBESTAND", "NULL");
        sSQLStatement = objTeil.getBedarfshinweis() != null ? StringUtils.substituteString(sSQLStatement, "BEDARFSHINWEIS", objTeil.getBedarfshinweis().toString()) : StringUtils.substituteString(sSQLStatement, "BEDARFSHINWEIS", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LAGERORT", StringUtils.maskiereHochkommaFuerDb(objTeil.getLagerort()));
        sSQLStatement = objTeil.getAuMe() != null ? StringUtils.substituteString(sSQLStatement, "AUME", objTeil.getAuMe().toString()) : StringUtils.substituteString(sSQLStatement, "AUME", "NULL");
        if (!bBestellliste) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PREIS", Double.toString(objTeil.getPreis()));
            sSQLStatement = objTeil.getRabatt() != null ? StringUtils.substituteString(sSQLStatement, "RABATT", objTeil.getRabatt().toString()) : StringUtils.substituteString(sSQLStatement, "RABATT", "NULL");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SPLIT", StringUtils.maskiereHochkommaFuerDb(objTeil.getSplitt()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TRANSPARENZ", StringUtils.maskiereHochkommaFuerDb(objTeil.getTransparenz()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUFFIX", StringUtils.maskiereHochkommaFuerDb(objTeil.getSuffix()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DISPO", StringUtils.maskiereHochkommaFuerDb(objTeil.getDispo()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "RUECKSENDEPFLICHT", StringUtils.maskiereHochkommaFuerDb(objTeil.getRuecksendepflicht()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST", Double.toString(objTeil.getMwSt()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ATST", Double.toString(objTeil.getAtSt()));
            sSQLStatement = objTeil.getFIString() != null ? StringUtils.substituteString(sSQLStatement, "FISTRING", "'" + StringUtils.maskiereHochkommaFuerDb(objTeil.getFIString()) + "'") : StringUtils.substituteString(sSQLStatement, "FISTRING", "NULL");
        } else {
            String sAuftragsNr = StringUtils.maskiereHochkommaFuerDb(objTeil.getAuftragsnummer());
            sAuftragsNr = sAuftragsNr == null || sAuftragsNr.length() < 1 ? "null" : "'" + sAuftragsNr + "'";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", sAuftragsNr);
            sSQLStatement = objTeil.getKundennummer() != null ? StringUtils.substituteString(sSQLStatement, "KUNDENNR", objTeil.getKundennummer().toString()) : StringUtils.substituteString(sSQLStatement, "KUNDENNR", "NULL");
        }
        String sLokalteil = "NULL";
        if (objTeil.getLokalteil()) {
            sLokalteil = "'J'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOKALTEIL", sLokalteil);
        sSQLStatement = sJobId != null ? StringUtils.substituteString(sSQLStatement, "JOBID", "'" + sJobId + "'") : StringUtils.substituteString(sSQLStatement, "JOBID", "NULL");
        sSQLStatement = sSrpId != null ? StringUtils.substituteString(sSQLStatement, "SRPID", "'" + sSrpId + "'") : StringUtils.substituteString(sSQLStatement, "SRPID", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "STATUS", Integer.toString(objTeil.getScoreAenderung()));
        sSQLStatement = sJobId == null ? StringUtils.substituteString(sSQLStatement, "PRUEFEN", "NULL") : (objTeil.isScorePruefen() ? StringUtils.substituteString(sSQLStatement, "PRUEFEN", "'J'") : StringUtils.substituteString(sSQLStatement, "PRUEFEN", "'N'"));
        sSQLStatement = sJobId == null ? StringUtils.substituteString(sSQLStatement, "LOCK", "NULL") : (objTeil.isScoreLock() ? StringUtils.substituteString(sSQLStatement, "LOCK", "'J'") : StringUtils.substituteString(sSQLStatement, "LOCK", "'N'"));
        sSQLStatement = objTeil.getAspgMenge() != null && objTeil.getAspgMenge().length() > 0 ? StringUtils.substituteString(sSQLStatement, "ASPGMENGE", StringUtils.maskiereHochkommaFuerDb(objTeil.getAspgMenge())) : StringUtils.substituteString(sSQLStatement, "ASPGMENGE", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ASPGTYP", StringUtils.maskiereHochkommaFuerDb(objTeil.getAspgTyp()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ASPGREF", StringUtils.maskiereHochkommaFuerDb(objTeil.getAspgRef()));
        return sSQLStatement;
    }

    public static void storeTeileliste(Connection con, Teileliste objTeileliste, boolean bNeuanlage, String sFirma) throws SQLException, DuplicateValueException {
        block15: {
            try {
                con.setAutoCommit(false);
                boolean bBestellliste = objTeileliste instanceof Bestellliste;
                if (!bBestellliste) {
                    TeileListeDbAccess.storeTeilelisteAllgemein(con, objTeileliste, bNeuanlage, sFirma);
                }
                if (!bBestellliste) {
                    TeileListeDbAccess.deleteAllPartsFromTeileliste(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID());
                } else {
                    TeileListeDbAccess.deleteAllPartsFromBestellliste(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale());
                }
                if (objTeileliste instanceof Scoreliste) {
                    TeileListeDbAccess.deleteAllJobsAndSrpsFromScoreliste(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID());
                }
                if (objTeileliste instanceof Scoreliste) {
                    log.debug((Object)"neue Positionen in Scoreliste inserten");
                    int nPosition = 0;
                    Scoreliste objScoreliste = (Scoreliste)objTeileliste;
                    Collection<ScorelisteJob> cJobs = objScoreliste.getJobs();
                    for (ScorelisteJob oAktJob : cJobs) {
                        log.debug((Object)("Job mit ID: " + oAktJob.getId()));
                        TeileListeDbAccess.insertJob(con, objScoreliste.getID(), sFirma, objScoreliste.getFiliale(), objScoreliste.getNutzerID(), oAktJob.getId(), oAktJob.getBezeichnung(), oAktJob.isLock());
                        con.commit();
                        Collection<ScorelisteSrp> cSrps = oAktJob.getSrps();
                        for (ScorelisteSrp oAktSrp : cSrps) {
                            log.debug((Object)("SRP mit ID: " + oAktSrp.getId()));
                            TeileListeDbAccess.insertSrp(con, objScoreliste.getID(), sFirma, objScoreliste.getFiliale(), objScoreliste.getNutzerID(), oAktSrp.getId(), oAktJob.getId(), oAktSrp.getBezeichnung(), oAktSrp.isLock(), oAktSrp.getQuelle());
                            con.commit();
                            Collection<Teil> cTeile = oAktSrp.getTeile();
                            if (cTeile.size() > 0) {
                                for (Teil objTeil : cTeile) {
                                    TeileListeDbAccess.insertTeilInListe(con, objScoreliste.getID(), sFirma, objScoreliste.getFiliale(), objScoreliste.getNutzerID(), false, oAktJob.getId(), oAktSrp.getId(), objTeil, ++nPosition);
                                    con.commit();
                                }
                                continue;
                            }
                            Teil objTeil = Teil.createScorePlatzhalter();
                            TeileListeDbAccess.insertTeilInListe(con, objScoreliste.getID(), sFirma, objScoreliste.getFiliale(), objScoreliste.getNutzerID(), false, oAktJob.getId(), oAktSrp.getId(), objTeil, ++nPosition);
                            con.commit();
                        }
                    }
                    break block15;
                }
                Vector<Teil> cTeile = objTeileliste.getTeile();
                Iterator iteratorTeile = cTeile.iterator();
                int nPosition = 0;
                while (iteratorTeile.hasNext()) {
                    Teil objTeil = (Teil)iteratorTeile.next();
                    TeileListeDbAccess.insertTeilInListe(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID(), bBestellliste, null, null, objTeil, ++nPosition);
                    con.commit();
                }
            }
            catch (SQLException ex) {
                con.rollback();
                throw ex;
            }
            finally {
                con.setAutoCommit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertTeile(Connection con, Teileliste objTeileliste, String sFirma, String sJobId, String sSrpId) throws SQLException {
        try {
            con.setAutoCommit(false);
            boolean bBestellliste = objTeileliste instanceof Bestellliste;
            Vector<Teil> cTeile = objTeileliste.getTeile();
            Iterator iteratorTeile = cTeile.iterator();
            int nPosition = 0;
            int nPositionBestellliste = 0;
            String sSQLStatement = null;
            if (bBestellliste) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_COUNT_BESTELLLISTEPOS();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                log.debug((Object)("Executing: " + sSQLStatement));
                Statement stmt = null;
                ResultSet res = null;
                try {
                    stmt = con.createStatement();
                    res = stmt.executeQuery(sSQLStatement);
                    res.next();
                    nPositionBestellliste = res.getInt(1);
                }
                catch (Throwable throwable) {
                    WebetkUtils.closeQuery(res);
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
            }
            while (iteratorTeile.hasNext()) {
                Teil objTeil = (Teil)iteratorTeile.next();
                ++nPosition;
                if (sJobId != null) {
                    nPosition = objTeil.getPosInt();
                }
                if (objTeil.getInsert()) {
                    ++nPositionBestellliste;
                    if (!bBestellliste) {
                        TeileListeDbAccess.insertTeilInListe(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID(), bBestellliste, sJobId, sSrpId, objTeil, nPosition);
                    } else {
                        TeileListeDbAccess.insertTeilInListe(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID(), bBestellliste, null, null, objTeil, nPositionBestellliste);
                    }
                    if (objTeil.getFIString() != null) {
                        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FISTRING", "'" + StringUtils.maskiereHochkommaFuerDb(objTeil.getFIString()) + "'");
                        continue;
                    }
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FISTRING", "NULL");
                    continue;
                }
                if (!objTeil.getUpdate()) continue;
                TeileListeDbAccess.updateTeilInListe(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID(), bBestellliste, sJobId, sSrpId, objTeil);
                if (objTeil.getFIString() != null) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FISTRING", "'" + StringUtils.maskiereHochkommaFuerDb(objTeil.getFIString()) + "'");
                    continue;
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FISTRING", "NULL");
            }
            for (Teil objTeil : cTeile) {
                objTeil.setInsert(false);
                objTeil.setUpdate(false);
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static void insertTeileliste(Connection con, Teileliste objTeileliste) throws SQLException, DuplicateValueException {
        try (Statement stmt = null;){
            String sSQLStatement = SQLStatements.TeilelisteHTML.instance.INSERT_LISTE_ALLG();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getBemerkung()));
            long lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatErstellung());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ERZEUGT", Long.toString(lDate));
            lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getMarke()));
            sSQLStatement = objTeileliste.getDringlichkeit() == null || objTeileliste.getDringlichkeit().length() < 1 ? StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "NULL") : StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getDringlichkeit()) + "'");
            sSQLStatement = objTeileliste.getVIN() == null || objTeileliste.getVIN().length() < 1 ? StringUtils.substituteString(sSQLStatement, "VIN", "NULL") : StringUtils.substituteString(sSQLStatement, "VIN", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getVIN()) + "'");
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
        }
    }

    public static void insertTeileliste(Connection con, Teileliste objTeileliste, String sFirma) throws SQLException, DuplicateValueException {
        try (Statement stmt = null;){
            Scoreliste objScoreliste = null;
            if (objTeileliste instanceof Scoreliste) {
                objScoreliste = (Scoreliste)objTeileliste;
                objScoreliste.setID(TeileListeDbAccess.getNextScorelistenId(con));
            }
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.INSERT_LISTE_ALLG();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getBemerkung()));
            long lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatErstellung());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ERZEUGT", Long.toString(lDate));
            lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getMarke()));
            String sValue = StringUtils.maskiereHochkommaFuerDb(objTeileliste.getAuftragsNr());
            sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", sValue);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "GESPERRT", "null");
            sValue = StringUtils.maskiereHochkommaFuerDb(objTeileliste.getAuftragsNrLokal());
            sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNRLOKAL", sValue);
            Long lValue = objTeileliste.getKundenNrLokal();
            sValue = lValue == null ? "null" : lValue.toString();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNRLOKAL", sValue);
            sValue = objTeileliste.getPrivat() ? "'J'" : "null";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRIVAT", sValue);
            sValue = objScoreliste != null ? "'" + objScoreliste.getDurchlaufId() + "'" : "null";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FZGDURCHLAUF", sValue);
            sSQLStatement = objTeileliste.getDringlichkeit() == null || objTeileliste.getDringlichkeit().length() < 1 ? StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "NULL") : StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getDringlichkeit()) + "'");
            sSQLStatement = objTeileliste.getVIN() == null || objTeileliste.getVIN().length() < 1 ? StringUtils.substituteString(sSQLStatement, "VIN", "NULL") : StringUtils.substituteString(sSQLStatement, "VIN", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getVIN()) + "'");
            sSQLStatement = objTeileliste.getSapStatus() == null || objTeileliste.getSapStatus().length() < 1 ? StringUtils.substituteString(sSQLStatement, "RRSAPSTATUS", "NULL") : StringUtils.substituteString(sSQLStatement, "RRSAPSTATUS", "'" + StringUtils.maskiereHochkommaFuerDb(objTeileliste.getSapStatus()) + "'");
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
        }
    }

    public static void storeTeilelisteAllgemein(Connection con, Teileliste objTeileliste, boolean bNeuanlage, String sFirma) throws SQLException, DuplicateValueException {
        int nRowsUpdated = 0;
        if (objTeileliste instanceof Scoreliste && !bNeuanlage) {
            return;
        }
        if (!bNeuanlage) {
            String sSQLStatement;
            boolean bTryUpdate = true;
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_ALLG();
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
                ps.setString(2, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                ps.setString(3, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                ps.setString(4, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                log.debug((Object)("Executing: " + sSQLStatement));
                ResultSet res = ps.executeQuery();
                if (res == null || !res.next()) {
                    bTryUpdate = false;
                } else if (!res.getString("Marke").equals(objTeileliste.getMarke())) {
                    bTryUpdate = false;
                }
                WebetkUtils.closeQuery(res);
            } else {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_ALLG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                log.debug((Object)("Executing: " + sSQLStatement));
                Statement stmt = con.createStatement();
                ResultSet res = stmt.executeQuery(sSQLStatement);
                if (res == null || !res.next()) {
                    bTryUpdate = false;
                } else if (!res.getString("Marke").equals(objTeileliste.getMarke())) {
                    bTryUpdate = false;
                }
                WebetkUtils.closeQuery(res);
            }
            if (bTryUpdate) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_LISTE_ALLG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEMERKUNG", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getBemerkung()));
                long lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatErstellung());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ERZEUGT", Long.toString(lDate));
                lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getMarke()));
                String sValue = StringUtils.maskiereHochkommaFuerDb(objTeileliste.getAuftragsNr());
                sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", sValue);
                sValue = StringUtils.maskiereHochkommaFuerDb(objTeileliste.getAuftragsNrLokal());
                sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNRLOKAL", sValue);
                Long lValue = objTeileliste.getKundenNrLokal();
                sValue = lValue == null ? "null" : lValue.toString();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNRLOKAL", sValue);
                sValue = objTeileliste.getPrivat() ? "'J'" : "null";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRIVAT", sValue);
                sValue = objTeileliste.getDringlichkeit();
                sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + StringUtils.maskiereHochkommaFuerDb(sValue) + "'";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "DRINGLICHKEIT", sValue);
                sValue = objTeileliste.getVIN();
                sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + StringUtils.maskiereHochkommaFuerDb(sValue) + "'";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "VIN", sValue);
                sValue = objTeileliste.getSapStatus();
                sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "RRSAPSTATUS", sValue);
                log.debug((Object)("Executing: " + sSQLStatement));
                Statement stmt = con.createStatement();
                nRowsUpdated = stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
        }
        if (nRowsUpdated == 0) {
            TeileListeDbAccess.insertTeileliste(con, objTeileliste, sFirma);
        }
    }

    public static void updateAenderungsdatum(Connection con, Teileliste objTeileliste, String sFirma) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_LISTE_AENDER_DAT();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
        long lDate = WebetkUtils.getLongFromDate(objTeileliste.getDatAenderung());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "GEAENDERT", Long.toString(lDate));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void updateSperre(Connection con, Teileliste objTeileliste, String sFirma) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_LISTE_SPERRE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
        String sGesperrt = "NULL";
        if (objTeileliste.getGesperrt()) {
            sGesperrt = "'J'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "GESPERRT", sGesperrt);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
        if (!objTeileliste.getGesperrt()) {
            TeileListeDbAccess.deleteSendeinfo(con, objTeileliste.getID(), sFirma, objTeileliste.getFiliale(), objTeileliste.getNutzerID());
        }
    }

    protected static void deleteSendeinfo(Connection con, String sID, String sFirma, String sFiliale, String sNutzerID) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_SENDE_INFO();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static boolean updateSperre(Connection con, boolean bGesperrt, boolean bForce, Teileliste objTeileliste, String sNutzer, String sFirma) throws SQLException {
        try {
            con.setAutoCommit(false);
            Statement stmtSelect = null;
            ResultSet res = null;
            if (bGesperrt) {
                String sGesperrtVon;
                String sSQLStatementSelect = null;
                PreparedStatement ps = null;
                if (HtmlUtils.isConnectionSourceOracle(con)) {
                    if (objTeileliste instanceof Bestellliste) {
                        sSQLStatementSelect = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_BESTELLLISTE_SPERRE_FOR_UPDATE();
                        ps = con.prepareStatement(sSQLStatementSelect);
                        ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
                        ps.setString(2, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                        ps.setString(3, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                    } else {
                        sSQLStatementSelect = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_SPERRE_FOR_UPDATE();
                        ps = con.prepareStatement(sSQLStatementSelect);
                        ps.setString(1, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                        ps.setString(2, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                        ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sFirma));
                        ps.setString(4, StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                    }
                    log.debug((Object)("Executing: " + sSQLStatementSelect));
                    res = ps.executeQuery();
                    if (res != null && res.next()) {
                        String sGesperrt;
                        sGesperrtVon = res.getString("GesperrtVon");
                        if (sGesperrtVon != null && !sGesperrtVon.equals(sNutzer)) {
                            log.debug((Object)"Liste ist bereits von anderem Nutzer gesperrt.");
                            long lGesperrtAm = res.getLong("GesperrtAm");
                            Date datGesperrtAm = WebetkUtils.getDateTimeFromLong(lGesperrtAm);
                            if (!bForce || !sGesperrtVon.equals(objTeileliste.getGesperrtVon()) || datGesperrtAm.compareTo(objTeileliste.getDatGesperrtAm()) != 0) {
                                log.debug((Object)"Ohne Sperre aufh\u00f6ren.");
                                objTeileliste.setGesperrtVon(sGesperrtVon);
                                objTeileliste.setDatGesperrtAm(datGesperrtAm);
                                res.close();
                                con.commit();
                                boolean bl = false;
                                return bl;
                            }
                            log.debug((Object)"Sperre mit eigener Sperre \u00fcberschreiben.");
                        }
                        if (!(objTeileliste instanceof Bestellliste) && (sGesperrt = res.getString("Gesperrt")) != null) {
                            log.debug((Object)"Liste ist durch fehlerhaftes Senden an DMS gesperrt.");
                            objTeileliste.setGesperrt(true);
                            res.close();
                            con.commit();
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (res != null) {
                        res.close();
                    }
                } else {
                    sSQLStatementSelect = objTeileliste instanceof Bestellliste ? SQLStatements.TeilelisteJAVA.instance.RETRIEVE_BESTELLLISTE_SPERRE_FOR_UPDATE() : SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_SPERRE_FOR_UPDATE();
                    sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                    sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
                    sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
                    sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "LISTE_NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
                    log.debug((Object)("Executing: " + sSQLStatementSelect));
                    stmtSelect = con.createStatement();
                    res = stmtSelect.executeQuery(sSQLStatementSelect);
                    if (res != null && res.next()) {
                        String sGesperrt;
                        sGesperrtVon = res.getString("GesperrtVon");
                        if (sGesperrtVon != null && !sGesperrtVon.equals(sNutzer)) {
                            log.debug((Object)"Liste ist bereits von anderem Nutzer gesperrt.");
                            long lGesperrtAm = res.getLong("GesperrtAm");
                            Date datGesperrtAm = WebetkUtils.getDateTimeFromLong(lGesperrtAm);
                            if (!bForce || !sGesperrtVon.equals(objTeileliste.getGesperrtVon()) || datGesperrtAm.compareTo(objTeileliste.getDatGesperrtAm()) != 0) {
                                log.debug((Object)"Ohne Sperre aufh\u00f6ren.");
                                objTeileliste.setGesperrtVon(sGesperrtVon);
                                objTeileliste.setDatGesperrtAm(datGesperrtAm);
                                res.close();
                                stmtSelect.close();
                                con.commit();
                                boolean bl = false;
                                return bl;
                            }
                            log.debug((Object)"Sperre mit eigener Sperre \u00fcberschreiben.");
                        }
                        if (!(objTeileliste instanceof Bestellliste) && (sGesperrt = res.getString("Gesperrt")) != null) {
                            log.debug((Object)"Liste ist durch fehlerhaftes Senden an DMS gesperrt.");
                            objTeileliste.setGesperrt(true);
                            res.close();
                            stmtSelect.close();
                            con.commit();
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                if (stmtSelect != null) {
                    if (res != null) {
                        res.close();
                    }
                    stmtSelect.close();
                }
            }
            String sSQLStatement = null;
            sSQLStatement = objTeileliste instanceof Bestellliste ? SQLStatements.TeilelisteJAVA.instance.UPDATE_BESTELLLISTE_SPERRE() : SQLStatements.TeilelisteJAVA.instance.UPDATE_LISTE_SPERRE_NUTZER();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LISTE_NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
            if (bGesperrt) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", "'" + sNutzer + "'");
                Calendar oToday = Calendar.getInstance();
                long lToday = oToday.get(1) * 100000000 + (oToday.get(2) + 1) * 1000000 + oToday.get(5) * 10000 + oToday.get(11) * 100 + oToday.get(12);
                String sToday = Long.toString(lToday);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SPERRE_DAT", sToday);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", "NULL");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SPERRE_DAT", "NULL");
            }
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            con.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static ResultSet loadSperre(Connection con, String sID, String sEigentuemer, String sNutzer, String sFirma, String sFiliale) throws SQLException {
        Statement stmtSelect = null;
        ResultSet res = null;
        String sSQLStatementSelect = null;
        sSQLStatementSelect = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_SPERRE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatementSelect);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sEigentuemer));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            log.debug((Object)("Executing: " + sSQLStatementSelect));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "LISTE_NUTZER", StringUtils.maskiereHochkommaFuerDb(sEigentuemer));
        log.debug((Object)("Executing: " + sSQLStatementSelect));
        stmtSelect = con.createStatement();
        res = stmtSelect.executeQuery(sSQLStatementSelect);
        return res;
    }

    public static void insertSendeinfo(Connection con, Teileliste objTeileliste, String sFirma, String sSendeArt, String sAuftragsnummer, int nKundennummer, int nMitarbeiternummer, boolean bGreiferschein, boolean bRechnung, boolean bLieferschein, String sFreitext, String sPasswort, int nSondersteuerung, double dBar, double dUnbar) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.INSERT_SENDE_INFO();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getNutzerID()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getFiliale()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(objTeileliste.getID()));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SATZART", StringUtils.maskiereHochkommaFuerDb(sSendeArt));
        sSQLStatement = sAuftragsnummer != null && sAuftragsnummer.length() > 0 ? StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", "'" + StringUtils.maskiereHochkommaFuerDb(sAuftragsnummer) + "'") : StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNR", Integer.toString(nKundennummer));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MITARBEITERNR", Integer.toString(nMitarbeiternummer));
        sSQLStatement = bGreiferschein ? StringUtils.substituteString(sSQLStatement, "GREIFERSCHEIN", "'J'") : StringUtils.substituteString(sSQLStatement, "GREIFERSCHEIN", "NULL");
        sSQLStatement = bRechnung ? StringUtils.substituteString(sSQLStatement, "RECHNUNG", "'J'") : StringUtils.substituteString(sSQLStatement, "RECHNUNG", "NULL");
        sSQLStatement = bLieferschein ? StringUtils.substituteString(sSQLStatement, "LIEFERSCHEIN", "'J'") : StringUtils.substituteString(sSQLStatement, "LIEFERSCHEIN", "NULL");
        sSQLStatement = sFreitext != null && sFreitext.length() > 0 ? StringUtils.substituteString(sSQLStatement, "FREITEXT", "'" + StringUtils.maskiereHochkommaFuerDb(sFreitext) + "'") : StringUtils.substituteString(sSQLStatement, "FREITEXT", "NULL");
        sSQLStatement = sPasswort != null && sPasswort.length() > 0 ? StringUtils.substituteString(sSQLStatement, "PASSWORT", "'" + StringUtils.maskiereHochkommaFuerDb(sPasswort) + "'") : StringUtils.substituteString(sSQLStatement, "PASSWORT", "NULL");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SONDERSTEUERUNG", Integer.toString(nSondersteuerung));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAR", Double.toString(dBar));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNBAR", Double.toString(dUnbar));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static ResultSet loadSendeinfo(Connection con, String sNutzerID, String sFirma, String sFiliale, String sListenID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_SENDE_INFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sListenID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sListenID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelisteZuAuftrag(Connection con, String sFirmaId, String sFilialeId, String sAuftragsNr) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.GET_TEILELISTE_ZU_AUFTRAG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirmaId));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFilialeId));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sAuftragsNr));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFilialeId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNUMMER", StringUtils.maskiereHochkommaFuerDb(sAuftragsNr));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean checkTeileliste(Connection con, String sID, String sNutzer) throws SQLException {
        block7: {
            block8: {
                block5: {
                    block6: {
                        res = null;
                        try {
                            sSQLStatement = SQLStatements.TeilelisteHTML.instance.CHECK_TEILELISTE();
                            if (!HtmlUtils.isConnectionSourceOracle(con)) ** GOTO lbl26
                            ps = con.prepareStatement(sSQLStatement);
                            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
                            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzer));
                            TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                            res = ps.executeQuery();
                            if (res == null || !res.next()) break block5;
                            if (!res.getString("teileliste_id").equals(sID) || !res.getString("teileliste_user_id").equals(sNutzer)) break block6;
                            var6_7 = true;
                        }
                        catch (Throwable var7_11) {
                            WebetkUtils.closeQuery(res);
                            throw var7_11;
                        }
                        WebetkUtils.closeQuery(res);
                        return var6_7;
                    }
                    var6_8 = false;
                    WebetkUtils.closeQuery(res);
                    return var6_8;
                }
                break block7;
lbl26:
                // 1 sources

                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
                TeileListeDbAccess.log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res == null || !res.next()) break block7;
                if (!res.getString("teileliste_id").equals(sID) || !res.getString("teileliste_user_id").equals(sNutzer)) break block8;
                var6_9 = true;
                WebetkUtils.closeQuery(res);
                return var6_9;
            }
            var6_10 = false;
            WebetkUtils.closeQuery(res);
            return var6_10;
        }
        WebetkUtils.closeQuery(res);
        return false;
    }

    public static void deleteTeileliste(Connection con, String sID, String sNutzer) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        try {
            String sSQLStatement = SQLStatements.TeilelisteHTML.instance.DELETE_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteHTML.instance.DELETE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.DELETE_TEILELISTE_HIST();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            TeileListeDbAccess.deleteSapDaten(con, false, sID, sNutzer);
            sSQLStatement = SQLStatements.TeilelisteHTML.instance.DELETE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (bOldAutoCommit) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            if (bOldAutoCommit) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
    }

    public static void deleteTeileliste(Connection con, String sID, String sNutzer, String sFirma, String sFiliale, String sAuftragsnummer, boolean bScoreListe) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        try {
            String sSQLStatement = null;
            Statement stmt = null;
            sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.DELETE_TEILELISTE_HIST();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            TeileListeDbAccess.deleteAllPartsFromTeileliste(con, sID, sFirma, sFiliale, sNutzer);
            if (sAuftragsnummer != null && sAuftragsnummer.length() > 0) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_AUFTRAG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNUMMER", StringUtils.maskiereHochkommaFuerDb(sAuftragsnummer));
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            if (bScoreListe) {
                TeileListeDbAccess.deleteAllJobsAndSrpsFromScoreliste(con, sID, sFirma, sFiliale, sNutzer);
            }
            TeileListeDbAccess.deleteSendeinfo(con, sID, sFirma, sFiliale, sNutzer);
            sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (bOldAutoCommit) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            if (bOldAutoCommit) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
    }

    public static void aendereEigentuemer(Connection con, String sNewNutzer, String sID, String sNutzer, String sFirma, String sFiliale) throws SQLException, DuplicateValueException {
        boolean bOldAutoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_EIGENTUEMER();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWNUTZER", StringUtils.maskiereHochkommaFuerDb(sNewNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_EIGENTUEMER_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWNUTZER", StringUtils.maskiereHochkommaFuerDb(sNewNutzer));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (bOldAutoCommit) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            int nCode;
            if (bOldAutoCommit) {
                con.rollback();
            }
            if ((nCode = ex.getErrorCode()) == 2112) {
                throw new DuplicateValueException();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
    }

    public static ResultSet selectTeilelistenIDs(Connection con, String sNutzer, Collection<String> aMarken) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_LISTEN_IDS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTeilelistenIDs(Connection con, String sNutzer, Collection<String> aMarken, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTEN_IDS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFirma));
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Teileliste> loadTeilelistenUebersicht(Connection con, String sNutzer, String sFirma, String sFiliale, String sSprache, boolean bMitBestelllisten, boolean bUSDirect, String sFilter, boolean bPrivate) throws SQLException {
        Vector<Teileliste> aResult = new Vector<Teileliste>();
        Vector<Teileliste> aGesperrtMitAuftrag = new Vector<Teileliste>();
        Vector<Teileliste> aGesperrtOhneAuftrag = new Vector<Teileliste>();
        Vector<Teileliste> aNichtGesperrtMitAuftrag = new Vector<Teileliste>();
        Vector<Teileliste> aNichtGesperrtOhneAuftrag = new Vector<Teileliste>();
        ResultSet res = null;
        Statement stmt = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_UEBERSICHT();
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                int index = 0;
                StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFirma));
                if (sFilter.equals("nutzer")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_NUTZER());
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
                } else if (sFilter.equals("filiale")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FILIALE());
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFiliale));
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
                } else if (sFilter.equals("firma")) {
                    if (bPrivate) {
                        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FIRMA_MIT_PRIVAT());
                        StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
                    } else {
                        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FIRMA());
                        StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sNutzer));
                    }
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug((Object)("Executing: " + sSQLStatement));
                res = ps.executeQuery();
                if (res != null) {
                    while (res.next()) {
                        String sEigentuemer;
                        String sID = res.getString("ListeId");
                        if (!bUSDirect && Marken.getInstance().getEigenschaften("marke.usListenIds").contains(sID) || (sEigentuemer = res.getString("UserId")) != null && sEigentuemer.equals("score")) continue;
                        Teileliste oTL = new Teileliste("", sEigentuemer, sID, sSprache);
                        oTL.setNutzerName(res.getString("UserName"));
                        oTL.setFiliale(res.getString("Filiale"));
                        oTL.setFilialeBen(res.getString("FilialeBen"));
                        oTL.setBemerkung(res.getString("Bemerkung"));
                        oTL.setDatErstellung(WebetkUtils.getDateFromLong(res.getLong("Erzeugt")));
                        String sGesperrt = res.getString("Gesperrt");
                        oTL.setGesperrt(sGesperrt != null && sGesperrt.equals("J"));
                        String sPrivat = res.getString("Privat");
                        oTL.setPrivat(sPrivat != null && sPrivat.equals("J"));
                        oTL.setSapStatus(res.getString("RrSapStatus"));
                        String sAuftragsNr = res.getString("Auftragsnr");
                        if (sAuftragsNr != null) {
                            String sKundenNr = res.getString("Kundennr");
                            Long lKundenNr = null;
                            if (sKundenNr != null) {
                                lKundenNr = Long.valueOf(sKundenNr);
                            }
                            Auftrag oAuftrag = new Auftrag(sFirma, sFiliale, sAuftragsNr, lKundenNr, null, null);
                            oTL.setAuftrag(oAuftrag);
                        } else {
                            oTL.setAuftrag(null);
                        }
                        if (oTL.getGesperrt()) {
                            if (sAuftragsNr != null) {
                                aGesperrtMitAuftrag.add(oTL);
                                continue;
                            }
                            aGesperrtOhneAuftrag.add(oTL);
                            continue;
                        }
                        if (sAuftragsNr != null) {
                            aNichtGesperrtMitAuftrag.add(oTL);
                            continue;
                        }
                        aNichtGesperrtOhneAuftrag.add(oTL);
                    }
                }
                WebetkUtils.closeQuery(res);
            } else {
                if (sFilter.equals("nutzer")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_NUTZER());
                } else if (sFilter.equals("filiale")) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FILIALE());
                } else if (sFilter.equals("firma")) {
                    sSQLStatement = bPrivate ? StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FIRMA_MIT_PRIVAT()) : StringUtils.substituteString(sSQLStatement, "FILTER", SQLStatements.TeilelisteJAVA.instance.FILTER_FIRMA());
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res != null) {
                    while (res.next()) {
                        String sEigentuemer;
                        String sID = res.getString("ListeId");
                        if (!bUSDirect && Marken.getInstance().getEigenschaften("marke.usListenIds").contains(sID) || (sEigentuemer = res.getString("UserId")) != null && sEigentuemer.equals("score")) continue;
                        Teileliste oTL = new Teileliste("", sEigentuemer, sID, sSprache);
                        oTL.setNutzerName(res.getString("UserName"));
                        oTL.setFiliale(res.getString("Filiale"));
                        oTL.setFilialeBen(res.getString("FilialeBen"));
                        oTL.setBemerkung(res.getString("Bemerkung"));
                        oTL.setDatErstellung(WebetkUtils.getDateFromLong(res.getLong("Erzeugt")));
                        String sGesperrt = res.getString("Gesperrt");
                        oTL.setGesperrt(sGesperrt != null && sGesperrt.equals("J"));
                        String sPrivat = res.getString("Privat");
                        oTL.setPrivat(sPrivat != null && sPrivat.equals("J"));
                        oTL.setSapStatus(res.getString("RrSapStatus"));
                        String sAuftragsNr = res.getString("Auftragsnr");
                        if (sAuftragsNr != null) {
                            String sKundenNr = res.getString("Kundennr");
                            Long lKundenNr = null;
                            if (sKundenNr != null) {
                                lKundenNr = Long.valueOf(sKundenNr);
                            }
                            Auftrag oAuftrag = new Auftrag(sFirma, sFiliale, sAuftragsNr, lKundenNr, null, null);
                            oTL.setAuftrag(oAuftrag);
                        } else {
                            oTL.setAuftrag(null);
                        }
                        if (oTL.getGesperrt()) {
                            if (sAuftragsNr != null) {
                                aGesperrtMitAuftrag.add(oTL);
                                continue;
                            }
                            aGesperrtOhneAuftrag.add(oTL);
                            continue;
                        }
                        if (sAuftragsNr != null) {
                            aNichtGesperrtMitAuftrag.add(oTL);
                            continue;
                        }
                        aNichtGesperrtOhneAuftrag.add(oTL);
                    }
                }
                WebetkUtils.closeQuery(res);
            }
            aResult.addAll(aGesperrtMitAuftrag);
            aResult.addAll(aGesperrtOhneAuftrag);
            aResult.addAll(aNichtGesperrtMitAuftrag);
            aResult.addAll(aNichtGesperrtOhneAuftrag);
            if (bMitBestelllisten) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_UEBERSICHT_BESTELLLISTEN();
                if (HtmlUtils.isConnectionSourceOracle(con)) {
                    PreparedStatement ps = con.prepareStatement(sSQLStatement);
                    ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
                    ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
                    log.debug((Object)("Executing: " + sSQLStatement));
                    res = ps.executeQuery();
                    if (res != null) {
                        while (res.next()) {
                            String sId = res.getString("ListeId");
                            Bestellliste oBL = new Bestellliste(sId);
                            oBL.setFiliale(sFiliale);
                            oBL.setGesperrtVon(res.getString("GesperrtVon"));
                            long lGesperrtAm = res.getLong("GesperrtAm");
                            if (lGesperrtAm > 0L) {
                                oBL.setDatGesperrtAm(WebetkUtils.getDateFromLong(lGesperrtAm));
                            }
                            aResult.add(oBL);
                        }
                    }
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
                    log.debug((Object)("Executing: " + sSQLStatement));
                    stmt = con.createStatement();
                    res = stmt.executeQuery(sSQLStatement);
                    if (res != null) {
                        while (res.next()) {
                            String sId = res.getString("ListeId");
                            Bestellliste oBL = new Bestellliste(sId);
                            oBL.setFiliale(sFiliale);
                            oBL.setGesperrtVon(res.getString("GesperrtVon"));
                            long lGesperrtAm = res.getLong("GesperrtAm");
                            if (lGesperrtAm > 0L) {
                                oBL.setDatGesperrtAm(WebetkUtils.getDateFromLong(lGesperrtAm));
                            }
                            aResult.add(oBL);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return aResult;
    }

    public static ResultSet selectBestelllistenIDs(Connection con, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_BESTELLLISTEN_IDS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelisteAllgemein(Connection con, String sID, String sNutzerID) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_LISTE_ALLG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelisteAllgemein(Connection con, String sID, String sNutzerID, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_ALLG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBestelllisteAllgemein(Connection con, String sID, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_BESTELLLISTE_ALLG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelistePositionen(Connection con, String sID, String sNutzerID, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_LISTE_POS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(1, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelistePositionen(Connection con, String sID, String sNutzerID, String sSprache, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_LISTE_POS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBestelllistePositionen(Connection con, String sID, String sSprache, String sFirma, String sFiliale) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_BESTELLLISTE_POS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
            ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeil(Connection con, String sSachnummer, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileliste.instance.RETRIEVE_TEIL();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sSachnummer));
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(3, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", StringUtils.maskiereHochkommaFuerDb(sSachnummer));
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadPreisInfo(Connection con, String sSachnummer, String sFirma) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_TEIL_PREISE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sSachnummer));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFirma));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", StringUtils.maskiereHochkommaFuerDb(sSachnummer));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelistePreisInfo(Connection con, String sFirma, String sFiliale, String sNutzerId, String sTeilelisteId) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_TEILELISTE_PREISE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sFirma);
            ps.setString(2, sFiliale);
            ps.setString(3, sTeilelisteId);
            ps.setString(4, sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sTeilelisteId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilelistePubldaten(Connection con, String sFirma, String sFiliale, String sNutzerId, String sTeilelisteId, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_TEILELISTE_PUBLDATEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(3, sFirma);
            ps.setString(4, sFiliale);
            ps.setString(5, sTeilelisteId);
            ps.setString(6, sNutzerId);
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(1, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sTeilelisteId);
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void saveTeilScoreStatus(Connection con, Teil objTeil, String sID, String sNutzerID, String sFirma, String sFiliale) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_SCORELISTE_POS_STATUS();
        sSQLStatement = TeileListeDbAccess.substituteInListePosSqlString(sSQLStatement, sID, sFirma, sFiliale, sNutzerID, false, null, null, objTeil, objTeil.getPos());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "STATUS", Integer.toString(objTeil.getScoreAenderung()));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void saveTeilInListe(Connection con, Teil objTeil, String sID, String sNutzerID, String sFirma, String sFiliale, String sJobId, String sSrpId) throws SQLException {
        int nRowsUpdated = TeileListeDbAccess.updateTeilInListe(con, sID, sFirma, sFiliale, sNutzerID, false, sJobId, sSrpId, objTeil);
        if (nRowsUpdated == 0) {
            TeileListeDbAccess.insertTeilInListe(con, sID, sFirma, sFiliale, sNutzerID, false, sJobId, sSrpId, objTeil, Integer.parseInt(objTeil.getPos()));
        }
    }

    public static void saveTeilInBestellliste(Connection con, Teil objTeil, String sID, String sFirma, String sFiliale) throws SQLException {
        int nRowsUpdated = TeileListeDbAccess.updateTeilInListe(con, sID, sFirma, sFiliale, null, true, null, null, objTeil);
        if (nRowsUpdated == 0) {
            TeileListeDbAccess.insertTeilInListe(con, sID, sFirma, sFiliale, null, true, null, null, objTeil, objTeil.getPosInt());
        }
    }

    public static void deleteTeilAusListe(Connection con, Teil objTeil, String sID, String sNutzerID, String sFirma, String sFiliale, boolean bScore) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_SINGLE_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", objTeil.getPos());
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (!bScore) {
                sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_POS();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", objTeil.getPos());
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
            }
            if (bOldAutoCommit) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            if (bOldAutoCommit) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
    }

    public static void deleteTeileAusTeileliste(Connection con, Collection<Teil> cTeile, String sID, String sNutzerID, String sFirma, String sFiliale, boolean bBestellliste, boolean bScore) throws SQLException {
        con.setAutoCommit(false);
        try {
            for (Teil oTeil : cTeile) {
                if (bBestellliste) {
                    TeileListeDbAccess.deleteTeilAusBestellliste(con, oTeil, sID, sFirma, sFiliale);
                } else {
                    TeileListeDbAccess.deleteTeilAusListe(con, oTeil, sID, sNutzerID, sFirma, sFiliale, bScore);
                }
                for (Teil oTeilPos : cTeile) {
                    oTeilPos.setPos(oTeilPos.getPosInt() - 1);
                }
            }
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static void deleteAllPartsFromBestellliste(Connection con, String sID, String sFirma, String sFiliale) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_BESTELLLISTE_POS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    private static void deleteAllPartsFromTeileliste(Connection con, String sID, String sFirma, String sFiliale, String sNutzer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_POS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    private static void deleteAllJobsAndSrpsFromScoreliste(Connection con, String sID, String sFirma, String sFiliale, String sNutzer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_JOBS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
        sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_SRPS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzer));
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void deleteTeilAusBestellliste(Connection con, Teil objTeil, String sID, String sFirma, String sFiliale) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.DELETE_BESTELLLISTE_SINGLE_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", objTeil.getPos());
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteJAVA.instance.UPDATE_BESTELL_POS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "POS", objTeil.getPos());
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (bOldAutoCommit) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            if (bOldAutoCommit) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
    }

    public static void storeAuftrag(Connection con, boolean bInsert, String sFirmaId, String sFilialeId, String sAuftragsnummer, Long lKundennummer, String sKundenname, String sFahrgestellnummer) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = bInsert ? SQLStatements.TeilelisteJAVA.instance.INSERT_AUFTRAG() : SQLStatements.TeilelisteJAVA.instance.UPDATE_AUFTRAG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFilialeId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNUMMER", StringUtils.maskiereHochkommaFuerDb(sAuftragsnummer));
        String sKundennummer = lKundennummer == null ? "null" : lKundennummer.toString();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNUMMER", sKundennummer);
        sKundenname = sKundenname == null ? "null" : "'" + StringUtils.maskiereHochkommaFuerDb(sKundenname) + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNAME", sKundenname);
        sFahrgestellnummer = sFahrgestellnummer == null ? "null" : "'" + StringUtils.maskiereHochkommaFuerDb(sFahrgestellnummer) + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FGSTNR", sFahrgestellnummer);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void storeBestellliste(Connection con, String sId, String sFilialId, String sFirmaId) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.INSERT_BESTELLLISTE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", StringUtils.maskiereHochkommaFuerDb(sFilialId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sId));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static ResultSet loadMailAdressen(Connection con, Collection<String> aMarken) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML.instance.RETRIEVE_MAILADRESSEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSapStatus(Connection con, String sID, String sNutzerID, long lAbfrageId) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.LOAD_TEILELISTE_RR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            ps.setString(3, Long.toString(lAbfrageId));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABFRAGEID", Long.toString(lAbfrageId));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSapAntwort(Connection con, String sID, String sNutzerID, long lAbfrageId) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.LOAD_TEILELISTE_POS_RR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            ps.setString(3, Long.toString(lAbfrageId));
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABFRAGEID", Long.toString(lAbfrageId));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeSapDaten(Connection con, String sID, String sNutzerID, String sArt) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        long lAbfrageId = 0L;
        try {
            TeileListeDbAccess.deleteSapDaten(con, false, sID, sNutzerID);
            lAbfrageId = TeileListeDbAccess.getNextAbfrageId(con);
            String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.INSERT_TEILELISTE_RR();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABFRAGEID", Long.toString(lAbfrageId));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "STATUS", "A");
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            con.commit();
        }
        finally {
            con.setAutoCommit(bOldAutoCommit);
        }
        return lAbfrageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSapDaten(Connection con, boolean bCommit, String sID, String sNutzerID) throws SQLException {
        boolean bOldAutoCommit = con.getAutoCommit();
        if (bCommit) {
            con.setAutoCommit(false);
        }
        try {
            String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.DELETE_TEILELISTE_RR();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.DELETE_TEILELISTEPOS_RR();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            if (bCommit) {
                con.commit();
            }
        }
        finally {
            if (bCommit) {
                con.setAutoCommit(bOldAutoCommit);
            }
        }
    }

    public static ResultSet loadHistorie(Connection con, String sID, String sNutzerID, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.LOAD_TEILELISTE_HIST();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sID));
            ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(3, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(4, sRegISO);
            ps.setString(5, "H");
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadHistorie(Connection con, String sFirma, String sID, String sNutzerID, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.LOAD_TEILELISTE_HIST();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void writeHistorie(Connection con, String sID, String sNutzerID, long lAbfrageId, String sFunktion) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.INSERT_TEILELISTE_HIST();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABFRAGEID", Long.toString(lAbfrageId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FUNKTION", StringUtils.maskiereHochkommaFuerDb(sFunktion));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void writeHistorie(Connection con, String sFirma, String sID, String sNutzerID, long lAbfrageId, String sFunktion) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.INSERT_TEILELISTE_HIST();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABFRAGEID", Long.toString(lAbfrageId));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FUNKTION", StringUtils.maskiereHochkommaFuerDb(sFunktion));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextAbfrageId(Connection con) throws SQLException {
        long lAbfrageId = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteHTML_SAP.instance.GET_NEXT_ABFRAGE_SEQ_VAL();
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                lAbfrageId = res.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return lAbfrageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextTeilelistenId(Connection con) throws SQLException {
        long lTeilelistenId = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.GET_NEXT_ID_SEQ_VAL();
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                lTeilelistenId = res.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return lTeilelistenId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNextScorelistenId(Connection con) throws SQLException {
        long lTeilelistenId = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.GET_NEXT_SCOREID_SEQ_VAL();
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                lTeilelistenId = res.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return "Score_" + Long.toString(lTeilelistenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextRrSapListenId(Connection con) throws SQLException {
        long lTeilelistenId = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.GET_NEXT_RRSAPID_SEQ_VAL();
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                lTeilelistenId = res.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return lTeilelistenId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextSammelnutzerListenId(Connection con) throws SQLException {
        long lTeilelistenId = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteHTML.instance.GET_NEXT_SAMMELID_SEQ_VAL();
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next()) {
                lTeilelistenId = res.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return lTeilelistenId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextPos(Connection con, String sID, String sNutzerID, String sFirma, String sFiliale) throws SQLException {
        long lPos = 0L;
        ResultSet res = null;
        try {
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.RETRIEVE_MAX_POS();
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps.setString(1, StringUtils.maskiereHochkommaFuerDb(sFirma));
                ps.setString(2, StringUtils.maskiereHochkommaFuerDb(sFiliale));
                ps.setString(3, StringUtils.maskiereHochkommaFuerDb(sID));
                ps.setString(4, StringUtils.maskiereHochkommaFuerDb(sNutzerID));
                log.debug((Object)("Executing: " + sSQLStatement));
                res = ps.executeQuery();
                if (res != null && res.next()) {
                    lPos = res.getLong(1) + 1L;
                }
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", StringUtils.maskiereHochkommaFuerDb(sFiliale));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sID));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZER", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
                log.debug((Object)("Executing: " + sSQLStatement));
                Statement stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res != null && res.next()) {
                    lPos = res.getLong(1) + 1L;
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return lPos;
    }

    public static void copyTeileliste(Connection con, String sNewID, String sOldID, String sNewNutzerID, String sOldNutzerID, String sFirma, String sNewFiliale, String sOldFiliale) throws SQLException, DuplicateValueException {
        try {
            con.setAutoCommit(false);
            String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.COPY_LISTE_ALLG();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWID", StringUtils.maskiereHochkommaFuerDb(sNewID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDID", StringUtils.maskiereHochkommaFuerDb(sOldID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWFILIALE", StringUtils.maskiereHochkommaFuerDb(sNewFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDFILIALE", StringUtils.maskiereHochkommaFuerDb(sOldFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWNUTZER", StringUtils.maskiereHochkommaFuerDb(sNewNutzerID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDNUTZER", StringUtils.maskiereHochkommaFuerDb(sOldNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            sSQLStatement = SQLStatements.TeilelisteJAVA.instance.COPY_LISTE_POSITIONEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWID", StringUtils.maskiereHochkommaFuerDb(sNewID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDID", StringUtils.maskiereHochkommaFuerDb(sOldID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWFILIALE", StringUtils.maskiereHochkommaFuerDb(sNewFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDFILIALE", StringUtils.maskiereHochkommaFuerDb(sOldFiliale));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWNUTZER", StringUtils.maskiereHochkommaFuerDb(sNewNutzerID));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDNUTZER", StringUtils.maskiereHochkommaFuerDb(sOldNutzerID));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            int nCode = ex.getErrorCode();
            if (nCode == 1 || nCode == 16801 || nCode == 9151) {
                throw new DuplicateValueException();
            }
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static ResultSet loadFzgDlfIds(Connection con, String sFirmaId) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.GET_RELEASED_SCORE_LISTS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadRrNutzerdaten(Connection con, String sNutzerID, String sFirma) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.LOAD_NUTZERDATEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sNutzerID));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void saveRrNutzerdaten(Connection con, String sFirma, String sId, RrNutzerdaten oNutzerdaten) throws SQLException {
        int nRowsUpdated = TeileListeDbAccess.updateRrNutzerdaten(con, sFirma, sId, oNutzerdaten);
        if (nRowsUpdated == 0) {
            TeileListeDbAccess.insertRrNutzerdaten(con, sFirma, sId, oNutzerdaten);
        }
    }

    private static int updateRrNutzerdaten(Connection con, String sFirma, String sId, RrNutzerdaten oNutzerdaten) throws SQLException {
        int nRowsUpdated = 0;
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.UPDATE_NUTZERDATEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sId));
        String sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerName());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NAME", sValue);
        sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerTelefon());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TELEFON", sValue);
        sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerEMail());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "EMAIL", sValue);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HAENDLERNR", StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getHaendlernummer()));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        nRowsUpdated = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return nRowsUpdated;
    }

    private static void insertRrNutzerdaten(Connection con, String sFirma, String sId, RrNutzerdaten oNutzerdaten) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.INSERT_NUTZERDATEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", StringUtils.maskiereHochkommaFuerDb(sId));
        String sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerName());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NAME", sValue);
        sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerTelefon());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TELEFON", sValue);
        sValue = StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getNutzerEMail());
        sValue = sValue == null || sValue.length() < 1 ? "null" : "'" + sValue + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "EMAIL", sValue);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HAENDLERNR", StringUtils.maskiereHochkommaFuerDb(oNutzerdaten.getHaendlernummer()));
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static ResultSet loadTCKennzeichen(Connection con, String sSachnummer, long lModellspalte, String sLandkuerzel) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA.instance.LOAD_TC_INFO();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.TeilelisteJAVA.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void renameRrSapListe(Connection con, String firma, String filiale, String user, String oldID, String newID) throws SQLException {
        String sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.UPDATE_ID_IN_LISTEPOS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWID", newID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDID", oldID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", firma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", filiale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER", user);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
        sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.UPDATE_ID_IN_LISTEHIST();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWID", newID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDID", oldID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", firma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER", user);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
        sSQLStatement = SQLStatements.TeilelisteJAVA_SAP.instance.UPDATE_ID_IN_LISTE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NEWID", newID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "OLDID", oldID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", firma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", filiale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER", user);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }
}

