/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileSucheAllgemeinDbAccess {
    private static Logger log = Logger.getLogger(TeileSucheAllgemeinDbAccess.class);

    public static ResultSet selectMarktBenennung(Connection con, String sSprache, String sProduktart, String sBildtafelnummer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAllgemein.instance.LOAD_MARKT_BENENNUNG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1008);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(2, sProduktart);
            ps.setString(1, sBildtafelnummer);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelnummer);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement(1004, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

