/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.LanguageUtils;
import webetk.app.zub.suche.BegriffSuche;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileVwdgBenDbAccess {
    private static Logger log = Logger.getLogger(TeileVwdgBenDbAccess.class);

    public static ResultSet loadBaureihen(Connection con, String sSuchbegriff, String sMarke, String sProduktart, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSuchstring = null;
        if (sSuchbegriff != null) {
            try {
                BegriffSuche suche = new BegriffSuche(sSuchbegriff);
                sSuchstring = suche.getSuchString("H.ben_text", "", true, sISO.equals("tr"));
            }
            catch (InvalidInitializationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        boolean bSonderlocke = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de") && (bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring))) {
            sSuchstring1 = sSuchstring;
            sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            sSuchstring2 = sSuchstring2.replace("H.BEN_TEXT", "H.ben_text");
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_BAUREIHEN_SONDERLOCKE();
                int index = 0;
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sKatalog);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sKatalog);
                StringUtils.setPreparedStatementParams(++index, "N");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
                for (String sRegionen : cRegionen) {
                    StringUtils.setPreparedStatementParams(++index, sRegionen);
                }
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug((Object)("Executing: " + sSQLStatement));
                ResultSet res = ps.executeQuery();
                return res;
            }
            sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_BAUREIHEN();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilevwdgBen.instance.RETRIEVE_BAUREIHEN_SONDERLOCKE() : SQLStatements.TeilevwdgBen.instance.RETRIEVE_BAUREIHEN();
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBaureihenTNR(Connection con, List<String> cSachnummern, String sModellspaltenIDs, String sMarke, String sProduktart, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_BAUREIHEN_TNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cSachnummern.size()));
            for (String sSachnummern : cSachnummern) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSachnummern = null;
        Iterator<String> iterator = cSachnummern.iterator();
        while (iterator.hasNext()) {
            String sSachnummer = iterator.next().toString();
            if (sSachnummern == null) {
                sSachnummern = "'" + sSachnummer + "'";
                continue;
            }
            sSachnummern = sSachnummern + ", '" + sSachnummer + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sSachnummern);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        String sRegionen = "";
        iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadModellspalten(Connection con, String sSuchstring, String sModellspaltenIDs, String sBaureihe, String sMarke, String sProduktart, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        if (sSuchstring != null) {
            try {
                BegriffSuche suche = new BegriffSuche(sSuchstring);
                sSuchstring = suche.getSuchString("H.ben_text", "", true, sISO.equals("tr"));
            }
            catch (InvalidInitializationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        boolean bSonderlocke = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de") && (bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring))) {
            sSuchstring1 = sSuchstring;
            sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            sSuchstring2 = sSuchstring2.replace("H.BEN_TEXT", "H.ben_text");
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_MODELLSPALTEN_SONDERLOCKE();
                int index = 0;
                String sRegISO = LanguageUtils.toRegion(sSprache, true);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                StringUtils.setPreparedStatementParams(++index, sKatalog);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, sBaureihe);
                StringUtils.setPreparedStatementParams(++index, sKatalog);
                StringUtils.setPreparedStatementParams(++index, "N");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
                for (String sRegionen : cRegionen) {
                    StringUtils.setPreparedStatementParams(++index, sRegionen);
                }
                StringUtils.setPreparedStatementParams(++index, "K");
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
                    String[] aMospIDs = sModellspaltenIDs.split(",");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
                    for (int i = 0; i < aMospIDs.length; ++i) {
                        StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
                    }
                    StringUtils.setPreparedStatementParams(++index, sModellspaltenIDs);
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
                }
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug((Object)("Executing: " + sSQLStatement));
                ResultSet res = ps.executeQuery();
                return res;
            }
            sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_MODELLSPALTEN();
            int index = 0;
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "K");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", SQLStatements.TeilevwdgTeil.instance.MODELLSPALTEN_STMT());
                StringUtils.setPreparedStatementParams(++index, sModellspaltenIDs);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilevwdgBen.instance.RETRIEVE_MODELLSPALTEN_SONDERLOCKE() : SQLStatements.TeilevwdgBen.instance.RETRIEVE_MODELLSPALTEN();
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        if (sModellspaltenIDs != null && !sModellspaltenIDs.equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", SQLStatements.TeilevwdgTeil.instance.MODELLSPALTEN_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sModellspaltenIDs);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODELLSPALTEN_STMT", "");
        }
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadModellspaltenTNR(Connection con, Collection<String> cSachnummern, String sModellspaltenIDs, String sBaureihe, String sMarke, String sProduktart, String sKatalog, String sSprache, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.TeilevwdgBen.instance.RETRIEVE_MODELLSPALTEN_TNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cSachnummern.size()));
            for (String sSachnummern : cSachnummern) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sKatalog);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, "K");
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSachnummern = null;
        Iterator<String> iterator = cSachnummern.iterator();
        while (iterator.hasNext()) {
            String sSachnummer = iterator.next().toString();
            if (sSachnummern == null) {
                sSachnummern = "'" + sSachnummer + "'";
                continue;
            }
            sSachnummern = sSachnummern + ", '" + sSachnummer + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sSachnummern);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalog);
        String sRegionen = "";
        iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummern_TVBenennung(Connection con, String sSuchstring, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        if (sSuchstring != null) {
            try {
                BegriffSuche suche = new BegriffSuche(sSuchstring);
                sSuchstring = suche.getSuchString("ben_teil.ben_text", "", true, sISO.equals("tr"));
            }
            catch (InvalidInitializationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        boolean bSonderlocke = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de") && (bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring))) {
            sSuchstring1 = sSuchstring;
            sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            sSuchstring2 = sSuchstring2.replace("BEN_TEIL.BEN_TEXT", "ben_teil.ben_text");
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilevwdgBen.instance.SEARCH_SNR_TVBENENNUNG_SONDERLOCKE();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
                int index = 0;
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, "J");
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, "J");
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps = StringUtils.setParameters(ps);
                log.debug((Object)("Executing: " + sSQLStatement));
                ResultSet res = ps.executeQuery();
                return res;
            }
            sSQLStatement = SQLStatements.TeilevwdgBen.instance.SEARCH_SNR_TVBENENNUNG();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "J");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "B");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "J");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "B");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilevwdgBen.instance.SEARCH_SNR_TVBENENNUNG_SONDERLOCKE() : SQLStatements.TeilevwdgBen.instance.SEARCH_SNR_TVBENENNUNG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_SNrs(Connection con, Collection<String> cTeile, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.TeilevwdgBen.instance.SEARCH_BT_SACHNUMMERN_TVBEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMERN());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(cTeile.size()));
            for (String sSachnummern : cTeile) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cTeile.size()));
            for (String sSachnummern : cTeile) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.TeilevwdgBen.instance.SEARCH_BT_SACHNUMMERN_TVBEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "UNION", " union ");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEARCH_BT_SACHNUMMERN_ASS", SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMERN());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", "");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sSachnummern = null;
        iterator = cTeile.iterator();
        while (iterator.hasNext()) {
            String sSachnummer = iterator.next().toString();
            if (sSachnummern == null) {
                sSachnummern = "'" + sSachnummer + "'";
                continue;
            }
            sSachnummern = sSachnummern + ", '" + sSachnummer + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sSachnummern);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

