/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.NoDataFoundException;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class VisualisierungsTeilDbAccess {
    private static Logger log = Logger.getLogger(VisualisierungsTeilDbAccess.class);

    public static ResultSet retrieveVisualisierungsInfo(Connection con, String sLang, Collection<String> aMarken, Collection<String> aProdukte, String sSachnummer) throws SQLException, NoDataFoundException, DatabaseBusyException {
        try {
            return VisualisierungsTeilDbAccess.retrieveVisualisierungsInfoUgb(con, sLang, aMarken, aProdukte, sSachnummer);
        }
        catch (NoDataFoundException e) {
            return VisualisierungsTeilDbAccess.retrieveVisualisierungsInfoGeb(con, sLang, aMarken, aProdukte, sSachnummer);
        }
    }

    private static ResultSet retrieveVisualisierungsInfoGeb(Connection con, String sLang, Collection<String> aMarken, Collection<String> aProdukte, String sSachnummer) throws SQLException, NoDataFoundException, DatabaseBusyException {
        String sSQLStatement = SQLStatements.VisualisierungTeil.instance.RETRIEVE_VISUALISIERUNGSINFO_GEB();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(aProdukte.size()));
            for (String sProdukte : aProdukte) {
                StringUtils.setPreparedStatementParams(++index, sProdukte);
            }
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "PRODUKTARTEN", aProdukte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.next()) {
            throw new NoDataFoundException("No values found");
        }
        return res;
    }

    private static ResultSet retrieveVisualisierungsInfoUgb(Connection con, String sLang, Collection<String> aMarken, Collection<String> aProdukte, String sSachnummer) throws SQLException, NoDataFoundException, DatabaseBusyException {
        String sSQLStatement = SQLStatements.VisualisierungTeil.instance.RETRIEVE_VISUALISIERUNGSINFO_UGB();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(aProdukte.size()));
            for (String sProdukte : aProdukte) {
                StringUtils.setPreparedStatementParams(++index, sProdukte);
            }
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "N");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "PRODUKTARTEN", aProdukte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.next()) {
            throw new NoDataFoundException("No values found");
        }
        return res;
    }
}

