/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.common.PreisZeile;
import webetk.app.zub.common.Preise;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.db.SQLStatements;
import webetk.db.zub.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class PreiseDbAccess {
    private static Logger log = Logger.getLogger(PreiseDbAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preise ladeTeileUndPreiseZuBte(String firmaid, String btenr, String btetyp, AufwandsKonfiguration aufwaende, FzgSucheInfo fahrzeug, ArrayList hinzugefuegteTeile, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs;
        Connection con;
        ArrayList<PreisZeile> zeilen;
        block23: {
            Statement prep;
            block22: {
                zeilen = new ArrayList<PreisZeile>();
                con = null;
                globs = ServerGlobalObjects.getInstance();
                prep = null;
                String statement = null;
                Collection<Long> mospIds = null;
                String sMospIds = null;
                if (fahrzeug != null) {
                    if (fahrzeug.getModellspalte() > 0L) {
                        mospIds = new Vector<Long>();
                        Long mosp = new Long(fahrzeug.getModellspalte());
                        mospIds.add(mosp);
                    } else {
                        mospIds = fahrzeug.getModellspalten();
                    }
                }
                if (mospIds != null && !mospIds.isEmpty()) {
                    for (Long lMospId : mospIds) {
                        String sMospId = lMospId.toString();
                        if (sMospIds == null) {
                            sMospIds = sMospId;
                            continue;
                        }
                        sMospIds = sMospIds + ", " + sMospId;
                    }
                }
                statement = btetyp.equals("FZG") ? (sMospIds != null ? SQLStatements.Preise.instance.LOAD_TEILE_UND_PREISE_ZU_MOSPIDS_FZG_BTE() : SQLStatements.Preise.instance.LOAD_TEILE_UND_PREISE_ZU_FZG_BTE()) : SQLStatements.Preise.instance.LOAD_TEILE_UND_PREISE_ZU_UGB_BTE();
                log.debug((Object)("Executing SQL-Statement: " + statement));
                ResultSet res = null;
                try {
                    con = globs.getDBConnection("zub.preise.ladeTeileUndPreiseZuBte");
                    if (sMospIds != null) {
                        statement = StringUtils.substituteString(statement, "MOSPIDS", sMospIds);
                    }
                    prep = con.prepareStatement(statement);
                    prep.setString(1, btenr);
                    res = prep.executeQuery();
                    while (res.next()) {
                        PreisZeile zeile = new PreisZeile();
                        zeile.setPos(res.getInt("Pos"));
                        zeile.setGehZuPos(res.getInt("Gehzupos"));
                        zeile.setBnbNr(res.getString("Bildpos"));
                        zeile.setArt(res.getString("Art"));
                        zeile.setVerweis(res.getInt("Verweis"));
                        zeile.setSachNr(res.getString("Sachnr"));
                        zeile.setHgUg(res.getString("Hg") + res.getString("Ug"));
                        zeile.setTeileart(res.getString("Teileart"));
                        zeile.setElementArt(res.getString("Elemart"));
                        zeile.setBuendel(res.getString("Buendel"));
                        zeile.setVarianteId(res.getLong("Variante"));
                        String sMengeMin = res.getString("Mengemin");
                        int nMengeMin = 1;
                        try {
                            nMengeMin = Integer.parseInt(sMengeMin);
                            if (nMengeMin == 0) {
                                nMengeMin = 1;
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        zeile.setMengeMin(nMengeMin);
                        zeile.setPreis(null);
                        zeilen.add(zeile);
                    }
                    if (res == null) break block22;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        WebetkUtils.closeQuery(res);
                    } else if (prep != null) {
                        prep.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "zub.preise.ladeTeileUndPreiseZuBte");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                break block23;
            }
            if (prep != null) {
                prep.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.preise.ladeTeileUndPreiseZuBte");
        }
        if (hinzugefuegteTeile != null) {
            for (PreisZeile zeile : hinzugefuegteTeile) {
                if (zeile.getHgUg() != null) continue;
                zeile.setHgUg(PreiseDbAccess.ladeHgUg(zeile.getSachNr()));
            }
            zeilen.addAll(hinzugefuegteTeile);
        }
        PreiseDbAccess.ladePreiseZuTeilen(firmaid, zeilen);
        Preise preise = new Preise(aufwaende, fahrzeug);
        preise.setBtenr(btenr);
        Iterator iter = zeilen.iterator();
        while (iter.hasNext()) {
            preise.addPreisZeile((PreisZeile)iter.next());
        }
        PreiseDbAccess.ladeEinbauinfos(btenr, preise, marktId, produktart);
        return preise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ladeHgUg(String sachnr) throws SQLException, DatabaseBusyException {
        String string;
        ServerGlobalObjects globs;
        Connection con;
        block20: {
            ResultSet res;
            block18: {
                String string2;
                block19: {
                    con = null;
                    globs = ServerGlobalObjects.getInstance();
                    String statement = SQLStatements.Teileinfo.instance.RETRIEVE_HGUG();
                    if (HtmlUtils.isConnectionSourceOracle(con)) {
                        String hg2;
                        block17: {
                            ResultSet res2;
                            block15: {
                                String string3;
                                block16: {
                                    res2 = null;
                                    try {
                                        con = globs.getDBConnection("zub.preise.ladeHgUg");
                                        PreparedStatement ps = con.prepareStatement(statement);
                                        ps.setString(1, sachnr);
                                        res2 = ps.executeQuery();
                                        log.debug((Object)("Executing SQL-Statement: " + statement));
                                        if (!res2.next()) break block15;
                                        String hg2 = res2.getString("Hg");
                                        String ug = res2.getString("Ug");
                                        string3 = hg2 + ug;
                                        if (res2 == null) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        if (res2 != null) {
                                            WebetkUtils.closeQuery(res2);
                                        }
                                        if (con != null) {
                                            globs.freeDBConnection(con, "zub.preise.ladeHgUg");
                                        }
                                        throw throwable;
                                    }
                                    WebetkUtils.closeQuery(res2);
                                }
                                if (con != null) {
                                    globs.freeDBConnection(con, "zub.preise.ladeHgUg");
                                }
                                return string3;
                            }
                            hg2 = null;
                            if (res2 == null) break block17;
                            WebetkUtils.closeQuery(res2);
                        }
                        if (con != null) {
                            globs.freeDBConnection(con, "zub.preise.ladeHgUg");
                        }
                        return hg2;
                    }
                    statement = StringUtils.substituteString(statement, "SACHNR", sachnr);
                    log.debug((Object)("Executing SQL-Statement: " + statement));
                    res = null;
                    try {
                        con = globs.getDBConnection("zub.preise.ladeHgUg");
                        Statement stmt = con.createStatement();
                        res = stmt.executeQuery(statement);
                        if (!res.next()) break block18;
                        String hg = res.getString("Hg");
                        String ug = res.getString("Ug");
                        string2 = hg + ug;
                        if (res == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (res != null) {
                            WebetkUtils.closeQuery(res);
                        }
                        if (con != null) {
                            globs.freeDBConnection(con, "zub.preise.ladeHgUg");
                        }
                        throw throwable;
                    }
                    WebetkUtils.closeQuery(res);
                }
                if (con != null) {
                    globs.freeDBConnection(con, "zub.preise.ladeHgUg");
                }
                return string2;
            }
            string = null;
            if (res == null) break block20;
            WebetkUtils.closeQuery(res);
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.preise.ladeHgUg");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ladePreiseZuTeilen(String firmaid, ArrayList zeilen) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        PreparedStatement prep = null;
        String statement = SQLStatements.Preise.instance.LOAD_PREIS_ZU_TEIL();
        log.debug((Object)("Executing SQL-Statement: " + statement));
        ResultSet res = null;
        try {
            con = globs.getDBConnectionPreise("zub.preise.ladePreiseZuTeilen");
            prep = con.prepareStatement(statement);
            for (PreisZeile zeile : zeilen) {
                String sachnr = zeile.getSachNr();
                prep.setString(1, firmaid);
                prep.setString(2, sachnr);
                res = prep.executeQuery();
                while (res.next()) {
                    double preis = res.getDouble("EVP");
                    String preisKz = res.getString("PreisKz");
                    if (preisKz != null && preisKz.equals("%")) {
                        preis /= 100.0;
                    }
                    if (preis == 0.0) {
                        zeile.setPreis(null);
                    } else {
                        zeile.setPreis(new Double(preis));
                    }
                    zeile.setMwSt(res.getDouble("MwSt"));
                    zeile.setMwStCode(res.getString("MwStCode"));
                }
            }
        }
        finally {
            if (res != null) {
                WebetkUtils.closeQuery(res);
            } else if (prep != null) {
                prep.close();
            }
            if (con != null) {
                globs.freeDBConnectionPreise(con, "zub.preise.ladePreiseZuTeilen");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ladeEinbauinfos(String btenr, Preise preise, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs;
        Connection con;
        block11: {
            PreparedStatement prep;
            block10: {
                con = null;
                globs = ServerGlobalObjects.getInstance();
                prep = null;
                String statement = SQLStatements.Preise.instance.ERMITTLE_ALLE_EINBAUINFOS_ZU_BTENR();
                log.debug((Object)("Executing SQL-Statement: " + statement));
                ResultSet res = null;
                try {
                    con = globs.getDBConnection("zub.preise.ladeEinbauinfos");
                    prep = con.prepareStatement(statement);
                    prep.setInt(1, marktId);
                    prep.setString(2, btenr);
                    res = prep.executeQuery();
                    while (res.next()) {
                        String elemId = res.getString("ElemId");
                        String art = res.getString("Art");
                        String baureihe = res.getString("Br");
                        int infoId = res.getInt("InfoId");
                        String komplexitaet = res.getString("Kompl");
                        String lesart = res.getString("Lesart");
                        float mechanischerAufwand = PreiseDbAccess.getAufwand(res, "Mech");
                        float elektrischerAufwand = PreiseDbAccess.getAufwand(res, "Elek");
                        float programmierAufwand = PreiseDbAccess.getAufwand(res, "Prog");
                        float lackierAufwand = PreiseDbAccess.getAufwand(res, "Lack");
                        float gesamtAufwand = PreiseDbAccess.getAufwand(res, "Ges");
                        EinbauInfo info = new EinbauInfo(infoId, komplexitaet, lesart, mechanischerAufwand, elektrischerAufwand, programmierAufwand, lackierAufwand, 0.0f, gesamtAufwand);
                        if (produktart.equals("M")) {
                            info = new EinbauInfo(infoId, komplexitaet, lesart, 0.0f, 0.0f, 0.0f, 0.0f, gesamtAufwand, gesamtAufwand);
                        }
                        preise.addEinbauinfo(art, elemId, baureihe, info);
                    }
                    if (res == null) break block10;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        WebetkUtils.closeQuery(res);
                    } else if (prep != null) {
                        prep.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "zub.preise.ladeEinbauinfos");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(res);
                break block11;
            }
            if (prep != null) {
                prep.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "zub.preise.ladeEinbauinfos");
        }
    }

    private static float getAufwand(ResultSet res, String column) throws SQLException {
        String aufwand = res.getString(column);
        if (aufwand == null) {
            return 0.0f;
        }
        aufwand = aufwand.replaceAll(",", ".");
        return Float.parseFloat(aufwand);
    }
}

