/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.asap;

import com.bmw.tetis.eba.psi.PsiUser;
import com.bmw.tetis.psi.client.ClientPsiFactory;
import com.bmw.tetis.psi.client.IAppEntry;
import com.bmw.tetis.psi.client.IAppEntryListener;
import com.bmw.tetis.psi.client.IClientPsi;
import com.bmw.tetis.psi.common.IPsiBusyController;
import com.bmw.tetis.psi.common.PsiCommunicationException;
import de.esg.commonclient.GlobalObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import webetk.javaclient.communication.asap.AsapEntryListener;
import webetk.javaclient.communication.asap.ConnectToAsapBusyDialog;
import webetk.javaclient.framework.MainViewController;

public class AsapAppletComCtrl {
    private static AsapAppletComCtrl _instance = new AsapAppletComCtrl();
    private static Logger log = Logger.getLogger(AsapAppletComCtrl.class);
    private IClientPsi psiClient = null;
    private static final String DEFAULT_PSI_INFO = "<?xml version='1.0' encoding='ISO-8859-1'?><SESSION><USER><USER_ID><![CDATA[FV]]></USER_ID><LANG_ISO><![CDATA[de]]></LANG_ISO><LANG_REGISO><![CDATA[DE]]></LANG_REGISO><SUBS_ID><![CDATA[AG]]></SUBS_ID><BRAND><![CDATA[BMW]]></BRAND><ADMIN_MARKET><![CDATA[JO]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[JR]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[Markt2]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[OA]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZA]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZB]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZC]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZD]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZF]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZG]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZH]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZN]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZO]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZU]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[ZV]]></ADMIN_MARKET><ADMIN_MARKET><![CDATA[xy]]></ADMIN_MARKET></USER><CONNECTION ID='ETKApplet_2PI'><ENTRY><ENTRY_NAME><![CDATA[PISearch]]></ENTRY_NAME><LINK_NAME><![CDATA[PISearch]]></LINK_NAME></ENTRY></CONNECTION><CONNECTION ID='ETKApplet_2HLI'><ENTRY><ENTRY_NAME><![CDATA[HLI_Anfrage]]></ENTRY_NAME><LINK_NAME><![CDATA[Teiletechnischer Support]]></LINK_NAME></ENTRY></CONNECTION><CONNECTION ID='ETKApplet_2EBA'><ENTRY><ENTRY_NAME><![CDATA[SUCHE2]]></ENTRY_NAME><LINK_NAME><![CDATA[test]]></LINK_NAME></ENTRY></CONNECTION><CONNECTION ID='ETKApplet_SDB'><ENTRY><ENTRY_NAME><![CDATA[Sicherheitsdaten]]></ENTRY_NAME><LINK_NAME><![CDATA[Sicherheitsdbl]]></LINK_NAME></ENTRY></CONNECTION><CONNECTION ID='ETKApplet_2SDB_I'><ENTRY><ENTRY_NAME><![CDATA[SDB_Internet]]></ENTRY_NAME><LINK_NAME><![CDATA[SDB_Internet]]></LINK_NAME></ENTRY></CONNECTION></SESSION>";
    private boolean isInitialized = false;

    public static AsapAppletComCtrl getInstance() {
        if (_instance == null) {
            _instance = new AsapAppletComCtrl();
        }
        return _instance;
    }

    public boolean init() {
        if (this.isInitialized) {
            log.debug((Object)"ASAP Controller has already been initialized.");
            return true;
        }
        Properties params = GlobalObjects.getInstance().getEtkData().getAsapAppletParameters();
        if (params == null) {
            log.info((Object)"ASAP Applet interface is not configured.");
            return false;
        }
        ConnectToAsapBusyDialog dlg = new ConnectToAsapBusyDialog(MainViewController.getInstance().getMainViewInstance());
        try {
            this.psiClient = ClientPsiFactory.getClientPsi((Properties)params, (IPsiBusyController)dlg);
        }
        catch (PsiCommunicationException ex) {
            log.error((Object)("Could not create PsiClient for ASAP Applet communication: " + ex.getMessage()));
            return false;
        }
        this.psiClient.addAppEntryListener("ETK JavaClient", (IAppEntryListener)AsapEntryListener.getInstance());
        this.isInitialized = true;
        log.info((Object)"ASAP Applet communication has been initialized.");
        return true;
    }

    public String getAsapSessionId() {
        if (this.psiClient == null) {
            log.warn((Object)"ASAP Communication has not been initialized correctly! Initializing ...");
            this.init();
        }
        if (this.psiClient == null) {
            log.error((Object)"ASAP Applet Interface is not available!");
            return null;
        }
        try {
            this.updatePsiInfo();
            String sPsessId = this.psiClient.getPsessId();
            if (sPsessId != null) {
                log.debug((Object)("ASAP Applet is running. We got SessionID: " + sPsessId));
                return sPsessId;
            }
            log.info((Object)"We have to start up ASAP to get the SessionID.");
            this.psiClient.getHomeEntry().invoke(new HashMap());
            sPsessId = this.psiClient.getPsessId();
            log.debug((Object)("ASAP Applet is running. We got SessionID: " + sPsessId));
            this.updatePsiInfo();
            return sPsessId;
        }
        catch (PsiCommunicationException e) {
            log.error((Object)("Communication Problem with Psi ASAP: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    public String getHaendlerNummer() {
        PsiUser user = this.getAsapUser();
        if (user == null) {
            return null;
        }
        String haendlerNummer = user.getDealerId();
        if (haendlerNummer == null) {
            return "";
        }
        return haendlerNummer;
    }

    public String getHaendlerName() {
        PsiUser user = this.getAsapUser();
        if (user == null) {
            return null;
        }
        String haendlerName = user.getDealerName();
        return haendlerName;
    }

    public String getHaendlerEmail() {
        PsiUser user = this.getAsapUser();
        if (user == null) {
            return null;
        }
        String haendlerEmail = user.getEmail();
        return haendlerEmail;
    }

    public String getHaendlerTel() {
        PsiUser user = this.getAsapUser();
        if (user == null) {
            return null;
        }
        String haendlerTel = user.getPhone();
        return haendlerTel;
    }

    public String getAsapUserId() {
        PsiUser user = this.getAsapUser();
        if (user == null) {
            return null;
        }
        String sUserId = user.getUserId();
        return sUserId;
    }

    public PsiUser getAsapUser() {
        PsiUser user = null;
        try {
            String sSessionId = this.getAsapSessionId();
            if (sSessionId == null || this.psiClient == null || this.psiClient.getUser() == null) {
                log.error((Object)"Could not get dealer number from ASAP");
                return null;
            }
            user = this.psiClient.getUser();
        }
        catch (PsiCommunicationException ex) {
            log.error((Object)"Could not get dealer number from ASAP", (Throwable)ex);
        }
        return user;
    }

    private void updatePsiInfo() throws PsiCommunicationException {
        String sPsiInfo = GlobalObjects.getInstance().getEtkData().getPsiInfo();
        log.debug((Object)("Loaded Psi Info from file: " + sPsiInfo));
        sPsiInfo = this.psiClient.getPsiInfo(sPsiInfo == null ? DEFAULT_PSI_INFO : sPsiInfo);
        log.info((Object)("Retrieved Psi Info from interface: " + sPsiInfo));
        GlobalObjects.getInstance().getEtkData().storePsiInfo(sPsiInfo);
    }

    public void invokeEba(String sSachnummer) throws PsiCommunicationException {
        log.debug((Object)("Calling ASAP function EBA with parameter <SACHNR>: " + sSachnummer));
        HashMap<String, String> ebaParams = new HashMap<String, String>();
        if (sSachnummer != null) {
            ebaParams.put("SACHNR", sSachnummer);
        }
        this.callAsapFunction("2EBA", ebaParams);
    }

    public void invokeHli(String sMarke, String sProdArt, String sKatUmfang, String sBaureihe, String sKarosserie, String sModell, String sRegion, String sLenkung, String sGetriebe, String sBaujahr, String sMonat, String sVin, String sBteNummer, String sBtePos, String sCDVersion, String sMedium) throws PsiCommunicationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling ASAP function HLI with parameters");
            log.debug((Object)("    <MARKE>: " + sMarke));
            log.debug((Object)("    <PRODART>: " + sProdArt));
            log.debug((Object)("    <KATUMFANG>: " + sKatUmfang));
            log.debug((Object)("    <BAUREIHE>: " + sBaureihe));
            log.debug((Object)("    <KARO>: " + sKarosserie));
            log.debug((Object)("    <MODELL>: " + sModell));
            log.debug((Object)("    <KATAUSF>: " + sRegion));
            log.debug((Object)("    <LENKUNG>: " + sLenkung));
            log.debug((Object)("    <GETRIEBE>: " + sGetriebe));
            log.debug((Object)("    <BAUJAHRMONAT>: " + sBaujahr + "." + sMonat));
            log.debug((Object)("    <FGSTNR>: " + sVin));
            log.debug((Object)("    <BTENR>: " + sBteNummer));
            log.debug((Object)("    <BTEPOS>: " + sBtePos));
            log.debug((Object)("    <PUBLDATUM>: " + sCDVersion));
            log.debug((Object)("    <MEDIUM>: " + sMedium));
        }
        HashMap<String, String> hliParams = new HashMap<String, String>();
        if (sMarke != null) {
            hliParams.put("MARKE", sMarke);
        }
        if (sProdArt != null) {
            hliParams.put("PRODART", sProdArt);
        }
        if (sKatUmfang != null) {
            hliParams.put("KATUMFANG", sKatUmfang);
        }
        if (sBaureihe != null) {
            hliParams.put("BAUREIHE", sBaureihe);
        }
        if (sKarosserie != null) {
            hliParams.put("KARO", sKarosserie);
        }
        if (sModell != null) {
            hliParams.put("MODELL", sModell);
        }
        if (sRegion != null) {
            hliParams.put("KATAUSF", sRegion);
        }
        if (sLenkung != null) {
            hliParams.put("LENKUNG", sLenkung);
        }
        if (sGetriebe != null) {
            hliParams.put("GETRIEBE", sGetriebe);
        }
        if (sBaujahr != null && sMonat != null) {
            hliParams.put("BAUJAHRMONAT", sBaujahr + "." + sMonat);
        }
        if (sVin != null) {
            hliParams.put("FGSTNR", sVin);
        }
        if (sBteNummer != null) {
            hliParams.put("BTENR", sBteNummer);
        }
        if (sBtePos != null) {
            hliParams.put("BTEPOS", sBtePos);
        }
        if (sCDVersion != null) {
            hliParams.put("PUBLDATUM", sCDVersion);
        }
        if (sMedium != null) {
            hliParams.put("MEDIUM", sMedium);
        }
        this.callAsapFunction("2HLI", hliParams);
    }

    public void invokePi(String sSachnummer, String sPiNummer) throws PsiCommunicationException {
        log.debug((Object)("Calling ASAP function PI with parameter <SACHNR>: " + sSachnummer + ", <" + "SACHNR" + ">: " + sPiNummer));
        HashMap<String, String> piParams = new HashMap<String, String>();
        if (sPiNummer != null) {
            piParams.put("PINR", sPiNummer);
        } else if (sSachnummer != null) {
            piParams.put("SACHNR", sSachnummer);
        }
        this.callAsapFunction("2PI", piParams);
    }

    private void invokeSdbI(String sSachnummer) throws PsiCommunicationException {
        log.debug((Object)("Calling ASAP function SDB_I with parameter <SACHNR>: " + sSachnummer));
        HashMap<String, String> sdbiParams = new HashMap<String, String>();
        if (sSachnummer != null) {
            sdbiParams.put("SACHNR", sSachnummer);
        }
        this.callAsapFunction("2SDB_I", sdbiParams);
    }

    public void invokeSdb(String sSachnummer) throws PsiCommunicationException {
        if (GlobalObjects.getInstance().usesInternet()) {
            this.invokeSdbI(sSachnummer);
        } else {
            this.invokeSdbE(sSachnummer);
        }
    }

    private void invokeSdbE(String sSachnummer) throws PsiCommunicationException {
        log.debug((Object)("Calling ASAP function SDB with parameter <SACHNR>: " + sSachnummer));
        HashMap<String, String> sdbParams = new HashMap<String, String>();
        if (sSachnummer != null) {
            sdbParams.put("SACHNR", sSachnummer);
        }
        this.callAsapFunction("SDB", sdbParams);
    }

    private void callAsapFunction(String asapFunction, HashMap paramMap) throws PsiCommunicationException {
        if (!(asapFunction.equals("2EBA") || asapFunction.equals("2HLI") || asapFunction.equals("2PI") || asapFunction.equals("2SDB_I") || asapFunction.equals("SDB"))) {
            log.error((Object)("Illegal ASAP Function call. No such ASAP function: " + asapFunction));
            throw new IllegalStateException("Illegal ASAP Function call. No such ASAP function: " + asapFunction);
        }
        if (this.psiClient == null) {
            log.warn((Object)"ASAP Communication has not been initialized correctly! Initializing ...");
            this.init();
        }
        if (this.psiClient == null) {
            log.error((Object)"ASAP Applet Interface is not available!");
            return;
        }
        this.updatePsiInfo();
        List entries = this.psiClient.getAppEntries(asapFunction);
        if (entries.size() == 0) {
            log.error((Object)("Could not find application entries for function: " + asapFunction));
            throw new IllegalStateException("Could not find application entries for function: " + asapFunction);
        }
        if (entries.size() > 1) {
            log.error((Object)("More than one application entry found for function: " + asapFunction));
        }
        IAppEntry entry = (IAppEntry)entries.get(0);
        entry.invoke((Map)paramMap);
    }

    public static class ASAP_Functions {
        public static final String EBA = "2EBA";
        public static final String HLI = "2HLI";
        public static final String PI = "2PI";
        public static final String SDB_I = "2SDB_I";
        public static final String SDB = "SDB";
    }

    public static class ASAP_Parameter {
        public static final String TETIS_SACHNUMMER = "SACHNR";
        public static final String TETIS_FAHRGESTELL_NR = "FGSTNR";
        public static final String TETIS_BENENNUNG = "BENENNUNG";
        public static final String TETIS_MARKE = "MARKE";
        public static final String TETIS_PRODUKTART = "PRODART";
        public static final String TETIS_DISPLAY_PRODUKTDATUM = "PRODUKTDATUM";
        public static final String TETIS_ENVIRONMENT = "ENV";
        public static final String TETIS_PINR = "PINR";
        public static final String TETIS_MOTOR = "MOTOR";
        public static final String TETIS_GETRIEBE = "GETRIEBE";
        public static final String TETIS_LENKUNG = "LENKUNG";
        public static final String TETIS_KATALOGAUSFUEHRUNG = "KATAUSF";
        public static final String TETIS_BAUJAHRMONAT = "BAUJAHRMONAT";
        public static final String TETIS_CDVERSION = "PUBLDATUM";
        public static final String TETIS_BTENR = "BTENR";
        public static final String TETIS_BTEPOS = "BTEPOS";
        public static final String TETIS_KATALOGUMFANG = "KATUMFANG";
        public static final String TETIS_MEDIUM = "MEDIUM";
        public static final String TETIS_BAUREIHE = "BAUREIHE";
        public static final String TETIS_KAROSSERIE = "KARO";
        public static final String TETIS_VERKAUFSBEZEICHNUNG = "VBEZ";
        public static final String TETIS_MODELL = "MODELL";
        public static final String TETIS_HG = "HG";
    }
}

