/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.asap;

import com.bmw.tetis.psi.common.IPsiBusyController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class ConnectToAsapBusyDialog
extends JDialog
implements IPsiBusyController {
    private static final long serialVersionUID = 1L;
    private boolean bStop = false;
    private boolean bStarted = false;
    private JButton btnCancel = new JButton(Resource.getInstance().getAbbrechen());

    public ConnectToAsapBusyDialog(Frame owner) {
        super(owner);
        this.constructDialog();
    }

    public ConnectToAsapBusyDialog(Dialog owner) {
        super(owner);
        this.constructDialog();
    }

    public ConnectToAsapBusyDialog() {
        this.constructDialog();
    }

    private void constructDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectToAsapBusyDialog.this.doCancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                ConnectToAsapBusyDialog.this.doCancel();
            }
        });
        JPanel jLabelPanel = new JPanel(new FlowLayout(1));
        JLabel lblConMeldung = new JLabel(Resource.getInstance().getVerbindungZuAsap());
        jLabelPanel.add(lblConMeldung);
        JPanel jButtonPanel = new JPanel(new FlowLayout(1));
        jButtonPanel.add(this.btnCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jLabelPanel, "Center");
        this.getContentPane().add((Component)jButtonPanel, "South");
    }

    private void doCancel() {
        Logger.getLogger(ConnectToAsapBusyDialog.class).debug((Object)"Connection attempt has been canceled.");
        System.out.println("Connection attempt has been canceled by the user.");
        this.bStop = true;
        this.btnCancel.setEnabled(false);
    }

    public boolean isCanceled() {
        return this.bStop;
    }

    public void start() {
        if (this.bStarted) {
            Logger.getLogger(ConnectToAsapBusyDialog.class).debug((Object)"Busy Dialog si already showing.");
            return;
        }
        Logger.getLogger(ConnectToAsapBusyDialog.class).debug((Object)"Constructing and showing Busy Dialog.");
        System.out.println("Constructing and showing Busy Dialog.");
        this.setModal(true);
        this.setSize(300, 100);
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        this.setVisible(true);
        this.bStarted = true;
    }

    public void stop() {
        Logger.getLogger(ConnectToAsapBusyDialog.class).debug((Object)"Hiding Busy Dialog.");
        System.out.println("stop called: Hiding Busy Dialog.");
        this.dispose();
        this.bStarted = false;
    }
}

