/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.login;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.utils.communication.ProxyAuthentication;

public abstract class CommonLogin {
    private static Logger log = Logger.getLogger(CommonLogin.class);
    private String proxyAdress = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyPassword = null;
    private String netzUrl = null;
    private String userID = null;
    private String password = null;
    private int statusCode = -1;
    private String statusMsg = null;
    private String asapSessionId = null;
    private String asapUserId = null;
    private String respCont = null;

    public abstract void login() throws IOException, KeyManagementException, NoSuchAlgorithmException, URISyntaxException;

    protected void resetProxyAuth(ProxyAuthentication proxyAuth) {
        if (proxyAuth != null) {
            proxyAuth.resetProxyAuthentication();
        }
    }

    protected BasicClientCookie settingCookie(String name, String value, String host, String path) {
        BasicClientCookie authcookie = new BasicClientCookie(name, value);
        authcookie.setVersion(0);
        authcookie.setDomain(host);
        authcookie.setPath(path);
        return authcookie;
    }

    protected boolean checkStatusAndSetStatus(String sContext, HttpRequestBase req, HttpResponse rsp, boolean checkLogin, CookieStore cookieStore) {
        this.setStatusMsg("login to " + sContext + " not successful. ");
        if (rsp == null) {
            this.setStatusCode(30);
            this.setStatusMsg(this.getStatusMsg() + "Unforeseen other problem during login routine for " + sContext + " login!");
            return false;
        }
        if (!checkLogin && rsp.getStatusLine().getStatusCode() != 302 && rsp.getStatusLine().getStatusCode() != 200) {
            this.setStatusCode(rsp.getStatusLine().getStatusCode());
            this.setStatusMsg(this.getStatusMsg() + rsp.getStatusLine() + " - URL: " + (req != null && req.getFirstHeader("Location") != null ? req.getFirstHeader("Location").getValue() : ""));
            return false;
        }
        if (checkLogin && (cookieStore != null && !this.isLoginSuccessfully(cookieStore) || cookieStore == null && this.respCont.indexOf("Your login was successful.") == -1)) {
            this.setStatusCode(10);
            this.setStatusMsg(this.getStatusMsg() + "Unknown or invalid login information!");
            return false;
        }
        this.setStatusCode(0);
        this.setStatusMsg("Successfully login to " + sContext + ". ");
        return true;
    }

    protected void setStatusForConnectionException(String sContext, HttpHostConnectException conExc) {
        log.error((Object)conExc.getMessage());
        this.setStatusCode(99);
        this.setStatusMsg("login to " + sContext + " portal not successful. " + "Can not connect!");
    }

    protected void showContentinBrowser(String content, String sFileName) throws IOException {
        if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true") && Level.DEBUG.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
            File file = new File("D:/ATemp/ETK/" + sFileName + ".html");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(this.respCont);
            out.close();
            Runtime rt = Runtime.getRuntime();
            rt.exec("C:\\Program Files (x86)\\Mozilla Firefox\\firefox.exe file:///D:/ATemp/ETK/" + sFileName + ".html");
        }
    }

    protected void printStatusAndHeaders(boolean forcePrint, HttpResponse rsp) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
            log.debug((Object)"-HttpResponse-Status-and-Header-start--------------------------------------");
            log.debug((Object)rsp.getStatusLine());
            for (Header header : rsp.getAllHeaders()) {
                log.debug((Object)header);
            }
            log.debug((Object)"-HttpResponse-Status-and-Header-ende---------------------------------------");
        } else if (forcePrint) {
            log.error((Object)"-HttpResponse-Status-and-Header-start--------------------------------------");
            log.error((Object)rsp.getStatusLine());
            for (Header header : rsp.getAllHeaders()) {
                log.error((Object)header);
            }
            log.error((Object)"-HttpResponse-Status-and-Header-ende---------------------------------------");
        }
    }

    protected String getContent(HttpResponse rsp) throws IOException {
        String content = "";
        HttpEntity entity = rsp.getEntity();
        if (entity != null) {
            byte[] a1 = EntityUtils.toByteArray((HttpEntity)entity);
            content = new String(a1);
            EntityUtils.consume((HttpEntity)entity);
        }
        return content;
    }

    protected boolean isLoginSuccessfully(CookieStore cookieStore) {
        for (Cookie cookie : cookieStore.getCookies()) {
            if (!cookie.getName().equals("SMIDENTITY") && !cookie.getName().equals("SMSESSION") || cookie.getValue() == null || cookie.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    protected void printContent(boolean forcePrint, String content) throws IOException {
        if (Level.DEBUG.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
            log.debug((Object)"-HttpResponse-content-start--------------------------------------");
            log.debug((Object)content);
            log.debug((Object)"-HttpResponse-content-ende---------------------------------------");
        } else if (forcePrint) {
            log.error((Object)"-HttpResponse-content-start--------------------------------------");
            log.error((Object)content);
            log.error((Object)"-HttpResponse-content-ende---------------------------------------");
        }
    }

    protected void printCookies(boolean forcePrint, CookieStore cookieStore) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
            log.debug((Object)"-CookieStore-start--------------------------------------");
            List cookies = cookieStore.getCookies();
            if (cookies.isEmpty()) {
                log.debug((Object)"no cookies");
            } else {
                for (int i = 0; i < cookies.size(); ++i) {
                    log.debug((Object)("- " + ((Cookie)cookies.get(i)).toString()));
                }
            }
            log.debug((Object)"-CookieStore-ende---------------------------------------");
        } else if (forcePrint) {
            log.error((Object)"-CookieStore-start--------------------------------------");
            List cookies = cookieStore.getCookies();
            if (cookies.isEmpty()) {
                log.error((Object)"no cookies");
            } else {
                for (int i = 0; i < cookies.size(); ++i) {
                    log.error((Object)("- " + ((Cookie)cookies.get(i)).toString()));
                }
            }
            log.error((Object)"-CookieStore-ende---------------------------------------");
        }
    }

    public String getProxyAdress() {
        return this.proxyAdress;
    }

    public void setProxyAdress(String proxyAdress) {
        this.proxyAdress = proxyAdress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getNetzUrl() {
        return this.netzUrl;
    }

    public void setNetzUrl(String netzUrl) {
        this.netzUrl = netzUrl;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public void setStatusMsg(String statusMsg) {
        this.statusMsg = statusMsg;
    }

    public String getAsapSessionId() {
        return this.asapSessionId;
    }

    public void setAsapSessionId(String asapSessionId) {
        this.asapSessionId = asapSessionId;
    }

    public String getAsapSessionIdWithoutIndex() {
        return this.asapSessionId != null ? this.asapSessionId.substring(0, this.asapSessionId.lastIndexOf(".")) : null;
    }

    public String getAsapUserId() {
        return this.asapUserId;
    }

    public void setAsapUserId(String asapUserId) {
        this.asapUserId = asapUserId;
    }

    protected String getRespCont() {
        return this.respCont;
    }

    protected void setRespCont(String respCont) {
        this.respCont = respCont;
    }
}

